/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.server.project.RefControl;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;

public class ListBranches
implements RestReadView<ProjectResource> {
    private final GitRepositoryManager repoManager;

    @Inject
    public ListBranches(GitRepositoryManager repoManager) {
        this.repoManager = repoManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BranchInfo> apply(ProjectResource rsrc) throws ResourceNotFoundException, IOException {
        Repository db;
        ArrayList<BranchInfo> branches = Lists.newArrayList();
        BranchInfo headBranch = null;
        BranchInfo configBranch = null;
        HashSet<String> targets = Sets.newHashSet();
        try {
            db = this.repoManager.openRepository(rsrc.getNameKey());
        }
        catch (RepositoryNotFoundException noGitRepository) {
            throw new ResourceNotFoundException();
        }
        try {
            Map<String, Ref> all = db.getRefDatabase().getRefs("");
            if (!all.containsKey("HEAD")) {
                try {
                    Ref head = db.getRef("HEAD");
                    if (head != null) {
                        all.put("HEAD", head);
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            for (Ref ref : all.values()) {
                if (!ref.isSymbolic()) continue;
                targets.add(ref.getTarget().getName());
            }
            for (Ref ref : all.values()) {
                if (ref.isSymbolic()) {
                    String target = ref.getTarget().getName();
                    RefControl targetRefControl = rsrc.getControl().controlForRef(target);
                    if (!targetRefControl.isVisible()) continue;
                    if (target.startsWith("refs/heads/")) {
                        target = target.substring("refs/heads/".length());
                    }
                    BranchInfo b = new BranchInfo(ref.getName(), target, false);
                    if ("HEAD".equals(ref.getName())) {
                        headBranch = b;
                        continue;
                    }
                    b.setCanDelete(targetRefControl.canDelete());
                    branches.add(b);
                    continue;
                }
                RefControl refControl = rsrc.getControl().controlForRef(ref.getName());
                if (!refControl.isVisible()) continue;
                if (ref.getName().startsWith("refs/heads/")) {
                    branches.add(ListBranches.createBranchInfo(ref, refControl, targets));
                    continue;
                }
                if (!"refs/meta/config".equals(ref.getName())) continue;
                configBranch = ListBranches.createBranchInfo(ref, refControl, targets);
            }
        }
        finally {
            db.close();
        }
        Collections.sort(branches, new Comparator<BranchInfo>(){

            @Override
            public int compare(BranchInfo a, BranchInfo b) {
                return a.ref.compareTo(b.ref);
            }
        });
        if (configBranch != null) {
            branches.add(0, configBranch);
        }
        if (headBranch != null) {
            branches.add(0, headBranch);
        }
        return branches;
    }

    private static BranchInfo createBranchInfo(Ref ref, RefControl refControl, Set<String> targets) {
        return new BranchInfo(ref.getName(), ref.getObjectId() != null ? ref.getObjectId().name() : null, !targets.contains(ref.getName()) && refControl.canDelete());
    }

    public static class BranchInfo {
        public String ref;
        public String revision;
        public Boolean canDelete;

        public BranchInfo(String ref, String revision, boolean canDelete) {
            this.ref = ref;
            this.revision = revision;
            this.canDelete = canDelete;
        }

        void setCanDelete(boolean canDelete) {
            this.canDelete = canDelete ? Boolean.valueOf(true) : null;
        }
    }
}

