/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query;

import com.google.gerrit.server.query.Predicate;
import com.google.gwtorm.server.OrmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class AndPredicate<T>
extends Predicate<T> {
    private final List<Predicate<T>> children;
    private final int cost;

    @SafeVarargs
    protected AndPredicate(Predicate<T> ... that) {
        this(Arrays.asList(that));
    }

    protected AndPredicate(Collection<? extends Predicate<T>> that) {
        ArrayList<Predicate<T>> t = new ArrayList<Predicate<T>>(that.size());
        int c = 0;
        for (Predicate<T> p : that) {
            if (this.getClass() == p.getClass()) {
                for (Predicate<T> gp : p.getChildren()) {
                    t.add(gp);
                    c += gp.getCost();
                }
                continue;
            }
            t.add(p);
            c += p.getCost();
        }
        this.children = t;
        this.cost = c;
    }

    @Override
    public final List<Predicate<T>> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public final int getChildCount() {
        return this.children.size();
    }

    @Override
    public final Predicate<T> getChild(int i) {
        return this.children.get(i);
    }

    @Override
    public Predicate<T> copy(Collection<? extends Predicate<T>> children) {
        return new AndPredicate<T>(children);
    }

    @Override
    public boolean match(T object) throws OrmException {
        for (Predicate<T> c : this.children) {
            if (c.match(object)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getCost() {
        return this.cost;
    }

    @Override
    public int hashCode() {
        return this.getChild(0).hashCode() * 31 + this.getChild(1).hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        return this.getClass() == other.getClass() && this.getChildren().equals(((Predicate)other).getChildren());
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append("(");
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (i != 0) {
                r.append(" ");
            }
            r.append(this.getChild(i));
        }
        r.append(")");
        return r.toString();
    }
}

