/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.server.index.ChangeField;
import com.google.gerrit.server.index.IndexPredicate;
import com.google.gerrit.server.query.change.ChangeCosts;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeDataResultSet;
import com.google.gerrit.server.query.change.ChangeDataSource;
import com.google.gerrit.server.query.change.ChangeQueryBuilder;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.ResultSet;

class ChangeIdPredicate
extends IndexPredicate<ChangeData>
implements ChangeDataSource {
    private final ChangeQueryBuilder.Arguments args;

    ChangeIdPredicate(ChangeQueryBuilder.Arguments args, String id) {
        super(ChangeField.ID, "change", id);
        this.args = args;
    }

    @Override
    public boolean match(ChangeData cd) throws OrmException {
        Change change = cd.change();
        if (change == null) {
            return false;
        }
        String key = change.getKey().get();
        return key.equals(this.getValue()) || key.startsWith(this.getValue());
    }

    @Override
    public ResultSet<ChangeData> read() throws OrmException {
        Change.Key a = new Change.Key(this.getValue());
        Change.Key b = a.max();
        return ChangeDataResultSet.change(this.args.changeDataFactory, this.args.db, this.args.db.get().changes().byKeyRange(a, b));
    }

    @Override
    public boolean hasChange() {
        return true;
    }

    @Override
    public int getCost() {
        return ChangeCosts.cost(2, this.getCardinality());
    }

    @Override
    public int getCardinality() {
        return 5;
    }
}

