/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.gerrit.common.errors.PermissionDeniedException;
import com.google.gerrit.server.git.BanCommit;
import com.google.gerrit.server.git.BanCommitResult;
import com.google.gerrit.server.git.MergeException;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.lib.ObjectId;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@CommandMetaData(name="ban-commit", description="Ban a commit from a project's repository", runsAt=CommandMetaData.Mode.MASTER_OR_SLAVE)
public class BanCommitCommand
extends SshCommand {
    @Option(name="--reason", aliases={"-r"}, metaVar="REASON", usage="reason for banning the commit")
    private String reason;
    @Argument(index=0, required=true, metaVar="PROJECT", usage="name of the project for which the commit should be banned")
    private ProjectControl projectControl;
    @Argument(index=1, required=true, multiValued=true, metaVar="COMMIT", usage="commit(s) that should be banned")
    private List<ObjectId> commitsToBan = new ArrayList<ObjectId>();
    @Inject
    private BanCommit.Factory banCommitFactory;

    @Override
    protected void run() throws BaseCommand.Failure {
        try {
            List<ObjectId> ignoredIds;
            List<ObjectId> alreadyBannedCommits;
            BanCommitResult result = this.banCommitFactory.create().ban(this.projectControl, this.commitsToBan, this.reason);
            List<ObjectId> newlyBannedCommits = result.getNewlyBannedCommits();
            if (!newlyBannedCommits.isEmpty()) {
                this.stdout.print("The following commits were banned:\n");
                BanCommitCommand.printCommits(this.stdout, newlyBannedCommits);
            }
            if (!(alreadyBannedCommits = result.getAlreadyBannedCommits()).isEmpty()) {
                this.stdout.print("The following commits were already banned:\n");
                BanCommitCommand.printCommits(this.stdout, alreadyBannedCommits);
            }
            if (!(ignoredIds = result.getIgnoredObjectIds()).isEmpty()) {
                this.stdout.print("The following ids do not represent commits and were ignored:\n");
                BanCommitCommand.printCommits(this.stdout, ignoredIds);
            }
        }
        catch (PermissionDeniedException e) {
            throw this.die(e);
        }
        catch (IOException e) {
            throw this.die(e);
        }
        catch (MergeException e) {
            throw this.die(e);
        }
        catch (InterruptedException e) {
            throw this.die(e);
        }
        catch (ConcurrentRefUpdateException e) {
            throw this.die(e);
        }
    }

    private static void printCommits(PrintWriter stdout, List<ObjectId> commits) {
        boolean first = true;
        for (ObjectId c : commits) {
            if (!first) {
                stdout.print(",\n");
            }
            stdout.print(c.getName());
            first = false;
        }
        stdout.print("\n\n");
    }
}

