/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.inject.OutOfScopeException;
import com.google.inject.internal.guava.collect.$Maps;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;

class ContinuingHttpServletRequest
extends HttpServletRequestWrapper {
    private final Map<String, Object> attributes = $Maps.newHashMap();

    public ContinuingHttpServletRequest(HttpServletRequest request) {
        super(request);
    }

    public HttpSession getSession() {
        throw new OutOfScopeException("Cannot access the session in a continued request");
    }

    public HttpSession getSession(boolean create) {
        throw new UnsupportedOperationException("Cannot access the session in a continued request");
    }

    public ServletInputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException("Cannot access raw request on a continued request");
    }

    public void setAttribute(String name, Object o) {
        this.attributes.put(name, o);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Cookie[] getCookies() {
        if (super.getCookies() == null) {
            return null;
        }
        return (Cookie[])super.getCookies().clone();
    }
}

