/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.prolog_cafe.lang;

import com.googlecode.prolog_cafe.lang.InternalException;
import com.googlecode.prolog_cafe.lang.Prolog;
import com.googlecode.prolog_cafe.lang.Term;
import com.googlecode.prolog_cafe.lang.Trail;
import com.googlecode.prolog_cafe.lang.Undoable;

public class VariableTerm
extends Term
implements Undoable {
    private Term val = this;
    private long timeStamp;

    public VariableTerm() {
        this.timeStamp = Long.MIN_VALUE;
    }

    public VariableTerm(Prolog prolog) {
        this.timeStamp = prolog.getCPFTimeStamp();
    }

    protected String variableName() {
        return "_" + Integer.toHexString(this.hashCode()).toUpperCase();
    }

    @Override
    public boolean unify(Term term, Trail trail) {
        if (this.val != this) {
            return this.val.unify(term, trail);
        }
        if (this != (term = term.dereference())) {
            this.bind(term, trail);
        }
        return true;
    }

    public void bind(Term term, Trail trail) {
        if (term.isVariable()) {
            VariableTerm variableTerm = (VariableTerm)term;
            if (variableTerm.timeStamp >= this.timeStamp) {
                variableTerm.val = this;
                if (variableTerm.timeStamp < trail.timeStamp) {
                    trail.push(variableTerm);
                }
                return;
            }
        }
        this.val = term;
        if (this.timeStamp < trail.timeStamp) {
            trail.push(this);
        }
    }

    @Override
    public boolean convertible(Class clazz) {
        if (this.val != this) {
            return this.val.convertible(clazz);
        }
        return VariableTerm.convertible(this.getClass(), clazz);
    }

    @Override
    protected Term copy(Prolog prolog) {
        if (this.val != this) {
            return this.val.copy(prolog);
        }
        VariableTerm variableTerm = prolog.copyHash.get(this);
        if (variableTerm == null) {
            variableTerm = new VariableTerm();
            prolog.copyHash.put(this, variableTerm);
        }
        return variableTerm;
    }

    @Override
    public Term dereference() {
        if (this.val == this) {
            return this;
        }
        return this.val.dereference();
    }

    @Override
    public boolean isGround() {
        if (this.val != this) {
            return this.val.isGround();
        }
        return false;
    }

    @Override
    public String name() {
        if (this.val == this) {
            return "";
        }
        return this.val.dereference().name();
    }

    @Override
    public Object toJava() {
        if (this.val != this) {
            return this.val.toJava();
        }
        return this;
    }

    @Override
    public String toQuotedString() {
        if (this.val != this) {
            return this.val.toQuotedString();
        }
        return this.variableName();
    }

    public boolean equals(Object object) {
        if (this.val != this) {
            return this.val.equals(object);
        }
        if (!(object instanceof VariableTerm)) {
            return false;
        }
        return this == object;
    }

    public String toString() {
        if (this.val != this) {
            return this.val.toString();
        }
        return this.variableName();
    }

    @Override
    public void undo() {
        this.val = this;
    }

    @Override
    public int compareTo(Term term) {
        if (this.val != this) {
            return this.val.compareTo(term);
        }
        if (!term.isVariable()) {
            return -1;
        }
        if (this == term) {
            return 0;
        }
        int n = this.hashCode() - ((VariableTerm)term).hashCode();
        if (n != 0) {
            return n;
        }
        throw new InternalException("VariableTerm is not unique");
    }
}

