/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io.mina;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.service.SimpleIoProcessorPool;
import org.apache.mina.transport.socket.nio.NioProcessor;
import org.apache.mina.transport.socket.nio.NioSession;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoServiceFactory;
import org.apache.sshd.common.io.mina.MinaAcceptor;
import org.apache.sshd.common.io.mina.MinaConnector;
import org.apache.sshd.common.util.CloseableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinaServiceFactory
implements IoServiceFactory {
    private final Logger logger = LoggerFactory.getLogger(MinaServiceFactory.class);
    private final FactoryManager manager;
    private final ExecutorService executor;
    private final IoProcessor<NioSession> ioProcessor;

    public MinaServiceFactory(FactoryManager manager) {
        this.manager = manager;
        this.executor = Executors.newCachedThreadPool();
        ((ThreadPoolExecutor)this.executor).setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        this.ioProcessor = new SimpleIoProcessorPool<NioSession>(NioProcessor.class, this.getNioWorkers());
    }

    public IoConnector createConnector(IoHandler handler) {
        return new MinaConnector(this.manager, handler, this.ioProcessor);
    }

    public IoAcceptor createAcceptor(IoHandler handler) {
        return new MinaAcceptor(this.manager, handler, this.ioProcessor);
    }

    public CloseFuture close(boolean immediately) {
        try {
            this.executor.shutdownNow();
            this.executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            this.logger.debug("Exception caught while closing executor", e);
        }
        return CloseableUtils.closed();
    }

    public int getNioWorkers() {
        int nb;
        String nioWorkers = this.manager.getProperties().get("nio-workers");
        if (nioWorkers != null && nioWorkers.length() > 0 && (nb = Integer.parseInt(nioWorkers)) > 0) {
            return nb;
        }
        return FactoryManager.DEFAULT_NIO_WORKERS;
    }
}

