/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io.nio2;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.future.DefaultSshFuture;
import org.apache.sshd.common.future.SshFuture;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoService;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.io.nio2.Nio2Service;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.common.util.CloseableUtils;
import org.apache.sshd.common.util.Readable;

public class Nio2Session
extends CloseableUtils.AbstractCloseable
implements IoSession {
    private static final AtomicLong sessionIdGenerator = new AtomicLong(100L);
    private final long id = sessionIdGenerator.incrementAndGet();
    private final Nio2Service service;
    private final IoHandler handler;
    private final AsynchronousSocketChannel socket;
    private final Map<Object, Object> attributes = new HashMap<Object, Object>();
    private final SocketAddress localAddress;
    private final SocketAddress remoteAddress;
    private final Queue<DefaultIoWriteFuture> writes = new LinkedTransferQueue<DefaultIoWriteFuture>();
    private final AtomicReference<DefaultIoWriteFuture> currentWrite = new AtomicReference();

    public Nio2Session(Nio2Service service, IoHandler handler, AsynchronousSocketChannel socket) throws IOException {
        this.service = service;
        this.handler = handler;
        this.socket = socket;
        this.localAddress = socket.getLocalAddress();
        this.remoteAddress = socket.getRemoteAddress();
        this.log.debug("Creating IoSession on {} from {}", this.localAddress, (Object)this.remoteAddress);
    }

    public long getId() {
        return this.id;
    }

    public Object getAttribute(Object key) {
        return this.attributes.get(key);
    }

    public Object setAttribute(Object key, Object value) {
        return this.attributes.put(key, value);
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public void suspend() {
        try {
            this.socket.shutdownInput();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.socket.shutdownOutput();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public IoWriteFuture write(Buffer buffer) {
        this.log.debug("Writing {} bytes", buffer.available());
        ByteBuffer buf = ByteBuffer.wrap(buffer.array(), buffer.rpos(), buffer.available());
        DefaultIoWriteFuture future = new DefaultIoWriteFuture(null, buf);
        if (this.state.get() != 0) {
            ClosedChannelException exc = new ClosedChannelException();
            future.setException(exc);
            this.exceptionCaught(exc);
            return future;
        }
        this.writes.add(future);
        this.startWriting();
        return future;
    }

    private void exceptionCaught(Throwable exc) {
        if (!this.closeFuture.isClosed()) {
            if (this.state.get() != 0 || !this.socket.isOpen()) {
                this.close(true);
            } else {
                try {
                    this.log.debug("Caught exception, now calling handler");
                    this.handler.exceptionCaught(this, exc);
                }
                catch (Throwable t) {
                    this.log.info("Exception handler threw exception, closing the session", t);
                    this.close(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SshFuture doCloseGracefully() {
        Queue<DefaultIoWriteFuture> queue = this.writes;
        synchronized (queue) {
            return CloseableUtils.parallel(this.writes.toArray(new SshFuture[this.writes.size()]));
        }
    }

    protected void doCloseImmediately() {
        DefaultIoWriteFuture future;
        while ((future = this.writes.poll()) != null) {
            future.setException(new ClosedChannelException());
        }
        try {
            this.socket.close();
        }
        catch (IOException e) {
            this.log.info("Exception caught while closing socket", e);
        }
        this.service.sessionClosed(this);
        this.closeFuture.setClosed();
        this.state.set(3);
        try {
            this.handler.sessionClosed(this);
        }
        catch (Exception e) {
            this.log.debug("Exception caught while calling IoHandler#sessionClosed", e);
        }
        this.log.debug("{} closed", this);
    }

    public IoService getService() {
        return this.service;
    }

    public void startReading() {
        final ByteBuffer buffer = ByteBuffer.allocate(32768);
        this.socket.read(buffer, null, new CompletionHandler<Integer, Object>(){

            @Override
            public void completed(Integer result, Object attachment) {
                try {
                    if (result >= 0) {
                        Nio2Session.this.log.debug("Read {} bytes", result);
                        buffer.flip();
                        Readable buf = new Readable(){

                            public int available() {
                                return buffer.remaining();
                            }

                            public void getRawBytes(byte[] data, int offset, int len) {
                                buffer.get(data, offset, len);
                            }
                        };
                        Nio2Session.this.handler.messageReceived(Nio2Session.this, buf);
                        if (!Nio2Session.this.closeFuture.isClosed()) {
                            Nio2Session.this.startReading();
                        } else {
                            Nio2Session.this.log.debug("IoSession has been closed, stop reading");
                        }
                    } else {
                        Nio2Session.this.log.debug("Socket has been disconnected, closing IoSession now");
                        Nio2Session.this.close(true);
                    }
                }
                catch (Throwable exc) {
                    this.failed(exc, attachment);
                }
            }

            @Override
            public void failed(Throwable exc, Object attachment) {
                Nio2Session.this.exceptionCaught(exc);
            }
        });
    }

    private void startWriting() {
        final DefaultIoWriteFuture future = this.writes.peek();
        if (future != null && this.currentWrite.compareAndSet(null, future)) {
            try {
                this.socket.write(future.buffer, null, new CompletionHandler<Integer, Object>(){

                    @Override
                    public void completed(Integer result, Object attachment) {
                        if (future.buffer.hasRemaining()) {
                            try {
                                Nio2Session.this.socket.write(future.buffer, null, this);
                            }
                            catch (Throwable t) {
                                Nio2Session.this.log.debug("Exception caught while writing", t);
                                future.setWritten();
                                this.finishWrite();
                            }
                        } else {
                            Nio2Session.this.log.debug("Finished writing");
                            future.setWritten();
                            this.finishWrite();
                        }
                    }

                    @Override
                    public void failed(Throwable exc, Object attachment) {
                        future.setException(exc);
                        Nio2Session.this.exceptionCaught(exc);
                        this.finishWrite();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private void finishWrite() {
                        Queue queue = Nio2Session.this.writes;
                        synchronized (queue) {
                            Nio2Session.this.writes.remove(future);
                            Nio2Session.this.writes.notifyAll();
                        }
                        Nio2Session.this.currentWrite.compareAndSet(future, null);
                        Nio2Session.this.startWriting();
                    }
                });
            }
            catch (RuntimeException e) {
                future.setWritten();
                throw e;
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[local=" + this.localAddress + ", remote=" + this.remoteAddress + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DefaultIoWriteFuture
    extends DefaultSshFuture<IoWriteFuture>
    implements IoWriteFuture {
        private final ByteBuffer buffer;

        DefaultIoWriteFuture(Object lock, ByteBuffer buffer) {
            super(lock);
            this.buffer = buffer;
        }

        @Override
        public boolean isWritten() {
            return this.getValue() instanceof Boolean;
        }

        @Override
        public void setWritten() {
            this.setValue(Boolean.TRUE);
        }

        @Override
        public Throwable getException() {
            Object v = this.getValue();
            return v instanceof Throwable ? (Throwable)v : null;
        }

        @Override
        public void setException(Throwable exception) {
            if (exception == null) {
                throw new IllegalArgumentException("exception");
            }
            this.setValue(exception);
        }
    }
}

