/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.BiMap;
import com.google.common.collect.testing.AbstractTester;
import com.google.common.collect.testing.FeatureSpecificTestSuiteBuilder;
import com.google.common.collect.testing.MapTestSuiteBuilder;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.PerCollectionSizeTestSuiteBuilder;
import com.google.common.collect.testing.SetTestSuiteBuilder;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.BiMapClearTester;
import com.google.common.collect.testing.google.BiMapEntrySetTester;
import com.google.common.collect.testing.google.BiMapInverseTester;
import com.google.common.collect.testing.google.BiMapPutTester;
import com.google.common.collect.testing.google.BiMapRemoveTester;
import com.google.common.collect.testing.google.DerivedGoogleCollectionGenerators;
import com.google.common.collect.testing.google.TestBiMapGenerator;
import com.google.common.collect.testing.testers.SetCreationTester;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestSuite;

@GwtIncompatible
public class BiMapTestSuiteBuilder<K, V>
extends PerCollectionSizeTestSuiteBuilder<BiMapTestSuiteBuilder<K, V>, TestBiMapGenerator<K, V>, BiMap<K, V>, Map.Entry<K, V>> {
    public static <K, V> BiMapTestSuiteBuilder<K, V> using(TestBiMapGenerator<K, V> generator) {
        return (BiMapTestSuiteBuilder)new BiMapTestSuiteBuilder<K, V>().usingGenerator(generator);
    }

    @Override
    protected List<Class<? extends AbstractTester>> getTesters() {
        ArrayList<Class<? extends AbstractTester>> testers = new ArrayList<Class<? extends AbstractTester>>();
        testers.add(BiMapEntrySetTester.class);
        testers.add(BiMapPutTester.class);
        testers.add(BiMapInverseTester.class);
        testers.add(BiMapRemoveTester.class);
        testers.add(BiMapClearTester.class);
        return testers;
    }

    @Override
    protected List<TestSuite> createDerivedSuites(FeatureSpecificTestSuiteBuilder<?, ? extends OneSizeTestContainerGenerator<BiMap<K, V>, Map.Entry<K, V>>> parentBuilder) {
        List<TestSuite> derived = super.createDerivedSuites(parentBuilder);
        derived.add(((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using(new DerivedGoogleCollectionGenerators.MapGenerator<K, V>(parentBuilder.getSubjectGenerator())).withFeatures(parentBuilder.getFeatures())).named(String.valueOf(parentBuilder.getName()).concat(" [Map]"))).suppressing(parentBuilder.getSuppressedTests())).suppressing(SetCreationTester.class.getMethods())).createTestSuite());
        derived.add(((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using(new DerivedGoogleCollectionGenerators.BiMapValueSetGenerator<K, V>(parentBuilder.getSubjectGenerator())).withFeatures(BiMapTestSuiteBuilder.computeValuesSetFeatures(parentBuilder.getFeatures()))).named(String.valueOf(parentBuilder.getName()).concat(" values [Set]"))).suppressing(parentBuilder.getSuppressedTests())).suppressing(SetCreationTester.class.getMethods())).createTestSuite());
        if (!parentBuilder.getFeatures().contains(NoRecurse.INVERSE)) {
            derived.add(((BiMapTestSuiteBuilder)((BiMapTestSuiteBuilder)((BiMapTestSuiteBuilder)BiMapTestSuiteBuilder.using(new DerivedGoogleCollectionGenerators.InverseBiMapGenerator<K, V>(parentBuilder.getSubjectGenerator())).withFeatures(BiMapTestSuiteBuilder.computeInverseFeatures(parentBuilder.getFeatures()))).named(String.valueOf(parentBuilder.getName()).concat(" inverse"))).suppressing(parentBuilder.getSuppressedTests())).createTestSuite());
        }
        return derived;
    }

    private static Set<Feature<?>> computeInverseFeatures(Set<Feature<?>> mapFeatures) {
        HashSet inverseFeatures = new HashSet(mapFeatures);
        boolean nullKeys = inverseFeatures.remove(MapFeature.ALLOWS_NULL_KEYS);
        boolean nullValues = inverseFeatures.remove(MapFeature.ALLOWS_NULL_VALUES);
        if (nullKeys) {
            inverseFeatures.add(MapFeature.ALLOWS_NULL_VALUES);
        }
        if (nullValues) {
            inverseFeatures.add(MapFeature.ALLOWS_NULL_KEYS);
        }
        inverseFeatures.add(NoRecurse.INVERSE);
        inverseFeatures.remove(CollectionFeature.KNOWN_ORDER);
        inverseFeatures.add(MapFeature.REJECTS_DUPLICATES_AT_CREATION);
        return inverseFeatures;
    }

    private static Set<Feature<?>> computeValuesSetFeatures(Set<Feature<?>> mapFeatures) {
        Set<Feature<?>> valuesCollectionFeatures = BiMapTestSuiteBuilder.computeCommonDerivedCollectionFeatures(mapFeatures);
        valuesCollectionFeatures.add(CollectionFeature.ALLOWS_NULL_QUERIES);
        if (mapFeatures.contains(MapFeature.ALLOWS_NULL_VALUES)) {
            valuesCollectionFeatures.add(CollectionFeature.ALLOWS_NULL_VALUES);
        }
        valuesCollectionFeatures.add(CollectionFeature.REJECTS_DUPLICATES_AT_CREATION);
        return valuesCollectionFeatures;
    }

    private static Set<Feature<?>> computeCommonDerivedCollectionFeatures(Set<Feature<?>> mapFeatures) {
        return MapTestSuiteBuilder.computeCommonDerivedCollectionFeatures(mapFeatures);
    }

    static enum NoRecurse implements Feature<Void>
    {
        INVERSE;


        @Override
        public Set<Feature<? super Void>> getImpliedFeatures() {
            return Collections.emptySet();
        }
    }
}

