/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractMultimapTester;
import com.google.common.collect.testing.google.ReflectionFreeAssertThrows;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.junit.Ignore;

@Ignore(value="test runners must not instantiate and run this directly, only via suites we build")
@GwtCompatible
public class MultimapAsMapTester<K, V>
extends AbstractMultimapTester<K, V, Multimap<K, V>> {
    public void testAsMapGet() {
        for (Object key : this.sampleKeys()) {
            ArrayList expectedValues = new ArrayList();
            for (Map.Entry entry : this.getSampleElements()) {
                if (!entry.getKey().equals(key)) continue;
                expectedValues.add(entry.getValue());
            }
            Collection collection = (Collection)this.multimap().asMap().get(key);
            if (expectedValues.isEmpty()) {
                MultimapAsMapTester.assertNull((Object)collection);
                continue;
            }
            Helpers.assertEqualIgnoringOrder(expectedValues, collection);
        }
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS})
    public void testAsMapGetNullKeyPresent() {
        this.initMultimapWithNullKey();
        Helpers.assertContentsAnyOrder((Iterable)this.multimap().asMap().get(null), this.getValueForNullKey());
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEY_QUERIES})
    public void testAsMapGetNullKeyAbsent() {
        MultimapAsMapTester.assertNull(this.multimap().asMap().get(null));
    }

    @MapFeature.Require(absent={MapFeature.ALLOWS_NULL_KEY_QUERIES})
    public void testAsMapGetNullKeyUnsupported() {
        ReflectionFreeAssertThrows.assertThrows(NullPointerException.class, () -> this.multimap().asMap().get(null));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testAsMapRemove() {
        Helpers.assertContentsInOrder((Iterable)this.multimap().asMap().remove(this.k0()), this.v0());
        this.assertGet(this.k0(), new Object[0]);
        MultimapAsMapTester.assertEquals((int)(this.getNumElements() - 1), (int)this.multimap().size());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testAsMapEntrySetReflectsPutSameKey() {
        this.resetContainer(Helpers.mapEntry(this.k0(), this.v0()), Helpers.mapEntry(this.k0(), this.v3()));
        Set asMapEntrySet = this.multimap().asMap().entrySet();
        Collection valueCollection = (Collection)((Map.Entry)Iterables.getOnlyElement(asMapEntrySet)).getValue();
        Helpers.assertContentsAnyOrder(valueCollection, this.v0(), this.v3());
        MultimapAsMapTester.assertTrue((boolean)this.multimap().put(this.k0(), this.v4()));
        Helpers.assertContentsAnyOrder(valueCollection, this.v0(), this.v3(), this.v4());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testAsMapEntrySetReflectsPutDifferentKey() {
        this.resetContainer(Helpers.mapEntry(this.k0(), this.v0()), Helpers.mapEntry(this.k0(), this.v3()));
        Set asMapEntrySet = this.multimap().asMap().entrySet();
        MultimapAsMapTester.assertTrue((boolean)this.multimap().put(this.k1(), this.v4()));
        MultimapAsMapTester.assertEquals((int)2, (int)asMapEntrySet.size());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.SUPPORTS_REMOVE})
    public void testAsMapEntrySetRemovePropagatesToMultimap() {
        this.resetContainer(Helpers.mapEntry(this.k0(), this.v0()), Helpers.mapEntry(this.k0(), this.v3()));
        Set asMapEntrySet = this.multimap().asMap().entrySet();
        Map.Entry asMapEntry0 = (Map.Entry)Iterables.getOnlyElement(asMapEntrySet);
        MultimapAsMapTester.assertTrue((boolean)this.multimap().put(this.k1(), this.v4()));
        MultimapAsMapTester.assertTrue((boolean)asMapEntrySet.remove(asMapEntry0));
        MultimapAsMapTester.assertEquals((int)1, (int)this.multimap().size());
        Helpers.assertContentsInOrder(this.multimap().keySet(), this.k1());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ITERATOR_REMOVE})
    public void testAsMapEntrySetIteratorRemovePropagatesToMultimap() {
        this.resetContainer(Helpers.mapEntry(this.k0(), this.v0()), Helpers.mapEntry(this.k0(), this.v3()));
        Set asMapEntrySet = this.multimap().asMap().entrySet();
        Iterator asMapEntryItr = asMapEntrySet.iterator();
        asMapEntryItr.next();
        asMapEntryItr.remove();
        MultimapAsMapTester.assertTrue((boolean)this.multimap().isEmpty());
    }
}

