/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractMultimapTester;
import com.google.common.collect.testing.google.ElementTypesAreNonnullByDefault;
import com.google.common.collect.testing.google.ReflectionFreeAssertThrows;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.junit.Ignore;

@Ignore(value="test runners must not instantiate and run this directly, only via suites we build")
@ElementTypesAreNonnullByDefault
@GwtCompatible
public class MultimapPutTester<K, V>
extends AbstractMultimapTester<K, V, Multimap<K, V>> {
    @MapFeature.Require(absent={MapFeature.SUPPORTS_PUT})
    public void testPutUnsupported() {
        ReflectionFreeAssertThrows.assertThrows(UnsupportedOperationException.class, () -> this.multimap().put(this.k3(), this.v3()));
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutEmpty() {
        int size = this.getNumElements();
        this.assertGet(this.k3(), ImmutableList.of());
        MultimapPutTester.assertTrue((boolean)this.multimap().put(this.k3(), this.v3()));
        this.assertGet(this.k3(), this.v3());
        MultimapPutTester.assertEquals((int)(size + 1), (int)this.multimap().size());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testPutPresent() {
        int size = this.getNumElements();
        this.assertGet(this.k0(), this.v0());
        MultimapPutTester.assertTrue((boolean)this.multimap().put(this.k0(), this.v3()));
        this.assertGet(this.k0(), this.v0(), this.v3());
        MultimapPutTester.assertEquals((int)(size + 1), (int)this.multimap().size());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutTwoElements() {
        int size = this.getNumElements();
        List values = Helpers.copyToList(this.multimap().get(this.k0()));
        MultimapPutTester.assertTrue((boolean)this.multimap().put(this.k0(), this.v1()));
        MultimapPutTester.assertTrue((boolean)this.multimap().put(this.k0(), this.v2()));
        values.add(this.v1());
        values.add(this.v2());
        this.assertGet(this.k0(), values);
        MultimapPutTester.assertEquals((int)(size + 2), (int)this.multimap().size());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_VALUES})
    public void testPutNullValue_supported() {
        int size = this.getNumElements();
        this.multimap().put(this.k3(), null);
        this.assertGet(this.k3(), Lists.newArrayList((Object[])new Object[]{null}));
        MultimapPutTester.assertEquals((int)(size + 1), (int)this.multimap().size());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT}, absent={MapFeature.ALLOWS_NULL_VALUES})
    public void testPutNullValue_unsupported() {
        ReflectionFreeAssertThrows.assertThrows(NullPointerException.class, () -> this.multimap().put(this.k1(), null));
        this.expectUnchanged();
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_KEYS})
    public void testPutNullKey() {
        int size = this.getNumElements();
        this.multimap().put(null, this.v3());
        this.assertGet(null, this.v3());
        MultimapPutTester.assertEquals((int)(size + 1), (int)this.multimap().size());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutNotPresentKeyPropagatesToGet() {
        int size = this.getNumElements();
        Collection collection = this.multimap().get(this.k3());
        Helpers.assertEmpty(collection);
        this.multimap().put(this.k3(), this.v3());
        Helpers.assertContains(collection, this.v3());
        MultimapPutTester.assertEquals((int)(size + 1), (int)this.multimap().size());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutNotPresentKeyPropagatesToEntries() {
        Collection entries = this.multimap().entries();
        MultimapPutTester.assertFalse((boolean)entries.contains(Helpers.mapEntry(this.k3(), this.v3())));
        this.multimap().put(this.k3(), this.v3());
        Helpers.assertContains(entries, Helpers.mapEntry(this.k3(), this.v3()));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPutPresentKeyPropagatesToEntries() {
        Collection entries = this.multimap().entries();
        MultimapPutTester.assertFalse((boolean)entries.contains(Helpers.mapEntry(this.k0(), this.v3())));
        this.multimap().put(this.k0(), this.v3());
        Helpers.assertContains(entries, Helpers.mapEntry(this.k0(), this.v3()));
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testPutPresentKeyPropagatesToGet() {
        List keys = Helpers.copyToList(this.multimap().keySet());
        for (Object key : keys) {
            this.resetContainer();
            int size = this.getNumElements();
            Collection collection = this.multimap().get(key);
            List expectedCollection = Helpers.copyToList(collection);
            this.multimap().put(key, this.v3());
            expectedCollection.add(this.v3());
            Helpers.assertEqualIgnoringOrder(expectedCollection, collection);
            MultimapPutTester.assertEquals((int)(size + 1), (int)this.multimap().size());
        }
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testPutPresentKeyPropagatesToAsMapGet() {
        List keys = Helpers.copyToList(this.multimap().keySet());
        for (Object key : keys) {
            this.resetContainer();
            int size = this.getNumElements();
            Collection collection = (Collection)this.multimap().asMap().get(key);
            MultimapPutTester.assertNotNull((Object)collection);
            List expectedCollection = Helpers.copyToList(collection);
            this.multimap().put(key, this.v3());
            expectedCollection.add(this.v3());
            Helpers.assertEqualIgnoringOrder(expectedCollection, collection);
            MultimapPutTester.assertEquals((int)(size + 1), (int)this.multimap().size());
        }
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testPutPresentKeyPropagatesToAsMapEntrySet() {
        List keys = Helpers.copyToList(this.multimap().keySet());
        for (Object key : keys) {
            this.resetContainer();
            int size = this.getNumElements();
            Iterator asMapItr = this.multimap().asMap().entrySet().iterator();
            Collection collection = null;
            while (asMapItr.hasNext()) {
                Map.Entry asMapEntry = asMapItr.next();
                if (!key.equals(asMapEntry.getKey())) continue;
                collection = (Collection)asMapEntry.getValue();
                break;
            }
            MultimapPutTester.assertNotNull(collection);
            List expectedCollection = Helpers.copyToList(collection);
            this.multimap().put(key, this.v3());
            expectedCollection.add(this.v3());
            Helpers.assertEqualIgnoringOrder(expectedCollection, collection);
            MultimapPutTester.assertEquals((int)(size + 1), (int)this.multimap().size());
        }
    }
}

