/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.testing.ElementTypesAreNonnullByDefault;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.List;
import junit.framework.AssertionFailedError;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class RelationshipTester<T> {
    private final Equivalence<? super T> equivalence;
    private final String relationshipName;
    private final String hashName;
    private final ItemReporter itemReporter;
    private final List<ImmutableList<T>> groups = Lists.newArrayList();

    RelationshipTester(Equivalence<? super T> equivalence, String relationshipName, String hashName, ItemReporter itemReporter) {
        this.equivalence = (Equivalence)Preconditions.checkNotNull(equivalence);
        this.relationshipName = (String)Preconditions.checkNotNull((Object)relationshipName);
        this.hashName = (String)Preconditions.checkNotNull((Object)hashName);
        this.itemReporter = (ItemReporter)Preconditions.checkNotNull((Object)itemReporter);
    }

    @CanIgnoreReturnValue
    public RelationshipTester<T> addRelatedGroup(Iterable<? extends T> group) {
        this.groups.add(ImmutableList.copyOf(group));
        return this;
    }

    public void test() {
        for (int groupNumber = 0; groupNumber < this.groups.size(); ++groupNumber) {
            ImmutableList<T> group = this.groups.get(groupNumber);
            for (int itemNumber = 0; itemNumber < group.size(); ++itemNumber) {
                for (int relatedItemNumber = 0; relatedItemNumber < group.size(); ++relatedItemNumber) {
                    if (itemNumber == relatedItemNumber) continue;
                    this.assertRelated(groupNumber, itemNumber, relatedItemNumber);
                }
                for (int unrelatedGroupNumber = 0; unrelatedGroupNumber < this.groups.size(); ++unrelatedGroupNumber) {
                    if (groupNumber == unrelatedGroupNumber) continue;
                    ImmutableList<T> unrelatedGroup = this.groups.get(unrelatedGroupNumber);
                    for (int unrelatedItemNumber = 0; unrelatedItemNumber < unrelatedGroup.size(); ++unrelatedItemNumber) {
                        this.assertUnrelated(groupNumber, itemNumber, unrelatedGroupNumber, unrelatedItemNumber);
                    }
                }
            }
        }
    }

    private void assertRelated(int groupNumber, int itemNumber, int relatedItemNumber) {
        Item<T> itemInfo = this.getItem(groupNumber, itemNumber);
        Item<T> relatedInfo = this.getItem(groupNumber, relatedItemNumber);
        Object item = itemInfo.value;
        Object related = relatedInfo.value;
        this.assertWithTemplate("$ITEM must be $RELATIONSHIP to $OTHER", itemInfo, relatedInfo, this.equivalence.equivalent(item, related));
        int itemHash = this.equivalence.hash(item);
        int relatedHash = this.equivalence.hash(related);
        this.assertWithTemplate("the $HASH (" + itemHash + ") of $ITEM must be equal to the $HASH (" + relatedHash + ") of $OTHER", itemInfo, relatedInfo, itemHash == relatedHash);
    }

    private void assertUnrelated(int groupNumber, int itemNumber, int unrelatedGroupNumber, int unrelatedItemNumber) {
        Item<T> itemInfo = this.getItem(groupNumber, itemNumber);
        Item<T> unrelatedInfo = this.getItem(unrelatedGroupNumber, unrelatedItemNumber);
        this.assertWithTemplate("$ITEM must not be $RELATIONSHIP to $OTHER", itemInfo, unrelatedInfo, !this.equivalence.equivalent(itemInfo.value, unrelatedInfo.value));
    }

    private void assertWithTemplate(String template, Item<T> item, Item<T> other, boolean condition) {
        if (!condition) {
            throw new AssertionFailedError(template.replace("$RELATIONSHIP", this.relationshipName).replace("$HASH", this.hashName).replace("$ITEM", this.itemReporter.reportItem(item)).replace("$OTHER", this.itemReporter.reportItem(other)));
        }
    }

    private Item<T> getItem(int groupNumber, int itemNumber) {
        return new Item<Object>(this.groups.get(groupNumber).get(itemNumber), groupNumber, itemNumber);
    }

    static class ItemReporter {
        ItemReporter() {
        }

        String reportItem(Item<?> item) {
            return item.toString();
        }
    }

    static final class Item<T> {
        final T value;
        final int groupNumber;
        final int itemNumber;

        Item(T value, int groupNumber, int itemNumber) {
            this.value = value;
            this.groupNumber = groupNumber;
            this.itemNumber = itemNumber;
        }

        public String toString() {
            return this.value + " [group " + (this.groupNumber + 1) + ", item " + (this.itemNumber + 1) + ']';
        }
    }
}

