/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Charsets;
import java.nio.charset.Charset;
import java.util.Arrays;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class CharsetsTest
extends TestCase {
    @GwtIncompatible
    public void testUsAscii() {
        CharsetsTest.assertEquals((Object)Charset.forName("US-ASCII"), (Object)Charsets.US_ASCII);
    }

    @GwtIncompatible
    public void testIso88591() {
        CharsetsTest.assertEquals((Object)Charset.forName("ISO-8859-1"), (Object)Charsets.ISO_8859_1);
    }

    public void testUtf8() {
        CharsetsTest.assertEquals((Object)Charset.forName("UTF-8"), (Object)Charsets.UTF_8);
    }

    @GwtIncompatible
    public void testUtf16be() {
        CharsetsTest.assertEquals((Object)Charset.forName("UTF-16BE"), (Object)Charsets.UTF_16BE);
    }

    @GwtIncompatible
    public void testUtf16le() {
        CharsetsTest.assertEquals((Object)Charset.forName("UTF-16LE"), (Object)Charsets.UTF_16LE);
    }

    @GwtIncompatible
    public void testUtf16() {
        CharsetsTest.assertEquals((Object)Charset.forName("UTF-16"), (Object)Charsets.UTF_16);
    }

    @GwtIncompatible
    public void testWhyUsAsciiIsDangerous() {
        byte[] b1 = "\u671d\u65e5\u65b0\u805e".getBytes(Charsets.US_ASCII);
        byte[] b2 = "\u805e\u671d\u65e5\u65b0".getBytes(Charsets.US_ASCII);
        byte[] b3 = "????".getBytes(Charsets.US_ASCII);
        byte[] b4 = "\u30cb\u30e5\u30fc\u30b9".getBytes(Charsets.US_ASCII);
        byte[] b5 = "\u30b9\u30e5\u30fc\u30fc".getBytes(Charsets.US_ASCII);
        CharsetsTest.assertTrue((boolean)Arrays.equals(b1, b2));
        CharsetsTest.assertTrue((boolean)Arrays.equals(b2, b3));
        CharsetsTest.assertTrue((boolean)Arrays.equals(b3, b4));
        CharsetsTest.assertTrue((boolean)Arrays.equals(b4, b5));
    }
}

