/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Iterator;

public class JoinerBenchmark {
    private static final String DELIMITER_STRING = ",";
    private static final char DELIMITER_CHARACTER = ',';
    private static final Joiner JOINER_ON_STRING = Joiner.on((String)",");
    private static final Joiner JOINER_ON_CHARACTER = Joiner.on((char)',');
    @Param(value={"3", "30", "300"})
    int count;
    @Param(value={"0", "1", "16", "32", "100"})
    int componentLength;
    private Iterable<String> components;

    @BeforeExperiment
    void setUp() {
        String component = Strings.repeat((String)"a", (int)this.componentLength);
        Object[] raw = new String[this.count];
        Arrays.fill(raw, component);
        this.components = Arrays.asList(raw);
    }

    @Benchmark
    int joinerWithStringDelimiter(int reps) {
        int dummy = 0;
        for (int i = 0; i < reps; ++i) {
            dummy ^= JOINER_ON_STRING.join(this.components).length();
        }
        return dummy;
    }

    @Benchmark
    int joinerWithCharacterDelimiter(int reps) {
        int dummy = 0;
        for (int i = 0; i < reps; ++i) {
            dummy ^= JOINER_ON_CHARACTER.join(this.components).length();
        }
        return dummy;
    }

    @Benchmark
    int joinerInlined(int reps) {
        int dummy = 0;
        for (int i = 0; i < reps; ++i) {
            StringBuilder sb = new StringBuilder();
            Iterator<String> iterator = this.components.iterator();
            if (iterator.hasNext()) {
                sb.append(iterator.next().toString());
                while (iterator.hasNext()) {
                    sb.append(DELIMITER_STRING);
                    sb.append(iterator.next());
                }
            }
            dummy ^= sb.toString().length();
        }
        return dummy;
    }

    @Benchmark
    int stringBuilderIsEmpty(int reps) {
        int dummy = 0;
        for (int i = 0; i < reps; ++i) {
            StringBuilder sb = new StringBuilder();
            for (String comp : this.components) {
                if (sb.length() > 0) {
                    sb.append(DELIMITER_STRING);
                }
                sb.append(comp);
            }
            dummy ^= sb.toString().length();
        }
        return dummy;
    }

    @Benchmark
    int booleanIfFirst(int reps) {
        int dummy = 0;
        for (int i = 0; i < reps; ++i) {
            StringBuilder sb = new StringBuilder();
            boolean append = false;
            for (String comp : this.components) {
                if (append) {
                    sb.append(DELIMITER_STRING);
                }
                sb.append(comp);
                append = true;
            }
            dummy ^= sb.toString().length();
        }
        return dummy;
    }

    @Benchmark
    int assignDelimiter(int reps) {
        int dummy = 0;
        for (int i = 0; i < reps; ++i) {
            StringBuilder sb = new StringBuilder();
            String delim = "";
            for (String comp : this.components) {
                sb.append(delim);
                sb.append(comp);
                delim = DELIMITER_STRING;
            }
            dummy ^= sb.toString().length();
        }
        return dummy;
    }

    @Benchmark
    int alwaysAppendThenBackUp(int reps) {
        int dummy = 0;
        for (int i = 0; i < reps; ++i) {
            StringBuilder sb = new StringBuilder();
            for (String comp : this.components) {
                sb.append(comp);
                sb.append(DELIMITER_STRING);
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - DELIMITER_STRING.length());
            }
            dummy ^= sb.toString().length();
        }
        return dummy;
    }
}

