/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.testing.ArbitraryInstances;
import com.google.common.testing.NullPointerTester;
import com.google.common.truth.Truth;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class PreconditionsTest
extends TestCase {
    private static final String NON_NULL_STRING = "foo";
    private static final ImmutableList<Class<?>> possibleParamTypes = ImmutableList.of(Character.TYPE, Integer.TYPE, Long.TYPE, Object.class);
    private static final Object IGNORE_ME = new Object(){

        public String toString() {
            throw new AssertionFailedError();
        }
    };
    private static final String FORMAT = "I ate %s pies.";

    public void testCheckArgument_simple_success() {
        Preconditions.checkArgument((boolean)true);
    }

    public void testCheckArgument_simple_failure() {
        try {
            Preconditions.checkArgument((boolean)false);
            PreconditionsTest.fail((String)"no exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCheckArgument_simpleMessage_success() {
        Preconditions.checkArgument((boolean)true, (Object)IGNORE_ME);
    }

    public void testCheckArgument_simpleMessage_failure() {
        try {
            Preconditions.checkArgument((boolean)false, (Object)new Message());
            PreconditionsTest.fail((String)"no exception thrown");
        }
        catch (IllegalArgumentException expected) {
            PreconditionsTest.verifySimpleMessage(expected);
        }
    }

    public void testCheckArgument_nullMessage_failure() {
        try {
            Preconditions.checkArgument((boolean)false, null);
            PreconditionsTest.fail((String)"no exception thrown");
        }
        catch (IllegalArgumentException expected) {
            Truth.assertThat((Throwable)expected).hasMessage("null");
        }
    }

    public void testCheckArgument_complexMessage_success() {
        Preconditions.checkArgument((boolean)true, (String)"%s", (Object)IGNORE_ME);
    }

    public void testCheckArgument_complexMessage_failure() {
        try {
            Preconditions.checkArgument((boolean)false, (String)FORMAT, (int)5);
            PreconditionsTest.fail((String)"no exception thrown");
        }
        catch (IllegalArgumentException expected) {
            PreconditionsTest.verifyComplexMessage(expected);
        }
    }

    public void testCheckState_simple_success() {
        Preconditions.checkState((boolean)true);
    }

    public void testCheckState_simple_failure() {
        try {
            Preconditions.checkState((boolean)false);
            PreconditionsTest.fail((String)"no exception thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testCheckState_simpleMessage_success() {
        Preconditions.checkState((boolean)true, (Object)IGNORE_ME);
    }

    public void testCheckState_simpleMessage_failure() {
        try {
            Preconditions.checkState((boolean)false, (Object)new Message());
            PreconditionsTest.fail((String)"no exception thrown");
        }
        catch (IllegalStateException expected) {
            PreconditionsTest.verifySimpleMessage(expected);
        }
    }

    public void testCheckState_nullMessage_failure() {
        try {
            Preconditions.checkState((boolean)false, null);
            PreconditionsTest.fail((String)"no exception thrown");
        }
        catch (IllegalStateException expected) {
            Truth.assertThat((Throwable)expected).hasMessage("null");
        }
    }

    public void testCheckState_complexMessage_success() {
        Preconditions.checkState((boolean)true, (String)"%s", (Object)IGNORE_ME);
    }

    public void testCheckState_complexMessage_failure() {
        try {
            Preconditions.checkState((boolean)false, (String)FORMAT, (int)5);
            PreconditionsTest.fail((String)"no exception thrown");
        }
        catch (IllegalStateException expected) {
            PreconditionsTest.verifyComplexMessage(expected);
        }
    }

    public void testCheckNotNull_simple_success() {
        String result = (String)Preconditions.checkNotNull((Object)NON_NULL_STRING);
        PreconditionsTest.assertSame((Object)NON_NULL_STRING, (Object)result);
    }

    public void testCheckNotNull_simple_failure() {
        try {
            Preconditions.checkNotNull(null);
            PreconditionsTest.fail((String)"no exception thrown");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testCheckNotNull_simpleMessage_success() {
        String result = (String)Preconditions.checkNotNull((Object)NON_NULL_STRING, (Object)IGNORE_ME);
        PreconditionsTest.assertSame((Object)NON_NULL_STRING, (Object)result);
    }

    public void testCheckNotNull_simpleMessage_failure() {
        try {
            Preconditions.checkNotNull(null, (Object)new Message());
            PreconditionsTest.fail((String)"no exception thrown");
        }
        catch (NullPointerException expected) {
            PreconditionsTest.verifySimpleMessage(expected);
        }
    }

    public void testCheckNotNull_complexMessage_success() {
        String result = (String)Preconditions.checkNotNull((Object)NON_NULL_STRING, (String)"%s", (Object)IGNORE_ME);
        PreconditionsTest.assertSame((Object)NON_NULL_STRING, (Object)result);
    }

    public void testCheckNotNull_complexMessage_failure() {
        try {
            Preconditions.checkNotNull(null, (String)FORMAT, (int)5);
            PreconditionsTest.fail((String)"no exception thrown");
        }
        catch (NullPointerException expected) {
            PreconditionsTest.verifyComplexMessage(expected);
        }
    }

    public void testCheckElementIndex_ok() {
        PreconditionsTest.assertEquals((int)0, (int)Preconditions.checkElementIndex((int)0, (int)1));
        PreconditionsTest.assertEquals((int)0, (int)Preconditions.checkElementIndex((int)0, (int)2));
        PreconditionsTest.assertEquals((int)1, (int)Preconditions.checkElementIndex((int)1, (int)2));
    }

    public void testCheckElementIndex_badSize() {
        try {
            Preconditions.checkElementIndex((int)1, (int)-1);
            PreconditionsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCheckElementIndex_negative() {
        try {
            Preconditions.checkElementIndex((int)-1, (int)1);
            PreconditionsTest.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            Truth.assertThat((Throwable)expected).hasMessage("index (-1) must not be negative");
        }
    }

    public void testCheckElementIndex_tooHigh() {
        try {
            Preconditions.checkElementIndex((int)1, (int)1);
            PreconditionsTest.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            Truth.assertThat((Throwable)expected).hasMessage("index (1) must be less than size (1)");
        }
    }

    public void testCheckElementIndex_withDesc_negative() {
        try {
            Preconditions.checkElementIndex((int)-1, (int)1, (String)NON_NULL_STRING);
            PreconditionsTest.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            Truth.assertThat((Throwable)expected).hasMessage("foo (-1) must not be negative");
        }
    }

    public void testCheckElementIndex_withDesc_tooHigh() {
        try {
            Preconditions.checkElementIndex((int)1, (int)1, (String)NON_NULL_STRING);
            PreconditionsTest.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            Truth.assertThat((Throwable)expected).hasMessage("foo (1) must be less than size (1)");
        }
    }

    public void testCheckPositionIndex_ok() {
        PreconditionsTest.assertEquals((int)0, (int)Preconditions.checkPositionIndex((int)0, (int)0));
        PreconditionsTest.assertEquals((int)0, (int)Preconditions.checkPositionIndex((int)0, (int)1));
        PreconditionsTest.assertEquals((int)1, (int)Preconditions.checkPositionIndex((int)1, (int)1));
    }

    public void testCheckPositionIndex_badSize() {
        try {
            Preconditions.checkPositionIndex((int)1, (int)-1);
            PreconditionsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCheckPositionIndex_negative() {
        try {
            Preconditions.checkPositionIndex((int)-1, (int)1);
            PreconditionsTest.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            Truth.assertThat((Throwable)expected).hasMessage("index (-1) must not be negative");
        }
    }

    public void testCheckPositionIndex_tooHigh() {
        try {
            Preconditions.checkPositionIndex((int)2, (int)1);
            PreconditionsTest.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            Truth.assertThat((Throwable)expected).hasMessage("index (2) must not be greater than size (1)");
        }
    }

    public void testCheckPositionIndex_withDesc_negative() {
        try {
            Preconditions.checkPositionIndex((int)-1, (int)1, (String)NON_NULL_STRING);
            PreconditionsTest.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            Truth.assertThat((Throwable)expected).hasMessage("foo (-1) must not be negative");
        }
    }

    public void testCheckPositionIndex_withDesc_tooHigh() {
        try {
            Preconditions.checkPositionIndex((int)2, (int)1, (String)NON_NULL_STRING);
            PreconditionsTest.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            Truth.assertThat((Throwable)expected).hasMessage("foo (2) must not be greater than size (1)");
        }
    }

    public void testCheckPositionIndexes_ok() {
        Preconditions.checkPositionIndexes((int)0, (int)0, (int)0);
        Preconditions.checkPositionIndexes((int)0, (int)0, (int)1);
        Preconditions.checkPositionIndexes((int)0, (int)1, (int)1);
        Preconditions.checkPositionIndexes((int)1, (int)1, (int)1);
    }

    public void testCheckPositionIndexes_badSize() {
        try {
            Preconditions.checkPositionIndexes((int)1, (int)1, (int)-1);
            PreconditionsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCheckPositionIndex_startNegative() {
        try {
            Preconditions.checkPositionIndexes((int)-1, (int)1, (int)1);
            PreconditionsTest.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            Truth.assertThat((Throwable)expected).hasMessage("start index (-1) must not be negative");
        }
    }

    public void testCheckPositionIndexes_endTooHigh() {
        try {
            Preconditions.checkPositionIndexes((int)0, (int)2, (int)1);
            PreconditionsTest.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            Truth.assertThat((Throwable)expected).hasMessage("end index (2) must not be greater than size (1)");
        }
    }

    public void testCheckPositionIndexes_reversed() {
        try {
            Preconditions.checkPositionIndexes((int)1, (int)0, (int)1);
            PreconditionsTest.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            Truth.assertThat((Throwable)expected).hasMessage("end index (0) must not be less than start index (1)");
        }
    }

    public void testFormat() {
        PreconditionsTest.assertEquals((String)"%s", (String)Preconditions.format((String)"%s", (Object[])new Object[0]));
        PreconditionsTest.assertEquals((String)"5", (String)Preconditions.format((String)"%s", (Object[])new Object[]{5}));
        PreconditionsTest.assertEquals((String)"foo [5]", (String)Preconditions.format((String)NON_NULL_STRING, (Object[])new Object[]{5}));
        PreconditionsTest.assertEquals((String)"foo [5, 6, 7]", (String)Preconditions.format((String)NON_NULL_STRING, (Object[])new Object[]{5, 6, 7}));
        PreconditionsTest.assertEquals((String)"%s 1 2", (String)Preconditions.format((String)"%s %s %s", (Object[])new Object[]{"%s", 1, 2}));
        PreconditionsTest.assertEquals((String)" [5, 6]", (String)Preconditions.format((String)"", (Object[])new Object[]{5, 6}));
        PreconditionsTest.assertEquals((String)"123", (String)Preconditions.format((String)"%s%s%s", (Object[])new Object[]{1, 2, 3}));
        PreconditionsTest.assertEquals((String)"1%s%s", (String)Preconditions.format((String)"%s%s%s", (Object[])new Object[]{1}));
        PreconditionsTest.assertEquals((String)"5 + 6 = 11", (String)Preconditions.format((String)"%s + 6 = 11", (Object[])new Object[]{5}));
        PreconditionsTest.assertEquals((String)"5 + 6 = 11", (String)Preconditions.format((String)"5 + %s = 11", (Object[])new Object[]{6}));
        PreconditionsTest.assertEquals((String)"5 + 6 = 11", (String)Preconditions.format((String)"5 + 6 = %s", (Object[])new Object[]{11}));
        PreconditionsTest.assertEquals((String)"5 + 6 = 11", (String)Preconditions.format((String)"%s + %s = %s", (Object[])new Object[]{5, 6, 11}));
        PreconditionsTest.assertEquals((String)"null [null, null]", (String)Preconditions.format((String)"%s", (Object[])new Object[]{null, null, null}));
        PreconditionsTest.assertEquals((String)"null [5, 6]", (String)Preconditions.format(null, (Object[])new Object[]{5, 6}));
    }

    @GwtIncompatible(value="Reflection")
    public void testAllOverloads_checkArgument() throws Exception {
        for (ImmutableList sig : PreconditionsTest.allSignatures(Boolean.TYPE)) {
            Method checkArgumentMethod = Preconditions.class.getMethod("checkArgument", (Class[])sig.toArray((Object[])new Class[0]));
            checkArgumentMethod.invoke(null, this.getParametersForSignature(true, sig));
            Object[] failingParams = this.getParametersForSignature(false, sig);
            try {
                checkArgumentMethod.invoke(null, failingParams);
                PreconditionsTest.fail();
            }
            catch (InvocationTargetException ite) {
                this.assertFailureCause(ite.getCause(), IllegalArgumentException.class, failingParams);
            }
        }
    }

    @GwtIncompatible(value="Reflection")
    public void testAllOverloads_checkState() throws Exception {
        for (ImmutableList sig : PreconditionsTest.allSignatures(Boolean.TYPE)) {
            Method checkArgumentMethod = Preconditions.class.getMethod("checkState", (Class[])sig.toArray((Object[])new Class[0]));
            checkArgumentMethod.invoke(null, this.getParametersForSignature(true, sig));
            Object[] failingParams = this.getParametersForSignature(false, sig);
            try {
                checkArgumentMethod.invoke(null, failingParams);
                PreconditionsTest.fail();
            }
            catch (InvocationTargetException ite) {
                this.assertFailureCause(ite.getCause(), IllegalStateException.class, failingParams);
            }
        }
    }

    @GwtIncompatible(value="Reflection")
    public void testAllOverloads_checkNotNull() throws Exception {
        for (ImmutableList sig : PreconditionsTest.allSignatures(Object.class)) {
            Method checkArgumentMethod = Preconditions.class.getMethod("checkNotNull", (Class[])sig.toArray((Object[])new Class[0]));
            checkArgumentMethod.invoke(null, this.getParametersForSignature(new Object(), sig));
            Object[] failingParams = this.getParametersForSignature(null, sig);
            try {
                checkArgumentMethod.invoke(null, failingParams);
                PreconditionsTest.fail();
            }
            catch (InvocationTargetException ite) {
                this.assertFailureCause(ite.getCause(), NullPointerException.class, failingParams);
            }
        }
    }

    private void assertFailureCause(Throwable throwable, Class<? extends Throwable> clazz, Object[] params) {
        Truth.assertThat((Throwable)throwable).isInstanceOf(clazz);
        if (params.length == 1) {
            Truth.assertThat((Throwable)throwable).hasMessage(null);
        } else if (params.length == 2) {
            Truth.assertThat((Throwable)throwable).hasMessage("");
        } else {
            Truth.assertThat((Throwable)throwable).hasMessage(Preconditions.format((String)"", (Object[])Arrays.copyOfRange(params, 2, params.length)));
        }
    }

    @GwtIncompatible(value="ArbitraryInstances")
    private Object[] getParametersForSignature(Object firstParam, ImmutableList<Class<?>> sig) {
        Object[] params = new Object[sig.size()];
        params[0] = firstParam;
        if (params.length > 1) {
            params[1] = "";
            if (params.length > 2) {
                for (int i = 2; i < params.length; ++i) {
                    params[i] = ArbitraryInstances.get((Class)((Class)sig.get(i)));
                }
            }
        }
        return params;
    }

    private static ImmutableList<ImmutableList<Class<?>>> allSignatures(Class<?> predicateType) {
        ImmutableSet.Builder allOverloads = ImmutableSet.builder();
        allOverloads.add((Object)ImmutableList.of(predicateType));
        allOverloads.add((Object)ImmutableList.of(predicateType, Object.class));
        ArrayList typesLists = new ArrayList();
        for (int i = 0; i < 2; ++i) {
            typesLists.add(possibleParamTypes);
            for (List curr : Lists.cartesianProduct(typesLists)) {
                allOverloads.add((Object)ImmutableList.builder().add(predicateType).add(String.class).addAll((Iterable)curr).build());
            }
        }
        return allOverloads.build().asList();
    }

    public void overloadSelection() {
        Boolean boxedBoolean = null;
        boolean aBoolean = true;
        Object boxedLong = null;
        int anInt = 1;
        Preconditions.checkState((boolean)boxedBoolean, (String)"", (int)1);
        Preconditions.checkState((boolean)boxedBoolean, (String)"", boxedLong);
        Preconditions.checkState((boolean)aBoolean, (String)"", (Object)(aBoolean ? "" : Integer.valueOf(anInt)), (Object)anInt);
        int s = 2;
        Preconditions.checkState((boolean)boxedBoolean, (String)"", (int)s);
    }

    @GwtIncompatible
    public void testNullPointers() {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicStaticMethods(Preconditions.class);
    }

    private static void verifySimpleMessage(Exception e) {
        Truth.assertThat((Throwable)e).hasMessage("A message");
    }

    private static void verifyComplexMessage(Exception e) {
        Truth.assertThat((Throwable)e).hasMessage("I ate 5 pies.");
    }

    private static class Message {
        boolean invoked;

        private Message() {
        }

        public String toString() {
            Assert.assertFalse((boolean)this.invoked);
            this.invoked = true;
            return "A message";
        }
    }
}

