/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.LocalCache;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

class CacheBuilderFactory {
    private Set<Integer> concurrencyLevels = Sets.newHashSet((Object[])new Integer[]{null});
    private Set<Integer> initialCapacities = Sets.newHashSet((Object[])new Integer[]{null});
    private Set<Integer> maximumSizes = Sets.newHashSet((Object[])new Integer[]{null});
    private Set<DurationSpec> expireAfterWrites = Sets.newHashSet((Object[])new DurationSpec[]{null});
    private Set<DurationSpec> expireAfterAccesses = Sets.newHashSet((Object[])new DurationSpec[]{null});
    private Set<DurationSpec> refreshes = Sets.newHashSet((Object[])new DurationSpec[]{null});
    private Set<LocalCache.Strength> keyStrengths = Sets.newHashSet((Object[])new LocalCache.Strength[]{null});
    private Set<LocalCache.Strength> valueStrengths = Sets.newHashSet((Object[])new LocalCache.Strength[]{null});
    private static final Function<Object, Optional<?>> NULLABLE_TO_OPTIONAL = new Function<Object, Optional<?>>(){

        public Optional<?> apply(@Nullable Object obj) {
            return Optional.fromNullable((Object)obj);
        }
    };
    private static final Function<Optional<?>, Object> OPTIONAL_TO_NULLABLE = new Function<Optional<?>, Object>(){

        public Object apply(Optional<?> optional) {
            return optional.orNull();
        }
    };

    CacheBuilderFactory() {
    }

    CacheBuilderFactory withConcurrencyLevels(Set<Integer> concurrencyLevels) {
        this.concurrencyLevels = Sets.newLinkedHashSet(concurrencyLevels);
        return this;
    }

    CacheBuilderFactory withInitialCapacities(Set<Integer> initialCapacities) {
        this.initialCapacities = Sets.newLinkedHashSet(initialCapacities);
        return this;
    }

    CacheBuilderFactory withMaximumSizes(Set<Integer> maximumSizes) {
        this.maximumSizes = Sets.newLinkedHashSet(maximumSizes);
        return this;
    }

    CacheBuilderFactory withExpireAfterWrites(Set<DurationSpec> durations) {
        this.expireAfterWrites = Sets.newLinkedHashSet(durations);
        return this;
    }

    CacheBuilderFactory withExpireAfterAccesses(Set<DurationSpec> durations) {
        this.expireAfterAccesses = Sets.newLinkedHashSet(durations);
        return this;
    }

    CacheBuilderFactory withRefreshes(Set<DurationSpec> durations) {
        this.refreshes = Sets.newLinkedHashSet(durations);
        return this;
    }

    CacheBuilderFactory withKeyStrengths(Set<LocalCache.Strength> keyStrengths) {
        this.keyStrengths = Sets.newLinkedHashSet(keyStrengths);
        Preconditions.checkArgument((!this.keyStrengths.contains(LocalCache.Strength.SOFT) ? 1 : 0) != 0);
        return this;
    }

    CacheBuilderFactory withValueStrengths(Set<LocalCache.Strength> valueStrengths) {
        this.valueStrengths = Sets.newLinkedHashSet(valueStrengths);
        return this;
    }

    Iterable<CacheBuilder<Object, Object>> buildAllPermutations() {
        Iterable<List<Object>> combinations = this.buildCartesianProduct(this.concurrencyLevels, this.initialCapacities, this.maximumSizes, this.expireAfterWrites, this.expireAfterAccesses, this.refreshes, this.keyStrengths, this.valueStrengths);
        return Iterables.transform(combinations, (Function)new Function<List<Object>, CacheBuilder<Object, Object>>(){

            public CacheBuilder<Object, Object> apply(List<Object> combination) {
                return CacheBuilderFactory.this.createCacheBuilder((Integer)combination.get(0), (Integer)combination.get(1), (Integer)combination.get(2), (DurationSpec)combination.get(3), (DurationSpec)combination.get(4), (DurationSpec)combination.get(5), (LocalCache.Strength)combination.get(6), (LocalCache.Strength)combination.get(7));
            }
        });
    }

    private Iterable<List<Object>> buildCartesianProduct(Set<?> ... sets) {
        ArrayList optionalSets = Lists.newArrayListWithExpectedSize((int)sets.length);
        for (Set<?> set : sets) {
            LinkedHashSet optionalSet = Sets.newLinkedHashSet((Iterable)Iterables.transform(set, NULLABLE_TO_OPTIONAL));
            optionalSets.add(optionalSet);
        }
        Set cartesianProduct = Sets.cartesianProduct((List)optionalSets);
        return Iterables.transform((Iterable)cartesianProduct, (Function)new Function<List<Optional<?>>, List<Object>>(){

            public List<Object> apply(List<Optional<?>> objs) {
                return Lists.transform(objs, (Function)OPTIONAL_TO_NULLABLE);
            }
        });
    }

    private CacheBuilder<Object, Object> createCacheBuilder(Integer concurrencyLevel, Integer initialCapacity, Integer maximumSize, DurationSpec expireAfterWrite, DurationSpec expireAfterAccess, DurationSpec refresh, LocalCache.Strength keyStrength, LocalCache.Strength valueStrength) {
        CacheBuilder builder = CacheBuilder.newBuilder();
        if (concurrencyLevel != null) {
            builder.concurrencyLevel(concurrencyLevel.intValue());
        }
        if (initialCapacity != null) {
            builder.initialCapacity(initialCapacity.intValue());
        }
        if (maximumSize != null) {
            builder.maximumSize((long)maximumSize.intValue());
        }
        if (expireAfterWrite != null) {
            builder.expireAfterWrite(expireAfterWrite.duration, expireAfterWrite.unit);
        }
        if (expireAfterAccess != null) {
            builder.expireAfterAccess(expireAfterAccess.duration, expireAfterAccess.unit);
        }
        if (refresh != null) {
            builder.refreshAfterWrite(refresh.duration, refresh.unit);
        }
        if (keyStrength != null) {
            builder.setKeyStrength(keyStrength);
        }
        if (valueStrength != null) {
            builder.setValueStrength(valueStrength);
        }
        return builder;
    }

    static class DurationSpec {
        private final long duration;
        private final TimeUnit unit;

        private DurationSpec(long duration, TimeUnit unit) {
            this.duration = duration;
            this.unit = unit;
        }

        public static DurationSpec of(long duration, TimeUnit unit) {
            return new DurationSpec(duration, unit);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.duration, this.unit});
        }

        public boolean equals(Object o) {
            if (o instanceof DurationSpec) {
                DurationSpec that = (DurationSpec)o;
                return this.unit.toNanos(this.duration) == that.unit.toNanos(that.duration);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("duration", this.duration).add("unit", (Object)this.unit).toString();
        }
    }
}

