/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheBuilderFactory;
import com.google.common.cache.CacheTesting;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.LocalCache;
import com.google.common.cache.TestingCacheLoaders;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.testing.EqualsTester;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;

public class EmptyCachesTest
extends TestCase {
    public void testEmpty() {
        for (LoadingCache<Object, Object> cache : this.caches()) {
            CacheTesting.checkEmpty(cache);
        }
    }

    public void testInvalidate_empty() {
        for (LoadingCache<Object, Object> cache : this.caches()) {
            cache.getUnchecked((Object)"a");
            cache.getUnchecked((Object)"b");
            cache.invalidate((Object)"a");
            cache.invalidate((Object)"b");
            cache.invalidate((Object)0);
            CacheTesting.checkEmpty(cache);
        }
    }

    public void testInvalidateAll_empty() {
        for (LoadingCache<Object, Object> cache : this.caches()) {
            cache.getUnchecked((Object)"a");
            cache.getUnchecked((Object)"b");
            cache.getUnchecked((Object)"c");
            cache.invalidateAll();
            CacheTesting.checkEmpty(cache);
        }
    }

    public void testEquals_null() {
        for (LoadingCache<Object, Object> cache : this.caches()) {
            EmptyCachesTest.assertFalse((boolean)cache.equals(null));
        }
    }

    public void testEqualsAndHashCode_different() {
        for (CacheBuilder<Object, Object> builder : this.cacheFactory().buildAllPermutations()) {
            new EqualsTester().addEqualityGroup(new Object[]{builder.build(TestingCacheLoaders.identityLoader())}).addEqualityGroup(new Object[]{builder.build(TestingCacheLoaders.identityLoader())}).addEqualityGroup(new Object[]{builder.build(TestingCacheLoaders.identityLoader())}).testEquals();
        }
    }

    public void testGet_null() throws ExecutionException {
        for (LoadingCache<Object, Object> cache : this.caches()) {
            try {
                cache.get(null);
                EmptyCachesTest.fail((String)"Expected NullPointerException");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            CacheTesting.checkEmpty(cache);
        }
    }

    public void testGetUnchecked_null() {
        for (LoadingCache<Object, Object> cache : this.caches()) {
            try {
                cache.getUnchecked(null);
                EmptyCachesTest.fail((String)"Expected NullPointerException");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            CacheTesting.checkEmpty(cache);
        }
    }

    public void testKeySet_nullToArray() {
        for (LoadingCache<Object, Object> cache : this.caches()) {
            Set keys = cache.asMap().keySet();
            try {
                keys.toArray((T[])null);
                EmptyCachesTest.fail();
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            CacheTesting.checkEmpty(cache);
        }
    }

    public void testKeySet_addNotSupported() {
        for (LoadingCache<Object, Object> cache : this.caches()) {
            try {
                cache.asMap().keySet().add(1);
                EmptyCachesTest.fail();
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
            try {
                cache.asMap().keySet().addAll(Arrays.asList(1, 2));
                EmptyCachesTest.fail();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
    }

    public void testKeySet_clear() {
        for (LoadingCache<Object, Object> cache : this.caches()) {
            EmptyCachesTest.warmUp(cache, 0, 100);
            Set keys = cache.asMap().keySet();
            keys.clear();
            CacheTesting.checkEmpty(keys);
            CacheTesting.checkEmpty(cache);
        }
    }

    public void testKeySet_empty_remove() {
        for (LoadingCache<Object, Object> cache : this.caches()) {
            Set keys = cache.asMap().keySet();
            EmptyCachesTest.assertFalse((boolean)keys.remove(null));
            EmptyCachesTest.assertFalse((boolean)keys.remove(6));
            EmptyCachesTest.assertFalse((boolean)keys.remove(-6));
            EmptyCachesTest.assertFalse((boolean)keys.removeAll(Arrays.asList(null, 0, 15, 1500)));
            EmptyCachesTest.assertFalse((boolean)keys.retainAll(Arrays.asList(null, 0, 15, 1500)));
            CacheTesting.checkEmpty(keys);
            CacheTesting.checkEmpty(cache);
        }
    }

    public void testKeySet_remove() {
        for (LoadingCache<Object, Object> cache : this.caches()) {
            cache.getUnchecked((Object)1);
            cache.getUnchecked((Object)2);
            Set keys = cache.asMap().keySet();
            keys.remove(1);
            keys.remove(2);
            EmptyCachesTest.assertFalse((boolean)keys.remove(null));
            EmptyCachesTest.assertFalse((boolean)keys.remove(6));
            EmptyCachesTest.assertFalse((boolean)keys.remove(-6));
            EmptyCachesTest.assertFalse((boolean)keys.removeAll(Arrays.asList(null, 0, 15, 1500)));
            EmptyCachesTest.assertFalse((boolean)keys.retainAll(Arrays.asList(null, 0, 15, 1500)));
            CacheTesting.checkEmpty(keys);
            CacheTesting.checkEmpty(cache);
        }
    }

    public void testValues_nullToArray() {
        for (LoadingCache<Object, Object> cache : this.caches()) {
            Collection values = cache.asMap().values();
            try {
                values.toArray((T[])null);
                EmptyCachesTest.fail();
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            CacheTesting.checkEmpty(cache);
        }
    }

    public void testValues_addNotSupported() {
        for (LoadingCache<Object, Object> cache : this.caches()) {
            try {
                cache.asMap().values().add(1);
                EmptyCachesTest.fail();
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
            try {
                cache.asMap().values().addAll(Arrays.asList(1, 2));
                EmptyCachesTest.fail();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
    }

    public void testValues_clear() {
        for (LoadingCache<Object, Object> cache : this.caches()) {
            EmptyCachesTest.warmUp(cache, 0, 100);
            Collection values = cache.asMap().values();
            values.clear();
            CacheTesting.checkEmpty(values);
            CacheTesting.checkEmpty(cache);
        }
    }

    public void testValues_empty_remove() {
        for (LoadingCache<Object, Object> cache : this.caches()) {
            Collection values = cache.asMap().values();
            EmptyCachesTest.assertFalse((boolean)values.remove(null));
            EmptyCachesTest.assertFalse((boolean)values.remove(6));
            EmptyCachesTest.assertFalse((boolean)values.remove(-6));
            EmptyCachesTest.assertFalse((boolean)values.removeAll(Arrays.asList(null, 0, 15, 1500)));
            EmptyCachesTest.assertFalse((boolean)values.retainAll(Arrays.asList(null, 0, 15, 1500)));
            CacheTesting.checkEmpty(values);
            CacheTesting.checkEmpty(cache);
        }
    }

    public void testValues_remove() {
        for (LoadingCache<Object, Object> cache : this.caches()) {
            cache.getUnchecked((Object)1);
            cache.getUnchecked((Object)2);
            Set values = cache.asMap().keySet();
            values.remove(1);
            values.remove(2);
            EmptyCachesTest.assertFalse((boolean)values.remove(null));
            EmptyCachesTest.assertFalse((boolean)values.remove(6));
            EmptyCachesTest.assertFalse((boolean)values.remove(-6));
            EmptyCachesTest.assertFalse((boolean)values.removeAll(Arrays.asList(null, 0, 15, 1500)));
            EmptyCachesTest.assertFalse((boolean)values.retainAll(Arrays.asList(null, 0, 15, 1500)));
            CacheTesting.checkEmpty(values);
            CacheTesting.checkEmpty(cache);
        }
    }

    public void testEntrySet_nullToArray() {
        for (LoadingCache<Object, Object> cache : this.caches()) {
            Set entries = cache.asMap().entrySet();
            try {
                entries.toArray((T[])null);
                EmptyCachesTest.fail();
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            CacheTesting.checkEmpty(cache);
        }
    }

    public void testEntrySet_addNotSupported() {
        for (LoadingCache<Object, Object> cache : this.caches()) {
            try {
                cache.asMap().entrySet().add(this.entryOf(1, 1));
                EmptyCachesTest.fail();
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
            try {
                cache.asMap().values().addAll(Arrays.asList(this.entryOf(1, 1), this.entryOf(2, 2)));
                EmptyCachesTest.fail();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
    }

    public void testEntrySet_clear() {
        for (LoadingCache<Object, Object> cache : this.caches()) {
            EmptyCachesTest.warmUp(cache, 0, 100);
            Set entrySet = cache.asMap().entrySet();
            entrySet.clear();
            CacheTesting.checkEmpty(entrySet);
            CacheTesting.checkEmpty(cache);
        }
    }

    public void testEntrySet_empty_remove() {
        for (LoadingCache<Object, Object> cache : this.caches()) {
            Set entrySet = cache.asMap().entrySet();
            EmptyCachesTest.assertFalse((boolean)entrySet.remove(null));
            EmptyCachesTest.assertFalse((boolean)entrySet.remove(this.entryOf(6, 6)));
            EmptyCachesTest.assertFalse((boolean)entrySet.remove(this.entryOf(-6, -6)));
            EmptyCachesTest.assertFalse((boolean)entrySet.removeAll(Arrays.asList(null, this.entryOf(0, 0), this.entryOf(15, 15))));
            EmptyCachesTest.assertFalse((boolean)entrySet.retainAll(Arrays.asList(null, this.entryOf(0, 0), this.entryOf(15, 15))));
            CacheTesting.checkEmpty(entrySet);
            CacheTesting.checkEmpty(cache);
        }
    }

    public void testEntrySet_remove() {
        for (LoadingCache<Object, Object> cache : this.caches()) {
            cache.getUnchecked((Object)1);
            cache.getUnchecked((Object)2);
            Set entrySet = cache.asMap().entrySet();
            entrySet.remove(this.entryOf(1, 1));
            entrySet.remove(this.entryOf(2, 2));
            EmptyCachesTest.assertFalse((boolean)entrySet.remove(null));
            EmptyCachesTest.assertFalse((boolean)entrySet.remove(this.entryOf(1, 1)));
            EmptyCachesTest.assertFalse((boolean)entrySet.remove(this.entryOf(6, 6)));
            EmptyCachesTest.assertFalse((boolean)entrySet.removeAll(Arrays.asList(null, this.entryOf(1, 1), this.entryOf(15, 15))));
            EmptyCachesTest.assertFalse((boolean)entrySet.retainAll(Arrays.asList(null, this.entryOf(1, 1), this.entryOf(15, 15))));
            CacheTesting.checkEmpty(entrySet);
            CacheTesting.checkEmpty(cache);
        }
    }

    private Iterable<LoadingCache<Object, Object>> caches() {
        CacheBuilderFactory factory = this.cacheFactory();
        return Iterables.transform(factory.buildAllPermutations(), (Function)new Function<CacheBuilder<Object, Object>, LoadingCache<Object, Object>>(){

            public LoadingCache<Object, Object> apply(CacheBuilder<Object, Object> builder) {
                return builder.build(TestingCacheLoaders.identityLoader());
            }
        });
    }

    private CacheBuilderFactory cacheFactory() {
        return new CacheBuilderFactory().withKeyStrengths((Set<LocalCache.Strength>)ImmutableSet.of((Object)LocalCache.Strength.STRONG, (Object)LocalCache.Strength.WEAK)).withValueStrengths((Set<LocalCache.Strength>)ImmutableSet.copyOf((Object[])LocalCache.Strength.values())).withConcurrencyLevels((Set<Integer>)ImmutableSet.of((Object)1, (Object)4, (Object)16, (Object)64)).withMaximumSizes((Set<Integer>)ImmutableSet.of((Object)0, (Object)1, (Object)10, (Object)100, (Object)1000)).withInitialCapacities((Set<Integer>)ImmutableSet.of((Object)0, (Object)1, (Object)10, (Object)100, (Object)1000)).withExpireAfterWrites((Set<CacheBuilderFactory.DurationSpec>)ImmutableSet.of((Object)CacheBuilderFactory.DurationSpec.of(0L, TimeUnit.SECONDS), (Object)CacheBuilderFactory.DurationSpec.of(1L, TimeUnit.SECONDS), (Object)CacheBuilderFactory.DurationSpec.of(1L, TimeUnit.DAYS))).withExpireAfterAccesses((Set<CacheBuilderFactory.DurationSpec>)ImmutableSet.of((Object)CacheBuilderFactory.DurationSpec.of(0L, TimeUnit.SECONDS), (Object)CacheBuilderFactory.DurationSpec.of(1L, TimeUnit.SECONDS), (Object)CacheBuilderFactory.DurationSpec.of(1L, TimeUnit.DAYS))).withRefreshes((Set<CacheBuilderFactory.DurationSpec>)ImmutableSet.of((Object)CacheBuilderFactory.DurationSpec.of(1L, TimeUnit.SECONDS), (Object)CacheBuilderFactory.DurationSpec.of(1L, TimeUnit.DAYS)));
    }

    private static void warmUp(LoadingCache<Object, Object> cache, int minimum, int maximum) {
        for (int i = minimum; i < maximum; ++i) {
            cache.getUnchecked((Object)i);
        }
    }

    private Map.Entry<Object, Object> entryOf(Object key, Object value) {
        return Maps.immutableEntry((Object)key, (Object)value);
    }
}

