/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.ForwardingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.concurrent.ExecutionException;
import junit.framework.TestCase;
import org.mockito.Mockito;

public class ForwardingCacheTest
extends TestCase {
    private Cache<String, Boolean> forward;
    private Cache<String, Boolean> mock;

    public void setUp() throws Exception {
        super.setUp();
        this.mock = (Cache)Mockito.mock(Cache.class);
        this.forward = new ForwardingCache<String, Boolean>(){

            protected Cache<String, Boolean> delegate() {
                return ForwardingCacheTest.this.mock;
            }
        };
    }

    public void testGetIfPresent() throws ExecutionException {
        Mockito.when((Object)this.mock.getIfPresent((Object)"key")).thenReturn((Object)Boolean.TRUE);
        ForwardingCacheTest.assertSame((Object)Boolean.TRUE, (Object)this.forward.getIfPresent((Object)"key"));
    }

    public void testGetAllPresent() throws ExecutionException {
        Mockito.when((Object)this.mock.getAllPresent((Iterable)ImmutableList.of((Object)"key"))).thenReturn((Object)ImmutableMap.of((Object)"key", (Object)Boolean.TRUE));
        ForwardingCacheTest.assertEquals((Object)ImmutableMap.of((Object)"key", (Object)Boolean.TRUE), (Object)this.forward.getAllPresent((Iterable)ImmutableList.of((Object)"key")));
    }

    public void testInvalidate() {
        this.forward.invalidate((Object)"key");
        ((Cache)Mockito.verify(this.mock)).invalidate((Object)"key");
    }

    public void testInvalidateAllIterable() {
        this.forward.invalidateAll((Iterable)ImmutableList.of((Object)"key"));
        ((Cache)Mockito.verify(this.mock)).invalidateAll((Iterable)ImmutableList.of((Object)"key"));
    }

    public void testInvalidateAll() {
        this.forward.invalidateAll();
        ((Cache)Mockito.verify(this.mock)).invalidateAll();
    }

    public void testSize() {
        Mockito.when((Object)this.mock.size()).thenReturn((Object)0L);
        ForwardingCacheTest.assertEquals((long)0L, (long)this.forward.size());
    }

    public void testStats() {
        Mockito.when((Object)this.mock.stats()).thenReturn(null);
        ForwardingCacheTest.assertNull((Object)this.forward.stats());
    }

    public void testAsMap() {
        Mockito.when((Object)this.mock.asMap()).thenReturn(null);
        ForwardingCacheTest.assertNull((Object)this.forward.asMap());
    }

    public void testCleanUp() {
        this.forward.cleanUp();
        ((Cache)Mockito.verify(this.mock)).cleanUp();
    }

    private static class OnlyGet<K, V>
    extends ForwardingCache<K, V> {
        private OnlyGet() {
        }

        protected Cache<K, V> delegate() {
            return null;
        }
    }
}

