/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

@GwtCompatible(emulated=true)
class TestingCacheLoaders {
    TestingCacheLoaders() {
    }

    static <K, V> CacheLoader<K, V> bulkLoader(final CacheLoader<K, V> loader) {
        Preconditions.checkNotNull(loader);
        return new CacheLoader<K, V>(){

            public V load(K key) throws Exception {
                return loader.load(key);
            }

            public Map<K, V> loadAll(Iterable<? extends K> keys) throws Exception {
                HashMap result = Maps.newHashMap();
                for (Object key : keys) {
                    result.put(key, this.load(key));
                }
                return result;
            }
        };
    }

    static <K, V> ConstantLoader<K, V> constantLoader(@Nullable V constant) {
        return new ConstantLoader(constant);
    }

    static IncrementingLoader incrementingLoader() {
        return new IncrementingLoader();
    }

    static <K, V> CacheLoader<K, V> errorLoader(final Error e) {
        Preconditions.checkNotNull((Object)e);
        return new CacheLoader<K, V>(){

            public V load(K key) {
                throw e;
            }
        };
    }

    static <K, V> CacheLoader<K, V> exceptionLoader(final Exception e) {
        Preconditions.checkNotNull((Object)e);
        return new CacheLoader<K, V>(){

            public V load(K key) throws Exception {
                throw e;
            }
        };
    }

    static <T> IdentityLoader<T> identityLoader() {
        return new IdentityLoader();
    }

    static final class IdentityLoader<T>
    extends CacheLoader<T, T> {
        IdentityLoader() {
        }

        public T load(T key) {
            return key;
        }
    }

    static class IncrementingLoader
    extends CacheLoader<Integer, Integer> {
        private final AtomicInteger countLoad = new AtomicInteger();
        private final AtomicInteger countReload = new AtomicInteger();

        IncrementingLoader() {
        }

        public Integer load(Integer key) {
            this.countLoad.incrementAndGet();
            return key;
        }

        @GwtIncompatible
        public ListenableFuture<Integer> reload(Integer key, Integer oldValue) {
            this.countReload.incrementAndGet();
            return Futures.immediateFuture((Object)(oldValue + 1));
        }

        public int getLoadCount() {
            return this.countLoad.get();
        }

        public int getReloadCount() {
            return this.countReload.get();
        }
    }

    static final class ConstantLoader<K, V>
    extends CacheLoader<K, V> {
        private final V constant;

        ConstantLoader(V constant) {
            this.constant = constant;
        }

        public V load(K key) {
            return this.constant;
        }
    }

    static class CountingLoader
    extends CacheLoader<Object, Object> {
        private final AtomicInteger count = new AtomicInteger();

        CountingLoader() {
        }

        public Object load(Object from) {
            this.count.incrementAndGet();
            return new Object();
        }

        public int getCount() {
            return this.count.get();
        }
    }
}

