/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.collect.testing.AbstractIteratorTester;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.IteratorFeature;
import com.google.common.collect.testing.IteratorTester;
import com.google.common.collect.testing.MinimalCollection;
import com.google.common.collect.testing.MinimalIterable;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public abstract class AbstractImmutableSetTest
extends TestCase {
    static final int LAST_COLOR_ADDED = 49151;

    protected abstract Set<String> of();

    protected abstract Set<String> of(String var1);

    protected abstract Set<String> of(String var1, String var2);

    protected abstract Set<String> of(String var1, String var2, String var3);

    protected abstract Set<String> of(String var1, String var2, String var3, String var4);

    protected abstract Set<String> of(String var1, String var2, String var3, String var4, String var5);

    protected abstract Set<String> of(String var1, String var2, String var3, String var4, String var5, String var6, String ... var7);

    protected abstract Set<String> copyOf(String[] var1);

    protected abstract Set<String> copyOf(Collection<String> var1);

    protected abstract Set<String> copyOf(Iterable<String> var1);

    protected abstract Set<String> copyOf(Iterator<String> var1);

    public void testCreation_noArgs() {
        Set<String> set = this.of();
        AbstractImmutableSetTest.assertEquals(Collections.emptySet(), set);
        AbstractImmutableSetTest.assertSame(this.of(), set);
    }

    public void testCreation_oneElement() {
        Set<String> set = this.of("a");
        AbstractImmutableSetTest.assertEquals(Collections.singleton("a"), set);
    }

    public void testCreation_twoElements() {
        Set<String> set = this.of("a", "b");
        AbstractImmutableSetTest.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"a", "b"}), set);
    }

    public void testCreation_threeElements() {
        Set<String> set = this.of("a", "b", "c");
        AbstractImmutableSetTest.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"a", "b", "c"}), set);
    }

    public void testCreation_fourElements() {
        Set<String> set = this.of("a", "b", "c", "d");
        AbstractImmutableSetTest.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"a", "b", "c", "d"}), set);
    }

    public void testCreation_fiveElements() {
        Set<String> set = this.of("a", "b", "c", "d", "e");
        AbstractImmutableSetTest.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"a", "b", "c", "d", "e"}), set);
    }

    public void testCreation_sixElements() {
        Set<String> set = this.of("a", "b", "c", "d", "e", "f", new String[0]);
        AbstractImmutableSetTest.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"a", "b", "c", "d", "e", "f"}), set);
    }

    public void testCreation_sevenElements() {
        Set<String> set = this.of("a", "b", "c", "d", "e", "f", "g");
        AbstractImmutableSetTest.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"a", "b", "c", "d", "e", "f", "g"}), set);
    }

    public void testCreation_eightElements() {
        Set<String> set = this.of("a", "b", "c", "d", "e", "f", "g", "h");
        AbstractImmutableSetTest.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"a", "b", "c", "d", "e", "f", "g", "h"}), set);
    }

    public void testCopyOf_emptyArray() {
        String[] array = new String[]{};
        Set<String> set = this.copyOf(array);
        AbstractImmutableSetTest.assertEquals(Collections.emptySet(), set);
        AbstractImmutableSetTest.assertSame(this.of(), set);
    }

    public void testCopyOf_arrayOfOneElement() {
        String[] array = new String[]{"a"};
        Set<String> set = this.copyOf(array);
        AbstractImmutableSetTest.assertEquals(Collections.singleton("a"), set);
    }

    public void testCopyOf_nullArray() {
        try {
            this.copyOf((String[])null);
            AbstractImmutableSetTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testCopyOf_arrayContainingOnlyNull() {
        String[] array = new String[]{null};
        try {
            this.copyOf(array);
            AbstractImmutableSetTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testCopyOf_collection_empty() {
        MinimalCollection c = MinimalCollection.of((Object[])new String[0]);
        Set<String> set = this.copyOf((Collection<String>)c);
        AbstractImmutableSetTest.assertEquals(Collections.emptySet(), set);
        AbstractImmutableSetTest.assertSame(this.of(), set);
    }

    public void testCopyOf_collection_oneElement() {
        MinimalCollection c = MinimalCollection.of((Object[])new String[]{"a"});
        Set<String> set = this.copyOf((Collection<String>)c);
        AbstractImmutableSetTest.assertEquals(Collections.singleton("a"), set);
    }

    public void testCopyOf_collection_oneElementRepeated() {
        MinimalCollection c = MinimalCollection.of((Object[])new String[]{"a", "a", "a"});
        Set<String> set = this.copyOf((Collection<String>)c);
        AbstractImmutableSetTest.assertEquals(Collections.singleton("a"), set);
    }

    public void testCopyOf_collection_general() {
        MinimalCollection c = MinimalCollection.of((Object[])new String[]{"a", "b", "a"});
        Set<String> set = this.copyOf((Collection<String>)c);
        AbstractImmutableSetTest.assertEquals((int)2, (int)set.size());
        AbstractImmutableSetTest.assertTrue((boolean)set.contains("a"));
        AbstractImmutableSetTest.assertTrue((boolean)set.contains("b"));
    }

    public void testCopyOf_collectionContainingNull() {
        MinimalCollection c = MinimalCollection.of((Object[])new String[]{"a", null, "b"});
        try {
            this.copyOf((Collection<String>)c);
            AbstractImmutableSetTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testCopyOf_iterator_empty() {
        UnmodifiableIterator iterator = Iterators.emptyIterator();
        Set<String> set = this.copyOf((Iterator<String>)iterator);
        AbstractImmutableSetTest.assertEquals(Collections.emptySet(), set);
        AbstractImmutableSetTest.assertSame(this.of(), set);
    }

    public void testCopyOf_iterator_oneElement() {
        UnmodifiableIterator iterator = Iterators.singletonIterator((Object)"a");
        Set<String> set = this.copyOf((Iterator<String>)iterator);
        AbstractImmutableSetTest.assertEquals(Collections.singleton("a"), set);
    }

    public void testCopyOf_iterator_oneElementRepeated() {
        UnmodifiableIterator iterator = Iterators.forArray((Object[])new String[]{"a", "a", "a"});
        Set<String> set = this.copyOf((Iterator<String>)iterator);
        AbstractImmutableSetTest.assertEquals(Collections.singleton("a"), set);
    }

    public void testCopyOf_iterator_general() {
        UnmodifiableIterator iterator = Iterators.forArray((Object[])new String[]{"a", "b", "a"});
        Set<String> set = this.copyOf((Iterator<String>)iterator);
        AbstractImmutableSetTest.assertEquals((int)2, (int)set.size());
        AbstractImmutableSetTest.assertTrue((boolean)set.contains("a"));
        AbstractImmutableSetTest.assertTrue((boolean)set.contains("b"));
    }

    public void testCopyOf_iteratorContainingNull() {
        UnmodifiableIterator c = Iterators.forArray((Object[])new String[]{"a", null, "b"});
        try {
            this.copyOf((Iterator<String>)c);
            AbstractImmutableSetTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testCopyOf_plainIterable() {
        CountingIterable iterable = new CountingIterable();
        Set<String> set = this.copyOf(iterable);
        AbstractImmutableSetTest.assertEquals((int)2, (int)set.size());
        AbstractImmutableSetTest.assertTrue((boolean)set.contains("a"));
        AbstractImmutableSetTest.assertTrue((boolean)set.contains("b"));
    }

    public void testCopyOf_plainIterable_iteratesOnce() {
        CountingIterable iterable = new CountingIterable();
        Set<String> unused = this.copyOf(iterable);
        AbstractImmutableSetTest.assertEquals((int)1, (int)iterable.count);
    }

    public void testCopyOf_shortcut_empty() {
        Set<String> c = this.of();
        AbstractImmutableSetTest.assertEquals(Collections.emptySet(), this.copyOf((Collection<String>)c));
        AbstractImmutableSetTest.assertSame(c, this.copyOf((Collection<String>)c));
    }

    public void testCopyOf_shortcut_singleton() {
        Set<String> c = this.of("a");
        AbstractImmutableSetTest.assertEquals(Collections.singleton("a"), this.copyOf((Collection<String>)c));
        AbstractImmutableSetTest.assertSame(c, this.copyOf((Collection<String>)c));
    }

    public void testCopyOf_shortcut_sameType() {
        Set<String> c = this.of("a", "b", "c");
        AbstractImmutableSetTest.assertSame(c, this.copyOf((Collection<String>)c));
    }

    public void testToString() {
        Set<String> set = this.of("a", "b", "c", "d", "e", "f", "g");
        AbstractImmutableSetTest.assertEquals((String)"[a, b, c, d, e, f, g]", (String)set.toString());
    }

    @GwtIncompatible
    public void testIterator_oneElement() {
        new IteratorTester<String>(5, (Iterable)IteratorFeature.UNMODIFIABLE, Collections.singleton("a"), AbstractIteratorTester.KnownOrder.KNOWN_ORDER){

            protected Iterator<String> newTargetIterator() {
                return AbstractImmutableSetTest.this.of("a").iterator();
            }
        }.test();
    }

    @GwtIncompatible
    public void testIterator_general() {
        new IteratorTester<String>(5, (Iterable)IteratorFeature.UNMODIFIABLE, Arrays.asList("a", "b", "c"), AbstractIteratorTester.KnownOrder.KNOWN_ORDER){

            protected Iterator<String> newTargetIterator() {
                return AbstractImmutableSetTest.this.of("a", "b", "c").iterator();
            }
        }.test();
    }

    public void testContainsAll_sameType() {
        Set<String> c = this.of("a", "b", "c");
        AbstractImmutableSetTest.assertFalse((boolean)c.containsAll(this.of("a", "b", "c", "d")));
        AbstractImmutableSetTest.assertFalse((boolean)c.containsAll(this.of("a", "d")));
        AbstractImmutableSetTest.assertTrue((boolean)c.containsAll(this.of("a", "c")));
        AbstractImmutableSetTest.assertTrue((boolean)c.containsAll(this.of("a", "b", "c")));
    }

    public void testEquals_sameType() {
        Set<String> c = this.of("a", "b", "c");
        AbstractImmutableSetTest.assertTrue((boolean)c.equals(this.of("a", "b", "c")));
        AbstractImmutableSetTest.assertFalse((boolean)c.equals(this.of("a", "b", "d")));
    }

    abstract <E extends Comparable<E>> ImmutableSet.Builder<E> builder();

    public void testBuilderWithNonDuplicateElements() {
        ImmutableSet set = this.builder().add((Object)"a").add((Object[])new String[]{"b", "c"}).add((Object[])new String[]{"d", "e", "f"}).add((Object[])new String[]{"g", "h", "i", "j"}).build();
        Truth.assertThat((Iterable)set).containsExactly(new Object[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j"}).inOrder();
    }

    public void testReuseBuilderWithNonDuplicateElements() {
        ImmutableSet.Builder builder = this.builder().add((Object)"a").add((Object)"b");
        Truth.assertThat((Iterable)builder.build()).containsExactly(new Object[]{"a", "b"}).inOrder();
        builder.add((Object[])new String[]{"c", "d"});
        Truth.assertThat((Iterable)builder.build()).containsExactly(new Object[]{"a", "b", "c", "d"}).inOrder();
    }

    public void testBuilderWithDuplicateElements() {
        ImmutableSet set = this.builder().add((Object)"a").add((Object[])new String[]{"a", "a"}).add((Object[])new String[]{"a", "a", "a"}).add((Object[])new String[]{"a", "a", "a", "a"}).build();
        AbstractImmutableSetTest.assertTrue((boolean)set.contains((Object)"a"));
        AbstractImmutableSetTest.assertFalse((boolean)set.contains((Object)"b"));
        AbstractImmutableSetTest.assertEquals((int)1, (int)set.size());
    }

    public void testReuseBuilderWithDuplicateElements() {
        ImmutableSet.Builder builder = this.builder().add((Object)"a").add((Object[])new String[]{"a", "a"}).add((Object)"b");
        Truth.assertThat((Iterable)builder.build()).containsExactly(new Object[]{"a", "b"}).inOrder();
        builder.add((Object[])new String[]{"a", "b", "c", "c"});
        Truth.assertThat((Iterable)builder.build()).containsExactly(new Object[]{"a", "b", "c"}).inOrder();
    }

    public void testBuilderAddAll() {
        List<String> a = Arrays.asList("a", "b", "c");
        List<String> b = Arrays.asList("c", "d", "e");
        ImmutableSet set = this.builder().addAll(a).addAll(b).build();
        Truth.assertThat((Iterable)set).containsExactly(new Object[]{"a", "b", "c", "d", "e"}).inOrder();
    }

    public void testComplexBuilder() {
        List<Integer> colorElem = Arrays.asList(0, 51, 102, 153, 204, 255);
        ImmutableSet.Builder webSafeColorsBuilder = this.builder();
        for (Integer red : colorElem) {
            for (Integer green : colorElem) {
                for (Integer blue : colorElem) {
                    webSafeColorsBuilder.add((Object)((red << 16) + (green << 8) + blue));
                }
            }
        }
        ImmutableSet webSafeColors = webSafeColorsBuilder.build();
        AbstractImmutableSetTest.assertEquals((int)216, (int)webSafeColors.size());
        Integer[] webSafeColorArray = (Integer[])webSafeColors.toArray((Object[])new Integer[webSafeColors.size()]);
        AbstractImmutableSetTest.assertEquals((int)0, (int)webSafeColorArray[0]);
        AbstractImmutableSetTest.assertEquals((int)51, (int)webSafeColorArray[1]);
        AbstractImmutableSetTest.assertEquals((int)102, (int)webSafeColorArray[2]);
        AbstractImmutableSetTest.assertEquals((int)13056, (int)webSafeColorArray[6]);
        AbstractImmutableSetTest.assertEquals((int)0x330000, (int)webSafeColorArray[36]);
        ImmutableSet addedColor = webSafeColorsBuilder.add((Object)49151).build();
        AbstractImmutableSetTest.assertEquals((String)"Modifying the builder should not have changed any already built sets", (int)216, (int)webSafeColors.size());
        AbstractImmutableSetTest.assertEquals((String)"the new array should be one bigger than webSafeColors", (int)217, (int)addedColor.size());
        Integer[] appendColorArray = (Integer[])addedColor.toArray((Object[])new Integer[addedColor.size()]);
        AbstractImmutableSetTest.assertEquals((int)this.getComplexBuilderSetLastElement(), (int)appendColorArray[216]);
    }

    abstract int getComplexBuilderSetLastElement();

    public void testBuilderAddHandlesNullsCorrectly() {
        ImmutableSet.Builder builder = this.builder();
        try {
            builder.add((Object)null);
            AbstractImmutableSetTest.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        builder = this.builder();
        try {
            builder.add((Object[])null);
            AbstractImmutableSetTest.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        builder = this.builder();
        try {
            builder.add((Object[])new String[]{"a", null});
            AbstractImmutableSetTest.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        builder = this.builder();
        try {
            builder.add((Object[])new String[]{"a", "b", null});
            AbstractImmutableSetTest.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        builder = this.builder();
        try {
            builder.add((Object[])new String[]{"a", "b", "c", null});
            AbstractImmutableSetTest.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        builder = this.builder();
        try {
            builder.add((Object[])new String[]{"a", "b", null, "c"});
            AbstractImmutableSetTest.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testBuilderAddAllHandlesNullsCorrectly() {
        ImmutableSet.Builder builder = this.builder();
        try {
            builder.addAll((Iterable)null);
            AbstractImmutableSetTest.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            builder.addAll((Iterator)null);
            AbstractImmutableSetTest.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        builder = this.builder();
        List<String> listWithNulls = Arrays.asList("a", null, "b");
        try {
            builder.addAll(listWithNulls);
            AbstractImmutableSetTest.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        MinimalIterable iterableWithNulls = MinimalIterable.of((Object[])new String[]{"a", null, "b"});
        try {
            builder.addAll((Iterable)iterableWithNulls);
            AbstractImmutableSetTest.fail((String)"expected NullPointerException");
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
    }

    @GwtIncompatible
    void verifyThreadSafe() {
        ArrayList sample = Lists.newArrayList((Object[])new String[]{"a", "b", "c"});
        for (int delta : new int[]{-1, 0, 1}) {
            for (int i = 0; i < sample.size(); ++i) {
                Collection misleading = Helpers.misleadingSizeCollection((int)delta);
                List expected = sample.subList(0, i);
                misleading.addAll(expected);
                AbstractImmutableSetTest.assertEquals((String)("delta: " + delta + " sample size: " + i), (Object)Sets.newHashSet(expected), this.copyOf(misleading));
            }
        }
    }

    private static class CountingIterable
    implements Iterable<String> {
        int count = 0;

        private CountingIterable() {
        }

        @Override
        public Iterator<String> iterator() {
            ++this.count;
            return Iterators.forArray((Object[])new String[]{"a", "b", "a"});
        }
    }
}

