/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import junit.framework.TestCase;

@GwtIncompatible
public abstract class AbstractRangeSetTest
extends TestCase {
    public static void testInvariants(RangeSet<?> rangeSet) {
        AbstractRangeSetTest.testInvariantsInternal(rangeSet);
        AbstractRangeSetTest.testInvariantsInternal(rangeSet.complement());
    }

    private static <C extends Comparable> void testInvariantsInternal(RangeSet<C> rangeSet) {
        AbstractRangeSetTest.assertEquals((boolean)rangeSet.asRanges().isEmpty(), (boolean)rangeSet.isEmpty());
        AbstractRangeSetTest.assertEquals((boolean)rangeSet.asDescendingSetOfRanges().isEmpty(), (boolean)rangeSet.isEmpty());
        AbstractRangeSetTest.assertEquals((!rangeSet.asRanges().iterator().hasNext() ? 1 : 0) != 0, (boolean)rangeSet.isEmpty());
        AbstractRangeSetTest.assertEquals((!rangeSet.asDescendingSetOfRanges().iterator().hasNext() ? 1 : 0) != 0, (boolean)rangeSet.isEmpty());
        ImmutableList asRanges = ImmutableList.copyOf((Collection)rangeSet.asRanges());
        int i = 0;
        while (i + 1 < asRanges.size()) {
            Range range1 = (Range)asRanges.get(i);
            Range range2 = (Range)asRanges.get(i + 1);
            AbstractRangeSetTest.assertFalse((boolean)range1.isConnected(range2));
            ++i;
        }
        for (Range range : asRanges) {
            AbstractRangeSetTest.assertFalse((boolean)range.isEmpty());
        }
        Iterator itr = rangeSet.asRanges().iterator();
        Range expectedSpan = null;
        if (itr.hasNext()) {
            expectedSpan = (Range)itr.next();
            while (itr.hasNext()) {
                expectedSpan = expectedSpan.span((Range)itr.next());
            }
        }
        try {
            Range span = rangeSet.span();
            AbstractRangeSetTest.assertEquals((Object)expectedSpan, (Object)span);
        }
        catch (NoSuchElementException e) {
            AbstractRangeSetTest.assertNull((Object)expectedSpan);
        }
        AbstractRangeSetTest.assertEquals((Object)Lists.reverse((List)asRanges), (Object)ImmutableList.copyOf((Collection)rangeSet.asDescendingSetOfRanges()));
    }
}

