/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ArrayTable;
import com.google.common.collect.BiMap;
import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedMultiset;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MapMaker;
import com.google.common.collect.MapMakerInternalMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.SortedMultiset;
import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import com.google.common.collect.TreeMultimap;
import com.google.common.collect.TreeMultiset;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;

final class BenchmarkHelpers {
    BenchmarkHelpers() {
    }

    public static enum ListSizeDistribution {
        UNIFORM_0_TO_2(0, 2),
        UNIFORM_0_TO_9(0, 9),
        ALWAYS_0(0, 0),
        ALWAYS_10(10, 10);

        final int min;
        final int max;

        private ListSizeDistribution(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public int chooseSize(Random random) {
            return random.nextInt(this.max - this.min + 1) + this.min;
        }
    }

    public static enum Value {
        INSTANCE;

    }

    static enum TableImpl {
        HashBased{

            @Override
            <R extends Comparable<R>, C extends Comparable<C>, V> Table<R, C, V> create(Table<R, C, V> contents) {
                return HashBasedTable.create(contents);
            }
        }
        ,
        TreeBased{

            @Override
            <R extends Comparable<R>, C extends Comparable<C>, V> Table<R, C, V> create(Table<R, C, V> contents) {
                TreeBasedTable table = TreeBasedTable.create();
                table.putAll(contents);
                return table;
            }
        }
        ,
        Array{

            @Override
            <R extends Comparable<R>, C extends Comparable<C>, V> Table<R, C, V> create(Table<R, C, V> contents) {
                if (contents.isEmpty()) {
                    return ImmutableTable.of();
                }
                return ArrayTable.create(contents);
            }
        }
        ,
        Immutable{

            @Override
            <R extends Comparable<R>, C extends Comparable<C>, V> Table<R, C, V> create(Table<R, C, V> contents) {
                return ImmutableTable.copyOf(contents);
            }
        };


        abstract <R extends Comparable<R>, C extends Comparable<C>, V> Table<R, C, V> create(Table<R, C, V> var1);
    }

    static enum SortedMultisetImpl {
        Tree{

            @Override
            <E extends Comparable<E>> SortedMultiset<E> create(Multiset<E> contents) {
                return TreeMultiset.create(contents);
            }
        }
        ,
        ImmutableSorted{

            @Override
            <E extends Comparable<E>> SortedMultiset<E> create(Multiset<E> contents) {
                return ImmutableSortedMultiset.copyOf(contents);
            }
        };


        abstract <E extends Comparable<E>> SortedMultiset<E> create(Multiset<E> var1);
    }

    static enum MultisetImpl {
        Hash{

            @Override
            <E> Multiset<E> create(Multiset<E> contents) {
                return HashMultiset.create(contents);
            }
        }
        ,
        LinkedHash{

            @Override
            <E> Multiset<E> create(Multiset<E> contents) {
                return LinkedHashMultiset.create(contents);
            }
        }
        ,
        ConcurrentHash{

            @Override
            <E> Multiset<E> create(Multiset<E> contents) {
                return ConcurrentHashMultiset.create(contents);
            }
        }
        ,
        Immutable{

            @Override
            <E> Multiset<E> create(Multiset<E> contents) {
                return ImmutableMultiset.copyOf(contents);
            }
        };


        abstract <E> Multiset<E> create(Multiset<E> var1);
    }

    static enum BiMapImpl {
        Hash{

            @Override
            <K, V> BiMap<K, V> create(BiMap<K, V> map) {
                return HashBiMap.create(map);
            }
        }
        ,
        Immutable{

            @Override
            <K, V> BiMap<K, V> create(BiMap<K, V> map) {
                return ImmutableBiMap.copyOf(map);
            }
        };


        abstract <K, V> BiMap<K, V> create(BiMap<K, V> var1);
    }

    static enum SortedMapImpl {
        Tree{

            @Override
            <K extends Comparable<K>, V> SortedMap<K, V> create(Map<K, V> map) {
                TreeMap result = Maps.newTreeMap();
                result.putAll(map);
                return result;
            }
        }
        ,
        ConcurrentSkipList{

            @Override
            <K extends Comparable<K>, V> SortedMap<K, V> create(Map<K, V> map) {
                return new ConcurrentSkipListMap<K, V>(map);
            }
        }
        ,
        ImmutableSorted{

            @Override
            <K extends Comparable<K>, V> SortedMap<K, V> create(Map<K, V> map) {
                return ImmutableSortedMap.copyOf(map);
            }
        };


        abstract <K extends Comparable<K>, V> SortedMap<K, V> create(Map<K, V> var1);
    }

    public static enum MapImpl {
        Hash{

            @Override
            <K, V> Map<K, V> create(Map<K, V> map) {
                return Maps.newHashMap(map);
            }
        }
        ,
        LinkedHash{

            @Override
            <K, V> Map<K, V> create(Map<K, V> map) {
                return Maps.newLinkedHashMap(map);
            }
        }
        ,
        ConcurrentHash{

            @Override
            <K, V> Map<K, V> create(Map<K, V> map) {
                return new ConcurrentHashMap<K, V>(map);
            }
        }
        ,
        Immutable{

            @Override
            <K, V> Map<K, V> create(Map<K, V> map) {
                return ImmutableMap.copyOf(map);
            }
        }
        ,
        MapMakerStrongKeysStrongValues{

            @Override
            <K, V> Map<K, V> create(Map<K, V> map) {
                ConcurrentMap newMap = new MapMaker().keyEquivalence(Equivalence.equals()).makeMap();
                Preconditions.checkState((boolean)(newMap instanceof MapMakerInternalMap));
                newMap.putAll(map);
                return newMap;
            }
        }
        ,
        MapMakerStrongKeysWeakValues{

            @Override
            <K, V> Map<K, V> create(Map<K, V> map) {
                ConcurrentMap newMap = new MapMaker().weakValues().makeMap();
                Preconditions.checkState((boolean)(newMap instanceof MapMakerInternalMap));
                newMap.putAll(map);
                return newMap;
            }
        }
        ,
        MapMakerWeakKeysStrongValues{

            @Override
            <K, V> Map<K, V> create(Map<K, V> map) {
                ConcurrentMap newMap = new MapMaker().weakKeys().makeMap();
                Preconditions.checkState((boolean)(newMap instanceof MapMakerInternalMap));
                newMap.putAll(map);
                return newMap;
            }
        }
        ,
        MapMakerWeakKeysWeakValues{

            @Override
            <K, V> Map<K, V> create(Map<K, V> map) {
                ConcurrentMap newMap = new MapMaker().weakKeys().weakValues().makeMap();
                Preconditions.checkState((boolean)(newMap instanceof MapMakerInternalMap));
                newMap.putAll(map);
                return newMap;
            }
        };


        abstract <K, V> Map<K, V> create(Map<K, V> var1);
    }

    public static enum SetMultimapImpl {
        Hash{

            @Override
            <K extends Comparable<K>, V extends Comparable<V>> SetMultimap<K, V> create(Multimap<K, V> contents) {
                return HashMultimap.create(contents);
            }
        }
        ,
        LinkedHash{

            @Override
            <K extends Comparable<K>, V extends Comparable<V>> SetMultimap<K, V> create(Multimap<K, V> contents) {
                return LinkedHashMultimap.create(contents);
            }
        }
        ,
        Tree{

            @Override
            <K extends Comparable<K>, V extends Comparable<V>> SetMultimap<K, V> create(Multimap<K, V> contents) {
                return TreeMultimap.create(contents);
            }
        }
        ,
        ImmutableSet{

            @Override
            <K extends Comparable<K>, V extends Comparable<V>> SetMultimap<K, V> create(Multimap<K, V> contents) {
                return ImmutableSetMultimap.copyOf(contents);
            }
        };


        abstract <K extends Comparable<K>, V extends Comparable<V>> SetMultimap<K, V> create(Multimap<K, V> var1);
    }

    public static enum ListMultimapImpl {
        ArrayList{

            @Override
            <K, V> ListMultimap<K, V> create(Multimap<K, V> contents) {
                return ArrayListMultimap.create(contents);
            }
        }
        ,
        LinkedList{

            @Override
            <K, V> ListMultimap<K, V> create(Multimap<K, V> contents) {
                return LinkedListMultimap.create(contents);
            }
        }
        ,
        ImmutableList{

            @Override
            <K, V> ListMultimap<K, V> create(Multimap<K, V> contents) {
                return ImmutableListMultimap.copyOf(contents);
            }
        };


        abstract <K, V> ListMultimap<K, V> create(Multimap<K, V> var1);
    }

    public static enum SetImpl {
        Hash{

            @Override
            <E extends Comparable<E>> Set<E> create(Collection<E> contents) {
                return new HashSet<E>(contents);
            }
        }
        ,
        LinkedHash{

            @Override
            <E extends Comparable<E>> Set<E> create(Collection<E> contents) {
                return new LinkedHashSet<E>(contents);
            }
        }
        ,
        Tree{

            @Override
            <E extends Comparable<E>> Set<E> create(Collection<E> contents) {
                return new TreeSet<E>(contents);
            }
        }
        ,
        Unmodifiable{

            @Override
            <E extends Comparable<E>> Set<E> create(Collection<E> contents) {
                return Collections.unmodifiableSet(new HashSet<E>(contents));
            }
        }
        ,
        Synchronized{

            @Override
            <E extends Comparable<E>> Set<E> create(Collection<E> contents) {
                return Collections.synchronizedSet(new HashSet<E>(contents));
            }
        }
        ,
        Immutable{

            @Override
            <E extends Comparable<E>> Set<E> create(Collection<E> contents) {
                return ImmutableSet.copyOf(contents);
            }
        }
        ,
        ImmutableSorted{

            @Override
            <E extends Comparable<E>> Set<E> create(Collection<E> contents) {
                return ImmutableSortedSet.copyOf(contents);
            }
        };


        abstract <E extends Comparable<E>> Set<E> create(Collection<E> var1);
    }
}

