/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.AbstractImmutableTableTest;
import com.google.common.collect.ArrayTable;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.TreeBasedTable;
import com.google.common.testing.EqualsTester;

@GwtCompatible(emulated=true)
public class EmptyImmutableTableTest
extends AbstractImmutableTableTest {
    private static final ImmutableTable<Character, Integer, String> INSTANCE = ImmutableTable.of();

    @Override
    Iterable<ImmutableTable<Character, Integer, String>> getTestInstances() {
        return ImmutableSet.of(INSTANCE);
    }

    public void testHashCode() {
        EmptyImmutableTableTest.assertEquals((int)0, (int)INSTANCE.hashCode());
    }

    public void testEqualsObject() {
        HashBasedTable nonEmptyTable = HashBasedTable.create();
        nonEmptyTable.put((Object)Character.valueOf('A'), (Object)1, (Object)"blah");
        new EqualsTester().addEqualityGroup(new Object[]{INSTANCE, HashBasedTable.create(), TreeBasedTable.create()}).addEqualityGroup(new Object[]{nonEmptyTable}).testEquals();
    }

    @GwtIncompatible
    public void testEqualsObjectNullValues() {
        new EqualsTester().addEqualityGroup(new Object[]{INSTANCE}).addEqualityGroup(new Object[]{ArrayTable.create((Iterable)ImmutableSet.of((Object)Character.valueOf('A')), (Iterable)ImmutableSet.of((Object)1))}).testEquals();
    }

    public void testToString() {
        EmptyImmutableTableTest.assertEquals((String)"{}", (String)INSTANCE.toString());
    }

    public void testSize() {
        EmptyImmutableTableTest.assertEquals((int)0, (int)INSTANCE.size());
    }

    public void testGet() {
        EmptyImmutableTableTest.assertNull((Object)INSTANCE.get((Object)Character.valueOf('a'), (Object)1));
    }

    public void testIsEmpty() {
        EmptyImmutableTableTest.assertTrue((boolean)INSTANCE.isEmpty());
    }

    public void testCellSet() {
        EmptyImmutableTableTest.assertEquals((Object)ImmutableSet.of(), (Object)INSTANCE.cellSet());
    }

    public void testColumn() {
        EmptyImmutableTableTest.assertEquals((Object)ImmutableMap.of(), (Object)INSTANCE.column((Object)1));
    }

    public void testColumnKeySet() {
        EmptyImmutableTableTest.assertEquals((Object)ImmutableSet.of(), (Object)INSTANCE.columnKeySet());
    }

    public void testColumnMap() {
        EmptyImmutableTableTest.assertEquals((Object)ImmutableMap.of(), (Object)INSTANCE.columnMap());
    }

    public void testContains() {
        EmptyImmutableTableTest.assertFalse((boolean)INSTANCE.contains((Object)Character.valueOf('a'), (Object)1));
    }

    public void testContainsColumn() {
        EmptyImmutableTableTest.assertFalse((boolean)INSTANCE.containsColumn((Object)1));
    }

    public void testContainsRow() {
        EmptyImmutableTableTest.assertFalse((boolean)INSTANCE.containsRow((Object)Character.valueOf('a')));
    }

    public void testContainsValue() {
        EmptyImmutableTableTest.assertFalse((boolean)INSTANCE.containsValue((Object)"blah"));
    }

    public void testRow() {
        EmptyImmutableTableTest.assertEquals((Object)ImmutableMap.of(), (Object)INSTANCE.row((Object)Character.valueOf('a')));
    }

    public void testRowKeySet() {
        EmptyImmutableTableTest.assertEquals((Object)ImmutableSet.of(), (Object)INSTANCE.rowKeySet());
    }

    public void testRowMap() {
        EmptyImmutableTableTest.assertEquals((Object)ImmutableMap.of(), (Object)INSTANCE.rowMap());
    }

    public void testValues() {
        EmptyImmutableTableTest.assertTrue((boolean)INSTANCE.values().isEmpty());
    }
}

