/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.EnumMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.google.common.collect.testing.AnEnum;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.google.MultisetFeature;
import com.google.common.collect.testing.google.MultisetTestSuiteBuilder;
import com.google.common.collect.testing.google.TestEnumMultisetGenerator;
import com.google.common.collect.testing.google.TestMultisetGenerator;
import com.google.common.testing.ClassSanityTester;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.SerializableTester;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

@GwtCompatible(emulated=true)
public class EnumMultisetTest
extends TestCase {
    @GwtIncompatible
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)((MultisetTestSuiteBuilder)((MultisetTestSuiteBuilder)MultisetTestSuiteBuilder.using((TestMultisetGenerator)EnumMultisetTest.enumMultisetGenerator()).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, CollectionFeature.GENERAL_PURPOSE, CollectionFeature.SUPPORTS_ITERATOR_REMOVE, CollectionFeature.ALLOWS_NULL_QUERIES, MultisetFeature.ENTRIES_ARE_VIEWS})).named("EnumMultiset")).createTestSuite());
        suite.addTestSuite(EnumMultisetTest.class);
        return suite;
    }

    private static TestEnumMultisetGenerator enumMultisetGenerator() {
        return new TestEnumMultisetGenerator(){

            protected Multiset<AnEnum> create(AnEnum[] elements) {
                return elements.length == 0 ? EnumMultiset.create(AnEnum.class) : EnumMultiset.create(Arrays.asList(elements));
            }
        };
    }

    public void testClassCreate() {
        EnumMultiset ms = EnumMultiset.create(Color.class);
        ms.add((Object)Color.RED);
        ms.add((Object)Color.YELLOW);
        ms.add((Object)Color.RED);
        EnumMultisetTest.assertEquals((int)0, (int)ms.count((Object)Color.BLUE));
        EnumMultisetTest.assertEquals((int)1, (int)ms.count((Object)Color.YELLOW));
        EnumMultisetTest.assertEquals((int)2, (int)ms.count((Object)Color.RED));
    }

    public void testCollectionCreate() {
        EnumMultiset ms = EnumMultiset.create(Arrays.asList(Color.RED, Color.YELLOW, Color.RED));
        EnumMultisetTest.assertEquals((int)0, (int)ms.count((Object)Color.BLUE));
        EnumMultisetTest.assertEquals((int)1, (int)ms.count((Object)Color.YELLOW));
        EnumMultisetTest.assertEquals((int)2, (int)ms.count((Object)Color.RED));
    }

    public void testIllegalCreate() {
        EnumSet<Color> empty = EnumSet.noneOf(Color.class);
        try {
            EnumMultiset.create(empty);
            EnumMultisetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCreateEmptyWithClass() {
        EnumMultiset ms = EnumMultiset.create((Iterable)ImmutableList.of(), Color.class);
        ms.add((Object)Color.RED);
    }

    public void testCreateEmptyWithoutClassFails() {
        try {
            EnumMultiset.create((Iterable)ImmutableList.of());
            EnumMultisetTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testToString() {
        EnumMultiset ms = EnumMultiset.create(Color.class);
        ms.add((Object)Color.BLUE, 3);
        ms.add((Object)Color.YELLOW, 1);
        ms.add((Object)Color.RED, 2);
        EnumMultisetTest.assertEquals((String)"[BLUE x 3, RED x 2, YELLOW]", (String)ms.toString());
    }

    @GwtIncompatible
    public void testSerializable() {
        EnumMultiset ms = EnumMultiset.create(Arrays.asList(Color.RED, Color.YELLOW, Color.RED));
        EnumMultisetTest.assertEquals((Object)ms, (Object)SerializableTester.reserialize((Object)ms));
    }

    public void testEntrySet() {
        EnumMultiset ms = EnumMultiset.create(Color.class);
        ms.add((Object)Color.BLUE, 3);
        ms.add((Object)Color.YELLOW, 1);
        ms.add((Object)Color.RED, 2);
        Set uniqueEntries = Sets.newIdentityHashSet();
        uniqueEntries.addAll(ms.entrySet());
        EnumMultisetTest.assertEquals((int)3, (int)uniqueEntries.size());
    }

    @GwtIncompatible
    public void testEquals() throws Exception {
        new ClassSanityTester().setDistinctValues(Class.class, Color.class, Gender.class).setDistinctValues(Enum.class, (Object)Color.BLUE, (Object)Color.RED).forAllPublicStaticMethods(EnumMultisetFactory.class).testEquals();
    }

    @GwtIncompatible
    public void testNulls() throws Exception {
        new NullPointerTester().setDefault(Class.class, Color.class).setDefault(Iterable.class, EnumSet.allOf(Color.class)).testAllPublicStaticMethods(EnumMultiset.class);
    }

    private static class EnumMultisetFactory {
        private EnumMultisetFactory() {
        }

        public static <E extends Enum<E>> EnumMultiset<E> create(Iterable<E> elements) {
            return EnumMultiset.create(elements);
        }
    }

    private static enum Gender {
        MALE,
        FEMALE;

    }

    private static enum Color {
        BLUE,
        RED,
        YELLOW,
        GREEN,
        WHITE;

    }
}

