/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ForwardingMapTest;
import com.google.common.collect.ForwardingSortedMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.MapTestSuiteBuilder;
import com.google.common.collect.testing.SafeTreeMap;
import com.google.common.collect.testing.SortedMapTestSuiteBuilder;
import com.google.common.collect.testing.TestSortedMapGenerator;
import com.google.common.collect.testing.TestStringSortedMapGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.MapFeature;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import junit.framework.Test;
import junit.framework.TestSuite;

public class ForwardingSortedMapTest
extends ForwardingMapTest {
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(ForwardingSortedMapTest.class);
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)SortedMapTestSuiteBuilder.using((TestSortedMapGenerator)new TestStringSortedMapGenerator(){

            protected SortedMap<String, String> create(Map.Entry<String, String>[] entries) {
                SafeTreeMap map = new SafeTreeMap();
                for (Map.Entry<String, String> entry : entries) {
                    map.put(entry.getKey(), entry.getValue());
                }
                return new StandardImplForwardingSortedMap(map);
            }
        }).named("ForwardingSortedMap[SafeTreeMap] with no comparator and standard implementations")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, MapFeature.ALLOWS_NULL_VALUES, MapFeature.GENERAL_PURPOSE, CollectionFeature.SUPPORTS_ITERATOR_REMOVE})).createTestSuite());
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)SortedMapTestSuiteBuilder.using((TestSortedMapGenerator)new TestStringSortedMapGenerator(){
            private final Comparator<String> comparator = Helpers.NullsBeforeTwo.INSTANCE;

            protected SortedMap<String, String> create(Map.Entry<String, String>[] entries) {
                SafeTreeMap map = new SafeTreeMap(this.comparator);
                for (Map.Entry<String, String> entry : entries) {
                    map.put(entry.getKey(), entry.getValue());
                }
                return new StandardImplForwardingSortedMap(map);
            }
        }).named("ForwardingSortedMap[SafeTreeMap] with natural comparator and standard implementations")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, MapFeature.ALLOWS_NULL_VALUES, MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_ANY_NULL_QUERIES, MapFeature.GENERAL_PURPOSE, CollectionFeature.SUPPORTS_ITERATOR_REMOVE})).createTestSuite());
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)SortedMapTestSuiteBuilder.using((TestSortedMapGenerator)new TestStringSortedMapGenerator(){

            protected SortedMap<String, String> create(Map.Entry<String, String>[] entries) {
                ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
                for (Map.Entry<String, String> entry : entries) {
                    builder.put((Object)entry.getKey(), (Object)entry.getValue());
                }
                return new StandardImplForwardingSortedMap(builder.build());
            }
        }).named("ForwardingSortedMap[ImmutableSortedMap] with standard implementations")).withFeatures(new Feature[]{CollectionSize.ANY, MapFeature.REJECTS_DUPLICATES_AT_CREATION, MapFeature.ALLOWS_ANY_NULL_QUERIES})).createTestSuite());
        return suite;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        final SortedMap sortedMap = this.createProxyInstance(SortedMap.class);
        this.forward = new ForwardingSortedMap<String, Boolean>(){

            protected SortedMap<String, Boolean> delegate() {
                return sortedMap;
            }
        };
    }

    public void testComparator() {
        this.forward().comparator();
        ForwardingSortedMapTest.assertEquals((String)"[comparator]", (String)this.getCalls());
    }

    public void testFirstKey() {
        this.forward().firstKey();
        ForwardingSortedMapTest.assertEquals((String)"[firstKey]", (String)this.getCalls());
    }

    public void testHeadMap_K() {
        this.forward().headMap("asdf");
        ForwardingSortedMapTest.assertEquals((String)"[headMap(Object)]", (String)this.getCalls());
    }

    public void testLastKey() {
        this.forward().lastKey();
        ForwardingSortedMapTest.assertEquals((String)"[lastKey]", (String)this.getCalls());
    }

    public void testSubMap_K_K() {
        this.forward().subMap("first", "last");
        ForwardingSortedMapTest.assertEquals((String)"[subMap(Object,Object)]", (String)this.getCalls());
    }

    public void testTailMap_K() {
        this.forward().tailMap("last");
        ForwardingSortedMapTest.assertEquals((String)"[tailMap(Object)]", (String)this.getCalls());
    }

    SortedMap<String, Boolean> forward() {
        return (SortedMap)super.forward();
    }

    static class StandardImplForwardingSortedMap<K, V>
    extends ForwardingSortedMap<K, V> {
        private final SortedMap<K, V> backingMap;

        StandardImplForwardingSortedMap(SortedMap<K, V> backingMap) {
            this.backingMap = backingMap;
        }

        protected SortedMap<K, V> delegate() {
            return this.backingMap;
        }

        public boolean containsKey(Object key) {
            return this.standardContainsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.standardContainsValue(value);
        }

        public void putAll(Map<? extends K, ? extends V> map) {
            this.standardPutAll(map);
        }

        public V remove(Object object) {
            return (V)this.standardRemove(object);
        }

        public boolean equals(Object object) {
            return this.standardEquals(object);
        }

        public int hashCode() {
            return this.standardHashCode();
        }

        public Set<K> keySet() {
            return new ForwardingSortedMap.StandardKeySet((ForwardingSortedMap)this);
        }

        public Collection<V> values() {
            return new ForwardingMap.StandardValues((ForwardingMap)this);
        }

        public String toString() {
            return this.standardToString();
        }

        public Set<Map.Entry<K, V>> entrySet() {
            return new ForwardingMap.StandardEntrySet(){

                public Iterator<Map.Entry<K, V>> iterator() {
                    return StandardImplForwardingSortedMap.this.backingMap.entrySet().iterator();
                }
            };
        }

        public void clear() {
            this.standardClear();
        }

        public boolean isEmpty() {
            return this.standardIsEmpty();
        }

        public SortedMap<K, V> subMap(K fromKey, K toKey) {
            return this.standardSubMap(fromKey, toKey);
        }
    }
}

