/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.SingletonImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.ListTestSuiteBuilder;
import com.google.common.collect.testing.MinimalCollection;
import com.google.common.collect.testing.MinimalIterable;
import com.google.common.collect.testing.TestListGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.google.ListGenerators;
import com.google.common.collect.testing.testers.ListHashCodeTester;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.SerializableTester;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

@GwtCompatible(emulated=true)
public class ImmutableListTest
extends TestCase {
    @GwtIncompatible
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using((TestListGenerator)new ListGenerators.ImmutableListOfGenerator()).named("ImmutableList")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using((TestListGenerator)new ListGenerators.BuilderAddAllListGenerator()).named("ImmutableList, built with Builder.add")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using((TestListGenerator)new ListGenerators.BuilderAddAllListGenerator()).named("ImmutableList, built with Builder.addAll")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using((TestListGenerator)new ListGenerators.BuilderReversedListGenerator()).named("ImmutableList, reversed")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using((TestListGenerator)new ListGenerators.ImmutableListHeadSubListGenerator()).named("ImmutableList, head subList")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using((TestListGenerator)new ListGenerators.ImmutableListTailSubListGenerator()).named("ImmutableList, tail subList")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using((TestListGenerator)new ListGenerators.ImmutableListMiddleSubListGenerator()).named("ImmutableList, middle subList")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((ListTestSuiteBuilder)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using((TestListGenerator)new ListGenerators.UnhashableElementsImmutableListGenerator()).suppressing(new Method[]{ListHashCodeTester.getHashCodeMethod()})).named("ImmutableList, unhashable values")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        return suite;
    }

    public static class BasicTests
    extends TestCase {
        @GwtIncompatible
        public void testNullPointers() {
            NullPointerTester tester = new NullPointerTester();
            tester.testAllPublicStaticMethods(ImmutableList.class);
            tester.testAllPublicInstanceMethods((Object)ImmutableList.of((Object)1, (Object)2, (Object)3));
        }

        @GwtIncompatible
        public void testSerialization_empty() {
            ImmutableList c = ImmutableList.of();
            BasicTests.assertSame((Object)c, (Object)SerializableTester.reserialize((Object)c));
        }

        @GwtIncompatible
        public void testSerialization_singleton() {
            ImmutableList c = ImmutableList.of((Object)"a");
            SerializableTester.reserializeAndAssert((Object)c);
        }

        @GwtIncompatible
        public void testSerialization_multiple() {
            ImmutableList c = ImmutableList.of((Object)"a", (Object)"b", (Object)"c");
            SerializableTester.reserializeAndAssert((Object)c);
        }

        public void testEquals_immutableList() {
            ImmutableList c = ImmutableList.of((Object)"a", (Object)"b", (Object)"c");
            BasicTests.assertTrue((boolean)c.equals(ImmutableList.of((Object)"a", (Object)"b", (Object)"c")));
            BasicTests.assertFalse((boolean)c.equals(ImmutableList.of((Object)"a", (Object)"c", (Object)"b")));
            BasicTests.assertFalse((boolean)c.equals(ImmutableList.of((Object)"a", (Object)"b")));
            BasicTests.assertFalse((boolean)c.equals(ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d")));
        }

        public void testBuilderAdd() {
            ImmutableList list = new ImmutableList.Builder().add((Object)"a").add((Object)"b").add((Object)"a").add((Object)"c").build();
            BasicTests.assertEquals(Arrays.asList("a", "b", "a", "c"), (Object)list);
        }

        public void testBuilderAdd_varargs() {
            ImmutableList list = new ImmutableList.Builder().add((Object[])new String[]{"a", "b", "a", "c"}).build();
            BasicTests.assertEquals(Arrays.asList("a", "b", "a", "c"), (Object)list);
        }

        public void testBuilderAddAll_iterable() {
            List<String> a = Arrays.asList("a", "b");
            List<String> b = Arrays.asList("c", "d");
            ImmutableList list = new ImmutableList.Builder().addAll(a).addAll(b).build();
            BasicTests.assertEquals(Arrays.asList("a", "b", "c", "d"), (Object)list);
            b.set(0, "f");
            BasicTests.assertEquals(Arrays.asList("a", "b", "c", "d"), (Object)list);
        }

        public void testBuilderAddAll_iterator() {
            List<String> a = Arrays.asList("a", "b");
            List<String> b = Arrays.asList("c", "d");
            ImmutableList list = new ImmutableList.Builder().addAll(a.iterator()).addAll(b.iterator()).build();
            BasicTests.assertEquals(Arrays.asList("a", "b", "c", "d"), (Object)list);
            b.set(0, "f");
            BasicTests.assertEquals(Arrays.asList("a", "b", "c", "d"), (Object)list);
        }

        public void testComplexBuilder() {
            List<Integer> colorElem = Arrays.asList(0, 51, 102, 153, 204, 255);
            ImmutableList.Builder webSafeColorsBuilder = ImmutableList.builder();
            for (Integer red : colorElem) {
                for (Integer green : colorElem) {
                    for (Integer blue : colorElem) {
                        webSafeColorsBuilder.add((Object)((red << 16) + (green << 8) + blue));
                    }
                }
            }
            ImmutableList webSafeColors = webSafeColorsBuilder.build();
            BasicTests.assertEquals((int)216, (int)webSafeColors.size());
            Integer[] webSafeColorArray = (Integer[])webSafeColors.toArray((Object[])new Integer[webSafeColors.size()]);
            BasicTests.assertEquals((int)0, (int)webSafeColorArray[0]);
            BasicTests.assertEquals((int)51, (int)webSafeColorArray[1]);
            BasicTests.assertEquals((int)102, (int)webSafeColorArray[2]);
            BasicTests.assertEquals((int)13056, (int)webSafeColorArray[6]);
            BasicTests.assertEquals((int)0x330000, (int)webSafeColorArray[36]);
            BasicTests.assertEquals((int)102, (int)((Integer)webSafeColors.get(2)));
            BasicTests.assertEquals((int)13056, (int)((Integer)webSafeColors.get(6)));
            ImmutableList addedColor = webSafeColorsBuilder.add((Object)49151).build();
            BasicTests.assertEquals((String)"Modifying the builder should not have changed any already built sets", (int)216, (int)webSafeColors.size());
            BasicTests.assertEquals((String)"the new array should be one bigger than webSafeColors", (int)217, (int)addedColor.size());
            Integer[] appendColorArray = (Integer[])addedColor.toArray((Object[])new Integer[addedColor.size()]);
            BasicTests.assertEquals((int)49151, (int)appendColorArray[216]);
        }

        public void testBuilderAddHandlesNullsCorrectly() {
            ImmutableList.Builder builder = ImmutableList.builder();
            try {
                builder.add((Object)null);
                BasicTests.fail((String)"expected NullPointerException");
            }
            catch (NullPointerException expected) {
                // empty catch block
            }
            try {
                builder.add((Object[])null);
                BasicTests.fail((String)"expected NullPointerException");
            }
            catch (NullPointerException expected) {
                // empty catch block
            }
            try {
                builder.add((Object[])new String[]{"a", null, "b"});
                BasicTests.fail((String)"expected NullPointerException");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        public void testBuilderAddAllHandlesNullsCorrectly() {
            ImmutableList.Builder builder = ImmutableList.builder();
            try {
                builder.addAll((Iterable)null);
                BasicTests.fail((String)"expected NullPointerException");
            }
            catch (NullPointerException expected) {
                // empty catch block
            }
            try {
                builder.addAll((Iterator)null);
                BasicTests.fail((String)"expected NullPointerException");
            }
            catch (NullPointerException expected) {
                // empty catch block
            }
            builder = ImmutableList.builder();
            List<String> listWithNulls = Arrays.asList("a", null, "b");
            try {
                builder.addAll(listWithNulls);
                BasicTests.fail((String)"expected NullPointerException");
            }
            catch (NullPointerException expected) {
                // empty catch block
            }
            builder = ImmutableList.builder();
            Iterator<String> iteratorWithNulls = Arrays.asList("a", null, "b").iterator();
            try {
                builder.addAll(iteratorWithNulls);
                BasicTests.fail((String)"expected NullPointerException");
            }
            catch (NullPointerException expected) {
                // empty catch block
            }
            MinimalIterable iterableWithNulls = MinimalIterable.of((Object[])new String[]{"a", null, "b"});
            try {
                builder.addAll((Iterable)iterableWithNulls);
                BasicTests.fail((String)"expected NullPointerException");
            }
            catch (NullPointerException expected) {
                // empty catch block
            }
        }

        public void testAsList() {
            ImmutableList list = ImmutableList.of((Object)"a", (Object)"b");
            BasicTests.assertSame((Object)list, (Object)list.asList());
        }
    }

    @GwtIncompatible
    public static class ConcurrentTests
    extends TestCase {
        private static void runConcurrentlyMutatedTest(Collection<Integer> initialContents, Iterable<ListFrobber> actionsToPerformConcurrently, WrapWithIterable wrap) {
            ConcurrentlyMutatedList<Integer> concurrentlyMutatedList = ConcurrentTests.newConcurrentlyMutatedList(initialContents, actionsToPerformConcurrently);
            Iterable<Integer> iterableToCopy = wrap == WrapWithIterable.WRAP ? Iterables.unmodifiableIterable(concurrentlyMutatedList) : concurrentlyMutatedList;
            ImmutableList copyOfIterable = ImmutableList.copyOf(iterableToCopy);
            ConcurrentTests.assertTrue((boolean)concurrentlyMutatedList.getAllStates().contains(copyOfIterable));
            ConcurrentTests.assertEquals((copyOfIterable.size() == 1 ? 1 : 0) != 0, (boolean)(copyOfIterable instanceof SingletonImmutableList));
        }

        private static void runConcurrentlyMutatedTest(WrapWithIterable wrap) {
            ConcurrentTests.runConcurrentlyMutatedTest(ConcurrentTests.elements(new Integer[0]), ConcurrentTests.ops(ConcurrentTests.add(1), ConcurrentTests.add(2)), wrap);
            ConcurrentTests.runConcurrentlyMutatedTest(ConcurrentTests.elements(new Integer[0]), ConcurrentTests.ops(ConcurrentTests.add(1), ConcurrentTests.nop()), wrap);
            ConcurrentTests.runConcurrentlyMutatedTest(ConcurrentTests.elements(new Integer[0]), ConcurrentTests.ops(ConcurrentTests.add(1), ConcurrentTests.remove()), wrap);
            ConcurrentTests.runConcurrentlyMutatedTest(ConcurrentTests.elements(new Integer[0]), ConcurrentTests.ops(ConcurrentTests.nop(), ConcurrentTests.add(1)), wrap);
            ConcurrentTests.runConcurrentlyMutatedTest(ConcurrentTests.elements(1), ConcurrentTests.ops(ConcurrentTests.remove(), ConcurrentTests.nop()), wrap);
            ConcurrentTests.runConcurrentlyMutatedTest(ConcurrentTests.elements(1), ConcurrentTests.ops(ConcurrentTests.remove(), ConcurrentTests.add(2)), wrap);
            ConcurrentTests.runConcurrentlyMutatedTest(ConcurrentTests.elements(1, 2), ConcurrentTests.ops(ConcurrentTests.remove(), ConcurrentTests.remove()), wrap);
            ConcurrentTests.runConcurrentlyMutatedTest(ConcurrentTests.elements(1, 2), ConcurrentTests.ops(ConcurrentTests.remove(), ConcurrentTests.nop()), wrap);
            ConcurrentTests.runConcurrentlyMutatedTest(ConcurrentTests.elements(1, 2), ConcurrentTests.ops(ConcurrentTests.remove(), ConcurrentTests.add(3)), wrap);
            ConcurrentTests.runConcurrentlyMutatedTest(ConcurrentTests.elements(1, 2), ConcurrentTests.ops(ConcurrentTests.nop(), ConcurrentTests.remove()), wrap);
            ConcurrentTests.runConcurrentlyMutatedTest(ConcurrentTests.elements(1, 2, 3), ConcurrentTests.ops(ConcurrentTests.remove(), ConcurrentTests.remove()), wrap);
        }

        private static ImmutableList<Integer> elements(Integer ... elements) {
            return ImmutableList.copyOf((Object[])elements);
        }

        private static ImmutableList<ListFrobber> ops(ListFrobber ... elements) {
            return ImmutableList.copyOf((Object[])elements);
        }

        public void testCopyOf_concurrentlyMutatedList() {
            ConcurrentTests.runConcurrentlyMutatedTest(WrapWithIterable.NO_WRAP);
        }

        public void testCopyOf_concurrentlyMutatedIterable() {
            ConcurrentTests.runConcurrentlyMutatedTest(WrapWithIterable.WRAP);
        }

        static ListFrobber add(final int element) {
            return new ListFrobber(){

                @Override
                public void perform(List<Integer> list) {
                    list.add(0, element);
                }
            };
        }

        static ListFrobber remove() {
            return new ListFrobber(){

                @Override
                public void perform(List<Integer> list) {
                    list.remove(0);
                }
            };
        }

        static ListFrobber nop() {
            return new ListFrobber(){

                @Override
                public void perform(List<Integer> list) {
                }
            };
        }

        private static ConcurrentlyMutatedList<Integer> newConcurrentlyMutatedList(final Collection<Integer> initialContents, final Iterable<ListFrobber> actionsToPerformConcurrently) {
            InvocationHandler invocationHandler = new InvocationHandler(){
                final CopyOnWriteArrayList<Integer> delegate;
                final Method getAllStatesMethod;
                final Iterator<ListFrobber> remainingActions;
                final Set<List<Integer>> allStates;
                {
                    this.delegate = new CopyOnWriteArrayList(initialContents);
                    this.getAllStatesMethod = (Method)Iterables.getOnlyElement(Arrays.asList(ConcurrentlyMutatedList.class.getDeclaredMethods()));
                    this.remainingActions = actionsToPerformConcurrently.iterator();
                    this.allStates = Sets.newHashSet();
                }

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    return method.equals(this.getAllStatesMethod) ? this.getAllStates() : this.invokeListMethod(method, args);
                }

                private Set<List<Integer>> getAllStates() {
                    return this.allStates;
                }

                private Object invokeListMethod(Method method, Object[] args) throws Throwable {
                    try {
                        Object returnValue = method.invoke(this.delegate, args);
                        this.mutateDelegate();
                        return returnValue;
                    }
                    catch (InvocationTargetException e) {
                        throw e.getCause();
                    }
                    catch (IllegalAccessException e) {
                        throw new AssertionError((Object)e);
                    }
                }

                private void mutateDelegate() {
                    this.allStates.add((List<Integer>)ImmutableList.copyOf(this.delegate));
                    this.remainingActions.next().perform(this.delegate);
                    this.allStates.add((List<Integer>)ImmutableList.copyOf(this.delegate));
                }
            };
            ConcurrentlyMutatedList list = (ConcurrentlyMutatedList)Proxy.newProxyInstance(CreationTests.class.getClassLoader(), new Class[]{ConcurrentlyMutatedList.class}, invocationHandler);
            return list;
        }

        static interface ConcurrentlyMutatedList<E>
        extends List<E> {
            public Set<List<E>> getAllStates();
        }

        static interface ListFrobber {
            public void perform(List<Integer> var1);
        }

        static enum WrapWithIterable {
            WRAP,
            NO_WRAP;

        }
    }

    public static class CreationTests
    extends TestCase {
        public void testCreation_noArgs() {
            ImmutableList list = ImmutableList.of();
            CreationTests.assertEquals(Collections.emptyList(), (Object)list);
        }

        public void testCreation_oneElement() {
            ImmutableList list = ImmutableList.of((Object)"a");
            CreationTests.assertEquals(Collections.singletonList("a"), (Object)list);
        }

        public void testCreation_twoElements() {
            ImmutableList list = ImmutableList.of((Object)"a", (Object)"b");
            CreationTests.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"a", "b"}), (Object)list);
        }

        public void testCreation_threeElements() {
            ImmutableList list = ImmutableList.of((Object)"a", (Object)"b", (Object)"c");
            CreationTests.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"a", "b", "c"}), (Object)list);
        }

        public void testCreation_fourElements() {
            ImmutableList list = ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d");
            CreationTests.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"a", "b", "c", "d"}), (Object)list);
        }

        public void testCreation_fiveElements() {
            ImmutableList list = ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e");
            CreationTests.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"a", "b", "c", "d", "e"}), (Object)list);
        }

        public void testCreation_sixElements() {
            ImmutableList list = ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f");
            CreationTests.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"a", "b", "c", "d", "e", "f"}), (Object)list);
        }

        public void testCreation_sevenElements() {
            ImmutableList list = ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f", (Object)"g");
            CreationTests.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"a", "b", "c", "d", "e", "f", "g"}), (Object)list);
        }

        public void testCreation_eightElements() {
            ImmutableList list = ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f", (Object)"g", (Object)"h");
            CreationTests.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"a", "b", "c", "d", "e", "f", "g", "h"}), (Object)list);
        }

        public void testCreation_nineElements() {
            ImmutableList list = ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f", (Object)"g", (Object)"h", (Object)"i");
            CreationTests.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i"}), (Object)list);
        }

        public void testCreation_tenElements() {
            ImmutableList list = ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f", (Object)"g", (Object)"h", (Object)"i", (Object)"j");
            CreationTests.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j"}), (Object)list);
        }

        public void testCreation_elevenElements() {
            ImmutableList list = ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f", (Object)"g", (Object)"h", (Object)"i", (Object)"j", (Object)"k");
            CreationTests.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k"}), (Object)list);
        }

        public void testCreation_twelveElements() {
            ImmutableList list = ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f", (Object)"g", (Object)"h", (Object)"i", (Object)"j", (Object)"k", (Object)"l", (Object[])new String[0]);
            CreationTests.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l"}), (Object)list);
        }

        public void testCreation_thirteenElements() {
            ImmutableList list = ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f", (Object)"g", (Object)"h", (Object)"i", (Object)"j", (Object)"k", (Object)"l", (Object[])new String[]{"m"});
            CreationTests.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m"}), (Object)list);
        }

        public void testCreation_fourteenElements() {
            ImmutableList list = ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f", (Object)"g", (Object)"h", (Object)"i", (Object)"j", (Object)"k", (Object)"l", (Object[])new String[]{"m", "n"});
            CreationTests.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n"}), (Object)list);
        }

        public void testCreation_singletonNull() {
            try {
                ImmutableList.of((Object)null);
                CreationTests.fail();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        public void testCreation_withNull() {
            try {
                ImmutableList.of((Object)"a", null, (Object)"b");
                CreationTests.fail();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        public void testCreation_generic() {
            ImmutableList a = ImmutableList.of((Object)"a");
            ImmutableList unused = ImmutableList.of((Object)a, (Object)a);
        }

        public void testCreation_arrayOfArray() {
            String[] array = new String[]{"a"};
            ImmutableList list = ImmutableList.of((Object)array);
            CreationTests.assertEquals(Collections.singletonList(array), (Object)list);
        }

        public void testCopyOf_emptyArray() {
            Object[] array = new String[]{};
            ImmutableList list = ImmutableList.copyOf((Object[])array);
            CreationTests.assertEquals(Collections.emptyList(), (Object)list);
        }

        public void testCopyOf_arrayOfOneElement() {
            Object[] array = new String[]{"a"};
            ImmutableList list = ImmutableList.copyOf((Object[])array);
            CreationTests.assertEquals(Collections.singletonList("a"), (Object)list);
        }

        public void testCopyOf_nullArray() {
            try {
                ImmutableList.copyOf((Object[])null);
                CreationTests.fail();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        public void testCopyOf_arrayContainingOnlyNull() {
            Object[] array = new String[]{null};
            try {
                ImmutableList.copyOf((Object[])array);
                CreationTests.fail();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        public void testCopyOf_collection_empty() {
            MinimalCollection c = MinimalCollection.of((Object[])new String[0]);
            ImmutableList list = ImmutableList.copyOf((Collection)c);
            CreationTests.assertEquals(Collections.emptyList(), (Object)list);
        }

        public void testCopyOf_collection_oneElement() {
            MinimalCollection c = MinimalCollection.of((Object[])new String[]{"a"});
            ImmutableList list = ImmutableList.copyOf((Collection)c);
            CreationTests.assertEquals(Collections.singletonList("a"), (Object)list);
        }

        public void testCopyOf_collection_general() {
            MinimalCollection c = MinimalCollection.of((Object[])new String[]{"a", "b", "a"});
            ImmutableList list = ImmutableList.copyOf((Collection)c);
            CreationTests.assertEquals(Arrays.asList("a", "b", "a"), (Object)list);
            List<String> mutableList = Arrays.asList("a", "b");
            list = ImmutableList.copyOf(mutableList);
            mutableList.set(0, "c");
            CreationTests.assertEquals(Arrays.asList("a", "b"), (Object)list);
        }

        public void testCopyOf_collectionContainingNull() {
            MinimalCollection c = MinimalCollection.of((Object[])new String[]{"a", null, "b"});
            try {
                ImmutableList.copyOf((Collection)c);
                CreationTests.fail();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        public void testCopyOf_iterator_empty() {
            UnmodifiableIterator iterator = Iterators.emptyIterator();
            ImmutableList list = ImmutableList.copyOf((Iterator)iterator);
            CreationTests.assertEquals(Collections.emptyList(), (Object)list);
        }

        public void testCopyOf_iterator_oneElement() {
            UnmodifiableIterator iterator = Iterators.singletonIterator((Object)"a");
            ImmutableList list = ImmutableList.copyOf((Iterator)iterator);
            CreationTests.assertEquals(Collections.singletonList("a"), (Object)list);
        }

        public void testCopyOf_iterator_general() {
            Iterator<String> iterator = Arrays.asList("a", "b", "a").iterator();
            ImmutableList list = ImmutableList.copyOf(iterator);
            CreationTests.assertEquals(Arrays.asList("a", "b", "a"), (Object)list);
        }

        public void testCopyOf_iteratorContainingNull() {
            Iterator<String> iterator = Arrays.asList("a", null, "b").iterator();
            try {
                ImmutableList.copyOf(iterator);
                CreationTests.fail();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        public void testCopyOf_iteratorNull() {
            try {
                ImmutableList.copyOf((Iterator)null);
                CreationTests.fail();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        public void testCopyOf_concurrentlyMutating() {
            ArrayList sample = Lists.newArrayList((Object[])new String[]{"a", "b", "c"});
            for (int delta : new int[]{-1, 0, 1}) {
                for (int i = 0; i < sample.size(); ++i) {
                    Collection misleading = Helpers.misleadingSizeCollection((int)delta);
                    List expected = sample.subList(0, i);
                    misleading.addAll(expected);
                    CreationTests.assertEquals(expected, (Object)ImmutableList.copyOf((Collection)misleading));
                    CreationTests.assertEquals(expected, (Object)ImmutableList.copyOf((Iterable)misleading));
                }
            }
        }

        public void testCopyOf_plainIterable() {
            CountingIterable iterable = new CountingIterable();
            ImmutableList list = ImmutableList.copyOf((Iterable)iterable);
            CreationTests.assertEquals(Arrays.asList("a", "b", "a"), (Object)list);
        }

        public void testCopyOf_plainIterable_iteratesOnce() {
            CountingIterable iterable = new CountingIterable();
            ImmutableList unused = ImmutableList.copyOf((Iterable)iterable);
            CreationTests.assertEquals((int)1, (int)iterable.count);
        }

        public void testCopyOf_shortcut_empty() {
            ImmutableList c = ImmutableList.of();
            CreationTests.assertSame((Object)c, (Object)ImmutableList.copyOf((Collection)c));
        }

        public void testCopyOf_shortcut_singleton() {
            ImmutableList c = ImmutableList.of((Object)"a");
            CreationTests.assertSame((Object)c, (Object)ImmutableList.copyOf((Collection)c));
        }

        public void testCopyOf_shortcut_immutableList() {
            ImmutableList c = ImmutableList.of((Object)"a", (Object)"b", (Object)"c");
            CreationTests.assertSame((Object)c, (Object)ImmutableList.copyOf((Collection)c));
        }

        public void testBuilderAddArrayHandlesNulls() {
            Object[] elements = new String[]{"a", null, "b"};
            ImmutableList.Builder builder = ImmutableList.builder();
            try {
                builder.add(elements);
                CreationTests.fail((String)"Expected NullPointerException");
            }
            catch (NullPointerException expected) {
                // empty catch block
            }
            ImmutableList result = builder.build();
            if (result.isEmpty()) {
                return;
            }
            CreationTests.assertTrue((boolean)ImmutableList.of((Object)"a").equals((Object)result));
            CreationTests.assertEquals((int)1, (int)result.size());
        }

        public void testBuilderAddCollectionHandlesNulls() {
            List<String> elements = Arrays.asList("a", null, "b");
            ImmutableList.Builder builder = ImmutableList.builder();
            try {
                builder.addAll(elements);
                CreationTests.fail((String)"Expected NullPointerException");
            }
            catch (NullPointerException expected) {
                // empty catch block
            }
            ImmutableList result = builder.build();
            CreationTests.assertEquals((Object)ImmutableList.of((Object)"a"), (Object)result);
            CreationTests.assertEquals((int)1, (int)result.size());
        }

        private static class CountingIterable
        implements Iterable<String> {
            int count = 0;

            private CountingIterable() {
            }

            @Override
            public Iterator<String> iterator() {
                ++this.count;
                return Arrays.asList("a", "b", "a").iterator();
            }
        }
    }
}

