/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.AbstractImmutableSetTest;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedAsList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LegacyComparable;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.testing.ListTestSuiteBuilder;
import com.google.common.collect.testing.NavigableSetTestSuiteBuilder;
import com.google.common.collect.testing.SetTestSuiteBuilder;
import com.google.common.collect.testing.TestListGenerator;
import com.google.common.collect.testing.TestSetGenerator;
import com.google.common.collect.testing.TestSortedSetGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.google.SetGenerators;
import com.google.common.collect.testing.testers.SetHashCodeTester;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.Truth;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import junit.framework.Test;
import junit.framework.TestSuite;

@GwtCompatible(emulated=true)
public class ImmutableSortedSetTest
extends AbstractImmutableSetTest {
    private static final Comparator<String> STRING_LENGTH = StringLengthComparator.INSTANCE;
    private static final Comparator<Object> TO_STRING = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            return o1.toString().compareTo(o2.toString());
        }
    };
    private static final ImmutableList<String> NUMBER_NAMES = ImmutableList.of((Object)"one", (Object)"two", (Object)"three", (Object)"four", (Object)"five", (Object)"six", (Object)"seven");
    private static final ImmutableList<String> SORTED_NUMBER_NAMES = Ordering.natural().immutableSortedCopy(NUMBER_NAMES);

    @GwtIncompatible
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)NavigableSetTestSuiteBuilder.using((TestSortedSetGenerator)new SetGenerators.ImmutableSortedSetCopyOfGenerator()).named(ImmutableSortedSetTest.class.getName())).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)NavigableSetTestSuiteBuilder.using((TestSetGenerator)new SetGenerators.ImmutableSortedSetExplicitComparator()).named(ImmutableSortedSetTest.class.getName() + ", explicit comparator, vararg")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)NavigableSetTestSuiteBuilder.using((TestSetGenerator)new SetGenerators.ImmutableSortedSetExplicitSuperclassComparatorGenerator()).named(ImmutableSortedSetTest.class.getName() + ", explicit superclass comparator, iterable")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)NavigableSetTestSuiteBuilder.using((TestSetGenerator)new SetGenerators.ImmutableSortedSetReversedOrderGenerator()).named(ImmutableSortedSetTest.class.getName() + ", reverseOrder, iterator")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)NavigableSetTestSuiteBuilder.using((TestSetGenerator)new SetGenerators.ImmutableSortedSetUnhashableGenerator()).suppressing(SetHashCodeTester.getHashCodeMethods())).named(ImmutableSortedSetTest.class.getName() + ", unhashable")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)NavigableSetTestSuiteBuilder.using((TestSortedSetGenerator)new SetGenerators.ImmutableSortedSetDescendingGenerator()).named(ImmutableSortedSetTest.class.getName() + ", descending")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using((TestListGenerator)new SetGenerators.ImmutableSortedSetAsListGenerator()).named("ImmutableSortedSet.asList")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.REJECTS_DUPLICATES_AT_CREATION, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using((TestListGenerator)new SetGenerators.ImmutableSortedSetSubsetAsListGenerator()).named("ImmutableSortedSet.subSet.asList")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.REJECTS_DUPLICATES_AT_CREATION, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using((TestListGenerator)new SetGenerators.ImmutableSortedSetDescendingAsListGenerator()).named("ImmutableSortedSet.descendingSet.asList")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.REJECTS_DUPLICATES_AT_CREATION, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTestSuite(ImmutableSortedSetTest.class);
        return suite;
    }

    protected SortedSet<String> of() {
        return ImmutableSortedSet.of();
    }

    protected SortedSet<String> of(String e) {
        return ImmutableSortedSet.of((Comparable)((Object)e));
    }

    protected SortedSet<String> of(String e1, String e2) {
        return ImmutableSortedSet.of((Comparable)((Object)e1), (Comparable)((Object)e2));
    }

    protected SortedSet<String> of(String e1, String e2, String e3) {
        return ImmutableSortedSet.of((Comparable)((Object)e1), (Comparable)((Object)e2), (Comparable)((Object)e3));
    }

    protected SortedSet<String> of(String e1, String e2, String e3, String e4) {
        return ImmutableSortedSet.of((Comparable)((Object)e1), (Comparable)((Object)e2), (Comparable)((Object)e3), (Comparable)((Object)e4));
    }

    protected SortedSet<String> of(String e1, String e2, String e3, String e4, String e5) {
        return ImmutableSortedSet.of((Comparable)((Object)e1), (Comparable)((Object)e2), (Comparable)((Object)e3), (Comparable)((Object)e4), (Comparable)((Object)e5));
    }

    protected SortedSet<String> of(String e1, String e2, String e3, String e4, String e5, String e6, String ... rest) {
        return ImmutableSortedSet.of((Comparable)((Object)e1), (Comparable)((Object)e2), (Comparable)((Object)e3), (Comparable)((Object)e4), (Comparable)((Object)e5), (Comparable)((Object)e6), (Comparable[])rest);
    }

    protected SortedSet<String> copyOf(String[] elements) {
        return ImmutableSortedSet.copyOf((Comparable[])elements);
    }

    protected SortedSet<String> copyOf(Collection<String> elements) {
        return ImmutableSortedSet.copyOf(elements);
    }

    protected SortedSet<String> copyOf(Iterable<String> elements) {
        return ImmutableSortedSet.copyOf(elements);
    }

    protected SortedSet<String> copyOf(Iterator<String> elements) {
        return ImmutableSortedSet.copyOf(elements);
    }

    @GwtIncompatible
    public void testNullPointers() {
        new NullPointerTester().testAllPublicStaticMethods(ImmutableSortedSet.class);
    }

    public void testEmpty_comparator() {
        Set set = this.of();
        ImmutableSortedSetTest.assertSame((Object)Ordering.natural(), set.comparator());
    }

    public void testEmpty_headSet() {
        Set set = this.of();
        ImmutableSortedSetTest.assertSame((Object)set, set.headSet("c"));
    }

    public void testEmpty_tailSet() {
        Set set = this.of();
        ImmutableSortedSetTest.assertSame((Object)set, set.tailSet("f"));
    }

    public void testEmpty_subSet() {
        Set set = this.of();
        ImmutableSortedSetTest.assertSame((Object)set, set.subSet("c", "f"));
    }

    public void testEmpty_first() {
        Set set = this.of();
        try {
            set.first();
            ImmutableSortedSetTest.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testEmpty_last() {
        Set set = this.of();
        try {
            set.last();
            ImmutableSortedSetTest.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testEmpty_serialization() {
        Set set = this.of();
        SortedSet copy = (SortedSet)SerializableTester.reserialize((Object)set);
        ImmutableSortedSetTest.assertSame((Object)set, (Object)copy);
    }

    public void testSingle_comparator() {
        Set set = this.of("e");
        ImmutableSortedSetTest.assertSame((Object)Ordering.natural(), set.comparator());
    }

    public void testSingle_headSet() {
        Set set = this.of("e");
        ImmutableSortedSetTest.assertTrue((boolean)(set.headSet("g") instanceof ImmutableSortedSet));
        Truth.assertThat(set.headSet("g")).contains((Object)"e");
        ImmutableSortedSetTest.assertSame((Object)this.of(), set.headSet("c"));
        ImmutableSortedSetTest.assertSame((Object)this.of(), set.headSet("e"));
    }

    public void testSingle_tailSet() {
        Set set = this.of("e");
        ImmutableSortedSetTest.assertTrue((boolean)(set.tailSet("c") instanceof ImmutableSortedSet));
        Truth.assertThat(set.tailSet("c")).contains((Object)"e");
        Truth.assertThat(set.tailSet("e")).contains((Object)"e");
        ImmutableSortedSetTest.assertSame((Object)this.of(), set.tailSet("g"));
    }

    public void testSingle_subSet() {
        Set set = this.of("e");
        ImmutableSortedSetTest.assertTrue((boolean)(set.subSet("c", "g") instanceof ImmutableSortedSet));
        Truth.assertThat(set.subSet("c", "g")).contains((Object)"e");
        Truth.assertThat(set.subSet("e", "g")).contains((Object)"e");
        ImmutableSortedSetTest.assertSame((Object)this.of(), set.subSet("f", "g"));
        ImmutableSortedSetTest.assertSame((Object)this.of(), set.subSet("c", "e"));
        ImmutableSortedSetTest.assertSame((Object)this.of(), set.subSet("c", "d"));
    }

    public void testSingle_first() {
        Set set = this.of("e");
        ImmutableSortedSetTest.assertEquals((String)"e", (String)((String)set.first()));
    }

    public void testSingle_last() {
        Set set = this.of("e");
        ImmutableSortedSetTest.assertEquals((String)"e", (String)((String)set.last()));
    }

    @GwtIncompatible
    public void testSingle_serialization() {
        Set set = this.of("e");
        SortedSet copy = (SortedSet)SerializableTester.reserializeAndAssert((Object)set);
        ImmutableSortedSetTest.assertEquals(set.comparator(), copy.comparator());
    }

    public void testOf_ordering() {
        Set set = this.of("e", "a", "f", "b", "d", "c", new String[0]);
        Truth.assertThat((Iterable)set).containsExactly(new Object[]{"a", "b", "c", "d", "e", "f"}).inOrder();
    }

    public void testOf_gwtArraycopyBug() {
        Impl a = new Impl();
        Impl b = new Impl();
        ImmutableSortedSet set = ImmutableSortedSet.of((Comparable)a, (Comparable)b);
        Object[] unused1 = set.toArray();
        Object[] unused2 = set.toArray(new Object[2]);
    }

    public void testOf_ordering_dupes() {
        Set set = this.of("e", "a", "e", "f", "b", "b", new String[]{"d", "a", "c"});
        Truth.assertThat((Iterable)set).containsExactly(new Object[]{"a", "b", "c", "d", "e", "f"}).inOrder();
    }

    public void testOf_comparator() {
        Set set = this.of("e", "a", "f", "b", "d", "c", new String[0]);
        ImmutableSortedSetTest.assertSame((Object)Ordering.natural(), set.comparator());
    }

    public void testOf_headSet() {
        Set set = this.of("e", "f", "b", "d", "c");
        ImmutableSortedSetTest.assertTrue((boolean)(set.headSet("e") instanceof ImmutableSortedSet));
        Truth.assertThat(set.headSet("e")).containsExactly(new Object[]{"b", "c", "d"}).inOrder();
        Truth.assertThat(set.headSet("g")).containsExactly(new Object[]{"b", "c", "d", "e", "f"}).inOrder();
        ImmutableSortedSetTest.assertSame((Object)this.of(), set.headSet("a"));
        ImmutableSortedSetTest.assertSame((Object)this.of(), set.headSet("b"));
    }

    public void testOf_tailSet() {
        Set set = this.of("e", "f", "b", "d", "c");
        ImmutableSortedSetTest.assertTrue((boolean)(set.tailSet("e") instanceof ImmutableSortedSet));
        Truth.assertThat(set.tailSet("e")).containsExactly(new Object[]{"e", "f"}).inOrder();
        Truth.assertThat(set.tailSet("a")).containsExactly(new Object[]{"b", "c", "d", "e", "f"}).inOrder();
        ImmutableSortedSetTest.assertSame((Object)this.of(), set.tailSet("g"));
    }

    public void testOf_subSet() {
        Set set = this.of("e", "f", "b", "d", "c");
        ImmutableSortedSetTest.assertTrue((boolean)(set.subSet("c", "e") instanceof ImmutableSortedSet));
        Truth.assertThat(set.subSet("c", "e")).containsExactly(new Object[]{"c", "d"}).inOrder();
        Truth.assertThat(set.subSet("a", "g")).containsExactly(new Object[]{"b", "c", "d", "e", "f"}).inOrder();
        ImmutableSortedSetTest.assertSame((Object)this.of(), set.subSet("a", "b"));
        ImmutableSortedSetTest.assertSame((Object)this.of(), set.subSet("g", "h"));
        ImmutableSortedSetTest.assertSame((Object)this.of(), set.subSet("c", "c"));
        try {
            set.subSet("e", "c");
            ImmutableSortedSetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testOf_subSetSerialization() {
        Set set = this.of("e", "f", "b", "d", "c");
        SerializableTester.reserializeAndAssert(set.subSet("c", "e"));
    }

    public void testOf_first() {
        Set set = this.of("e", "f", "b", "d", "c");
        ImmutableSortedSetTest.assertEquals((String)"b", (String)((String)set.first()));
    }

    public void testOf_last() {
        Set set = this.of("e", "f", "b", "d", "c");
        ImmutableSortedSetTest.assertEquals((String)"f", (String)((String)set.last()));
    }

    @GwtIncompatible
    public void testOf_serialization() {
        Set set = this.of("e", "f", "b", "d", "c");
        SortedSet copy = (SortedSet)SerializableTester.reserializeAndAssert((Object)set);
        ImmutableSortedSetTest.assertTrue((boolean)Iterables.elementsEqual((Iterable)set, (Iterable)copy));
        ImmutableSortedSetTest.assertEquals(set.comparator(), copy.comparator());
    }

    public void testExplicit_ordering() {
        ImmutableSortedSet set = ImmutableSortedSet.orderedBy(STRING_LENGTH).add((Object[])new String[]{"in", "the", "quick", "jumped", "over", "a"}).build();
        Truth.assertThat((Iterable)set).containsExactly(new Object[]{"a", "in", "the", "over", "quick", "jumped"}).inOrder();
    }

    public void testExplicit_ordering_dupes() {
        ImmutableSortedSet set = ImmutableSortedSet.orderedBy(STRING_LENGTH).add((Object[])new String[]{"in", "the", "quick", "brown", "fox", "jumped", "over", "a", "lazy", "dog"}).build();
        Truth.assertThat((Iterable)set).containsExactly(new Object[]{"a", "in", "the", "over", "quick", "jumped"}).inOrder();
    }

    public void testExplicit_contains() {
        ImmutableSortedSet set = ImmutableSortedSet.orderedBy(STRING_LENGTH).add((Object[])new String[]{"in", "the", "quick", "jumped", "over", "a"}).build();
        ImmutableSortedSetTest.assertTrue((boolean)set.contains("quick"));
        ImmutableSortedSetTest.assertTrue((boolean)set.contains("google"));
        ImmutableSortedSetTest.assertFalse((boolean)set.contains(""));
        ImmutableSortedSetTest.assertFalse((boolean)set.contains("california"));
        ImmutableSortedSetTest.assertFalse((boolean)set.contains(null));
    }

    public void testExplicit_containsMismatchedTypes() {
        ImmutableSortedSet set = ImmutableSortedSet.orderedBy(STRING_LENGTH).add((Object[])new String[]{"in", "the", "quick", "jumped", "over", "a"}).build();
        ImmutableSortedSetTest.assertFalse((boolean)set.contains(3.7));
    }

    public void testExplicit_comparator() {
        ImmutableSortedSet set = ImmutableSortedSet.orderedBy(STRING_LENGTH).add((Object[])new String[]{"in", "the", "quick", "jumped", "over", "a"}).build();
        ImmutableSortedSetTest.assertSame(STRING_LENGTH, set.comparator());
    }

    public void testExplicit_headSet() {
        ImmutableSortedSet set = ImmutableSortedSet.orderedBy(STRING_LENGTH).add((Object[])new String[]{"in", "the", "quick", "jumped", "over", "a"}).build();
        ImmutableSortedSetTest.assertTrue((boolean)(set.headSet("a") instanceof ImmutableSortedSet));
        ImmutableSortedSetTest.assertTrue((boolean)(set.headSet("fish") instanceof ImmutableSortedSet));
        Truth.assertThat(set.headSet("fish")).containsExactly(new Object[]{"a", "in", "the"}).inOrder();
        Truth.assertThat(set.headSet("california")).containsExactly(new Object[]{"a", "in", "the", "over", "quick", "jumped"}).inOrder();
        ImmutableSortedSetTest.assertTrue((boolean)set.headSet("a").isEmpty());
        ImmutableSortedSetTest.assertTrue((boolean)set.headSet("").isEmpty());
    }

    public void testExplicit_tailSet() {
        ImmutableSortedSet set = ImmutableSortedSet.orderedBy(STRING_LENGTH).add((Object[])new String[]{"in", "the", "quick", "jumped", "over", "a"}).build();
        ImmutableSortedSetTest.assertTrue((boolean)(set.tailSet("california") instanceof ImmutableSortedSet));
        ImmutableSortedSetTest.assertTrue((boolean)(set.tailSet("fish") instanceof ImmutableSortedSet));
        Truth.assertThat(set.tailSet("fish")).containsExactly(new Object[]{"over", "quick", "jumped"}).inOrder();
        Truth.assertThat(set.tailSet("a")).containsExactly(new Object[]{"a", "in", "the", "over", "quick", "jumped"}).inOrder();
        ImmutableSortedSetTest.assertTrue((boolean)set.tailSet("california").isEmpty());
    }

    public void testExplicit_subSet() {
        ImmutableSortedSet set = ImmutableSortedSet.orderedBy(STRING_LENGTH).add((Object[])new String[]{"in", "the", "quick", "jumped", "over", "a"}).build();
        ImmutableSortedSetTest.assertTrue((boolean)(set.subSet("the", "quick") instanceof ImmutableSortedSet));
        ImmutableSortedSetTest.assertTrue((boolean)(set.subSet("", "b") instanceof ImmutableSortedSet));
        Truth.assertThat(set.subSet("the", "quick")).containsExactly(new Object[]{"the", "over"}).inOrder();
        Truth.assertThat(set.subSet("a", "california")).containsExactly(new Object[]{"a", "in", "the", "over", "quick", "jumped"}).inOrder();
        ImmutableSortedSetTest.assertTrue((boolean)set.subSet("", "b").isEmpty());
        ImmutableSortedSetTest.assertTrue((boolean)set.subSet("vermont", "california").isEmpty());
        ImmutableSortedSetTest.assertTrue((boolean)set.subSet("aaa", "zzz").isEmpty());
        try {
            set.subSet("quick", "the");
            ImmutableSortedSetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testExplicit_first() {
        ImmutableSortedSet set = ImmutableSortedSet.orderedBy(STRING_LENGTH).add((Object[])new String[]{"in", "the", "quick", "jumped", "over", "a"}).build();
        ImmutableSortedSetTest.assertEquals((String)"a", (String)((String)set.first()));
    }

    public void testExplicit_last() {
        ImmutableSortedSet set = ImmutableSortedSet.orderedBy(STRING_LENGTH).add((Object[])new String[]{"in", "the", "quick", "jumped", "over", "a"}).build();
        ImmutableSortedSetTest.assertEquals((String)"jumped", (String)((String)set.last()));
    }

    @GwtIncompatible
    public void testExplicitEmpty_serialization() {
        ImmutableSortedSet set = ImmutableSortedSet.orderedBy(STRING_LENGTH).build();
        SortedSet copy = (SortedSet)SerializableTester.reserializeAndAssert((Object)set);
        ImmutableSortedSetTest.assertTrue((boolean)set.isEmpty());
        ImmutableSortedSetTest.assertTrue((boolean)copy.isEmpty());
        ImmutableSortedSetTest.assertSame(set.comparator(), copy.comparator());
    }

    @GwtIncompatible
    public void testExplicit_serialization() {
        ImmutableSortedSet set = ImmutableSortedSet.orderedBy(STRING_LENGTH).add((Object[])new String[]{"in", "the", "quick", "jumped", "over", "a"}).build();
        SortedSet copy = (SortedSet)SerializableTester.reserializeAndAssert((Object)set);
        ImmutableSortedSetTest.assertTrue((boolean)Iterables.elementsEqual((Iterable)set, (Iterable)copy));
        ImmutableSortedSetTest.assertSame(set.comparator(), copy.comparator());
    }

    public void testCopyOf_ordering() {
        Set set = this.copyOf(Arrays.asList("e", "a", "f", "b", "d", "c"));
        Truth.assertThat((Iterable)set).containsExactly(new Object[]{"a", "b", "c", "d", "e", "f"}).inOrder();
    }

    public void testCopyOf_ordering_dupes() {
        Set set = this.copyOf(Arrays.asList("e", "a", "e", "f", "b", "b", "d", "a", "c"));
        Truth.assertThat((Iterable)set).containsExactly(new Object[]{"a", "b", "c", "d", "e", "f"}).inOrder();
    }

    public void testCopyOf_subSet() {
        Set set = this.of("e", "a", "f", "b", "d", "c", new String[0]);
        SortedSet<String> subset = set.subSet("c", "e");
        Set copy = this.copyOf(subset);
        ImmutableSortedSetTest.assertEquals(subset, (Object)copy);
    }

    public void testCopyOf_headSet() {
        Set set = this.of("e", "a", "f", "b", "d", "c", new String[0]);
        SortedSet<String> headset = set.headSet("d");
        Set copy = this.copyOf(headset);
        ImmutableSortedSetTest.assertEquals(headset, (Object)copy);
    }

    public void testCopyOf_tailSet() {
        Set set = this.of("e", "a", "f", "b", "d", "c", new String[0]);
        SortedSet<String> tailset = set.tailSet("d");
        Set copy = this.copyOf(tailset);
        ImmutableSortedSetTest.assertEquals(tailset, (Object)copy);
    }

    public void testCopyOf_comparator() {
        Set set = this.copyOf(Arrays.asList("e", "a", "f", "b", "d", "c"));
        ImmutableSortedSetTest.assertSame((Object)Ordering.natural(), set.comparator());
    }

    public void testCopyOf_iterator_ordering() {
        Set set = this.copyOf((Iterator)ImmutableSortedSetTest.asIterator("e", "a", "f", "b", "d", "c"));
        Truth.assertThat((Iterable)set).containsExactly(new Object[]{"a", "b", "c", "d", "e", "f"}).inOrder();
    }

    public void testCopyOf_iterator_ordering_dupes() {
        Set set = this.copyOf((Iterator)ImmutableSortedSetTest.asIterator("e", "a", "e", "f", "b", "b", "d", "a", "c"));
        Truth.assertThat((Iterable)set).containsExactly(new Object[]{"a", "b", "c", "d", "e", "f"}).inOrder();
    }

    public void testCopyOf_iterator_comparator() {
        Set set = this.copyOf((Iterator)ImmutableSortedSetTest.asIterator("e", "a", "f", "b", "d", "c"));
        ImmutableSortedSetTest.assertSame((Object)Ordering.natural(), set.comparator());
    }

    public void testCopyOf_sortedSet_ordering() {
        Set set = this.copyOf((Collection)Sets.newTreeSet(Arrays.asList("e", "a", "f", "b", "d", "c")));
        Truth.assertThat((Iterable)set).containsExactly(new Object[]{"a", "b", "c", "d", "e", "f"}).inOrder();
    }

    public void testCopyOf_sortedSet_comparator() {
        Set set = this.copyOf((Collection)Sets.newTreeSet());
        ImmutableSortedSetTest.assertSame((Object)Ordering.natural(), set.comparator());
    }

    public void testCopyOfExplicit_ordering() {
        ImmutableSortedSet set = ImmutableSortedSet.copyOf(STRING_LENGTH, Arrays.asList("in", "the", "quick", "jumped", "over", "a"));
        Truth.assertThat((Iterable)set).containsExactly(new Object[]{"a", "in", "the", "over", "quick", "jumped"}).inOrder();
    }

    public void testCopyOfExplicit_ordering_dupes() {
        ImmutableSortedSet set = ImmutableSortedSet.copyOf(STRING_LENGTH, Arrays.asList("in", "the", "quick", "brown", "fox", "jumped", "over", "a", "lazy", "dog"));
        Truth.assertThat((Iterable)set).containsExactly(new Object[]{"a", "in", "the", "over", "quick", "jumped"}).inOrder();
    }

    public void testCopyOfExplicit_comparator() {
        ImmutableSortedSet set = ImmutableSortedSet.copyOf(STRING_LENGTH, Arrays.asList("in", "the", "quick", "jumped", "over", "a"));
        ImmutableSortedSetTest.assertSame(STRING_LENGTH, set.comparator());
    }

    public void testCopyOfExplicit_iterator_ordering() {
        ImmutableSortedSet set = ImmutableSortedSet.copyOf(STRING_LENGTH, ImmutableSortedSetTest.asIterator("in", "the", "quick", "jumped", "over", "a"));
        Truth.assertThat((Iterable)set).containsExactly(new Object[]{"a", "in", "the", "over", "quick", "jumped"}).inOrder();
    }

    public void testCopyOfExplicit_iterator_ordering_dupes() {
        ImmutableSortedSet set = ImmutableSortedSet.copyOf(STRING_LENGTH, ImmutableSortedSetTest.asIterator("in", "the", "quick", "brown", "fox", "jumped", "over", "a", "lazy", "dog"));
        Truth.assertThat((Iterable)set).containsExactly(new Object[]{"a", "in", "the", "over", "quick", "jumped"}).inOrder();
    }

    public void testCopyOfExplicit_iterator_comparator() {
        ImmutableSortedSet set = ImmutableSortedSet.copyOf(STRING_LENGTH, ImmutableSortedSetTest.asIterator("in", "the", "quick", "jumped", "over", "a"));
        ImmutableSortedSetTest.assertSame(STRING_LENGTH, set.comparator());
    }

    public void testCopyOf_sortedSetIterable() {
        TreeSet input = Sets.newTreeSet(STRING_LENGTH);
        Collections.addAll(input, "in", "the", "quick", "jumped", "over", "a");
        Set set = this.copyOf((Collection)input);
        Truth.assertThat((Iterable)set).containsExactly(new Object[]{"a", "in", "jumped", "over", "quick", "the"}).inOrder();
    }

    public void testCopyOfSorted_natural_ordering() {
        TreeSet input = Sets.newTreeSet(Arrays.asList("in", "the", "quick", "jumped", "over", "a"));
        ImmutableSortedSet set = ImmutableSortedSet.copyOfSorted((SortedSet)input);
        Truth.assertThat((Iterable)set).containsExactly(new Object[]{"a", "in", "jumped", "over", "quick", "the"}).inOrder();
    }

    public void testCopyOfSorted_natural_comparator() {
        TreeSet input = Sets.newTreeSet(Arrays.asList("in", "the", "quick", "jumped", "over", "a"));
        ImmutableSortedSet set = ImmutableSortedSet.copyOfSorted((SortedSet)input);
        ImmutableSortedSetTest.assertSame((Object)Ordering.natural(), set.comparator());
    }

    public void testCopyOfSorted_explicit_ordering() {
        TreeSet input = Sets.newTreeSet(STRING_LENGTH);
        Collections.addAll(input, "in", "the", "quick", "jumped", "over", "a");
        ImmutableSortedSet set = ImmutableSortedSet.copyOfSorted((SortedSet)input);
        Truth.assertThat((Iterable)set).containsExactly(new Object[]{"a", "in", "the", "over", "quick", "jumped"}).inOrder();
        ImmutableSortedSetTest.assertSame(STRING_LENGTH, set.comparator());
    }

    public void testEquals_bothDefaultOrdering() {
        Set set = this.of("a", "b", "c");
        ImmutableSortedSetTest.assertEquals((Object)set, (Object)Sets.newTreeSet(Arrays.asList("a", "b", "c")));
        ImmutableSortedSetTest.assertEquals((Object)Sets.newTreeSet(Arrays.asList("a", "b", "c")), (Object)set);
        ImmutableSortedSetTest.assertFalse((boolean)((Object)set).equals(Sets.newTreeSet(Arrays.asList("a", "b", "d"))));
        ImmutableSortedSetTest.assertFalse((boolean)Sets.newTreeSet(Arrays.asList("a", "b", "d")).equals(set));
        ImmutableSortedSetTest.assertFalse((boolean)((Object)set).equals(Sets.newHashSet((Object[])new Integer[]{4, 5, 6})));
        ImmutableSortedSetTest.assertFalse((boolean)Sets.newHashSet((Object[])new Integer[]{4, 5, 6}).equals(set));
    }

    public void testEquals_bothExplicitOrdering() {
        Set set = this.of("in", "the", "a");
        ImmutableSortedSetTest.assertEquals((Object)Sets.newTreeSet(Arrays.asList("in", "the", "a")), (Object)set);
        ImmutableSortedSetTest.assertFalse((boolean)((Object)set).equals(Sets.newTreeSet(Arrays.asList("in", "the", "house"))));
        ImmutableSortedSetTest.assertFalse((boolean)Sets.newTreeSet(Arrays.asList("in", "the", "house")).equals(set));
        ImmutableSortedSetTest.assertFalse((boolean)((Object)set).equals(Sets.newHashSet((Object[])new Integer[]{4, 5, 6})));
        ImmutableSortedSetTest.assertFalse((boolean)Sets.newHashSet((Object[])new Integer[]{4, 5, 6}).equals(set));
        TreeSet complex = Sets.newTreeSet(STRING_LENGTH);
        Collections.addAll(complex, "in", "the", "a");
        ImmutableSortedSetTest.assertEquals((Object)set, (Object)complex);
    }

    public void testEquals_bothDefaultOrdering_StringVsInt() {
        Set set = this.of("a", "b", "c");
        ImmutableSortedSetTest.assertFalse((boolean)((Object)set).equals(Sets.newTreeSet(Arrays.asList(4, 5, 6))));
        ImmutableSortedSetTest.assertNotEqualLenient(Sets.newTreeSet(Arrays.asList(4, 5, 6)), set);
    }

    public void testEquals_bothExplicitOrdering_StringVsInt() {
        Set set = this.of("in", "the", "a");
        ImmutableSortedSetTest.assertFalse((boolean)((Object)set).equals(Sets.newTreeSet(Arrays.asList(4, 5, 6))));
        ImmutableSortedSetTest.assertNotEqualLenient(Sets.newTreeSet(Arrays.asList(4, 5, 6)), set);
    }

    public void testContainsAll_notSortedSet() {
        Set set = this.of("a", "b", "f");
        ImmutableSortedSetTest.assertTrue((boolean)set.containsAll(Collections.emptyList()));
        ImmutableSortedSetTest.assertTrue((boolean)set.containsAll(Arrays.asList("b")));
        ImmutableSortedSetTest.assertTrue((boolean)set.containsAll(Arrays.asList("b", "b")));
        ImmutableSortedSetTest.assertTrue((boolean)set.containsAll(Arrays.asList("b", "f")));
        ImmutableSortedSetTest.assertTrue((boolean)set.containsAll(Arrays.asList("b", "f", "a")));
        ImmutableSortedSetTest.assertFalse((boolean)set.containsAll(Arrays.asList("d")));
        ImmutableSortedSetTest.assertFalse((boolean)set.containsAll(Arrays.asList("z")));
        ImmutableSortedSetTest.assertFalse((boolean)set.containsAll(Arrays.asList("b", "d")));
        ImmutableSortedSetTest.assertFalse((boolean)set.containsAll(Arrays.asList("f", "d", "a")));
    }

    public void testContainsAll_sameComparator() {
        Set set = this.of("a", "b", "f");
        ImmutableSortedSetTest.assertTrue((boolean)set.containsAll(Sets.newTreeSet()));
        ImmutableSortedSetTest.assertTrue((boolean)set.containsAll(Sets.newTreeSet(Arrays.asList("b"))));
        ImmutableSortedSetTest.assertTrue((boolean)set.containsAll(Sets.newTreeSet(Arrays.asList("a", "f"))));
        ImmutableSortedSetTest.assertTrue((boolean)set.containsAll(Sets.newTreeSet(Arrays.asList("a", "b", "f"))));
        ImmutableSortedSetTest.assertFalse((boolean)set.containsAll(Sets.newTreeSet(Arrays.asList("d"))));
        ImmutableSortedSetTest.assertFalse((boolean)set.containsAll(Sets.newTreeSet(Arrays.asList("z"))));
        ImmutableSortedSetTest.assertFalse((boolean)set.containsAll(Sets.newTreeSet(Arrays.asList("b", "d"))));
        ImmutableSortedSetTest.assertFalse((boolean)set.containsAll(Sets.newTreeSet(Arrays.asList("f", "d", "a"))));
    }

    public void testContainsAll_sameComparator_StringVsInt() {
        Set set = this.of("a", "b", "f");
        TreeSet unexpected = Sets.newTreeSet((Comparator)Ordering.natural());
        unexpected.addAll(Arrays.asList(1, 2, 3));
        ImmutableSortedSetTest.assertFalse((boolean)set.containsAll(unexpected));
    }

    public void testContainsAll_differentComparator() {
        Comparator comparator = Collections.reverseOrder();
        ImmutableSortedSet set = new ImmutableSortedSet.Builder(comparator).add((Object[])new String[]{"a", "b", "f"}).build();
        ImmutableSortedSetTest.assertTrue((boolean)set.containsAll(Sets.newTreeSet()));
        ImmutableSortedSetTest.assertTrue((boolean)set.containsAll(Sets.newTreeSet(Arrays.asList("b"))));
        ImmutableSortedSetTest.assertTrue((boolean)set.containsAll(Sets.newTreeSet(Arrays.asList("a", "f"))));
        ImmutableSortedSetTest.assertTrue((boolean)set.containsAll(Sets.newTreeSet(Arrays.asList("a", "b", "f"))));
        ImmutableSortedSetTest.assertFalse((boolean)set.containsAll(Sets.newTreeSet(Arrays.asList("d"))));
        ImmutableSortedSetTest.assertFalse((boolean)set.containsAll(Sets.newTreeSet(Arrays.asList("z"))));
        ImmutableSortedSetTest.assertFalse((boolean)set.containsAll(Sets.newTreeSet(Arrays.asList("b", "d"))));
        ImmutableSortedSetTest.assertFalse((boolean)set.containsAll(Sets.newTreeSet(Arrays.asList("f", "d", "a"))));
    }

    @GwtIncompatible
    public void testDifferentComparator_serialization() {
        Ordering comparator = Ordering.natural().reverse();
        ImmutableSortedSet set = new ImmutableSortedSet.Builder((Comparator)comparator).add((Object[])new String[]{"a", "b", "c"}).build();
        SortedSet copy = (SortedSet)SerializableTester.reserializeAndAssert((Object)set);
        ImmutableSortedSetTest.assertTrue((boolean)Iterables.elementsEqual((Iterable)set, (Iterable)copy));
        ImmutableSortedSetTest.assertEquals(set.comparator(), copy.comparator());
    }

    public void testReverseOrder() {
        ImmutableSortedSet set = ImmutableSortedSet.reverseOrder().add((Object[])new String[]{"a", "b", "c"}).build();
        Truth.assertThat((Iterable)set).containsExactly(new Object[]{"c", "b", "a"}).inOrder();
        ImmutableSortedSetTest.assertEquals((Object)Ordering.natural().reverse(), set.comparator());
    }

    public void testSupertypeComparator() {
        ImmutableSortedSet set = new ImmutableSortedSet.Builder(TO_STRING).add((Object[])new Integer[]{3, 12, 101, 44}).build();
        Truth.assertThat((Iterable)set).containsExactly(new Object[]{101, 12, 3, 44}).inOrder();
    }

    public void testSupertypeComparatorSubtypeElements() {
        ImmutableSortedSet set = new ImmutableSortedSet.Builder(TO_STRING).add((Object[])new Number[]{3, 12, 101, 44}).build();
        Truth.assertThat((Iterable)set).containsExactly(new Object[]{101, 12, 3, 44}).inOrder();
    }

    <E extends Comparable<E>> ImmutableSortedSet.Builder<E> builder() {
        return ImmutableSortedSet.naturalOrder();
    }

    @Override
    int getComplexBuilderSetLastElement() {
        return 0xFFFFFF;
    }

    public void testLegacyComparable_of() {
        ImmutableSortedSet set0 = ImmutableSortedSet.of();
        ImmutableSortedSet set1 = ImmutableSortedSet.of((Comparable)LegacyComparable.Z);
        ImmutableSortedSet set2 = ImmutableSortedSet.of((Comparable)LegacyComparable.Z, (Comparable)LegacyComparable.Y);
    }

    public void testLegacyComparable_copyOf_collection() {
        ImmutableSortedSet set = ImmutableSortedSet.copyOf(LegacyComparable.VALUES_BACKWARD);
        ImmutableSortedSetTest.assertTrue((boolean)Iterables.elementsEqual(LegacyComparable.VALUES_FORWARD, (Iterable)set));
    }

    public void testLegacyComparable_copyOf_iterator() {
        ImmutableSortedSet set = ImmutableSortedSet.copyOf(LegacyComparable.VALUES_BACKWARD.iterator());
        ImmutableSortedSetTest.assertTrue((boolean)Iterables.elementsEqual(LegacyComparable.VALUES_FORWARD, (Iterable)set));
    }

    public void testLegacyComparable_builder_natural() {
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
        builder.addAll(LegacyComparable.VALUES_BACKWARD);
        builder.add((Object)LegacyComparable.X);
        builder.add((Object[])new LegacyComparable[]{LegacyComparable.Y, LegacyComparable.Z});
        ImmutableSortedSet set = builder.build();
        ImmutableSortedSetTest.assertTrue((boolean)Iterables.elementsEqual(LegacyComparable.VALUES_FORWARD, (Iterable)set));
    }

    public void testLegacyComparable_builder_reverse() {
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.reverseOrder();
        builder.addAll(LegacyComparable.VALUES_FORWARD);
        builder.add((Object)LegacyComparable.X);
        builder.add((Object[])new LegacyComparable[]{LegacyComparable.Y, LegacyComparable.Z});
        ImmutableSortedSet set = builder.build();
        ImmutableSortedSetTest.assertTrue((boolean)Iterables.elementsEqual(LegacyComparable.VALUES_BACKWARD, (Iterable)set));
    }

    public void testBuilderMethod() {
        try {
            ImmutableSortedSet.builder();
            ImmutableSortedSetTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testAsList() {
        ImmutableSortedSet set = ImmutableSortedSet.of((Comparable)((Object)"a"), (Comparable)((Object)"e"), (Comparable)((Object)"i"), (Comparable)((Object)"o"), (Comparable)((Object)"u"));
        ImmutableList list = set.asList();
        ImmutableSortedSetTest.assertEquals((Object)ImmutableList.of((Object)"a", (Object)"e", (Object)"i", (Object)"o", (Object)"u"), (Object)list);
        ImmutableSortedSetTest.assertSame((Object)list, (Object)ImmutableList.copyOf((Collection)set));
    }

    @GwtIncompatible
    public void testAsListReturnTypeAndSerialization() {
        ImmutableSortedSet set = ImmutableSortedSet.of((Comparable)((Object)"a"), (Comparable)((Object)"e"), (Comparable)((Object)"i"), (Comparable)((Object)"o"), (Comparable)((Object)"u"));
        ImmutableList list = set.asList();
        ImmutableSortedSetTest.assertTrue((boolean)(list instanceof ImmutableSortedAsList));
        ImmutableList copy = (ImmutableList)SerializableTester.reserializeAndAssert((Object)list);
        ImmutableSortedSetTest.assertTrue((boolean)(copy instanceof ImmutableSortedAsList));
    }

    public void testSubsetAsList() {
        ImmutableSortedSet set = ImmutableSortedSet.of((Comparable)((Object)"a"), (Comparable)((Object)"e"), (Comparable)((Object)"i"), (Comparable)((Object)"o"), (Comparable)((Object)"u")).subSet((Object)"c", (Object)"r");
        ImmutableList list = set.asList();
        ImmutableSortedSetTest.assertEquals((Object)ImmutableList.of((Object)"e", (Object)"i", (Object)"o"), (Object)list);
        ImmutableSortedSetTest.assertEquals((Object)list, (Object)ImmutableList.copyOf((Collection)set));
    }

    @GwtIncompatible
    public void testSubsetAsListReturnTypeAndSerialization() {
        ImmutableSortedSet set = ImmutableSortedSet.of((Comparable)((Object)"a"), (Comparable)((Object)"e"), (Comparable)((Object)"i"), (Comparable)((Object)"o"), (Comparable)((Object)"u")).subSet((Object)"c", (Object)"r");
        ImmutableList list = set.asList();
        ImmutableSortedSetTest.assertTrue((boolean)(list instanceof ImmutableSortedAsList));
        ImmutableList copy = (ImmutableList)SerializableTester.reserializeAndAssert((Object)list);
        ImmutableSortedSetTest.assertTrue((boolean)(copy instanceof ImmutableSortedAsList));
    }

    public void testAsListInconsistentComprator() {
        ImmutableSortedSet set = ImmutableSortedSet.orderedBy(STRING_LENGTH).add((Object[])new String[]{"in", "the", "quick", "jumped", "over", "a"}).build();
        ImmutableList list = set.asList();
        ImmutableSortedSetTest.assertTrue((boolean)list.contains((Object)"the"));
        ImmutableSortedSetTest.assertEquals((int)2, (int)list.indexOf((Object)"the"));
        ImmutableSortedSetTest.assertEquals((int)2, (int)list.lastIndexOf((Object)"the"));
        ImmutableSortedSetTest.assertFalse((boolean)list.contains((Object)"dog"));
        ImmutableSortedSetTest.assertEquals((int)-1, (int)list.indexOf((Object)"dog"));
        ImmutableSortedSetTest.assertEquals((int)-1, (int)list.lastIndexOf((Object)"dog"));
        ImmutableSortedSetTest.assertFalse((boolean)list.contains((Object)"chicken"));
        ImmutableSortedSetTest.assertEquals((int)-1, (int)list.indexOf((Object)"chicken"));
        ImmutableSortedSetTest.assertEquals((int)-1, (int)list.lastIndexOf((Object)"chicken"));
    }

    private static <E> Iterator<E> asIterator(E ... elements) {
        return Arrays.asList(elements).iterator();
    }

    private static void assertNotEqualLenient(TreeSet<?> unexpected, SortedSet<?> actual) {
        try {
            Truth.assertThat(actual).isNotEqualTo(unexpected);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void testHeadSetInclusive() {
        Object[] strings = (String[])NUMBER_NAMES.toArray((Object[])new String[0]);
        ImmutableSortedSet set = ImmutableSortedSet.copyOf((Comparable[])strings);
        Arrays.sort(strings);
        for (int i = 0; i < strings.length; ++i) {
            Truth.assertThat((Iterable)set.headSet(strings[i], true)).containsExactlyElementsIn(ImmutableSortedSetTest.sortedNumberNames(0, i + 1)).inOrder();
        }
    }

    public void testHeadSetExclusive() {
        Object[] strings = (String[])NUMBER_NAMES.toArray((Object[])new String[0]);
        ImmutableSortedSet set = ImmutableSortedSet.copyOf((Comparable[])strings);
        Arrays.sort(strings);
        for (int i = 0; i < strings.length; ++i) {
            Truth.assertThat((Iterable)set.headSet(strings[i], false)).containsExactlyElementsIn(ImmutableSortedSetTest.sortedNumberNames(0, i)).inOrder();
        }
    }

    public void testTailSetInclusive() {
        Object[] strings = (String[])NUMBER_NAMES.toArray((Object[])new String[0]);
        ImmutableSortedSet set = ImmutableSortedSet.copyOf((Comparable[])strings);
        Arrays.sort(strings);
        for (int i = 0; i < strings.length; ++i) {
            Truth.assertThat((Iterable)set.tailSet(strings[i], true)).containsExactlyElementsIn(ImmutableSortedSetTest.sortedNumberNames(i, strings.length)).inOrder();
        }
    }

    public void testTailSetExclusive() {
        Object[] strings = (String[])NUMBER_NAMES.toArray((Object[])new String[0]);
        ImmutableSortedSet set = ImmutableSortedSet.copyOf((Comparable[])strings);
        Arrays.sort(strings);
        for (int i = 0; i < strings.length; ++i) {
            Truth.assertThat((Iterable)set.tailSet(strings[i], false)).containsExactlyElementsIn(ImmutableSortedSetTest.sortedNumberNames(i + 1, strings.length)).inOrder();
        }
    }

    public void testSubSetExclusiveExclusive() {
        Object[] strings = (String[])NUMBER_NAMES.toArray((Object[])new String[0]);
        ImmutableSortedSet set = ImmutableSortedSet.copyOf((Comparable[])strings);
        Arrays.sort(strings);
        for (int i = 0; i < strings.length; ++i) {
            for (int j = i; j < strings.length; ++j) {
                Truth.assertThat((Iterable)set.subSet(strings[i], false, strings[j], false)).containsExactlyElementsIn(ImmutableSortedSetTest.sortedNumberNames(Math.min(i + 1, j), j)).inOrder();
            }
        }
    }

    public void testSubSetInclusiveExclusive() {
        Object[] strings = (String[])NUMBER_NAMES.toArray((Object[])new String[0]);
        ImmutableSortedSet set = ImmutableSortedSet.copyOf((Comparable[])strings);
        Arrays.sort(strings);
        for (int i = 0; i < strings.length; ++i) {
            for (int j = i; j < strings.length; ++j) {
                Truth.assertThat((Iterable)set.subSet(strings[i], true, strings[j], false)).containsExactlyElementsIn(ImmutableSortedSetTest.sortedNumberNames(i, j)).inOrder();
            }
        }
    }

    public void testSubSetExclusiveInclusive() {
        Object[] strings = (String[])NUMBER_NAMES.toArray((Object[])new String[0]);
        ImmutableSortedSet set = ImmutableSortedSet.copyOf((Comparable[])strings);
        Arrays.sort(strings);
        for (int i = 0; i < strings.length; ++i) {
            for (int j = i; j < strings.length; ++j) {
                Truth.assertThat((Iterable)set.subSet(strings[i], false, strings[j], true)).containsExactlyElementsIn(ImmutableSortedSetTest.sortedNumberNames(i + 1, j + 1)).inOrder();
            }
        }
    }

    public void testSubSetInclusiveInclusive() {
        Object[] strings = (String[])NUMBER_NAMES.toArray((Object[])new String[0]);
        ImmutableSortedSet set = ImmutableSortedSet.copyOf((Comparable[])strings);
        Arrays.sort(strings);
        for (int i = 0; i < strings.length; ++i) {
            for (int j = i; j < strings.length; ++j) {
                Truth.assertThat((Iterable)set.subSet(strings[i], true, strings[j], true)).containsExactlyElementsIn(ImmutableSortedSetTest.sortedNumberNames(i, j + 1)).inOrder();
            }
        }
    }

    private static ImmutableList<String> sortedNumberNames(int i, int j) {
        return ImmutableList.copyOf((Collection)SORTED_NUMBER_NAMES.subList(i, j));
    }

    public void testBuilderGenerics_SelfComparable() {
        ImmutableSortedSet.Builder natural = ImmutableSortedSet.naturalOrder();
        ImmutableSortedSet.Builder reverse = ImmutableSortedSet.reverseOrder();
    }

    public void testBuilderGenerics_SuperComparable() {
        ImmutableSortedSet.Builder natural = ImmutableSortedSet.naturalOrder();
        ImmutableSortedSet.Builder reverse = ImmutableSortedSet.reverseOrder();
    }

    private static class SuperComparableExample
    extends SelfComparableExample {
        private SuperComparableExample() {
        }
    }

    private static class SelfComparableExample
    implements Comparable<SelfComparableExample> {
        private SelfComparableExample() {
        }

        @Override
        public int compareTo(SelfComparableExample o) {
            return 0;
        }
    }

    static class Impl
    implements Interface {
        static int nextId;
        Integer id = nextId++;

        Impl() {
        }

        @Override
        public int compareTo(Interface other) {
            return this.id.compareTo(((Impl)other).id);
        }
    }

    static interface Interface
    extends Comparable<Interface> {
    }

    private static enum StringLengthComparator implements Comparator<String>
    {
        INSTANCE;


        @Override
        public int compare(String a, String b) {
            return a.length() - b.length();
        }
    }
}

