/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Supplier;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MapConstraint;
import com.google.common.collect.MapConstraints;
import com.google.common.collect.Maps;
import com.google.common.collect.testing.Helpers;
import com.google.common.truth.Truth;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.RandomAccess;
import java.util.Set;
import java.util.TreeMap;
import junit.framework.Assert;
import junit.framework.TestCase;

@GwtCompatible
public class MapConstraintsTest
extends TestCase {
    private static final String TEST_KEY = "test";
    private static final Integer TEST_VALUE = 42;
    static final MapConstraint<String, Integer> TEST_CONSTRAINT = new TestConstraint();

    public void testConstrainedMapLegal() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        Map constrained = MapConstraints.constrainedMap((Map)map, TEST_CONSTRAINT);
        map.put(TEST_KEY, TEST_VALUE);
        constrained.put("foo", 1);
        map.putAll(ImmutableMap.of((Object)"bar", (Object)2));
        constrained.putAll(ImmutableMap.of((Object)"baz", (Object)3));
        MapConstraintsTest.assertTrue((boolean)map.equals(constrained));
        MapConstraintsTest.assertTrue((boolean)constrained.equals(map));
        MapConstraintsTest.assertEquals(map.entrySet(), constrained.entrySet());
        MapConstraintsTest.assertEquals(map.keySet(), constrained.keySet());
        MapConstraintsTest.assertEquals((Object)HashMultiset.create(map.values()), (Object)HashMultiset.create(constrained.values()));
        Truth.assertThat(map.values()).isNotInstanceOf(Serializable.class);
        MapConstraintsTest.assertEquals((String)((Object)map).toString(), (String)constrained.toString());
        MapConstraintsTest.assertEquals((int)map.hashCode(), (int)constrained.hashCode());
        Truth.assertThat(map.entrySet()).containsExactly(new Object[]{Maps.immutableEntry((Object)TEST_KEY, (Object)TEST_VALUE), Maps.immutableEntry((Object)"foo", (Object)1), Maps.immutableEntry((Object)"bar", (Object)2), Maps.immutableEntry((Object)"baz", (Object)3)}).inOrder();
    }

    public void testConstrainedMapIllegal() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        Map constrained = MapConstraints.constrainedMap((Map)map, TEST_CONSTRAINT);
        try {
            constrained.put(TEST_KEY, TEST_VALUE);
            MapConstraintsTest.fail((String)"TestKeyException expected");
        }
        catch (TestKeyException expected) {
            // empty catch block
        }
        try {
            constrained.put("baz", TEST_VALUE);
            MapConstraintsTest.fail((String)"TestValueException expected");
        }
        catch (TestValueException expected) {
            // empty catch block
        }
        try {
            constrained.put(TEST_KEY, 3);
            MapConstraintsTest.fail((String)"TestKeyException expected");
        }
        catch (TestKeyException expected) {
            // empty catch block
        }
        try {
            constrained.putAll(ImmutableMap.of((Object)"baz", (Object)3, (Object)TEST_KEY, (Object)4));
            MapConstraintsTest.fail((String)"TestKeyException expected");
        }
        catch (TestKeyException testKeyException) {
            // empty catch block
        }
        MapConstraintsTest.assertEquals(Collections.emptySet(), map.entrySet());
        MapConstraintsTest.assertEquals(Collections.emptySet(), constrained.entrySet());
    }

    public void testConstrainedTypePreservingList() {
        ListMultimap multimap = MapConstraints.constrainedListMultimap((ListMultimap)LinkedListMultimap.create(), TEST_CONSTRAINT);
        multimap.put((Object)"foo", (Object)1);
        Map.Entry entry = multimap.asMap().entrySet().iterator().next();
        MapConstraintsTest.assertTrue((boolean)(entry.getValue() instanceof List));
        MapConstraintsTest.assertFalse((boolean)(multimap.entries() instanceof Set));
        MapConstraintsTest.assertFalse((boolean)(multimap.get((Object)"foo") instanceof RandomAccess));
    }

    public void testConstrainedTypePreservingRandomAccessList() {
        ListMultimap multimap = MapConstraints.constrainedListMultimap((ListMultimap)ArrayListMultimap.create(), TEST_CONSTRAINT);
        multimap.put((Object)"foo", (Object)1);
        Map.Entry entry = multimap.asMap().entrySet().iterator().next();
        MapConstraintsTest.assertTrue((boolean)(entry.getValue() instanceof List));
        MapConstraintsTest.assertFalse((boolean)(multimap.entries() instanceof Set));
        MapConstraintsTest.assertTrue((boolean)(multimap.get((Object)"foo") instanceof RandomAccess));
    }

    public void testMapEntrySetToArray() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        Map constrained = MapConstraints.constrainedMap((Map)map, TEST_CONSTRAINT);
        map.put("foo", 1);
        Map.Entry entry = (Map.Entry)constrained.entrySet().toArray()[0];
        try {
            entry.setValue(TEST_VALUE);
            MapConstraintsTest.fail((String)"TestValueException expected");
        }
        catch (TestValueException expected) {
            // empty catch block
        }
        MapConstraintsTest.assertFalse((boolean)map.containsValue(TEST_VALUE));
    }

    public void testMapEntrySetContainsNefariousEntry() {
        TreeMap map = Maps.newTreeMap();
        Map constrained = MapConstraints.constrainedMap((Map)map, TEST_CONSTRAINT);
        map.put("foo", 1);
        Map.Entry nefariousEntry = Helpers.nefariousMapEntry((Object)TEST_KEY, (Object)TEST_VALUE);
        Set entries = constrained.entrySet();
        MapConstraintsTest.assertFalse((boolean)entries.contains(nefariousEntry));
        MapConstraintsTest.assertFalse((boolean)map.containsValue(TEST_VALUE));
        MapConstraintsTest.assertFalse((boolean)entries.containsAll(Collections.singleton(nefariousEntry)));
        MapConstraintsTest.assertFalse((boolean)map.containsValue(TEST_VALUE));
    }

    public void testNefariousMapPutAll() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        Map constrained = MapConstraints.constrainedMap((Map)map, TEST_CONSTRAINT);
        Map<String, Integer> onceIterable = MapConstraintsTest.onceIterableMap("foo", 1);
        constrained.putAll(onceIterable);
        MapConstraintsTest.assertEquals((Object)1, constrained.get("foo"));
    }

    static <K, V> Map<K, V> onceIterableMap(K key, V value) {
        final Map.Entry entry = Maps.immutableEntry(key, value);
        return new AbstractMap<K, V>(){
            boolean iteratorCalled;

            @Override
            public int size() {
                return 1;
            }

            @Override
            public Set<Map.Entry<K, V>> entrySet() {
                return new ForwardingSet<Map.Entry<K, V>>(){

                    protected Set<Map.Entry<K, V>> delegate() {
                        return Collections.singleton(entry);
                    }

                    public Iterator<Map.Entry<K, V>> iterator() {
                        Assert.assertFalse((String)"Expected only one call to iterator()", (boolean)iteratorCalled);
                        iteratorCalled = true;
                        return super.iterator();
                    }
                };
            }

            @Override
            public Set<K> keySet() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Collection<V> values() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static class QueueSupplier
    implements Supplier<Queue<Integer>> {
        private QueueSupplier() {
        }

        public Queue<Integer> get() {
            return new LinkedList<Integer>();
        }
    }

    private static final class TestConstraint
    implements MapConstraint<String, Integer>,
    Serializable {
        private static final long serialVersionUID = 0L;

        private TestConstraint() {
        }

        public void checkKeyValue(String key, Integer value) {
            if (MapConstraintsTest.TEST_KEY.equals(key)) {
                throw new TestKeyException();
            }
            if (TEST_VALUE.equals(value)) {
                throw new TestValueException();
            }
        }
    }

    static final class TestValueException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 0L;

        TestValueException() {
        }
    }

    static final class TestKeyException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 0L;

        TestKeyException() {
        }
    }
}

