/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Equivalence;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MapMaker;
import com.google.common.collect.MapMakerInternalMap;
import com.google.common.testing.NullPointerTester;
import com.google.common.truth.Truth;
import java.lang.ref.Reference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import junit.framework.TestCase;

public class MapMakerInternalMapTest
extends TestCase {
    static final int SMALL_MAX_SIZE = 315;

    private static <K, V> MapMakerInternalMap<K, V, ? extends MapMakerInternalMap.InternalEntry<K, V, ?>, ? extends MapMakerInternalMap.Segment<K, V, ?, ?>> makeMap(MapMaker maker) {
        return MapMakerInternalMap.create((MapMaker)maker);
    }

    private static MapMaker createMapMaker() {
        MapMaker maker = new MapMaker();
        maker.useCustomMap = true;
        return maker;
    }

    public void testDefaults() {
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker());
        MapMakerInternalMapTest.assertSame((Object)MapMakerInternalMap.Strength.STRONG, (Object)map.keyStrength());
        MapMakerInternalMapTest.assertSame((Object)MapMakerInternalMap.Strength.STRONG, (Object)map.valueStrength());
        MapMakerInternalMapTest.assertSame((Object)map.keyStrength().defaultEquivalence(), (Object)map.keyEquivalence);
        MapMakerInternalMapTest.assertSame((Object)map.valueStrength().defaultEquivalence(), (Object)map.valueEquivalence());
        Truth.assertThat((Object)map.entryHelper).isInstanceOf(MapMakerInternalMap.StrongKeyStrongValueEntry.Helper.class);
        MapMakerInternalMapTest.assertEquals((int)4, (int)map.concurrencyLevel);
        Truth.assertThat((Object[])map.segments).hasLength(4);
        MapMakerInternalMapTest.assertEquals((int)(16 / map.segments.length), (int)map.segments[0].table.length());
    }

    public void testSetKeyEquivalence() {
        Equivalence<Object> testEquivalence = new Equivalence<Object>(){

            protected boolean doEquivalent(Object a, Object b) {
                return false;
            }

            protected int doHash(Object t) {
                return 0;
            }
        };
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().keyEquivalence((Equivalence)testEquivalence));
        MapMakerInternalMapTest.assertSame((Object)testEquivalence, (Object)map.keyEquivalence);
        MapMakerInternalMapTest.assertSame((Object)map.valueStrength().defaultEquivalence(), (Object)map.valueEquivalence());
    }

    public void testSetConcurrencyLevel() {
        MapMakerInternalMapTest.checkConcurrencyLevel(1, 1);
        MapMakerInternalMapTest.checkConcurrencyLevel(2, 2);
        MapMakerInternalMapTest.checkConcurrencyLevel(3, 4);
        MapMakerInternalMapTest.checkConcurrencyLevel(4, 4);
        MapMakerInternalMapTest.checkConcurrencyLevel(5, 8);
        MapMakerInternalMapTest.checkConcurrencyLevel(6, 8);
        MapMakerInternalMapTest.checkConcurrencyLevel(7, 8);
        MapMakerInternalMapTest.checkConcurrencyLevel(8, 8);
    }

    private static void checkConcurrencyLevel(int concurrencyLevel, int segmentCount) {
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().concurrencyLevel(concurrencyLevel));
        Truth.assertThat((Object[])map.segments).hasLength(segmentCount);
    }

    public void testSetInitialCapacity() {
        MapMakerInternalMapTest.checkInitialCapacity(1, 0, 1);
        MapMakerInternalMapTest.checkInitialCapacity(1, 1, 1);
        MapMakerInternalMapTest.checkInitialCapacity(1, 2, 2);
        MapMakerInternalMapTest.checkInitialCapacity(1, 3, 4);
        MapMakerInternalMapTest.checkInitialCapacity(1, 4, 4);
        MapMakerInternalMapTest.checkInitialCapacity(1, 5, 8);
        MapMakerInternalMapTest.checkInitialCapacity(1, 6, 8);
        MapMakerInternalMapTest.checkInitialCapacity(1, 7, 8);
        MapMakerInternalMapTest.checkInitialCapacity(1, 8, 8);
        MapMakerInternalMapTest.checkInitialCapacity(2, 0, 1);
        MapMakerInternalMapTest.checkInitialCapacity(2, 1, 1);
        MapMakerInternalMapTest.checkInitialCapacity(2, 2, 1);
        MapMakerInternalMapTest.checkInitialCapacity(2, 3, 2);
        MapMakerInternalMapTest.checkInitialCapacity(2, 4, 2);
        MapMakerInternalMapTest.checkInitialCapacity(2, 5, 4);
        MapMakerInternalMapTest.checkInitialCapacity(2, 6, 4);
        MapMakerInternalMapTest.checkInitialCapacity(2, 7, 4);
        MapMakerInternalMapTest.checkInitialCapacity(2, 8, 4);
        MapMakerInternalMapTest.checkInitialCapacity(4, 0, 1);
        MapMakerInternalMapTest.checkInitialCapacity(4, 1, 1);
        MapMakerInternalMapTest.checkInitialCapacity(4, 2, 1);
        MapMakerInternalMapTest.checkInitialCapacity(4, 3, 1);
        MapMakerInternalMapTest.checkInitialCapacity(4, 4, 1);
        MapMakerInternalMapTest.checkInitialCapacity(4, 5, 2);
        MapMakerInternalMapTest.checkInitialCapacity(4, 6, 2);
        MapMakerInternalMapTest.checkInitialCapacity(4, 7, 2);
        MapMakerInternalMapTest.checkInitialCapacity(4, 8, 2);
    }

    private static void checkInitialCapacity(int concurrencyLevel, int initialCapacity, int segmentSize) {
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().concurrencyLevel(concurrencyLevel).initialCapacity(initialCapacity));
        for (int i = 0; i < map.segments.length; ++i) {
            MapMakerInternalMapTest.assertEquals((int)segmentSize, (int)map.segments[i].table.length());
        }
    }

    public void testSetMaximumSize() {
        for (int maxSize = 1; maxSize < 8; ++maxSize) {
            MapMakerInternalMapTest.checkMaximumSize(1, 8, maxSize);
            MapMakerInternalMapTest.checkMaximumSize(2, 8, maxSize);
            MapMakerInternalMapTest.checkMaximumSize(4, 8, maxSize);
            MapMakerInternalMapTest.checkMaximumSize(8, 8, maxSize);
        }
        MapMakerInternalMapTest.checkMaximumSize(1, 8, Integer.MAX_VALUE);
        MapMakerInternalMapTest.checkMaximumSize(2, 8, Integer.MAX_VALUE);
        MapMakerInternalMapTest.checkMaximumSize(4, 8, Integer.MAX_VALUE);
        MapMakerInternalMapTest.checkMaximumSize(8, 8, Integer.MAX_VALUE);
        for (int capacity = 0; capacity < 8; ++capacity) {
            MapMakerInternalMapTest.checkMaximumSize(1, capacity, 4);
            MapMakerInternalMapTest.checkMaximumSize(2, capacity, 4);
            MapMakerInternalMapTest.checkMaximumSize(4, capacity, 4);
            MapMakerInternalMapTest.checkMaximumSize(8, capacity, 4);
        }
    }

    private static void checkMaximumSize(int concurrencyLevel, int initialCapacity, int maxSize) {
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().concurrencyLevel(concurrencyLevel).initialCapacity(initialCapacity));
        int totalCapacity = 0;
        for (int i = 0; i < map.segments.length; ++i) {
            totalCapacity += map.segments[i].maxSegmentSize;
        }
        MapMakerInternalMapTest.assertTrue((String)("totalCapcity=" + totalCapacity + ", maxSize=" + maxSize), (totalCapacity <= maxSize ? 1 : 0) != 0);
    }

    public void testSetWeakKeys() {
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().weakKeys());
        MapMakerInternalMapTest.checkStrength(map, MapMakerInternalMap.Strength.WEAK, MapMakerInternalMap.Strength.STRONG);
        Truth.assertThat((Object)map.entryHelper).isInstanceOf(MapMakerInternalMap.WeakKeyStrongValueEntry.Helper.class);
    }

    public void testSetWeakValues() {
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().weakValues());
        MapMakerInternalMapTest.checkStrength(map, MapMakerInternalMap.Strength.STRONG, MapMakerInternalMap.Strength.WEAK);
        Truth.assertThat((Object)map.entryHelper).isInstanceOf(MapMakerInternalMap.StrongKeyWeakValueEntry.Helper.class);
    }

    private static void checkStrength(MapMakerInternalMap<Object, Object, ?, ?> map, MapMakerInternalMap.Strength keyStrength, MapMakerInternalMap.Strength valueStrength) {
        MapMakerInternalMapTest.assertSame((Object)keyStrength, (Object)map.keyStrength());
        MapMakerInternalMapTest.assertSame((Object)valueStrength, (Object)map.valueStrength());
        MapMakerInternalMapTest.assertSame((Object)keyStrength.defaultEquivalence(), (Object)map.keyEquivalence);
        MapMakerInternalMapTest.assertSame((Object)valueStrength.defaultEquivalence(), (Object)map.valueEquivalence());
    }

    public void testNewEntry() {
        for (MapMaker maker : MapMakerInternalMapTest.allWeakValueStrengthMakers()) {
            MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(maker);
            MapMakerInternalMap.Segment segment = map.segments[0];
            Object keyOne = new Object();
            Object valueOne = new Object();
            int hashOne = map.hash(keyOne);
            MapMakerInternalMap.InternalEntry entryOne = segment.newEntryForTesting(keyOne, hashOne, null);
            MapMakerInternalMap.WeakValueReference valueRefOne = segment.newWeakValueReferenceForTesting(entryOne, valueOne);
            MapMakerInternalMapTest.assertSame((Object)valueOne, (Object)valueRefOne.get());
            segment.setWeakValueReferenceForTesting(entryOne, valueRefOne);
            MapMakerInternalMapTest.assertSame((Object)keyOne, (Object)entryOne.getKey());
            MapMakerInternalMapTest.assertEquals((int)hashOne, (int)entryOne.getHash());
            MapMakerInternalMapTest.assertNull((Object)entryOne.getNext());
            MapMakerInternalMapTest.assertSame((Object)valueRefOne, (Object)segment.getWeakValueReferenceForTesting(entryOne));
            Object keyTwo = new Object();
            Object valueTwo = new Object();
            int hashTwo = map.hash(keyTwo);
            MapMakerInternalMap.InternalEntry entryTwo = segment.newEntryForTesting(keyTwo, hashTwo, entryOne);
            MapMakerInternalMap.WeakValueReference valueRefTwo = segment.newWeakValueReferenceForTesting(entryTwo, valueTwo);
            MapMakerInternalMapTest.assertSame((Object)valueTwo, (Object)valueRefTwo.get());
            segment.setWeakValueReferenceForTesting(entryTwo, valueRefTwo);
            MapMakerInternalMapTest.assertSame((Object)keyTwo, (Object)entryTwo.getKey());
            MapMakerInternalMapTest.assertEquals((int)hashTwo, (int)entryTwo.getHash());
            MapMakerInternalMapTest.assertSame((Object)entryOne, (Object)entryTwo.getNext());
            MapMakerInternalMapTest.assertSame((Object)valueRefTwo, (Object)segment.getWeakValueReferenceForTesting(entryTwo));
        }
    }

    public void testCopyEntry() {
        for (MapMaker maker : MapMakerInternalMapTest.allWeakValueStrengthMakers()) {
            MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(maker);
            MapMakerInternalMap.Segment segment = map.segments[0];
            Object keyOne = new Object();
            Object valueOne = new Object();
            int hashOne = map.hash(keyOne);
            MapMakerInternalMap.InternalEntry entryOne = segment.newEntryForTesting(keyOne, hashOne, null);
            segment.setValueForTesting(entryOne, valueOne);
            Object keyTwo = new Object();
            Object valueTwo = new Object();
            int hashTwo = map.hash(keyTwo);
            MapMakerInternalMap.InternalEntry entryTwo = segment.newEntryForTesting(keyTwo, hashTwo, null);
            segment.setValueForTesting(entryTwo, valueTwo);
            MapMakerInternalMap.InternalEntry copyOne = segment.copyForTesting(entryOne, null);
            MapMakerInternalMapTest.assertSame((Object)keyOne, (Object)entryOne.getKey());
            MapMakerInternalMapTest.assertEquals((int)hashOne, (int)entryOne.getHash());
            MapMakerInternalMapTest.assertNull((Object)entryOne.getNext());
            MapMakerInternalMapTest.assertSame((Object)valueOne, (Object)copyOne.getValue());
            MapMakerInternalMap.InternalEntry copyTwo = segment.copyForTesting(entryTwo, copyOne);
            MapMakerInternalMapTest.assertSame((Object)keyTwo, (Object)copyTwo.getKey());
            MapMakerInternalMapTest.assertEquals((int)hashTwo, (int)copyTwo.getHash());
            MapMakerInternalMapTest.assertSame((Object)copyOne, (Object)copyTwo.getNext());
            MapMakerInternalMapTest.assertSame((Object)valueTwo, (Object)copyTwo.getValue());
        }
    }

    public void testSegmentGetAndContains() {
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().concurrencyLevel(1).weakValues());
        MapMakerInternalMap.Segment segment = map.segments[0];
        Object key = new Object();
        int hash = map.hash(key);
        Object value = new Object();
        AtomicReferenceArray table = segment.table;
        int index = hash & table.length() - 1;
        MapMakerInternalMap.InternalEntry entry = segment.newEntryForTesting(key, hash, null);
        segment.setValueForTesting(entry, value);
        MapMakerInternalMapTest.assertNull((Object)segment.get(key, hash));
        segment.setTableEntryForTesting(index, entry);
        MapMakerInternalMapTest.assertNull((Object)segment.get(key, hash));
        MapMakerInternalMapTest.assertFalse((boolean)segment.containsKey(key, hash));
        MapMakerInternalMapTest.assertFalse((boolean)segment.containsValue(value));
        ++segment.count;
        MapMakerInternalMapTest.assertSame((Object)value, (Object)segment.get(key, hash));
        MapMakerInternalMapTest.assertTrue((boolean)segment.containsKey(key, hash));
        MapMakerInternalMapTest.assertTrue((boolean)segment.containsValue(value));
        MapMakerInternalMapTest.assertNull((Object)segment.get(new Object(), hash));
        MapMakerInternalMap.InternalEntry nullEntry = segment.newEntryForTesting(null, hash, entry);
        Object nullValue = new Object();
        MapMakerInternalMap.WeakValueReference nullValueRef = segment.newWeakValueReferenceForTesting(nullEntry, nullValue);
        segment.setWeakValueReferenceForTesting(nullEntry, nullValueRef);
        segment.setTableEntryForTesting(index, nullEntry);
        MapMakerInternalMapTest.assertSame((Object)value, (Object)segment.get(key, hash));
        MapMakerInternalMapTest.assertTrue((boolean)segment.containsKey(key, hash));
        MapMakerInternalMapTest.assertTrue((boolean)segment.containsValue(value));
        MapMakerInternalMapTest.assertFalse((boolean)segment.containsValue(nullValue));
        MapMakerInternalMap.InternalEntry dummyEntry = segment.newEntryForTesting(new Object(), hash, entry);
        Object dummyValue = new Object();
        MapMakerInternalMap.WeakValueReference dummyValueRef = segment.newWeakValueReferenceForTesting(dummyEntry, dummyValue);
        segment.setWeakValueReferenceForTesting(dummyEntry, dummyValueRef);
        segment.setTableEntryForTesting(index, dummyEntry);
        MapMakerInternalMapTest.assertSame((Object)value, (Object)segment.get(key, hash));
        MapMakerInternalMapTest.assertTrue((boolean)segment.containsKey(key, hash));
        MapMakerInternalMapTest.assertTrue((boolean)segment.containsValue(value));
        MapMakerInternalMapTest.assertTrue((boolean)segment.containsValue(dummyValue));
        dummyEntry = segment.newEntryForTesting(key, hash, entry);
        dummyValue = new Object();
        dummyValueRef = segment.newWeakValueReferenceForTesting(dummyEntry, dummyValue);
        segment.setWeakValueReferenceForTesting(dummyEntry, dummyValueRef);
        segment.setTableEntryForTesting(index, dummyEntry);
        MapMakerInternalMapTest.assertSame((Object)dummyValue, (Object)segment.get(key, hash));
        MapMakerInternalMapTest.assertTrue((boolean)segment.containsKey(key, hash));
        MapMakerInternalMapTest.assertTrue((boolean)segment.containsValue(value));
        MapMakerInternalMapTest.assertTrue((boolean)segment.containsValue(dummyValue));
    }

    public void testSegmentReplaceValue() {
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().concurrencyLevel(1).weakValues());
        MapMakerInternalMap.Segment segment = map.segments[0];
        Object key = new Object();
        int hash = map.hash(key);
        Object oldValue = new Object();
        Object newValue = new Object();
        AtomicReferenceArray table = segment.table;
        int index = hash & table.length() - 1;
        MapMakerInternalMap.InternalEntry entry = segment.newEntryForTesting(key, hash, null);
        MapMakerInternalMap.WeakValueReference oldValueRef = segment.newWeakValueReferenceForTesting(entry, oldValue);
        segment.setWeakValueReferenceForTesting(entry, oldValueRef);
        MapMakerInternalMapTest.assertFalse((boolean)segment.replace(key, hash, oldValue, newValue));
        MapMakerInternalMapTest.assertEquals((int)0, (int)segment.count);
        segment.setTableEntryForTesting(index, entry);
        ++segment.count;
        MapMakerInternalMapTest.assertEquals((int)1, (int)segment.count);
        MapMakerInternalMapTest.assertSame((Object)oldValue, (Object)segment.get(key, hash));
        MapMakerInternalMapTest.assertTrue((boolean)segment.replace(key, hash, oldValue, newValue));
        MapMakerInternalMapTest.assertEquals((int)1, (int)segment.count);
        MapMakerInternalMapTest.assertSame((Object)newValue, (Object)segment.get(key, hash));
        MapMakerInternalMapTest.assertFalse((boolean)segment.replace(key, hash, oldValue, newValue));
        MapMakerInternalMapTest.assertEquals((int)1, (int)segment.count);
        MapMakerInternalMapTest.assertSame((Object)newValue, (Object)segment.get(key, hash));
        segment.setWeakValueReferenceForTesting(entry, oldValueRef);
        oldValueRef.clear();
        MapMakerInternalMapTest.assertFalse((boolean)segment.replace(key, hash, oldValue, newValue));
        MapMakerInternalMapTest.assertEquals((int)0, (int)segment.count);
        MapMakerInternalMapTest.assertNull((Object)segment.get(key, hash));
    }

    public void testSegmentReplace() {
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().concurrencyLevel(1).weakValues());
        MapMakerInternalMap.Segment segment = map.segments[0];
        Object key = new Object();
        int hash = map.hash(key);
        Object oldValue = new Object();
        Object newValue = new Object();
        AtomicReferenceArray table = segment.table;
        int index = hash & table.length() - 1;
        MapMakerInternalMap.InternalEntry entry = segment.newEntryForTesting(key, hash, null);
        MapMakerInternalMap.WeakValueReference oldValueRef = segment.newWeakValueReferenceForTesting(entry, oldValue);
        segment.setWeakValueReferenceForTesting(entry, oldValueRef);
        MapMakerInternalMapTest.assertNull((Object)segment.replace(key, hash, newValue));
        MapMakerInternalMapTest.assertEquals((int)0, (int)segment.count);
        segment.setTableEntryForTesting(index, entry);
        ++segment.count;
        MapMakerInternalMapTest.assertEquals((int)1, (int)segment.count);
        MapMakerInternalMapTest.assertSame((Object)oldValue, (Object)segment.get(key, hash));
        MapMakerInternalMapTest.assertSame((Object)oldValue, (Object)segment.replace(key, hash, newValue));
        MapMakerInternalMapTest.assertEquals((int)1, (int)segment.count);
        MapMakerInternalMapTest.assertSame((Object)newValue, (Object)segment.get(key, hash));
        segment.setWeakValueReferenceForTesting(entry, oldValueRef);
        oldValueRef.clear();
        MapMakerInternalMapTest.assertNull((Object)segment.replace(key, hash, newValue));
        MapMakerInternalMapTest.assertEquals((int)0, (int)segment.count);
        MapMakerInternalMapTest.assertNull((Object)segment.get(key, hash));
    }

    public void testSegmentPut() {
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().concurrencyLevel(1).weakValues());
        MapMakerInternalMap.Segment segment = map.segments[0];
        Object key = new Object();
        int hash = map.hash(key);
        Object oldValue = new Object();
        Object newValue = new Object();
        MapMakerInternalMapTest.assertEquals((int)0, (int)segment.count);
        MapMakerInternalMapTest.assertNull((Object)segment.put(key, hash, oldValue, false));
        MapMakerInternalMapTest.assertEquals((int)1, (int)segment.count);
        MapMakerInternalMapTest.assertSame((Object)oldValue, (Object)segment.put(key, hash, newValue, false));
        MapMakerInternalMapTest.assertEquals((int)1, (int)segment.count);
        MapMakerInternalMapTest.assertSame((Object)newValue, (Object)segment.get(key, hash));
        MapMakerInternalMap.InternalEntry entry = segment.getEntry(key, hash);
        MapMakerInternalMap.WeakValueReference oldValueRef = segment.newWeakValueReferenceForTesting(entry, oldValue);
        segment.setWeakValueReferenceForTesting(entry, oldValueRef);
        MapMakerInternalMapTest.assertSame((Object)oldValue, (Object)segment.get(key, hash));
        oldValueRef.clear();
        MapMakerInternalMapTest.assertNull((Object)segment.put(key, hash, newValue, false));
        MapMakerInternalMapTest.assertEquals((int)1, (int)segment.count);
        MapMakerInternalMapTest.assertSame((Object)newValue, (Object)segment.get(key, hash));
    }

    public void testSegmentPutIfAbsent() {
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().concurrencyLevel(1).weakValues());
        MapMakerInternalMap.Segment segment = map.segments[0];
        Object key = new Object();
        int hash = map.hash(key);
        Object oldValue = new Object();
        Object newValue = new Object();
        MapMakerInternalMapTest.assertEquals((int)0, (int)segment.count);
        MapMakerInternalMapTest.assertNull((Object)segment.put(key, hash, oldValue, true));
        MapMakerInternalMapTest.assertEquals((int)1, (int)segment.count);
        MapMakerInternalMapTest.assertSame((Object)oldValue, (Object)segment.put(key, hash, newValue, true));
        MapMakerInternalMapTest.assertEquals((int)1, (int)segment.count);
        MapMakerInternalMapTest.assertSame((Object)oldValue, (Object)segment.get(key, hash));
        MapMakerInternalMap.InternalEntry entry = segment.getEntry(key, hash);
        MapMakerInternalMap.WeakValueReference oldValueRef = segment.newWeakValueReferenceForTesting(entry, oldValue);
        segment.setWeakValueReferenceForTesting(entry, oldValueRef);
        MapMakerInternalMapTest.assertSame((Object)oldValue, (Object)segment.get(key, hash));
        oldValueRef.clear();
        MapMakerInternalMapTest.assertNull((Object)segment.put(key, hash, newValue, true));
        MapMakerInternalMapTest.assertEquals((int)1, (int)segment.count);
        MapMakerInternalMapTest.assertSame((Object)newValue, (Object)segment.get(key, hash));
    }

    public void testSegmentPut_expand() {
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().concurrencyLevel(1).initialCapacity(1));
        MapMakerInternalMap.Segment segment = map.segments[0];
        MapMakerInternalMapTest.assertEquals((int)1, (int)segment.table.length());
        int count = 1024;
        for (int i = 0; i < count; ++i) {
            Object key = new Object();
            Object value = new Object();
            int hash = map.hash(key);
            MapMakerInternalMapTest.assertNull((Object)segment.put(key, hash, value, false));
            MapMakerInternalMapTest.assertTrue((segment.table.length() > i ? 1 : 0) != 0);
        }
    }

    public void testSegmentRemove() {
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().concurrencyLevel(1).weakValues());
        MapMakerInternalMap.Segment segment = map.segments[0];
        Object key = new Object();
        int hash = map.hash(key);
        Object oldValue = new Object();
        AtomicReferenceArray table = segment.table;
        int index = hash & table.length() - 1;
        MapMakerInternalMap.InternalEntry entry = segment.newEntryForTesting(key, hash, null);
        MapMakerInternalMap.WeakValueReference oldValueRef = segment.newWeakValueReferenceForTesting(entry, oldValue);
        segment.setWeakValueReferenceForTesting(entry, oldValueRef);
        MapMakerInternalMapTest.assertEquals((int)0, (int)segment.count);
        MapMakerInternalMapTest.assertNull((Object)segment.remove(key, hash));
        MapMakerInternalMapTest.assertEquals((int)0, (int)segment.count);
        segment.setTableEntryForTesting(index, entry);
        ++segment.count;
        MapMakerInternalMapTest.assertEquals((int)1, (int)segment.count);
        MapMakerInternalMapTest.assertSame((Object)oldValue, (Object)segment.get(key, hash));
        MapMakerInternalMapTest.assertSame((Object)oldValue, (Object)segment.remove(key, hash));
        MapMakerInternalMapTest.assertEquals((int)0, (int)segment.count);
        MapMakerInternalMapTest.assertNull((Object)segment.get(key, hash));
        segment.setTableEntryForTesting(index, entry);
        ++segment.count;
        MapMakerInternalMapTest.assertEquals((int)1, (int)segment.count);
        MapMakerInternalMapTest.assertSame((Object)oldValue, (Object)segment.get(key, hash));
        oldValueRef.clear();
        MapMakerInternalMapTest.assertNull((Object)segment.remove(key, hash));
        MapMakerInternalMapTest.assertEquals((int)0, (int)segment.count);
        MapMakerInternalMapTest.assertNull((Object)segment.get(key, hash));
    }

    public void testSegmentRemoveValue() {
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().concurrencyLevel(1).weakValues());
        MapMakerInternalMap.Segment segment = map.segments[0];
        Object key = new Object();
        int hash = map.hash(key);
        Object oldValue = new Object();
        Object newValue = new Object();
        AtomicReferenceArray table = segment.table;
        int index = hash & table.length() - 1;
        MapMakerInternalMap.InternalEntry entry = segment.newEntryForTesting(key, hash, null);
        MapMakerInternalMap.WeakValueReference oldValueRef = segment.newWeakValueReferenceForTesting(entry, oldValue);
        segment.setWeakValueReferenceForTesting(entry, oldValueRef);
        MapMakerInternalMapTest.assertEquals((int)0, (int)segment.count);
        MapMakerInternalMapTest.assertNull((Object)segment.remove(key, hash));
        MapMakerInternalMapTest.assertEquals((int)0, (int)segment.count);
        segment.setTableEntryForTesting(index, entry);
        ++segment.count;
        MapMakerInternalMapTest.assertEquals((int)1, (int)segment.count);
        MapMakerInternalMapTest.assertSame((Object)oldValue, (Object)segment.get(key, hash));
        MapMakerInternalMapTest.assertTrue((boolean)segment.remove(key, hash, oldValue));
        MapMakerInternalMapTest.assertEquals((int)0, (int)segment.count);
        MapMakerInternalMapTest.assertNull((Object)segment.get(key, hash));
        segment.setTableEntryForTesting(index, entry);
        ++segment.count;
        MapMakerInternalMapTest.assertEquals((int)1, (int)segment.count);
        MapMakerInternalMapTest.assertSame((Object)oldValue, (Object)segment.get(key, hash));
        MapMakerInternalMapTest.assertFalse((boolean)segment.remove(key, hash, newValue));
        MapMakerInternalMapTest.assertEquals((int)1, (int)segment.count);
        MapMakerInternalMapTest.assertSame((Object)oldValue, (Object)segment.get(key, hash));
        MapMakerInternalMapTest.assertSame((Object)oldValue, (Object)segment.get(key, hash));
        oldValueRef.clear();
        MapMakerInternalMapTest.assertFalse((boolean)segment.remove(key, hash, oldValue));
        MapMakerInternalMapTest.assertEquals((int)0, (int)segment.count);
        MapMakerInternalMapTest.assertNull((Object)segment.get(key, hash));
    }

    public void testExpand() {
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().concurrencyLevel(1).initialCapacity(1));
        MapMakerInternalMap.Segment segment = map.segments[0];
        MapMakerInternalMapTest.assertEquals((int)1, (int)segment.table.length());
        int originalCount = 1024;
        MapMakerInternalMap.InternalEntry entry = null;
        for (int i = 0; i < originalCount; ++i) {
            Object key = new Object();
            Object value = new Object();
            int hash = map.hash(key);
            entry = segment.newEntryForTesting(key, hash, entry);
            segment.setValueForTesting(entry, value);
        }
        segment.setTableEntryForTesting(0, entry);
        segment.count = originalCount;
        ImmutableMap originalMap = ImmutableMap.copyOf(map);
        MapMakerInternalMapTest.assertEquals((int)originalCount, (int)originalMap.size());
        MapMakerInternalMapTest.assertEquals((Object)originalMap, map);
        for (int i = 1; i <= originalCount * 2; i *= 2) {
            if (i > 1) {
                segment.expand();
            }
            MapMakerInternalMapTest.assertEquals((int)i, (int)segment.table.length());
            MapMakerInternalMapTest.assertEquals((int)originalCount, (int)MapMakerInternalMapTest.countLiveEntries(map));
            MapMakerInternalMapTest.assertEquals((int)originalCount, (int)segment.count);
            MapMakerInternalMapTest.assertEquals((Object)originalMap, map);
        }
    }

    public void testRemoveFromChain() {
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().concurrencyLevel(1));
        MapMakerInternalMap.Segment segment = map.segments[0];
        Object keyOne = new Object();
        Object valueOne = new Object();
        int hashOne = map.hash(keyOne);
        MapMakerInternalMap.InternalEntry entryOne = segment.newEntryForTesting(keyOne, hashOne, null);
        segment.setValueForTesting(entryOne, valueOne);
        Object keyTwo = new Object();
        Object valueTwo = new Object();
        int hashTwo = map.hash(keyTwo);
        MapMakerInternalMap.InternalEntry entryTwo = segment.newEntryForTesting(keyTwo, hashTwo, entryOne);
        segment.setValueForTesting(entryTwo, valueTwo);
        Object keyThree = new Object();
        Object valueThree = new Object();
        int hashThree = map.hash(keyThree);
        MapMakerInternalMap.InternalEntry entryThree = segment.newEntryForTesting(keyThree, hashThree, entryTwo);
        segment.setValueForTesting(entryThree, valueThree);
        MapMakerInternalMapTest.assertNull((Object)segment.removeFromChainForTesting(entryOne, entryOne));
        MapMakerInternalMapTest.assertSame((Object)entryOne, (Object)segment.removeFromChainForTesting(entryTwo, entryTwo));
        MapMakerInternalMap.InternalEntry newFirst = segment.removeFromChainForTesting(entryThree, entryTwo);
        MapMakerInternalMapTest.assertSame((Object)keyThree, (Object)newFirst.getKey());
        MapMakerInternalMapTest.assertSame((Object)valueThree, (Object)newFirst.getValue());
        MapMakerInternalMapTest.assertEquals((int)hashThree, (int)newFirst.getHash());
        MapMakerInternalMapTest.assertSame((Object)entryOne, (Object)newFirst.getNext());
        newFirst = segment.removeFromChainForTesting(entryThree, entryOne);
        MapMakerInternalMapTest.assertSame((Object)keyTwo, (Object)newFirst.getKey());
        MapMakerInternalMapTest.assertSame((Object)valueTwo, (Object)newFirst.getValue());
        MapMakerInternalMapTest.assertEquals((int)hashTwo, (int)newFirst.getHash());
        newFirst = newFirst.getNext();
        MapMakerInternalMapTest.assertSame((Object)keyThree, (Object)newFirst.getKey());
        MapMakerInternalMapTest.assertSame((Object)valueThree, (Object)newFirst.getValue());
        MapMakerInternalMapTest.assertEquals((int)hashThree, (int)newFirst.getHash());
        MapMakerInternalMapTest.assertNull((Object)newFirst.getNext());
    }

    public void testExpand_cleanup() {
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().concurrencyLevel(1).initialCapacity(1));
        MapMakerInternalMap.Segment segment = map.segments[0];
        MapMakerInternalMapTest.assertEquals((int)1, (int)segment.table.length());
        int originalCount = 1024;
        MapMakerInternalMap.InternalEntry entry = null;
        for (int i = 0; i < originalCount; ++i) {
            Object key = new Object();
            Object value = i % 3 == 0 ? null : new Object();
            int hash = map.hash(key);
            if (i % 3 == 1) {
                key = null;
            }
            entry = segment.newEntryForTesting(key, hash, entry);
            segment.setValueForTesting(entry, value);
        }
        segment.setTableEntryForTesting(0, entry);
        segment.count = originalCount;
        int liveCount = originalCount / 3;
        MapMakerInternalMapTest.assertEquals((int)1, (int)segment.table.length());
        MapMakerInternalMapTest.assertEquals((int)liveCount, (int)MapMakerInternalMapTest.countLiveEntries(map));
        ImmutableMap originalMap = ImmutableMap.copyOf(map);
        MapMakerInternalMapTest.assertEquals((int)liveCount, (int)originalMap.size());
        for (int i = 1; i <= originalCount * 2; i *= 2) {
            if (i > 1) {
                segment.expand();
            }
            MapMakerInternalMapTest.assertEquals((int)i, (int)segment.table.length());
            MapMakerInternalMapTest.assertEquals((int)liveCount, (int)MapMakerInternalMapTest.countLiveEntries(map));
            MapMakerInternalMapTest.assertTrue((segment.count >= liveCount ? 1 : 0) != 0);
            MapMakerInternalMapTest.assertTrue((segment.count <= originalCount ? 1 : 0) != 0);
            MapMakerInternalMapTest.assertEquals((Object)originalMap, (Object)ImmutableMap.copyOf(map));
        }
    }

    private static <K, V> int countLiveEntries(MapMakerInternalMap<K, V, ?, ?> map) {
        int result = 0;
        for (MapMakerInternalMap.Segment segment : map.segments) {
            AtomicReferenceArray table = segment.table;
            for (int i = 0; i < table.length(); ++i) {
                for (MapMakerInternalMap.InternalEntry e = (MapMakerInternalMap.InternalEntry)table.get(i); e != null; e = e.getNext()) {
                    if (!map.isLiveForTesting(e)) continue;
                    ++result;
                }
            }
        }
        return result;
    }

    public void testClear() {
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().concurrencyLevel(1).initialCapacity(1));
        MapMakerInternalMap.Segment segment = map.segments[0];
        AtomicReferenceArray table = segment.table;
        MapMakerInternalMapTest.assertEquals((int)1, (int)table.length());
        Object key = new Object();
        Object value = new Object();
        int hash = map.hash(key);
        MapMakerInternalMap.InternalEntry entry = segment.newEntryForTesting(key, hash, null);
        segment.setValueForTesting(entry, value);
        segment.setTableEntryForTesting(0, entry);
        segment.readCount.incrementAndGet();
        segment.count = 1;
        MapMakerInternalMapTest.assertSame((Object)entry, table.get(0));
        segment.clear();
        MapMakerInternalMapTest.assertNull(table.get(0));
        MapMakerInternalMapTest.assertEquals((int)0, (int)segment.readCount.get());
        MapMakerInternalMapTest.assertEquals((int)0, (int)segment.count);
    }

    public void testRemoveEntry() {
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().concurrencyLevel(1).initialCapacity(1));
        MapMakerInternalMap.Segment segment = map.segments[0];
        AtomicReferenceArray table = segment.table;
        MapMakerInternalMapTest.assertEquals((int)1, (int)table.length());
        Object key = new Object();
        Object value = new Object();
        int hash = map.hash(key);
        MapMakerInternalMap.InternalEntry entry = segment.newEntryForTesting(key, hash, null);
        segment.setValueForTesting(entry, value);
        MapMakerInternalMapTest.assertFalse((boolean)segment.removeTableEntryForTesting(entry));
        segment.setTableEntryForTesting(0, entry);
        segment.count = 1;
        MapMakerInternalMapTest.assertTrue((boolean)segment.removeTableEntryForTesting(entry));
        MapMakerInternalMapTest.assertEquals((int)0, (int)segment.count);
        MapMakerInternalMapTest.assertNull(table.get(0));
    }

    public void testClearValue() {
        MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker().concurrencyLevel(1).initialCapacity(1).weakValues());
        MapMakerInternalMap.Segment segment = map.segments[0];
        AtomicReferenceArray table = segment.table;
        MapMakerInternalMapTest.assertEquals((int)1, (int)table.length());
        Object key = new Object();
        Object value = new Object();
        int hash = map.hash(key);
        MapMakerInternalMap.InternalEntry entry = segment.newEntryForTesting(key, hash, null);
        segment.setValueForTesting(entry, value);
        MapMakerInternalMap.WeakValueReference valueRef = segment.getWeakValueReferenceForTesting(entry);
        MapMakerInternalMapTest.assertFalse((boolean)segment.clearValueForTesting(key, hash, valueRef));
        segment.setTableEntryForTesting(0, entry);
        MapMakerInternalMapTest.assertTrue((boolean)segment.clearValueForTesting(key, hash, valueRef));
        MapMakerInternalMapTest.assertEquals((int)0, (int)segment.count);
        MapMakerInternalMapTest.assertNull(table.get(0));
        segment.setTableEntryForTesting(0, entry);
        MapMakerInternalMap.WeakValueReference otherValueRef = segment.newWeakValueReferenceForTesting(entry, value);
        segment.setWeakValueReferenceForTesting(entry, otherValueRef);
        MapMakerInternalMapTest.assertFalse((boolean)segment.clearValueForTesting(key, hash, valueRef));
        segment.setWeakValueReferenceForTesting(entry, valueRef);
        MapMakerInternalMapTest.assertTrue((boolean)segment.clearValueForTesting(key, hash, valueRef));
    }

    public void testDrainKeyReferenceQueueOnWrite() {
        for (MapMaker maker : MapMakerInternalMapTest.allWeakKeyStrengthMakers()) {
            MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(maker.concurrencyLevel(1));
            if (maker.getKeyStrength() != MapMakerInternalMap.Strength.WEAK) continue;
            MapMakerInternalMap.Segment segment = map.segments[0];
            Object keyOne = new Object();
            int hashOne = map.hash(keyOne);
            Object valueOne = new Object();
            Object keyTwo = new Object();
            Object valueTwo = new Object();
            map.put(keyOne, valueOne);
            MapMakerInternalMap.InternalEntry entry = segment.getEntry(keyOne, hashOne);
            Reference reference = (Reference)entry;
            reference.enqueue();
            map.put(keyTwo, valueTwo);
            MapMakerInternalMapTest.assertFalse((boolean)map.containsKey(keyOne));
            MapMakerInternalMapTest.assertFalse((boolean)map.containsValue(valueOne));
            MapMakerInternalMapTest.assertNull((Object)map.get(keyOne));
            MapMakerInternalMapTest.assertEquals((int)1, (int)map.size());
            MapMakerInternalMapTest.assertNull(segment.getKeyReferenceQueueForTesting().poll());
        }
    }

    public void testDrainValueReferenceQueueOnWrite() {
        for (MapMaker maker : MapMakerInternalMapTest.allWeakValueStrengthMakers()) {
            MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(maker.concurrencyLevel(1));
            if (maker.getValueStrength() != MapMakerInternalMap.Strength.WEAK) continue;
            MapMakerInternalMap.Segment segment = map.segments[0];
            Object keyOne = new Object();
            int hashOne = map.hash(keyOne);
            Object valueOne = new Object();
            Object keyTwo = new Object();
            Object valueTwo = new Object();
            map.put(keyOne, valueOne);
            MapMakerInternalMap.WeakValueEntry entry = (MapMakerInternalMap.WeakValueEntry)segment.getEntry(keyOne, hashOne);
            MapMakerInternalMap.WeakValueReference valueReference = entry.getValueReference();
            Reference reference = (Reference)valueReference;
            reference.enqueue();
            map.put(keyTwo, valueTwo);
            MapMakerInternalMapTest.assertFalse((boolean)map.containsKey(keyOne));
            MapMakerInternalMapTest.assertFalse((boolean)map.containsValue(valueOne));
            MapMakerInternalMapTest.assertNull((Object)map.get(keyOne));
            MapMakerInternalMapTest.assertEquals((int)1, (int)map.size());
            MapMakerInternalMapTest.assertNull(segment.getValueReferenceQueueForTesting().poll());
        }
    }

    public void testDrainKeyReferenceQueueOnRead() {
        for (MapMaker maker : MapMakerInternalMapTest.allWeakKeyStrengthMakers()) {
            MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(maker.concurrencyLevel(1));
            if (maker.getKeyStrength() != MapMakerInternalMap.Strength.WEAK) continue;
            MapMakerInternalMap.Segment segment = map.segments[0];
            Object keyOne = new Object();
            int hashOne = map.hash(keyOne);
            Object valueOne = new Object();
            Object keyTwo = new Object();
            map.put(keyOne, valueOne);
            MapMakerInternalMap.InternalEntry entry = segment.getEntry(keyOne, hashOne);
            Reference reference = (Reference)entry;
            reference.enqueue();
            for (int i = 0; i < 315; ++i) {
                Object unused = map.get(keyTwo);
            }
            MapMakerInternalMapTest.assertFalse((boolean)map.containsKey(keyOne));
            MapMakerInternalMapTest.assertFalse((boolean)map.containsValue(valueOne));
            MapMakerInternalMapTest.assertNull((Object)map.get(keyOne));
            MapMakerInternalMapTest.assertEquals((int)0, (int)map.size());
            MapMakerInternalMapTest.assertNull(segment.getKeyReferenceQueueForTesting().poll());
        }
    }

    public void testDrainValueReferenceQueueOnRead() {
        for (MapMaker maker : MapMakerInternalMapTest.allWeakValueStrengthMakers()) {
            MapMakerInternalMap map = MapMakerInternalMapTest.makeMap(maker.concurrencyLevel(1));
            if (maker.getValueStrength() != MapMakerInternalMap.Strength.WEAK) continue;
            MapMakerInternalMap.Segment segment = map.segments[0];
            Object keyOne = new Object();
            int hashOne = map.hash(keyOne);
            Object valueOne = new Object();
            Object keyTwo = new Object();
            map.put(keyOne, valueOne);
            MapMakerInternalMap.WeakValueEntry entry = (MapMakerInternalMap.WeakValueEntry)segment.getEntry(keyOne, hashOne);
            MapMakerInternalMap.WeakValueReference valueReference = entry.getValueReference();
            Reference reference = (Reference)valueReference;
            reference.enqueue();
            for (int i = 0; i < 315; ++i) {
                Object unused = map.get(keyTwo);
            }
            MapMakerInternalMapTest.assertFalse((boolean)map.containsKey(keyOne));
            MapMakerInternalMapTest.assertFalse((boolean)map.containsValue(valueOne));
            MapMakerInternalMapTest.assertNull((Object)map.get(keyOne));
            MapMakerInternalMapTest.assertEquals((int)0, (int)map.size());
            MapMakerInternalMapTest.assertNull(segment.getValueReferenceQueueForTesting().poll());
        }
    }

    private static Iterable<MapMaker> allWeakKeyStrengthMakers() {
        return ImmutableList.of((Object)MapMakerInternalMapTest.createMapMaker().weakKeys(), (Object)MapMakerInternalMapTest.createMapMaker().weakKeys().weakValues());
    }

    private static Iterable<MapMaker> allWeakValueStrengthMakers() {
        return ImmutableList.of((Object)MapMakerInternalMapTest.createMapMaker().weakValues(), (Object)MapMakerInternalMapTest.createMapMaker().weakKeys().weakValues());
    }

    public void testNullParameters() throws Exception {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicInstanceMethods(MapMakerInternalMapTest.makeMap(MapMakerInternalMapTest.createMapMaker()));
    }
}

