/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.TreeMultimap;
import com.google.common.collect.testing.AbstractIteratorTester;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.IteratorFeature;
import com.google.common.collect.testing.IteratorTester;
import com.google.common.collect.testing.google.UnmodifiableCollectionTests;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.Truth;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nullable;
import junit.framework.Assert;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class MultimapsTest
extends TestCase {
    private static final Comparator<Integer> INT_COMPARATOR = Ordering.natural().reverse().nullsFirst();

    public void testUnmodifiableListMultimapShortCircuit() {
        ArrayListMultimap mod = ArrayListMultimap.create();
        ListMultimap unmod = Multimaps.unmodifiableListMultimap((ListMultimap)mod);
        MultimapsTest.assertNotSame((Object)mod, (Object)unmod);
        MultimapsTest.assertSame((Object)unmod, (Object)Multimaps.unmodifiableListMultimap((ListMultimap)unmod));
        ImmutableListMultimap immutable = ImmutableListMultimap.of((Object)"a", (Object)1, (Object)"b", (Object)2, (Object)"a", (Object)3);
        MultimapsTest.assertSame((Object)immutable, (Object)Multimaps.unmodifiableListMultimap((ImmutableListMultimap)immutable));
        MultimapsTest.assertSame((Object)immutable, (Object)Multimaps.unmodifiableListMultimap((ListMultimap)immutable));
    }

    public void testUnmodifiableSetMultimapShortCircuit() {
        HashMultimap mod = HashMultimap.create();
        SetMultimap unmod = Multimaps.unmodifiableSetMultimap((SetMultimap)mod);
        MultimapsTest.assertNotSame((Object)mod, (Object)unmod);
        MultimapsTest.assertSame((Object)unmod, (Object)Multimaps.unmodifiableSetMultimap((SetMultimap)unmod));
        ImmutableSetMultimap immutable = ImmutableSetMultimap.of((Object)"a", (Object)1, (Object)"b", (Object)2, (Object)"a", (Object)3);
        MultimapsTest.assertSame((Object)immutable, (Object)Multimaps.unmodifiableSetMultimap((ImmutableSetMultimap)immutable));
        MultimapsTest.assertSame((Object)immutable, (Object)Multimaps.unmodifiableSetMultimap((SetMultimap)immutable));
    }

    public void testUnmodifiableMultimapShortCircuit() {
        HashMultimap mod = HashMultimap.create();
        Multimap unmod = Multimaps.unmodifiableMultimap((Multimap)mod);
        MultimapsTest.assertNotSame((Object)mod, (Object)unmod);
        MultimapsTest.assertSame((Object)unmod, (Object)Multimaps.unmodifiableMultimap((Multimap)unmod));
        ImmutableMultimap immutable = ImmutableMultimap.of((Object)"a", (Object)1, (Object)"b", (Object)2, (Object)"a", (Object)3);
        MultimapsTest.assertSame((Object)immutable, (Object)Multimaps.unmodifiableMultimap((ImmutableMultimap)immutable));
        MultimapsTest.assertSame((Object)immutable, (Object)Multimaps.unmodifiableMultimap((Multimap)immutable));
    }

    @GwtIncompatible
    public void testUnmodifiableArrayListMultimap() {
        MultimapsTest.checkUnmodifiableMultimap((Multimap<String, Integer>)ArrayListMultimap.create(), true);
    }

    @GwtIncompatible
    public void testSerializingUnmodifiableArrayListMultimap() {
        Multimap<String, Integer> unmodifiable = MultimapsTest.prepareUnmodifiableTests((Multimap<String, Integer>)ArrayListMultimap.create(), true, null, null);
        SerializableTester.reserializeAndAssert(unmodifiable);
    }

    public void testUnmodifiableArrayListMultimapRandomAccess() {
        ArrayListMultimap delegate = ArrayListMultimap.create();
        delegate.put((Object)"foo", (Object)1);
        delegate.put((Object)"foo", (Object)3);
        ListMultimap multimap = Multimaps.unmodifiableListMultimap((ListMultimap)delegate);
        MultimapsTest.assertTrue((boolean)(multimap.get((Object)"foo") instanceof RandomAccess));
        MultimapsTest.assertTrue((boolean)(multimap.get((Object)"bar") instanceof RandomAccess));
    }

    public void testUnmodifiableLinkedListMultimapRandomAccess() {
        LinkedListMultimap delegate = LinkedListMultimap.create();
        delegate.put((Object)"foo", (Object)1);
        delegate.put((Object)"foo", (Object)3);
        ListMultimap multimap = Multimaps.unmodifiableListMultimap((ListMultimap)delegate);
        Truth.assertThat((Iterable)multimap.get((Object)"foo")).isNotInstanceOf(RandomAccess.class);
        Truth.assertThat((Iterable)multimap.get((Object)"bar")).isNotInstanceOf(RandomAccess.class);
    }

    @GwtIncompatible
    public void testUnmodifiableHashMultimap() {
        MultimapsTest.checkUnmodifiableMultimap((Multimap<String, Integer>)HashMultimap.create(), false);
    }

    @GwtIncompatible
    public void testSerializingUnmodifiableHashMultimap() {
        Multimap<String, Integer> unmodifiable = MultimapsTest.prepareUnmodifiableTests((Multimap<String, Integer>)HashMultimap.create(), false, null, null);
        SerializableTester.reserializeAndAssert(unmodifiable);
    }

    @GwtIncompatible
    public void testUnmodifiableTreeMultimap() {
        MultimapsTest.checkUnmodifiableMultimap((Multimap<String, Integer>)TreeMultimap.create(), false, "null", 42);
    }

    @GwtIncompatible
    public void testSerializingUnmodifiableTreeMultimap() {
        Multimap<String, Integer> unmodifiable = MultimapsTest.prepareUnmodifiableTests((Multimap<String, Integer>)TreeMultimap.create(), false, "null", 42);
        SerializableTester.reserializeAndAssert(unmodifiable);
    }

    @GwtIncompatible
    public void testUnmodifiableSynchronizedArrayListMultimap() {
        MultimapsTest.checkUnmodifiableMultimap((Multimap<String, Integer>)Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create()), true);
    }

    @GwtIncompatible
    public void testSerializingUnmodifiableSynchronizedArrayListMultimap() {
        Multimap<String, Integer> unmodifiable = MultimapsTest.prepareUnmodifiableTests((Multimap<String, Integer>)Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create()), true, null, null);
        SerializableTester.reserializeAndAssert(unmodifiable);
    }

    @GwtIncompatible
    public void testUnmodifiableSynchronizedHashMultimap() {
        MultimapsTest.checkUnmodifiableMultimap((Multimap<String, Integer>)Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create()), false);
    }

    @GwtIncompatible
    public void testSerializingUnmodifiableSynchronizedHashMultimap() {
        Multimap<String, Integer> unmodifiable = MultimapsTest.prepareUnmodifiableTests((Multimap<String, Integer>)Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create()), false, null, null);
        SerializableTester.reserializeAndAssert(unmodifiable);
    }

    @GwtIncompatible
    public void testUnmodifiableSynchronizedTreeMultimap() {
        TreeMultimap delegate = TreeMultimap.create((Comparator)Ordering.natural(), INT_COMPARATOR);
        SortedSetMultimap multimap = Multimaps.synchronizedSortedSetMultimap((SortedSetMultimap)delegate);
        MultimapsTest.checkUnmodifiableMultimap((Multimap<String, Integer>)multimap, false, "null", 42);
        MultimapsTest.assertSame(INT_COMPARATOR, (Object)multimap.valueComparator());
    }

    @GwtIncompatible
    public void testSerializingUnmodifiableSynchronizedTreeMultimap() {
        TreeMultimap delegate = TreeMultimap.create((Comparator)Ordering.natural(), INT_COMPARATOR);
        SortedSetMultimap multimap = Multimaps.synchronizedSortedSetMultimap((SortedSetMultimap)delegate);
        Multimap<String, Integer> unmodifiable = MultimapsTest.prepareUnmodifiableTests((Multimap<String, Integer>)multimap, false, "null", 42);
        SerializableTester.reserializeAndAssert(unmodifiable);
        MultimapsTest.assertSame(INT_COMPARATOR, (Object)multimap.valueComparator());
    }

    public void testUnmodifiableMultimapIsView() {
        HashMultimap mod = HashMultimap.create();
        Multimap unmod = Multimaps.unmodifiableMultimap((Multimap)mod);
        MultimapsTest.assertEquals((Object)mod, (Object)unmod);
        mod.put((Object)"foo", (Object)1);
        MultimapsTest.assertTrue((boolean)unmod.containsEntry((Object)"foo", (Object)1));
        MultimapsTest.assertEquals((Object)mod, (Object)unmod);
    }

    public void testUnmodifiableMultimapEntries() {
        HashMultimap mod = HashMultimap.create();
        Multimap unmod = Multimaps.unmodifiableMultimap((Multimap)mod);
        mod.put((Object)"foo", (Object)1);
        Map.Entry entry = (Map.Entry)unmod.entries().iterator().next();
        try {
            entry.setValue(2);
            MultimapsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        entry = (Map.Entry)unmod.entries().toArray()[0];
        try {
            entry.setValue(2);
            MultimapsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        Map.Entry[] array = new Map.Entry[2];
        MultimapsTest.assertSame((Object)array, (Object)unmod.entries().toArray(array));
        try {
            array[0].setValue(2);
            MultimapsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        MultimapsTest.assertFalse((boolean)unmod.entries().contains(Helpers.nefariousMapEntry((Object)"pwnd", (Object)2)));
        MultimapsTest.assertFalse((boolean)unmod.keys().contains((Object)"pwnd"));
    }

    private static void checkUnmodifiableMultimap(Multimap<String, Integer> multimap, boolean permitsDuplicates) {
        MultimapsTest.checkUnmodifiableMultimap(multimap, permitsDuplicates, null, null);
    }

    private static void checkUnmodifiableMultimap(Multimap<String, Integer> multimap, boolean permitsDuplicates, @Nullable String nullKey, @Nullable Integer nullValue) {
        Multimap<String, Integer> unmodifiable = MultimapsTest.prepareUnmodifiableTests(multimap, permitsDuplicates, nullKey, nullValue);
        UnmodifiableCollectionTests.assertMultimapIsUnmodifiable(unmodifiable, (Object)"test", (Object)123);
        MultimapsTest.assertUnmodifiableIterableInTandem(unmodifiable.keys(), multimap.keys());
        MultimapsTest.assertUnmodifiableIterableInTandem(unmodifiable.keySet(), multimap.keySet());
        MultimapsTest.assertUnmodifiableIterableInTandem(unmodifiable.entries(), multimap.entries());
        MultimapsTest.assertUnmodifiableIterableInTandem(unmodifiable.asMap().entrySet(), multimap.asMap().entrySet());
        MultimapsTest.assertEquals((String)multimap.toString(), (String)unmodifiable.toString());
        MultimapsTest.assertEquals((int)multimap.hashCode(), (int)unmodifiable.hashCode());
        MultimapsTest.assertEquals(multimap, unmodifiable);
        Truth.assertThat((Iterable)((Iterable)unmodifiable.asMap().get("bar"))).containsExactly(new Object[]{5, -1});
        MultimapsTest.assertNull(unmodifiable.asMap().get("missing"));
        Truth.assertThat((Iterable)unmodifiable.entries()).isNotInstanceOf(Serializable.class);
    }

    private static Multimap<String, Integer> prepareUnmodifiableTests(Multimap<String, Integer> multimap, boolean permitsDuplicates, @Nullable String nullKey, @Nullable Integer nullValue) {
        multimap.clear();
        multimap.put((Object)"foo", (Object)1);
        multimap.put((Object)"foo", (Object)2);
        multimap.put((Object)"foo", (Object)3);
        multimap.put((Object)"bar", (Object)5);
        multimap.put((Object)"bar", (Object)-1);
        multimap.put((Object)nullKey, (Object)nullValue);
        multimap.put((Object)"foo", (Object)nullValue);
        multimap.put((Object)nullKey, (Object)5);
        multimap.put((Object)"foo", (Object)2);
        if (permitsDuplicates) {
            MultimapsTest.assertEquals((int)9, (int)multimap.size());
        } else {
            MultimapsTest.assertEquals((int)8, (int)multimap.size());
        }
        Object unmodifiable = multimap instanceof SortedSetMultimap ? Multimaps.unmodifiableSortedSetMultimap((SortedSetMultimap)((SortedSetMultimap)multimap)) : (multimap instanceof SetMultimap ? Multimaps.unmodifiableSetMultimap((SetMultimap)((SetMultimap)multimap)) : (multimap instanceof ListMultimap ? Multimaps.unmodifiableListMultimap((ListMultimap)((ListMultimap)multimap)) : Multimaps.unmodifiableMultimap(multimap)));
        return unmodifiable;
    }

    private static <T> void assertUnmodifiableIterableInTandem(Iterable<T> unmodifiable, Iterable<T> modifiable) {
        UnmodifiableCollectionTests.assertIteratorIsUnmodifiable(unmodifiable.iterator());
        UnmodifiableCollectionTests.assertIteratorsInOrder(unmodifiable.iterator(), modifiable.iterator());
    }

    public void testInvertFrom() {
        ImmutableMultimap empty = ImmutableMultimap.of();
        Multimap multimap = Multimaps.invertFrom((Multimap)empty, (Multimap)ArrayListMultimap.create());
        MultimapsTest.assertTrue((boolean)multimap.isEmpty());
        ImmutableMultimap single = new ImmutableMultimap.Builder().put((Object)1, (Object)"one").put((Object)2, (Object)"two").build();
        MultimapsTest.assertSame((Object)multimap, (Object)Multimaps.invertFrom((Multimap)single, (Multimap)multimap));
        ImmutableMultimap expected = new ImmutableMultimap.Builder().put((Object)"one", (Object)1).put((Object)"two", (Object)2).build();
        MultimapsTest.assertEquals((Object)expected, (Object)multimap);
    }

    public void testAsMap_multimap() {
        Multimap multimap = Multimaps.newMultimap(new HashMap(), (Supplier)new QueueSupplier());
        Map map = Multimaps.asMap((Multimap)multimap);
        MultimapsTest.assertSame((Object)multimap.asMap(), (Object)map);
    }

    public void testAsMap_listMultimap() {
        ArrayListMultimap listMultimap = ArrayListMultimap.create();
        Map map = Multimaps.asMap((ListMultimap)listMultimap);
        MultimapsTest.assertSame((Object)listMultimap.asMap(), (Object)map);
    }

    public void testAsMap_setMultimap() {
        LinkedHashMultimap setMultimap = LinkedHashMultimap.create();
        Map map = Multimaps.asMap((SetMultimap)setMultimap);
        MultimapsTest.assertSame((Object)setMultimap.asMap(), (Object)map);
    }

    public void testAsMap_sortedSetMultimap() {
        TreeMultimap sortedSetMultimap = TreeMultimap.create();
        Map map = Multimaps.asMap((SortedSetMultimap)sortedSetMultimap);
        MultimapsTest.assertSame((Object)sortedSetMultimap.asMap(), (Object)map);
    }

    public void testForMap() {
        HashMap map = Maps.newHashMap();
        map.put("foo", 1);
        map.put("bar", 2);
        HashMultimap multimap = HashMultimap.create();
        multimap.put((Object)"foo", (Object)1);
        multimap.put((Object)"bar", (Object)2);
        SetMultimap multimapView = Multimaps.forMap((Map)map);
        new EqualsTester().addEqualityGroup(new Object[]{multimap, multimapView}).addEqualityGroup(new Object[]{map}).testEquals();
        HashMultimap multimap2 = HashMultimap.create();
        multimap2.put((Object)"foo", (Object)1);
        MultimapsTest.assertFalse((boolean)multimapView.equals((Object)multimap2));
        multimap2.put((Object)"bar", (Object)1);
        MultimapsTest.assertFalse((boolean)multimapView.equals((Object)multimap2));
        ImmutableListMultimap listMultimap = new ImmutableListMultimap.Builder().put((Object)"foo", (Object)1).put((Object)"bar", (Object)2).build();
        MultimapsTest.assertFalse((String)"SetMultimap equals ListMultimap", (boolean)multimapView.equals((Object)listMultimap));
        MultimapsTest.assertEquals((String)multimap.toString(), (String)multimapView.toString());
        MultimapsTest.assertEquals((int)multimap.hashCode(), (int)multimapView.hashCode());
        MultimapsTest.assertEquals((int)multimap.size(), (int)multimapView.size());
        MultimapsTest.assertTrue((boolean)multimapView.containsKey((Object)"foo"));
        MultimapsTest.assertTrue((boolean)multimapView.containsValue((Object)1));
        MultimapsTest.assertTrue((boolean)multimapView.containsEntry((Object)"bar", (Object)2));
        MultimapsTest.assertEquals(Collections.singleton(1), (Object)multimapView.get((Object)"foo"));
        MultimapsTest.assertEquals(Collections.singleton(2), (Object)multimapView.get((Object)"bar"));
        try {
            multimapView.put((Object)"baz", (Object)3);
            MultimapsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        try {
            multimapView.putAll((Object)"baz", Collections.singleton(3));
            MultimapsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        try {
            multimapView.putAll((Multimap)multimap);
            MultimapsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        try {
            multimapView.replaceValues((Object)"foo", Collections.emptySet());
            MultimapsTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException expected) {
            // empty catch block
        }
        multimapView.remove((Object)"bar", (Object)2);
        MultimapsTest.assertFalse((boolean)multimapView.containsKey((Object)"bar"));
        MultimapsTest.assertFalse((boolean)map.containsKey("bar"));
        MultimapsTest.assertEquals(map.keySet(), (Object)multimapView.keySet());
        MultimapsTest.assertEquals(map.keySet(), (Object)multimapView.keys().elementSet());
        Truth.assertThat((Multiset)multimapView.keys()).contains((Object)"foo");
        Truth.assertThat((Iterable)multimapView.values()).contains((Object)1);
        Truth.assertThat((Iterable)multimapView.entries()).contains((Object)Maps.immutableEntry((Object)"foo", (Object)1));
        Truth.assertThat(multimapView.asMap().entrySet()).contains((Object)Maps.immutableEntry((Object)"foo", Collections.singleton(1)));
        multimapView.clear();
        MultimapsTest.assertFalse((boolean)multimapView.containsKey((Object)"foo"));
        MultimapsTest.assertFalse((boolean)map.containsKey("foo"));
        MultimapsTest.assertTrue((boolean)map.isEmpty());
        MultimapsTest.assertTrue((boolean)multimapView.isEmpty());
        multimap.clear();
        MultimapsTest.assertEquals((String)multimap.toString(), (String)multimapView.toString());
        MultimapsTest.assertEquals((int)multimap.hashCode(), (int)multimapView.hashCode());
        MultimapsTest.assertEquals((int)multimap.size(), (int)multimapView.size());
        MultimapsTest.assertEquals((Object)multimapView, (Object)ArrayListMultimap.create());
    }

    @GwtIncompatible
    public void testForMapSerialization() {
        HashMap map = Maps.newHashMap();
        map.put("foo", 1);
        map.put("bar", 2);
        SetMultimap multimapView = Multimaps.forMap((Map)map);
        SerializableTester.reserializeAndAssert((Object)multimapView);
    }

    public void testForMapRemoveAll() {
        HashMap map = Maps.newHashMap();
        map.put("foo", 1);
        map.put("bar", 2);
        map.put("cow", 3);
        SetMultimap multimap = Multimaps.forMap((Map)map);
        MultimapsTest.assertEquals((int)3, (int)multimap.size());
        MultimapsTest.assertEquals(Collections.emptySet(), (Object)multimap.removeAll((Object)"dog"));
        MultimapsTest.assertEquals((int)3, (int)multimap.size());
        MultimapsTest.assertTrue((boolean)multimap.containsKey((Object)"bar"));
        MultimapsTest.assertEquals(Collections.singleton(2), (Object)multimap.removeAll((Object)"bar"));
        MultimapsTest.assertEquals((int)2, (int)multimap.size());
        MultimapsTest.assertFalse((boolean)multimap.containsKey((Object)"bar"));
    }

    public void testForMapAsMap() {
        HashMap map = Maps.newHashMap();
        map.put("foo", 1);
        map.put("bar", 2);
        Map asMap = Multimaps.forMap((Map)map).asMap();
        MultimapsTest.assertEquals(Collections.singleton(1), asMap.get("foo"));
        MultimapsTest.assertNull(asMap.get("cow"));
        MultimapsTest.assertTrue((boolean)asMap.containsKey("foo"));
        MultimapsTest.assertFalse((boolean)asMap.containsKey("cow"));
        Set entries = asMap.entrySet();
        MultimapsTest.assertFalse((boolean)entries.contains(4.5));
        MultimapsTest.assertFalse((boolean)entries.remove(4.5));
        MultimapsTest.assertFalse((boolean)entries.contains(Maps.immutableEntry((Object)"foo", Collections.singletonList(1))));
        MultimapsTest.assertFalse((boolean)entries.remove(Maps.immutableEntry((Object)"foo", Collections.singletonList(1))));
        MultimapsTest.assertFalse((boolean)entries.contains(Maps.immutableEntry((Object)"foo", (Object)Sets.newLinkedHashSet(Arrays.asList(1, 2)))));
        MultimapsTest.assertFalse((boolean)entries.remove(Maps.immutableEntry((Object)"foo", (Object)Sets.newLinkedHashSet(Arrays.asList(1, 2)))));
        MultimapsTest.assertFalse((boolean)entries.contains(Maps.immutableEntry((Object)"foo", Collections.singleton(2))));
        MultimapsTest.assertFalse((boolean)entries.remove(Maps.immutableEntry((Object)"foo", Collections.singleton(2))));
        MultimapsTest.assertTrue((boolean)map.containsKey("foo"));
        MultimapsTest.assertTrue((boolean)entries.contains(Maps.immutableEntry((Object)"foo", Collections.singleton(1))));
        MultimapsTest.assertTrue((boolean)entries.remove(Maps.immutableEntry((Object)"foo", Collections.singleton(1))));
        MultimapsTest.assertFalse((boolean)map.containsKey("foo"));
    }

    public void testForMapGetIteration() {
        IteratorTester<Integer> tester = new IteratorTester<Integer>(4, (Iterable)IteratorFeature.MODIFIABLE, (Iterable)Sets.newHashSet((Object[])new Integer[]{1}), AbstractIteratorTester.KnownOrder.KNOWN_ORDER){
            private Multimap<String, Integer> multimap;

            protected Iterator<Integer> newTargetIterator() {
                HashMap map = Maps.newHashMap();
                map.put("foo", 1);
                map.put("bar", 2);
                this.multimap = Multimaps.forMap((Map)map);
                return this.multimap.get((Object)"foo").iterator();
            }

            protected void verify(List<Integer> elements) {
                Assert.assertEquals((Object)Sets.newHashSet(elements), (Object)this.multimap.get((Object)"foo"));
            }
        };
        tester.test();
    }

    public void testNewMultimapWithCollectionRejectingNegativeElements() {
        SetSupplier factory = new SetSupplier(){

            @Override
            public Set<Integer> getImpl() {
                Object backing = super.getImpl();
                return new ForwardingSet<Integer>((Set)backing){
                    final /* synthetic */ Set val$backing;
                    {
                        this.val$backing = set;
                    }

                    protected Set<Integer> delegate() {
                        return this.val$backing;
                    }

                    public boolean add(Integer element) {
                        Preconditions.checkArgument((element >= 0 ? 1 : 0) != 0);
                        return super.add((Object)element);
                    }

                    public boolean addAll(Collection<? extends Integer> collection) {
                        return this.standardAddAll(collection);
                    }
                };
            }
        };
        EnumMap map = Maps.newEnumMap(Color.class);
        Multimap multimap = Multimaps.newMultimap((Map)map, (Supplier)factory);
        try {
            multimap.put((Object)Color.BLUE, (Object)-1);
            MultimapsTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        multimap.put((Object)Color.RED, (Object)1);
        multimap.put((Object)Color.BLUE, (Object)2);
        try {
            multimap.put((Object)Color.GREEN, (Object)-1);
            MultimapsTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        Truth.assertThat((Iterable)multimap.entries()).containsExactly(new Object[]{Maps.immutableEntry((Object)((Object)Color.RED), (Object)1), Maps.immutableEntry((Object)((Object)Color.BLUE), (Object)2)});
    }

    public void testNewMultimap() {
        QueueSupplier factory = new QueueSupplier();
        EnumMap map = Maps.newEnumMap(Color.class);
        Multimap multimap = Multimaps.newMultimap((Map)map, (Supplier)factory);
        MultimapsTest.assertEquals((int)0, (int)factory.count);
        multimap.putAll((Object)Color.BLUE, Arrays.asList(3, 1, 4));
        MultimapsTest.assertEquals((int)1, (int)factory.count);
        multimap.putAll((Object)Color.RED, Arrays.asList(2, 7, 1, 8));
        MultimapsTest.assertEquals((int)2, (int)factory.count);
        MultimapsTest.assertEquals((String)"[3, 1, 4]", (String)multimap.get((Object)Color.BLUE).toString());
        Multimap ummodifiable = Multimaps.unmodifiableMultimap((Multimap)multimap);
        MultimapsTest.assertEquals((String)"[3, 1, 4]", (String)ummodifiable.get((Object)Color.BLUE).toString());
        Collection collection = multimap.get((Object)Color.BLUE);
        MultimapsTest.assertEquals((Object)collection, (Object)collection);
        Truth.assertThat((Iterable)multimap.keySet()).isNotInstanceOf(SortedSet.class);
        Truth.assertThat((Map)multimap.asMap()).isNotInstanceOf(SortedMap.class);
    }

    @GwtIncompatible
    public void testNewMultimapSerialization() {
        QueueSupplier factory = new QueueSupplier();
        EnumMap map = Maps.newEnumMap(Color.class);
        Multimap multimap = Multimaps.newMultimap((Map)map, (Supplier)factory);
        multimap.putAll((Object)Color.BLUE, Arrays.asList(3, 1, 4));
        multimap.putAll((Object)Color.RED, Arrays.asList(2, 7, 1, 8));
        SerializableTester.reserializeAndAssert((Object)multimap);
    }

    public void testNewListMultimap() {
        ListSupplier factory = new ListSupplier();
        TreeMap map = Maps.newTreeMap();
        ListMultimap multimap = Multimaps.newListMultimap((Map)map, (Supplier)factory);
        MultimapsTest.assertEquals((int)0, (int)factory.count);
        multimap.putAll((Object)Color.BLUE, Arrays.asList(3, 1, 4, 1));
        MultimapsTest.assertEquals((int)1, (int)factory.count);
        multimap.putAll((Object)Color.RED, Arrays.asList(2, 7, 1, 8));
        MultimapsTest.assertEquals((int)2, (int)factory.count);
        MultimapsTest.assertEquals((String)"{BLUE=[3, 1, 4, 1], RED=[2, 7, 1, 8]}", (String)multimap.toString());
        Truth.assertThat((Iterable)multimap.get((Object)Color.BLUE)).isNotInstanceOf(RandomAccess.class);
        MultimapsTest.assertTrue((boolean)(multimap.keySet() instanceof SortedSet));
        MultimapsTest.assertTrue((boolean)(multimap.asMap() instanceof SortedMap));
    }

    @GwtIncompatible
    public void testNewListMultimapSerialization() {
        ListSupplier factory = new ListSupplier();
        TreeMap map = Maps.newTreeMap();
        ListMultimap multimap = Multimaps.newListMultimap((Map)map, (Supplier)factory);
        multimap.putAll((Object)Color.BLUE, Arrays.asList(3, 1, 4, 1));
        multimap.putAll((Object)Color.RED, Arrays.asList(2, 7, 1, 8));
        SerializableTester.reserializeAndAssert((Object)multimap);
    }

    public void testNewSetMultimap() {
        SetSupplier factory = new SetSupplier();
        HashMap map = Maps.newHashMap();
        SetMultimap multimap = Multimaps.newSetMultimap((Map)map, (Supplier)factory);
        MultimapsTest.assertEquals((int)0, (int)factory.count);
        multimap.putAll((Object)Color.BLUE, Arrays.asList(3, 1, 4));
        MultimapsTest.assertEquals((int)1, (int)factory.count);
        multimap.putAll((Object)Color.RED, Arrays.asList(2, 7, 1, 8));
        MultimapsTest.assertEquals((int)2, (int)factory.count);
        MultimapsTest.assertEquals((Object)Sets.newHashSet((Object[])new Integer[]{4, 3, 1}), (Object)multimap.get((Object)Color.BLUE));
    }

    @GwtIncompatible
    public void testNewSetMultimapSerialization() {
        SetSupplier factory = new SetSupplier();
        HashMap map = Maps.newHashMap();
        SetMultimap multimap = Multimaps.newSetMultimap((Map)map, (Supplier)factory);
        multimap.putAll((Object)Color.BLUE, Arrays.asList(3, 1, 4));
        multimap.putAll((Object)Color.RED, Arrays.asList(2, 7, 1, 8));
        SerializableTester.reserializeAndAssert((Object)multimap);
    }

    public void testNewSortedSetMultimap() {
        SortedSetSupplier factory = new SortedSetSupplier();
        EnumMap map = Maps.newEnumMap(Color.class);
        SortedSetMultimap multimap = Multimaps.newSortedSetMultimap((Map)map, (Supplier)factory);
        MultimapsTest.assertEquals((int)1, (int)factory.count);
        multimap.putAll((Object)Color.BLUE, Arrays.asList(3, 1, 4));
        MultimapsTest.assertEquals((int)2, (int)factory.count);
        multimap.putAll((Object)Color.RED, Arrays.asList(2, 7, 1, 8));
        MultimapsTest.assertEquals((int)3, (int)factory.count);
        MultimapsTest.assertEquals((String)"[4, 3, 1]", (String)multimap.get((Object)Color.BLUE).toString());
        MultimapsTest.assertEquals(INT_COMPARATOR, (Object)multimap.valueComparator());
    }

    @GwtIncompatible
    public void testNewSortedSetMultimapSerialization() {
        SortedSetSupplier factory = new SortedSetSupplier();
        EnumMap map = Maps.newEnumMap(Color.class);
        SortedSetMultimap multimap = Multimaps.newSortedSetMultimap((Map)map, (Supplier)factory);
        multimap.putAll((Object)Color.BLUE, Arrays.asList(3, 1, 4));
        multimap.putAll((Object)Color.RED, Arrays.asList(2, 7, 1, 8));
        SerializableTester.reserializeAndAssert((Object)multimap);
        MultimapsTest.assertEquals(INT_COMPARATOR, (Object)multimap.valueComparator());
    }

    public void testIndex() {
        ImmutableMultimap stringToObject = new ImmutableMultimap.Builder().put((Object)"1", (Object)1).put((Object)"1", (Object)1L).put((Object)"1", (Object)"1").put((Object)"2", (Object)2).put((Object)"2", (Object)2L).build();
        ImmutableListMultimap outputMap = Multimaps.index((Iterable)stringToObject.values(), (Function)Functions.toStringFunction());
        MultimapsTest.assertEquals((Object)stringToObject, (Object)outputMap);
    }

    public void testIndexIterator() {
        ImmutableMultimap stringToObject = new ImmutableMultimap.Builder().put((Object)"1", (Object)1).put((Object)"1", (Object)1L).put((Object)"1", (Object)"1").put((Object)"2", (Object)2).put((Object)"2", (Object)2L).build();
        ImmutableListMultimap outputMap = Multimaps.index(stringToObject.values().iterator(), (Function)Functions.toStringFunction());
        MultimapsTest.assertEquals((Object)stringToObject, (Object)outputMap);
    }

    public void testIndex_ordering() {
        ImmutableListMultimap expectedIndex = new ImmutableListMultimap.Builder().put((Object)4, (Object)"Inky").put((Object)6, (Object)"Blinky").put((Object)5, (Object)"Pinky").put((Object)5, (Object)"Pinky").put((Object)5, (Object)"Clyde").build();
        List<String> badGuys = Arrays.asList("Inky", "Blinky", "Pinky", "Pinky", "Clyde");
        Function<String, Integer> stringLengthFunction = new Function<String, Integer>(){

            public Integer apply(String input) {
                return input.length();
            }
        };
        ImmutableListMultimap index = Multimaps.index(badGuys, (Function)stringLengthFunction);
        MultimapsTest.assertEquals((Object)expectedIndex, (Object)index);
    }

    public void testIndex_nullValue() {
        List<Integer> values = Arrays.asList(1, null);
        try {
            Multimaps.index(values, (Function)Functions.identity());
            MultimapsTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testIndex_nullKey() {
        List<Integer> values = Arrays.asList(1, 2);
        try {
            Multimaps.index(values, (Function)Functions.constant(null));
            MultimapsTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @GwtIncompatible(value="untested")
    public void testTransformValues() {
        ImmutableSetMultimap multimap = ImmutableSetMultimap.of((Object)"a", (Object)2, (Object)"b", (Object)-3, (Object)"b", (Object)3, (Object)"a", (Object)4, (Object)"c", (Object)6);
        Function<Integer, Integer> square = new Function<Integer, Integer>(){

            public Integer apply(Integer in) {
                return in * in;
            }
        };
        Multimap transformed = Multimaps.transformValues((Multimap)multimap, (Function)square);
        Truth.assertThat((Iterable)transformed.entries()).containsExactly(new Object[]{Maps.immutableEntry((Object)"a", (Object)4), Maps.immutableEntry((Object)"a", (Object)16), Maps.immutableEntry((Object)"b", (Object)9), Maps.immutableEntry((Object)"b", (Object)9), Maps.immutableEntry((Object)"c", (Object)36)}).inOrder();
    }

    @GwtIncompatible(value="untested")
    public void testTransformValuesIsView() {
        LinkedListMultimap multimap = LinkedListMultimap.create();
        multimap.put((Object)"a", (Object)"a");
        Multimap transformed = Multimaps.transformValues((Multimap)multimap, (Function)new Function<String, Integer>(){

            public Integer apply(String str) {
                return str.length();
            }
        });
        Map.Entry entry = (Map.Entry)multimap.entries().iterator().next();
        entry.setValue("bbb");
        Truth.assertThat((Iterable)transformed.entries()).containsExactly(new Object[]{Maps.immutableEntry((Object)"a", (Object)3)});
    }

    @GwtIncompatible(value="untested")
    public void testTransformListValues() {
        ImmutableListMultimap multimap = ImmutableListMultimap.of((Object)"a", (Object)2, (Object)"b", (Object)-3, (Object)"b", (Object)3, (Object)"a", (Object)4, (Object)"c", (Object)6);
        Function<Integer, Integer> square = new Function<Integer, Integer>(){

            public Integer apply(Integer in) {
                return in * in;
            }
        };
        ListMultimap transformed = Multimaps.transformValues((ListMultimap)multimap, (Function)square);
        Truth.assertThat((Iterable)transformed.entries()).containsExactly(new Object[]{Maps.immutableEntry((Object)"a", (Object)4), Maps.immutableEntry((Object)"a", (Object)16), Maps.immutableEntry((Object)"b", (Object)9), Maps.immutableEntry((Object)"b", (Object)9), Maps.immutableEntry((Object)"c", (Object)36)}).inOrder();
    }

    @GwtIncompatible(value="untested")
    public void testTransformEntries() {
        ImmutableSetMultimap multimap = ImmutableSetMultimap.of((Object)"a", (Object)1, (Object)"a", (Object)4, (Object)"b", (Object)-6);
        Maps.EntryTransformer<String, Integer, String> transformer = new Maps.EntryTransformer<String, Integer, String>(){

            public String transformEntry(String key, Integer value) {
                return value >= 0 ? key : "no" + key;
            }
        };
        Multimap transformed = Multimaps.transformEntries((Multimap)multimap, (Maps.EntryTransformer)transformer);
        Truth.assertThat((Iterable)transformed.entries()).containsExactly(new Object[]{Maps.immutableEntry((Object)"a", (Object)"a"), Maps.immutableEntry((Object)"a", (Object)"a"), Maps.immutableEntry((Object)"b", (Object)"nob")}).inOrder();
    }

    @GwtIncompatible(value="untested")
    public void testTransformListEntries() {
        ImmutableListMultimap multimap = ImmutableListMultimap.of((Object)"a", (Object)1, (Object)"a", (Object)4, (Object)"b", (Object)6, (Object)"a", (Object)4);
        Maps.EntryTransformer<String, Integer, String> transformer = new Maps.EntryTransformer<String, Integer, String>(){

            public String transformEntry(String key, Integer value) {
                return key + value;
            }
        };
        ListMultimap transformed = Multimaps.transformEntries((ListMultimap)multimap, (Maps.EntryTransformer)transformer);
        MultimapsTest.assertEquals((Object)ImmutableListMultimap.of((Object)"a", (Object)"a1", (Object)"a", (Object)"a4", (Object)"a", (Object)"a4", (Object)"b", (Object)"b6"), (Object)transformed);
        MultimapsTest.assertEquals((String)"{a=[a1, a4, a4], b=[b6]}", (String)transformed.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> void testSynchronizedMultimapSampleCodeCompilation() {
        Object key = null;
        Multimap multimap = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
        Collection values = multimap.get(key);
        Multimap multimap2 = multimap;
        synchronized (multimap2) {
            Iterator i = values.iterator();
            while (i.hasNext()) {
                MultimapsTest.foo(i.next());
            }
        }
    }

    private static void foo(Object o) {
    }

    public void testFilteredKeysSetMultimapReplaceValues() {
        LinkedHashMultimap multimap = LinkedHashMultimap.create();
        multimap.put((Object)"foo", (Object)1);
        multimap.put((Object)"bar", (Object)2);
        multimap.put((Object)"baz", (Object)3);
        multimap.put((Object)"bar", (Object)4);
        SetMultimap filtered = Multimaps.filterKeys((SetMultimap)multimap, (Predicate)Predicates.in((Collection)ImmutableSet.of((Object)"foo", (Object)"bar")));
        MultimapsTest.assertEquals((Object)ImmutableSet.of(), (Object)filtered.replaceValues((Object)"baz", (Iterable)ImmutableSet.of()));
        try {
            filtered.replaceValues((Object)"baz", (Iterable)ImmutableSet.of((Object)5));
            MultimapsTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testFilteredKeysSetMultimapGetBadValue() {
        LinkedHashMultimap multimap = LinkedHashMultimap.create();
        multimap.put((Object)"foo", (Object)1);
        multimap.put((Object)"bar", (Object)2);
        multimap.put((Object)"baz", (Object)3);
        multimap.put((Object)"bar", (Object)4);
        SetMultimap filtered = Multimaps.filterKeys((SetMultimap)multimap, (Predicate)Predicates.in((Collection)ImmutableSet.of((Object)"foo", (Object)"bar")));
        Set bazSet = filtered.get((Object)"baz");
        Truth.assertThat((Iterable)bazSet).isEmpty();
        try {
            bazSet.add(5);
            MultimapsTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            bazSet.addAll(ImmutableSet.of((Object)6, (Object)7));
            MultimapsTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
    }

    public void testFilteredKeysListMultimapGetBadValue() {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        multimap.put((Object)"foo", (Object)1);
        multimap.put((Object)"bar", (Object)2);
        multimap.put((Object)"baz", (Object)3);
        multimap.put((Object)"bar", (Object)4);
        ListMultimap filtered = Multimaps.filterKeys((ListMultimap)multimap, (Predicate)Predicates.in((Collection)ImmutableSet.of((Object)"foo", (Object)"bar")));
        List bazList = filtered.get((Object)"baz");
        Truth.assertThat((Iterable)bazList).isEmpty();
        try {
            bazList.add(5);
            MultimapsTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            bazList.add(0, 6);
            MultimapsTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            bazList.addAll(ImmutableList.of((Object)7, (Object)8));
            MultimapsTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            bazList.addAll(0, ImmutableList.of((Object)9, (Object)10));
            MultimapsTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testNullPointers() {
        new NullPointerTester().testAllPublicStaticMethods(Multimaps.class);
    }

    private static class SortedSetSupplier
    extends CountingSupplier<TreeSet<Integer>> {
        private static final long serialVersionUID = 0L;

        private SortedSetSupplier() {
        }

        @Override
        public TreeSet<Integer> getImpl() {
            return Sets.newTreeSet((Comparator)INT_COMPARATOR);
        }
    }

    private static class SetSupplier
    extends CountingSupplier<Set<Integer>> {
        private static final long serialVersionUID = 0L;

        private SetSupplier() {
        }

        @Override
        public Set<Integer> getImpl() {
            return new HashSet<Integer>(4);
        }
    }

    private static class ListSupplier
    extends CountingSupplier<LinkedList<Integer>> {
        private static final long serialVersionUID = 0L;

        private ListSupplier() {
        }

        @Override
        public LinkedList<Integer> getImpl() {
            return new LinkedList<Integer>();
        }
    }

    private static class QueueSupplier
    extends CountingSupplier<Queue<Integer>> {
        private static final long serialVersionUID = 0L;

        private QueueSupplier() {
        }

        @Override
        public Queue<Integer> getImpl() {
            return new LinkedList<Integer>();
        }
    }

    private static abstract class CountingSupplier<E>
    implements Supplier<E>,
    Serializable {
        int count;

        private CountingSupplier() {
        }

        abstract E getImpl();

        public E get() {
            ++this.count;
            return this.getImpl();
        }
    }

    private static enum Color {
        BLUE,
        RED,
        YELLOW,
        GREEN;

    }
}

