/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.eventbus;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.eventbus.Subscriber;
import com.google.common.eventbus.SubscriberRegistry;
import java.util.Iterator;
import junit.framework.TestCase;

public class SubscriberRegistryTest
extends TestCase {
    private final SubscriberRegistry registry = new SubscriberRegistry(new EventBus());

    public void testRegister() {
        SubscriberRegistryTest.assertEquals((int)0, (int)this.registry.getSubscribersForTesting(String.class).size());
        this.registry.register((Object)new StringSubscriber());
        SubscriberRegistryTest.assertEquals((int)1, (int)this.registry.getSubscribersForTesting(String.class).size());
        this.registry.register((Object)new StringSubscriber());
        SubscriberRegistryTest.assertEquals((int)2, (int)this.registry.getSubscribersForTesting(String.class).size());
        this.registry.register((Object)new ObjectSubscriber());
        SubscriberRegistryTest.assertEquals((int)2, (int)this.registry.getSubscribersForTesting(String.class).size());
        SubscriberRegistryTest.assertEquals((int)1, (int)this.registry.getSubscribersForTesting(Object.class).size());
    }

    public void testUnregister() {
        StringSubscriber s1 = new StringSubscriber();
        StringSubscriber s2 = new StringSubscriber();
        this.registry.register((Object)s1);
        this.registry.register((Object)s2);
        this.registry.unregister((Object)s1);
        SubscriberRegistryTest.assertEquals((int)1, (int)this.registry.getSubscribersForTesting(String.class).size());
        this.registry.unregister((Object)s2);
        SubscriberRegistryTest.assertTrue((boolean)this.registry.getSubscribersForTesting(String.class).isEmpty());
    }

    public void testUnregister_notRegistered() {
        try {
            this.registry.unregister((Object)new StringSubscriber());
            SubscriberRegistryTest.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        StringSubscriber s1 = new StringSubscriber();
        this.registry.register((Object)s1);
        try {
            this.registry.unregister((Object)new StringSubscriber());
            SubscriberRegistryTest.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        this.registry.unregister((Object)s1);
        try {
            this.registry.unregister((Object)s1);
            SubscriberRegistryTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetSubscribers() {
        SubscriberRegistryTest.assertEquals((int)0, (int)Iterators.size((Iterator)this.registry.getSubscribers((Object)"")));
        this.registry.register((Object)new StringSubscriber());
        SubscriberRegistryTest.assertEquals((int)1, (int)Iterators.size((Iterator)this.registry.getSubscribers((Object)"")));
        this.registry.register((Object)new StringSubscriber());
        SubscriberRegistryTest.assertEquals((int)2, (int)Iterators.size((Iterator)this.registry.getSubscribers((Object)"")));
        this.registry.register((Object)new ObjectSubscriber());
        SubscriberRegistryTest.assertEquals((int)3, (int)Iterators.size((Iterator)this.registry.getSubscribers((Object)"")));
        SubscriberRegistryTest.assertEquals((int)1, (int)Iterators.size((Iterator)this.registry.getSubscribers(new Object())));
        SubscriberRegistryTest.assertEquals((int)1, (int)Iterators.size((Iterator)this.registry.getSubscribers((Object)1)));
        this.registry.register((Object)new IntegerSubscriber());
        SubscriberRegistryTest.assertEquals((int)3, (int)Iterators.size((Iterator)this.registry.getSubscribers((Object)"")));
        SubscriberRegistryTest.assertEquals((int)1, (int)Iterators.size((Iterator)this.registry.getSubscribers(new Object())));
        SubscriberRegistryTest.assertEquals((int)2, (int)Iterators.size((Iterator)this.registry.getSubscribers((Object)1)));
    }

    public void testGetSubscribers_returnsImmutableSnapshot() {
        StringSubscriber s1 = new StringSubscriber();
        StringSubscriber s2 = new StringSubscriber();
        ObjectSubscriber o1 = new ObjectSubscriber();
        Iterator empty = this.registry.getSubscribers((Object)"");
        SubscriberRegistryTest.assertFalse((boolean)empty.hasNext());
        empty = this.registry.getSubscribers((Object)"");
        this.registry.register((Object)s1);
        SubscriberRegistryTest.assertFalse((boolean)empty.hasNext());
        Iterator one = this.registry.getSubscribers((Object)"");
        SubscriberRegistryTest.assertEquals((Object)s1, (Object)((Subscriber)one.next()).target);
        SubscriberRegistryTest.assertFalse((boolean)one.hasNext());
        one = this.registry.getSubscribers((Object)"");
        this.registry.register((Object)s2);
        this.registry.register((Object)o1);
        Iterator three = this.registry.getSubscribers((Object)"");
        SubscriberRegistryTest.assertEquals((Object)s1, (Object)((Subscriber)one.next()).target);
        SubscriberRegistryTest.assertFalse((boolean)one.hasNext());
        SubscriberRegistryTest.assertEquals((Object)s1, (Object)((Subscriber)three.next()).target);
        SubscriberRegistryTest.assertEquals((Object)s2, (Object)((Subscriber)three.next()).target);
        SubscriberRegistryTest.assertEquals((Object)o1, (Object)((Subscriber)three.next()).target);
        SubscriberRegistryTest.assertFalse((boolean)three.hasNext());
        three = this.registry.getSubscribers((Object)"");
        this.registry.unregister((Object)s2);
        SubscriberRegistryTest.assertEquals((Object)s1, (Object)((Subscriber)three.next()).target);
        SubscriberRegistryTest.assertEquals((Object)s2, (Object)((Subscriber)three.next()).target);
        SubscriberRegistryTest.assertEquals((Object)o1, (Object)((Subscriber)three.next()).target);
        SubscriberRegistryTest.assertFalse((boolean)three.hasNext());
        Iterator two = this.registry.getSubscribers((Object)"");
        SubscriberRegistryTest.assertEquals((Object)s1, (Object)((Subscriber)two.next()).target);
        SubscriberRegistryTest.assertEquals((Object)o1, (Object)((Subscriber)two.next()).target);
        SubscriberRegistryTest.assertFalse((boolean)two.hasNext());
    }

    public void testFlattenHierarchy() {
        SubscriberRegistryTest.assertEquals((Object)ImmutableSet.of(Object.class, HierarchyFixtureInterface.class, HierarchyFixtureSubinterface.class, HierarchyFixtureParent.class, HierarchyFixture.class), (Object)SubscriberRegistry.flattenHierarchy(HierarchyFixture.class));
    }

    private static class HierarchyFixture
    extends HierarchyFixtureParent {
        private HierarchyFixture() {
        }
    }

    private static class HierarchyFixtureParent
    implements HierarchyFixtureSubinterface {
        private HierarchyFixtureParent() {
        }
    }

    private static interface HierarchyFixtureSubinterface
    extends HierarchyFixtureInterface {
    }

    private static interface HierarchyFixtureInterface {
    }

    public static class ObjectSubscriber {
        @Subscribe
        public void handle(Object o) {
        }
    }

    public static class IntegerSubscriber {
        @Subscribe
        public void handle(Integer i) {
        }
    }

    public static class StringSubscriber {
        @Subscribe
        public void handle(String s) {
        }
    }
}

