/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.graph.AbstractGraphTest;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graph;
import com.google.common.graph.Graphs;
import com.google.common.graph.ImmutableNetwork;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.google.common.graph.TestUtil;
import com.google.common.truth.Truth;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collection;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractNetworkTest {
    MutableNetwork<Integer, String> network;
    static final Integer N1 = 1;
    static final Integer N2 = 2;
    static final Integer N3 = 3;
    static final Integer N4 = 4;
    static final Integer N5 = 5;
    static final Integer NODE_NOT_IN_GRAPH = 1000;
    static final String E11 = "1-1";
    static final String E11_A = "1-1a";
    static final String E12 = "1-2";
    static final String E12_A = "1-2a";
    static final String E12_B = "1-2b";
    static final String E21 = "2-1";
    static final String E13 = "1-3";
    static final String E14 = "1-4";
    static final String E23 = "2-3";
    static final String E31 = "3-1";
    static final String E34 = "3-4";
    static final String E41 = "4-1";
    static final String E15 = "1-5";
    static final String EDGE_NOT_IN_GRAPH = "edgeNotInGraph";
    static final String ERROR_ELEMENT_NOT_IN_GRAPH = "not an element of this graph";
    static final String NODE_STRING = "Node";
    static final String EDGE_STRING = "Edge";
    static final String ERROR_PARALLEL_EDGE = "connected by a different edge";
    static final String ERROR_REUSE_EDGE = "it cannot be reused to connect";
    static final String ERROR_MODIFIABLE_COLLECTION = "Collection returned is unexpectedly modifiable";
    static final String ERROR_SELF_LOOP = "self-loops are not allowed";
    static final String ERROR_NODE_NOT_IN_GRAPH = "Should not be allowed to pass a node that is not an element of the graph.";
    static final String ERROR_EDGE_NOT_IN_GRAPH = "Should not be allowed to pass an edge that is not an element of the graph.";
    static final String ERROR_ADDED_SELF_LOOP = "Should not be allowed to add a self-loop edge.";
    static final String ERROR_ADDED_PARALLEL_EDGE = "Should not be allowed to add a parallel edge.";
    static final String ERROR_ADDED_EXISTING_EDGE = "Reusing an existing edge to connect different nodes succeeded";

    public abstract MutableNetwork<Integer, String> createGraph();

    @CanIgnoreReturnValue
    protected boolean addNode(Integer n) {
        return this.network.addNode((Object)n);
    }

    @CanIgnoreReturnValue
    protected boolean addEdge(Integer n1, Integer n2, String e) {
        this.network.addNode((Object)n1);
        this.network.addNode((Object)n2);
        return this.network.addEdge((Object)n1, (Object)n2, (Object)e);
    }

    @Before
    public void init() {
        this.network = this.createGraph();
    }

    @After
    public void validateNetworkState() {
        AbstractNetworkTest.validateNetwork(this.network);
    }

    static <N, E> void validateNetwork(Network<N, E> network) {
        TestUtil.assertStronglyEquivalent(network, Graphs.copyOf(network));
        TestUtil.assertStronglyEquivalent(network, ImmutableNetwork.copyOf(network));
        String networkString = network.toString();
        Truth.assertThat((String)networkString).contains((CharSequence)("isDirected: " + network.isDirected()));
        Truth.assertThat((String)networkString).contains((CharSequence)("allowsParallelEdges: " + network.allowsParallelEdges()));
        Truth.assertThat((String)networkString).contains((CharSequence)("allowsSelfLoops: " + network.allowsSelfLoops()));
        int nodeStart = networkString.indexOf("nodes:");
        int edgeStart = networkString.indexOf("edges:");
        String nodeString = networkString.substring(nodeStart, edgeStart);
        String edgeString = networkString.substring(edgeStart);
        Graph asGraph = network.asGraph();
        AbstractGraphTest.validateGraph(asGraph);
        Truth.assertThat((Iterable)network.nodes()).isEqualTo((Object)asGraph.nodes());
        Truth.assertThat((Integer)network.edges().size()).isAtLeast((Comparable)Integer.valueOf(asGraph.edges().size()));
        Truth.assertThat((Object)network.nodeOrder()).isEqualTo((Object)asGraph.nodeOrder());
        Truth.assertThat((Boolean)network.isDirected()).isEqualTo((Object)asGraph.isDirected());
        Truth.assertThat((Boolean)network.allowsSelfLoops()).isEqualTo((Object)asGraph.allowsSelfLoops());
        for (Object edge : TestUtil.sanityCheckSet(network.edges())) {
            Truth.assertThat((String)edgeString).contains((CharSequence)edge.toString());
            EndpointPair endpointPair = network.incidentNodes(edge);
            Object nodeU = endpointPair.nodeU();
            Object nodeV = endpointPair.nodeV();
            Truth.assertThat((Iterable)asGraph.edges()).contains((Object)EndpointPair.of(network, (Object)nodeU, (Object)nodeV));
            Truth.assertThat((Iterable)network.edgesConnecting(nodeU, nodeV)).contains(edge);
            Truth.assertThat((Iterable)network.successors(nodeU)).contains(nodeV);
            Truth.assertThat((Iterable)network.adjacentNodes(nodeU)).contains(nodeV);
            Truth.assertThat((Iterable)network.outEdges(nodeU)).contains(edge);
            Truth.assertThat((Iterable)network.incidentEdges(nodeU)).contains(edge);
            Truth.assertThat((Iterable)network.predecessors(nodeV)).contains(nodeU);
            Truth.assertThat((Iterable)network.adjacentNodes(nodeV)).contains(nodeU);
            Truth.assertThat((Iterable)network.inEdges(nodeV)).contains(edge);
            Truth.assertThat((Iterable)network.incidentEdges(nodeV)).contains(edge);
            for (Object incidentNode : network.incidentNodes(edge)) {
                Truth.assertThat((Iterable)network.nodes()).contains(incidentNode);
                for (Object adjacentEdge : network.incidentEdges(incidentNode)) {
                    Assert.assertTrue((edge.equals(adjacentEdge) || network.adjacentEdges(edge).contains(adjacentEdge) ? 1 : 0) != 0);
                }
            }
        }
        for (Object node : TestUtil.sanityCheckSet(network.nodes())) {
            Truth.assertThat((String)nodeString).contains((CharSequence)node.toString());
            Truth.assertThat((Iterable)network.adjacentNodes(node)).isEqualTo((Object)asGraph.adjacentNodes(node));
            Truth.assertThat((Iterable)network.predecessors(node)).isEqualTo((Object)asGraph.predecessors(node));
            Truth.assertThat((Iterable)network.successors(node)).isEqualTo((Object)asGraph.successors(node));
            int selfLoopCount = network.edgesConnecting(node, node).size();
            Truth.assertThat((Integer)(network.incidentEdges(node).size() + selfLoopCount)).isEqualTo((Object)network.degree(node));
            if (network.isDirected()) {
                Truth.assertThat((Integer)(network.incidentEdges(node).size() + selfLoopCount)).isEqualTo((Object)(network.inDegree(node) + network.outDegree(node)));
                Truth.assertThat((Iterable)network.inEdges(node)).hasSize(network.inDegree(node));
                Truth.assertThat((Iterable)network.outEdges(node)).hasSize(network.outDegree(node));
            } else {
                Truth.assertThat((Iterable)network.predecessors(node)).isEqualTo((Object)network.adjacentNodes(node));
                Truth.assertThat((Iterable)network.successors(node)).isEqualTo((Object)network.adjacentNodes(node));
                Truth.assertThat((Iterable)network.inEdges(node)).isEqualTo((Object)network.incidentEdges(node));
                Truth.assertThat((Iterable)network.outEdges(node)).isEqualTo((Object)network.incidentEdges(node));
                Truth.assertThat((Integer)network.inDegree(node)).isEqualTo((Object)network.degree(node));
                Truth.assertThat((Integer)network.outDegree(node)).isEqualTo((Object)network.degree(node));
            }
            for (Object otherNode : network.nodes()) {
                boolean connected;
                Set edgesConnecting = TestUtil.sanityCheckSet(network.edgesConnecting(node, otherNode));
                boolean isSelfLoop = node.equals(otherNode);
                boolean bl = connected = !edgesConnecting.isEmpty();
                if (network.isDirected() || !isSelfLoop) {
                    Truth.assertThat(edgesConnecting).isEqualTo((Object)Sets.intersection((Set)network.outEdges(node), (Set)network.inEdges(otherNode)));
                }
                if (!network.allowsParallelEdges()) {
                    Truth.assertThat((Integer)edgesConnecting.size()).isAtMost((Comparable)Integer.valueOf(1));
                }
                if (!network.allowsSelfLoops() && isSelfLoop) {
                    Truth.assertThat((Boolean)connected).isFalse();
                }
                Truth.assertThat((Boolean)network.successors(node).contains(otherNode)).isEqualTo((Object)connected);
                Truth.assertThat((Boolean)network.predecessors(otherNode).contains(node)).isEqualTo((Object)connected);
                for (Object edge : edgesConnecting) {
                    Truth.assertThat((Iterable)network.incidentNodes(edge)).isEqualTo((Object)EndpointPair.of(network, node, otherNode));
                    Truth.assertThat((Iterable)network.outEdges(node)).contains(edge);
                    Truth.assertThat((Iterable)network.inEdges(otherNode)).contains(edge);
                }
            }
            for (Object adjacentNode : TestUtil.sanityCheckSet(network.adjacentNodes(node))) {
                Assert.assertTrue((network.predecessors(node).contains(adjacentNode) || network.successors(node).contains(adjacentNode) ? 1 : 0) != 0);
                Assert.assertTrue((!network.edgesConnecting(node, adjacentNode).isEmpty() || !network.edgesConnecting(adjacentNode, node).isEmpty() ? 1 : 0) != 0);
            }
            for (Object predecessor : TestUtil.sanityCheckSet(network.predecessors(node))) {
                Truth.assertThat((Iterable)network.successors(predecessor)).contains(node);
                Truth.assertThat((Iterable)network.edgesConnecting(predecessor, node)).isNotEmpty();
            }
            for (Object successor : TestUtil.sanityCheckSet(network.successors(node))) {
                Truth.assertThat((Iterable)network.predecessors(successor)).contains(node);
                Truth.assertThat((Iterable)network.edgesConnecting(node, successor)).isNotEmpty();
            }
            for (Object incidentEdge : TestUtil.sanityCheckSet(network.incidentEdges(node))) {
                Assert.assertTrue((network.inEdges(node).contains(incidentEdge) || network.outEdges(node).contains(incidentEdge) ? 1 : 0) != 0);
                Truth.assertThat((Iterable)network.edges()).contains(incidentEdge);
                Truth.assertThat((Iterable)network.incidentNodes(incidentEdge)).contains(node);
            }
            for (Object inEdge : TestUtil.sanityCheckSet(network.inEdges(node))) {
                Truth.assertThat((Iterable)network.incidentEdges(node)).contains(inEdge);
                Truth.assertThat((Iterable)network.outEdges(network.incidentNodes(inEdge).adjacentNode(node))).contains(inEdge);
                if (!network.isDirected()) continue;
                Truth.assertThat((Object)network.incidentNodes(inEdge).target()).isEqualTo(node);
            }
            for (Object outEdge : TestUtil.sanityCheckSet(network.outEdges(node))) {
                Truth.assertThat((Iterable)network.incidentEdges(node)).contains(outEdge);
                Truth.assertThat((Iterable)network.inEdges(network.incidentNodes(outEdge).adjacentNode(node))).contains(outEdge);
                if (!network.isDirected()) continue;
                Truth.assertThat((Object)network.incidentNodes(outEdge).source()).isEqualTo(node);
            }
        }
    }

    @Test
    public abstract void nodes_checkReturnedSetMutability();

    @Test
    public abstract void edges_checkReturnedSetMutability();

    @Test
    public abstract void incidentEdges_checkReturnedSetMutability();

    @Test
    public abstract void adjacentNodes_checkReturnedSetMutability();

    @Test
    public abstract void adjacentEdges_checkReturnedSetMutability();

    @Test
    public abstract void edgesConnecting_checkReturnedSetMutability();

    @Test
    public abstract void inEdges_checkReturnedSetMutability();

    @Test
    public abstract void outEdges_checkReturnedSetMutability();

    @Test
    public abstract void predecessors_checkReturnedSetMutability();

    @Test
    public abstract void successors_checkReturnedSetMutability();

    @Test
    public void nodes_oneNode() {
        this.addNode(N1);
        Truth.assertThat((Iterable)this.network.nodes()).containsExactly(new Object[]{N1});
    }

    @Test
    public void nodes_noNodes() {
        Truth.assertThat((Iterable)this.network.nodes()).isEmpty();
    }

    @Test
    public void edges_oneEdge() {
        this.addEdge(N1, N2, E12);
        Truth.assertThat((Iterable)this.network.edges()).containsExactly(new Object[]{E12});
    }

    @Test
    public void edges_noEdges() {
        Truth.assertThat((Iterable)this.network.edges()).isEmpty();
        this.addNode(N1);
        this.addNode(N2);
        Truth.assertThat((Iterable)this.network.edges()).isEmpty();
    }

    @Test
    public void incidentEdges_oneEdge() {
        this.addEdge(N1, N2, E12);
        Truth.assertThat((Iterable)this.network.incidentEdges((Object)N2)).containsExactly(new Object[]{E12});
        Truth.assertThat((Iterable)this.network.incidentEdges((Object)N1)).containsExactly(new Object[]{E12});
    }

    @Test
    public void incidentEdges_isolatedNode() {
        this.addNode(N1);
        Truth.assertThat((Iterable)this.network.incidentEdges((Object)N1)).isEmpty();
    }

    @Test
    public void incidentEdges_nodeNotInGraph() {
        try {
            this.network.incidentEdges((Object)NODE_NOT_IN_GRAPH);
            Assert.fail((String)ERROR_NODE_NOT_IN_GRAPH);
        }
        catch (IllegalArgumentException e) {
            AbstractNetworkTest.assertNodeNotInGraphErrorMessage(e);
        }
    }

    @Test
    public void incidentNodes_oneEdge() {
        this.addEdge(N1, N2, E12);
        Truth.assertThat((Iterable)this.network.incidentNodes((Object)E12)).containsExactly(new Object[]{N1, N2});
    }

    @Test
    public void incidentNodes_edgeNotInGraph() {
        try {
            this.network.incidentNodes((Object)EDGE_NOT_IN_GRAPH);
            Assert.fail((String)ERROR_EDGE_NOT_IN_GRAPH);
        }
        catch (IllegalArgumentException e) {
            AbstractNetworkTest.assertEdgeNotInGraphErrorMessage(e);
        }
    }

    @Test
    public void adjacentNodes_oneEdge() {
        this.addEdge(N1, N2, E12);
        Truth.assertThat((Iterable)this.network.adjacentNodes((Object)N1)).containsExactly(new Object[]{N2});
        Truth.assertThat((Iterable)this.network.adjacentNodes((Object)N2)).containsExactly(new Object[]{N1});
    }

    @Test
    public void adjacentNodes_noAdjacentNodes() {
        this.addNode(N1);
        Truth.assertThat((Iterable)this.network.adjacentNodes((Object)N1)).isEmpty();
    }

    @Test
    public void adjacentNodes_nodeNotInGraph() {
        try {
            this.network.adjacentNodes((Object)NODE_NOT_IN_GRAPH);
            Assert.fail((String)ERROR_NODE_NOT_IN_GRAPH);
        }
        catch (IllegalArgumentException e) {
            AbstractNetworkTest.assertNodeNotInGraphErrorMessage(e);
        }
    }

    @Test
    public void adjacentEdges_bothEndpoints() {
        this.addEdge(N1, N2, E12);
        this.addEdge(N2, N3, E23);
        this.addEdge(N3, N1, E31);
        this.addEdge(N3, N4, E34);
        Truth.assertThat((Iterable)this.network.adjacentEdges((Object)E12)).containsExactly(new Object[]{E31, E23});
    }

    @Test
    public void adjacentEdges_noAdjacentEdges() {
        this.addEdge(N1, N2, E12);
        this.addEdge(N3, N4, E34);
        Truth.assertThat((Iterable)this.network.adjacentEdges((Object)E12)).isEmpty();
    }

    @Test
    public void adjacentEdges_edgeNotInGraph() {
        try {
            this.network.adjacentEdges((Object)EDGE_NOT_IN_GRAPH);
            Assert.fail((String)ERROR_EDGE_NOT_IN_GRAPH);
        }
        catch (IllegalArgumentException e) {
            AbstractNetworkTest.assertEdgeNotInGraphErrorMessage(e);
        }
    }

    @Test
    public void edgesConnecting_disconnectedNodes() {
        this.addNode(N1);
        this.addNode(N2);
        Truth.assertThat((Iterable)this.network.edgesConnecting((Object)N1, (Object)N2)).isEmpty();
    }

    @Test
    public void edgesConnecting_nodesNotInGraph() {
        this.addNode(N1);
        this.addNode(N2);
        try {
            this.network.edgesConnecting((Object)N1, (Object)NODE_NOT_IN_GRAPH);
            Assert.fail((String)ERROR_NODE_NOT_IN_GRAPH);
        }
        catch (IllegalArgumentException e) {
            AbstractNetworkTest.assertNodeNotInGraphErrorMessage(e);
        }
        try {
            this.network.edgesConnecting((Object)NODE_NOT_IN_GRAPH, (Object)N2);
            Assert.fail((String)ERROR_NODE_NOT_IN_GRAPH);
        }
        catch (IllegalArgumentException e) {
            AbstractNetworkTest.assertNodeNotInGraphErrorMessage(e);
        }
        try {
            this.network.edgesConnecting((Object)NODE_NOT_IN_GRAPH, (Object)NODE_NOT_IN_GRAPH);
            Assert.fail((String)ERROR_NODE_NOT_IN_GRAPH);
        }
        catch (IllegalArgumentException e) {
            AbstractNetworkTest.assertNodeNotInGraphErrorMessage(e);
        }
    }

    @Test
    public void inEdges_noInEdges() {
        this.addNode(N1);
        Truth.assertThat((Iterable)this.network.inEdges((Object)N1)).isEmpty();
    }

    @Test
    public void inEdges_nodeNotInGraph() {
        try {
            this.network.inEdges((Object)NODE_NOT_IN_GRAPH);
            Assert.fail((String)ERROR_NODE_NOT_IN_GRAPH);
        }
        catch (IllegalArgumentException e) {
            AbstractNetworkTest.assertNodeNotInGraphErrorMessage(e);
        }
    }

    @Test
    public void outEdges_noOutEdges() {
        this.addNode(N1);
        Truth.assertThat((Iterable)this.network.outEdges((Object)N1)).isEmpty();
    }

    @Test
    public void outEdges_nodeNotInGraph() {
        try {
            this.network.outEdges((Object)NODE_NOT_IN_GRAPH);
            Assert.fail((String)ERROR_NODE_NOT_IN_GRAPH);
        }
        catch (IllegalArgumentException e) {
            AbstractNetworkTest.assertNodeNotInGraphErrorMessage(e);
        }
    }

    @Test
    public void predecessors_noPredecessors() {
        this.addNode(N1);
        Truth.assertThat((Iterable)this.network.predecessors((Object)N1)).isEmpty();
    }

    @Test
    public void predecessors_nodeNotInGraph() {
        try {
            this.network.predecessors((Object)NODE_NOT_IN_GRAPH);
            Assert.fail((String)ERROR_NODE_NOT_IN_GRAPH);
        }
        catch (IllegalArgumentException e) {
            AbstractNetworkTest.assertNodeNotInGraphErrorMessage(e);
        }
    }

    @Test
    public void successors_noSuccessors() {
        this.addNode(N1);
        Truth.assertThat((Iterable)this.network.successors((Object)N1)).isEmpty();
    }

    @Test
    public void successors_nodeNotInGraph() {
        try {
            this.network.successors((Object)NODE_NOT_IN_GRAPH);
            Assert.fail((String)ERROR_NODE_NOT_IN_GRAPH);
        }
        catch (IllegalArgumentException e) {
            AbstractNetworkTest.assertNodeNotInGraphErrorMessage(e);
        }
    }

    @Test
    public void addNode_newNode() {
        Assert.assertTrue((boolean)this.addNode(N1));
        Truth.assertThat((Iterable)this.network.nodes()).contains((Object)N1);
    }

    @Test
    public void addNode_existingNode() {
        this.addNode(N1);
        ImmutableSet nodes = ImmutableSet.copyOf((Collection)this.network.nodes());
        Assert.assertFalse((boolean)this.addNode(N1));
        Truth.assertThat((Iterable)this.network.nodes()).containsExactlyElementsIn((Iterable)nodes);
    }

    @Test
    public void removeNode_existingNode() {
        this.addEdge(N1, N2, E12);
        this.addEdge(N4, N1, E41);
        Assert.assertTrue((boolean)this.network.removeNode((Object)N1));
        Assert.assertFalse((boolean)this.network.removeNode((Object)N1));
        Truth.assertThat((Iterable)this.network.nodes()).containsExactly(new Object[]{N2, N4});
        Truth.assertThat((Iterable)this.network.edges()).doesNotContain((Object)E12);
        Truth.assertThat((Iterable)this.network.edges()).doesNotContain((Object)E41);
    }

    @Test
    public void removeNode_nodeNotPresent() {
        this.addNode(N1);
        ImmutableSet nodes = ImmutableSet.copyOf((Collection)this.network.nodes());
        Assert.assertFalse((boolean)this.network.removeNode((Object)NODE_NOT_IN_GRAPH));
        Truth.assertThat((Iterable)this.network.nodes()).containsExactlyElementsIn((Iterable)nodes);
    }

    @Test
    public void removeNode_queryAfterRemoval() {
        this.addNode(N1);
        Set unused = this.network.adjacentNodes((Object)N1);
        Assert.assertTrue((boolean)this.network.removeNode((Object)N1));
        try {
            this.network.adjacentNodes((Object)N1);
            Assert.fail((String)ERROR_NODE_NOT_IN_GRAPH);
        }
        catch (IllegalArgumentException e) {
            AbstractNetworkTest.assertNodeNotInGraphErrorMessage(e);
        }
    }

    @Test
    public void removeEdge_existingEdge() {
        this.addEdge(N1, N2, E12);
        Assert.assertTrue((boolean)this.network.removeEdge((Object)E12));
        Assert.assertFalse((boolean)this.network.removeEdge((Object)E12));
        Truth.assertThat((Iterable)this.network.edges()).doesNotContain((Object)E12);
        Truth.assertThat((Iterable)this.network.edgesConnecting((Object)N1, (Object)N2)).isEmpty();
    }

    @Test
    public void removeEdge_oneOfMany() {
        this.addEdge(N1, N2, E12);
        this.addEdge(N1, N3, E13);
        this.addEdge(N1, N4, E14);
        Truth.assertThat((Iterable)this.network.edges()).containsExactly(new Object[]{E12, E13, E14});
        Assert.assertTrue((boolean)this.network.removeEdge((Object)E13));
        Truth.assertThat((Iterable)this.network.edges()).containsExactly(new Object[]{E12, E14});
    }

    @Test
    public void removeEdge_edgeNotPresent() {
        this.addEdge(N1, N2, E12);
        ImmutableSet edges = ImmutableSet.copyOf((Collection)this.network.edges());
        Assert.assertFalse((boolean)this.network.removeEdge((Object)EDGE_NOT_IN_GRAPH));
        Truth.assertThat((Iterable)this.network.edges()).containsExactlyElementsIn((Iterable)edges);
    }

    @Test
    public void removeEdge_queryAfterRemoval() {
        this.addEdge(N1, N2, E12);
        EndpointPair unused = this.network.incidentNodes((Object)E12);
        Assert.assertTrue((boolean)this.network.removeEdge((Object)E12));
        try {
            this.network.incidentNodes((Object)E12);
            Assert.fail((String)ERROR_EDGE_NOT_IN_GRAPH);
        }
        catch (IllegalArgumentException e) {
            AbstractNetworkTest.assertEdgeNotInGraphErrorMessage(e);
        }
    }

    static void assertNodeNotInGraphErrorMessage(Throwable throwable) {
        Truth.assertThat((String)throwable.getMessage()).startsWith(NODE_STRING);
        Truth.assertThat((String)throwable.getMessage()).contains((CharSequence)ERROR_ELEMENT_NOT_IN_GRAPH);
    }

    static void assertEdgeNotInGraphErrorMessage(Throwable throwable) {
        Truth.assertThat((String)throwable.getMessage()).startsWith(EDGE_STRING);
        Truth.assertThat((String)throwable.getMessage()).contains((CharSequence)ERROR_ELEMENT_NOT_IN_GRAPH);
    }
}

