/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.graph.AbstractGraphTest;
import com.google.common.testing.EqualsTester;
import com.google.common.truth.Truth;
import org.junit.After;
import org.junit.Test;

public abstract class AbstractUndirectedGraphTest
extends AbstractGraphTest {
    @After
    public void validateUndirectedEdges() {
        for (Integer node : this.graph.nodes()) {
            new EqualsTester().addEqualityGroup(new Object[]{this.graph.predecessors((Object)node), this.graph.successors((Object)node), this.graph.adjacentNodes((Object)node)}).testEquals();
        }
    }

    @Test
    public void predecessors_oneEdge() {
        this.putEdge(N1, N2);
        Truth.assertThat((Iterable)this.graph.predecessors((Object)N2)).containsExactly(new Object[]{N1});
        Truth.assertThat((Iterable)this.graph.predecessors((Object)N1)).containsExactly(new Object[]{N2});
    }

    @Test
    public void successors_oneEdge() {
        this.putEdge(N1, N2);
        Truth.assertThat((Iterable)this.graph.successors((Object)N1)).containsExactly(new Object[]{N2});
        Truth.assertThat((Iterable)this.graph.successors((Object)N2)).containsExactly(new Object[]{N1});
    }

    @Test
    public void inDegree_oneEdge() {
        this.putEdge(N1, N2);
        Truth.assertThat((Integer)this.graph.inDegree((Object)N2)).isEqualTo((Object)1);
        Truth.assertThat((Integer)this.graph.inDegree((Object)N1)).isEqualTo((Object)1);
    }

    @Test
    public void outDegree_oneEdge() {
        this.putEdge(N1, N2);
        Truth.assertThat((Integer)this.graph.outDegree((Object)N1)).isEqualTo((Object)1);
        Truth.assertThat((Integer)this.graph.outDegree((Object)N2)).isEqualTo((Object)1);
    }

    @Test
    public void addEdge_existingNodes() {
        this.addNode(N1);
        this.addNode(N2);
        Truth.assertThat((Boolean)this.putEdge(N1, N2)).isTrue();
    }

    @Test
    public void addEdge_existingEdgeBetweenSameNodes() {
        this.putEdge(N1, N2);
        Truth.assertThat((Boolean)this.putEdge(N2, N1)).isFalse();
    }

    @Test
    public void removeEdge_antiparallelEdges() {
        this.putEdge(N1, N2);
        this.putEdge(N2, N1);
        Truth.assertThat((Boolean)this.graph.removeEdge((Object)N1, (Object)N2)).isTrue();
        Truth.assertThat((Iterable)this.graph.adjacentNodes((Object)N1)).isEmpty();
        Truth.assertThat((Iterable)this.graph.edges()).isEmpty();
        Truth.assertThat((Boolean)this.graph.removeEdge((Object)N2, (Object)N1)).isFalse();
    }
}

