/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.collect.ImmutableSet;
import com.google.common.graph.ConfigurableSimpleDirectedNetworkTest;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.NetworkBuilder;
import com.google.common.truth.Truth;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ConfigurableDirectedNetworkTest
extends ConfigurableSimpleDirectedNetworkTest {
    @Override
    public MutableNetwork<Integer, String> createGraph() {
        return NetworkBuilder.directed().allowsSelfLoops(true).build();
    }

    @Test
    public void edges_selfLoop() {
        this.addEdge(N1, N1, "1-1");
        Truth.assertThat((Iterable)this.network.edges()).containsExactly(new Object[]{"1-1"});
    }

    @Test
    public void incidentEdges_selfLoop() {
        this.addEdge(N1, N1, "1-1");
        Truth.assertThat((Iterable)this.network.incidentEdges((Object)N1)).containsExactly(new Object[]{"1-1"});
    }

    @Test
    public void incidentNodes_selfLoop() {
        this.addEdge(N1, N1, "1-1");
        Truth.assertThat((Integer)((Integer)this.network.incidentNodes((Object)"1-1").source())).isEqualTo((Object)N1);
        Truth.assertThat((Integer)((Integer)this.network.incidentNodes((Object)"1-1").target())).isEqualTo((Object)N1);
    }

    @Test
    public void adjacentNodes_selfLoop() {
        this.addEdge(N1, N1, "1-1");
        this.addEdge(N1, N2, "1-2");
        Truth.assertThat((Iterable)this.network.adjacentNodes((Object)N1)).containsExactly(new Object[]{N1, N2});
    }

    @Test
    public void adjacentEdges_selfLoop() {
        this.addEdge(N1, N1, "1-1");
        this.addEdge(N1, N2, "1-2");
        Truth.assertThat((Iterable)this.network.adjacentEdges((Object)"1-1")).containsExactly(new Object[]{"1-2"});
    }

    @Test
    public void edgesConnecting_selfLoop() {
        this.addEdge(N1, N1, "1-1");
        Truth.assertThat((Iterable)this.network.edgesConnecting((Object)N1, (Object)N1)).containsExactly(new Object[]{"1-1"});
        this.addEdge(N1, N2, "1-2");
        Truth.assertThat((Iterable)this.network.edgesConnecting((Object)N1, (Object)N2)).containsExactly(new Object[]{"1-2"});
        Truth.assertThat((Iterable)this.network.edgesConnecting((Object)N1, (Object)N1)).containsExactly(new Object[]{"1-1"});
    }

    @Test
    public void inEdges_selfLoop() {
        this.addEdge(N1, N1, "1-1");
        Truth.assertThat((Iterable)this.network.inEdges((Object)N1)).containsExactly(new Object[]{"1-1"});
        this.addEdge(N4, N1, "4-1");
        Truth.assertThat((Iterable)this.network.inEdges((Object)N1)).containsExactly(new Object[]{"1-1", "4-1"});
    }

    @Test
    public void outEdges_selfLoop() {
        this.addEdge(N1, N1, "1-1");
        Truth.assertThat((Iterable)this.network.outEdges((Object)N1)).containsExactly(new Object[]{"1-1"});
        this.addEdge(N1, N2, "1-2");
        Truth.assertThat((Iterable)this.network.outEdges((Object)N1)).containsExactly(new Object[]{"1-1", "1-2"});
    }

    @Test
    public void predecessors_selfLoop() {
        this.addEdge(N1, N1, "1-1");
        Truth.assertThat((Iterable)this.network.predecessors((Object)N1)).containsExactly(new Object[]{N1});
        this.addEdge(N4, N1, "4-1");
        Truth.assertThat((Iterable)this.network.predecessors((Object)N1)).containsExactly(new Object[]{N1, N4});
    }

    @Test
    public void successors_selfLoop() {
        this.addEdge(N1, N1, "1-1");
        Truth.assertThat((Iterable)this.network.successors((Object)N1)).containsExactly(new Object[]{N1});
        this.addEdge(N1, N2, "1-2");
        Truth.assertThat((Iterable)this.network.successors((Object)N1)).containsExactly(new Object[]{N1, N2});
    }

    @Test
    public void source_selfLoop() {
        this.addEdge(N1, N1, "1-1");
        Truth.assertThat((Integer)((Integer)this.network.incidentNodes((Object)"1-1").source())).isEqualTo((Object)N1);
    }

    @Test
    public void target_selfLoop() {
        this.addEdge(N1, N1, "1-1");
        Truth.assertThat((Integer)((Integer)this.network.incidentNodes((Object)"1-1").target())).isEqualTo((Object)N1);
    }

    @Test
    public void degree_selfLoop() {
        this.addEdge(N1, N1, "1-1");
        Truth.assertThat((Integer)this.network.degree((Object)N1)).isEqualTo((Object)2);
        this.addEdge(N1, N2, "1-2");
        Truth.assertThat((Integer)this.network.degree((Object)N1)).isEqualTo((Object)3);
    }

    @Test
    public void inDegree_selfLoop() {
        this.addEdge(N1, N1, "1-1");
        Truth.assertThat((Integer)this.network.inDegree((Object)N1)).isEqualTo((Object)1);
        this.addEdge(N4, N1, "4-1");
        Truth.assertThat((Integer)this.network.inDegree((Object)N1)).isEqualTo((Object)2);
    }

    @Test
    public void outDegree_selfLoop() {
        this.addEdge(N1, N1, "1-1");
        Truth.assertThat((Integer)this.network.outDegree((Object)N1)).isEqualTo((Object)1);
        this.addEdge(N1, N2, "1-2");
        Truth.assertThat((Integer)this.network.outDegree((Object)N1)).isEqualTo((Object)2);
    }

    @Override
    @Test
    public void addEdge_selfLoop() {
        Truth.assertThat((Boolean)this.addEdge(N1, N1, "1-1")).isTrue();
        Truth.assertThat((Iterable)this.network.edges()).contains((Object)"1-1");
        Truth.assertThat((Iterable)this.network.edgesConnecting((Object)N1, (Object)N1)).containsExactly(new Object[]{"1-1"});
    }

    @Test
    public void addEdge_existingSelfLoopEdgeBetweenSameNodes() {
        this.addEdge(N1, N1, "1-1");
        ImmutableSet edges = ImmutableSet.copyOf((Collection)this.network.edges());
        Truth.assertThat((Boolean)this.addEdge(N1, N1, "1-1")).isFalse();
        Truth.assertThat((Iterable)this.network.edges()).containsExactlyElementsIn((Iterable)edges);
    }

    @Test
    public void addEdge_existingEdgeBetweenDifferentNodes_selfLoops() {
        this.addEdge(N1, N1, "1-1");
        try {
            this.addEdge(N1, N2, "1-1");
            Assert.fail((String)"Reusing an existing self-loop edge to connect different nodes succeeded");
        }
        catch (IllegalArgumentException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"it cannot be reused to connect");
        }
        try {
            this.addEdge(N2, N2, "1-1");
            Assert.fail((String)"Reusing an existing self-loop edge to make a different self-loop edge succeeded");
        }
        catch (IllegalArgumentException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"it cannot be reused to connect");
        }
        this.addEdge(N1, N2, "1-2");
        try {
            this.addEdge(N1, N1, "1-2");
            Assert.fail((String)"Reusing an existing edge to add a self-loop edge between different nodes succeeded");
        }
        catch (IllegalArgumentException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"it cannot be reused to connect");
        }
    }

    @Test
    public void addEdge_parallelSelfLoopEdge() {
        this.addEdge(N1, N1, "1-1");
        try {
            this.addEdge(N1, N1, "edgeNotInGraph");
            Assert.fail((String)"Adding a parallel self-loop edge succeeded");
        }
        catch (IllegalArgumentException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"connected by a different edge");
        }
    }

    @Test
    public void removeNode_existingNodeWithSelfLoopEdge() {
        this.addNode(N1);
        this.addEdge(N1, N1, "1-1");
        Truth.assertThat((Boolean)this.network.removeNode((Object)N1)).isTrue();
        Truth.assertThat((Iterable)this.network.nodes()).isEmpty();
        Truth.assertThat((Iterable)this.network.edges()).doesNotContain((Object)"1-1");
    }

    @Test
    public void removeEdge_existingSelfLoopEdge() {
        this.addEdge(N1, N1, "1-1");
        Truth.assertThat((Boolean)this.network.removeEdge((Object)"1-1")).isTrue();
        Truth.assertThat((Iterable)this.network.edges()).doesNotContain((Object)"1-1");
        Truth.assertThat((Iterable)this.network.edgesConnecting((Object)N1, (Object)N1)).isEmpty();
    }
}

