/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.graph.AbstractUndirectedGraphTest;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.google.common.truth.Truth;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ConfigurableSimpleUndirectedGraphTest
extends AbstractUndirectedGraphTest {
    @Override
    public MutableGraph<Integer> createGraph() {
        return GraphBuilder.undirected().allowsSelfLoops(false).build();
    }

    @Override
    @Test
    public void nodes_checkReturnedSetMutability() {
        Set nodes = this.graph.nodes();
        try {
            nodes.add(N2);
            Assert.fail((String)"Set returned is unexpectedly modifiable");
        }
        catch (UnsupportedOperationException e) {
            this.addNode(N1);
            Truth.assertThat((Iterable)this.graph.nodes()).containsExactlyElementsIn((Iterable)nodes);
        }
    }

    @Override
    @Test
    public void adjacentNodes_checkReturnedSetMutability() {
        this.addNode(N1);
        Set adjacentNodes = this.graph.adjacentNodes((Object)N1);
        try {
            adjacentNodes.add(N2);
            Assert.fail((String)"Set returned is unexpectedly modifiable");
        }
        catch (UnsupportedOperationException e) {
            this.putEdge(N1, N2);
            Truth.assertThat((Iterable)this.graph.adjacentNodes((Object)N1)).containsExactlyElementsIn((Iterable)adjacentNodes);
        }
    }

    @Override
    @Test
    public void predecessors_checkReturnedSetMutability() {
        this.addNode(N2);
        Set predecessors = this.graph.predecessors((Object)N2);
        try {
            predecessors.add(N1);
            Assert.fail((String)"Set returned is unexpectedly modifiable");
        }
        catch (UnsupportedOperationException e) {
            this.putEdge(N1, N2);
            Truth.assertThat((Iterable)this.graph.predecessors((Object)N2)).containsExactlyElementsIn((Iterable)predecessors);
        }
    }

    @Override
    @Test
    public void successors_checkReturnedSetMutability() {
        this.addNode(N1);
        Set successors = this.graph.successors((Object)N1);
        try {
            successors.add(N2);
            Assert.fail((String)"Set returned is unexpectedly modifiable");
        }
        catch (UnsupportedOperationException e) {
            this.putEdge(N1, N2);
            Truth.assertThat((Iterable)this.graph.successors((Object)N1)).containsExactlyElementsIn((Iterable)successors);
        }
    }

    @Test
    public void addEdge_selfLoop() {
        try {
            this.putEdge(N1, N1);
            Assert.fail((String)"Should not be allowed to add a self-loop edge.");
        }
        catch (IllegalArgumentException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"self-loops are not allowed");
        }
    }

    @Test
    public void addEdge_nodesNotInGraph() {
        this.graph.addNode((Object)N1);
        Assert.assertTrue((boolean)this.graph.putEdge((Object)N1, (Object)N5));
        Assert.assertTrue((boolean)this.graph.putEdge((Object)N4, (Object)N1));
        Assert.assertTrue((boolean)this.graph.putEdge((Object)N2, (Object)N3));
        Truth.assertThat((Iterable)this.graph.nodes()).containsExactly(new Object[]{N1, N5, N4, N2, N3}).inOrder();
        Truth.assertThat((Iterable)this.graph.adjacentNodes((Object)N1)).containsExactly(new Object[]{N4, N5});
        Truth.assertThat((Iterable)this.graph.adjacentNodes((Object)N2)).containsExactly(new Object[]{N3});
        Truth.assertThat((Iterable)this.graph.adjacentNodes((Object)N3)).containsExactly(new Object[]{N2});
        Truth.assertThat((Iterable)this.graph.adjacentNodes((Object)N4)).containsExactly(new Object[]{N1});
        Truth.assertThat((Iterable)this.graph.adjacentNodes((Object)N5)).containsExactly(new Object[]{N1});
    }
}

