/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.NetworkBuilder;
import com.google.common.testing.EqualsTester;
import com.google.common.truth.Truth;
import java.util.Collection;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public final class EndpointPairTest {
    private static final Integer N0 = 0;
    private static final Integer N1 = 1;
    private static final Integer N2 = 2;
    private static final Integer N3 = 3;
    private static final Integer N4 = 4;
    private static final String E12 = "1-2";
    private static final String E12_A = "1-2a";
    private static final String E21 = "2-1";
    private static final String E13 = "1-3";
    private static final String E44 = "4-4";

    @Test
    public void testOrderedEndpointPair() {
        EndpointPair ordered = EndpointPair.ordered((Object)"source", (Object)"target");
        Truth.assertThat((Boolean)ordered.isOrdered()).isTrue();
        Truth.assertThat((Iterable)ordered).containsExactly(new Object[]{"source", "target"}).inOrder();
        Truth.assertThat((String)((String)ordered.source())).isEqualTo((Object)"source");
        Truth.assertThat((String)((String)ordered.target())).isEqualTo((Object)"target");
        Truth.assertThat((String)((String)ordered.nodeU())).isEqualTo((Object)"source");
        Truth.assertThat((String)((String)ordered.nodeV())).isEqualTo((Object)"target");
        Truth.assertThat((String)((String)ordered.adjacentNode((Object)"source"))).isEqualTo((Object)"target");
        Truth.assertThat((String)((String)ordered.adjacentNode((Object)"target"))).isEqualTo((Object)"source");
        Truth.assertThat((String)ordered.toString()).isEqualTo((Object)"<source -> target>");
    }

    @Test
    public void testUnorderedEndpointPair() {
        EndpointPair unordered = EndpointPair.unordered((Object)"chicken", (Object)"egg");
        Truth.assertThat((Boolean)unordered.isOrdered()).isFalse();
        Truth.assertThat((Iterable)unordered).containsExactly(new Object[]{"chicken", "egg"});
        Truth.assertThat((Iterable)ImmutableSet.of((Object)unordered.nodeU(), (Object)unordered.nodeV())).containsExactly(new Object[]{"chicken", "egg"});
        Truth.assertThat((String)((String)unordered.adjacentNode(unordered.nodeU()))).isEqualTo(unordered.nodeV());
        Truth.assertThat((String)((String)unordered.adjacentNode(unordered.nodeV()))).isEqualTo(unordered.nodeU());
        Truth.assertThat((String)unordered.toString()).contains((CharSequence)"chicken");
        Truth.assertThat((String)unordered.toString()).contains((CharSequence)"egg");
    }

    @Test
    public void testSelfLoop() {
        EndpointPair unordered = EndpointPair.unordered((Object)"node", (Object)"node");
        Truth.assertThat((Boolean)unordered.isOrdered()).isFalse();
        Truth.assertThat((Iterable)unordered).containsExactly(new Object[]{"node", "node"});
        Truth.assertThat((String)((String)unordered.nodeU())).isEqualTo((Object)"node");
        Truth.assertThat((String)((String)unordered.nodeV())).isEqualTo((Object)"node");
        Truth.assertThat((String)((String)unordered.adjacentNode((Object)"node"))).isEqualTo((Object)"node");
        Truth.assertThat((String)unordered.toString()).isEqualTo((Object)"[node, node]");
    }

    @Test
    public void testAdjacentNode_nodeNotIncident() {
        ImmutableList testNetworks = ImmutableList.of((Object)NetworkBuilder.directed().build(), (Object)NetworkBuilder.undirected().build());
        for (MutableNetwork network : testNetworks) {
            network.addEdge((Object)1, (Object)2, (Object)E12);
            EndpointPair endpointPair = network.incidentNodes((Object)E12);
            try {
                endpointPair.adjacentNode((Object)3);
                Assert.fail((String)"Should have rejected adjacentNode() called with a node not incident to edge.");
            }
            catch (IllegalArgumentException expected) {}
        }
    }

    @Test
    public void testEquals() {
        EndpointPair ordered = EndpointPair.ordered((Object)"a", (Object)"b");
        EndpointPair orderedMirror = EndpointPair.ordered((Object)"b", (Object)"a");
        EndpointPair unordered = EndpointPair.unordered((Object)"a", (Object)"b");
        EndpointPair unorderedMirror = EndpointPair.unordered((Object)"b", (Object)"a");
        new EqualsTester().addEqualityGroup(new Object[]{ordered}).addEqualityGroup(new Object[]{orderedMirror}).addEqualityGroup(new Object[]{unordered, unorderedMirror}).testEquals();
    }

    @Test
    public void endpointPair_directedGraph() {
        MutableGraph directedGraph = GraphBuilder.directed().allowsSelfLoops(true).build();
        directedGraph.addNode((Object)N0);
        directedGraph.putEdge((Object)N1, (Object)N2);
        directedGraph.putEdge((Object)N2, (Object)N1);
        directedGraph.putEdge((Object)N1, (Object)N3);
        directedGraph.putEdge((Object)N4, (Object)N4);
        EndpointPairTest.containsExactlySanityCheck(directedGraph.edges(), EndpointPair.ordered((Object)N1, (Object)N2), EndpointPair.ordered((Object)N2, (Object)N1), EndpointPair.ordered((Object)N1, (Object)N3), EndpointPair.ordered((Object)N4, (Object)N4));
    }

    @Test
    public void endpointPair_undirectedGraph() {
        MutableGraph undirectedGraph = GraphBuilder.undirected().allowsSelfLoops(true).build();
        undirectedGraph.addNode((Object)N0);
        undirectedGraph.putEdge((Object)N1, (Object)N2);
        undirectedGraph.putEdge((Object)N2, (Object)N1);
        undirectedGraph.putEdge((Object)N1, (Object)N3);
        undirectedGraph.putEdge((Object)N4, (Object)N4);
        EndpointPairTest.containsExactlySanityCheck(undirectedGraph.edges(), EndpointPair.unordered((Object)N1, (Object)N2), EndpointPair.unordered((Object)N1, (Object)N3), EndpointPair.unordered((Object)N4, (Object)N4));
    }

    @Test
    public void endpointPair_directedNetwork() {
        MutableNetwork directedNetwork = NetworkBuilder.directed().allowsSelfLoops(true).build();
        directedNetwork.addNode((Object)N0);
        directedNetwork.addEdge((Object)N1, (Object)N2, (Object)E12);
        directedNetwork.addEdge((Object)N2, (Object)N1, (Object)E21);
        directedNetwork.addEdge((Object)N1, (Object)N3, (Object)E13);
        directedNetwork.addEdge((Object)N4, (Object)N4, (Object)E44);
        EndpointPairTest.containsExactlySanityCheck(directedNetwork.asGraph().edges(), EndpointPair.ordered((Object)N1, (Object)N2), EndpointPair.ordered((Object)N2, (Object)N1), EndpointPair.ordered((Object)N1, (Object)N3), EndpointPair.ordered((Object)N4, (Object)N4));
    }

    @Test
    public void endpointPair_undirectedNetwork() {
        MutableNetwork undirectedNetwork = NetworkBuilder.undirected().allowsParallelEdges(true).allowsSelfLoops(true).build();
        undirectedNetwork.addNode((Object)N0);
        undirectedNetwork.addEdge((Object)N1, (Object)N2, (Object)E12);
        undirectedNetwork.addEdge((Object)N2, (Object)N1, (Object)E12_A);
        undirectedNetwork.addEdge((Object)N1, (Object)N3, (Object)E13);
        undirectedNetwork.addEdge((Object)N4, (Object)N4, (Object)E44);
        EndpointPairTest.containsExactlySanityCheck(undirectedNetwork.asGraph().edges(), EndpointPair.unordered((Object)N1, (Object)N2), EndpointPair.unordered((Object)N1, (Object)N3), EndpointPair.unordered((Object)N4, (Object)N4));
    }

    @Test
    public void endpointPair_unmodifiableView() {
        MutableGraph directedGraph = GraphBuilder.directed().build();
        Set edges = directedGraph.edges();
        directedGraph.putEdge((Object)N1, (Object)N2);
        EndpointPairTest.containsExactlySanityCheck(edges, EndpointPair.ordered((Object)N1, (Object)N2));
        directedGraph.putEdge((Object)N2, (Object)N1);
        EndpointPairTest.containsExactlySanityCheck(edges, EndpointPair.ordered((Object)N1, (Object)N2), EndpointPair.ordered((Object)N2, (Object)N1));
        directedGraph.removeEdge((Object)N1, (Object)N2);
        directedGraph.removeEdge((Object)N2, (Object)N1);
        EndpointPairTest.containsExactlySanityCheck(edges, new Object[0]);
        try {
            edges.add(EndpointPair.ordered((Object)N1, (Object)N2));
            Assert.fail((String)"Set returned by edges() should be unmodifiable");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void endpointPair_containment() {
        MutableGraph undirectedGraph = GraphBuilder.undirected().allowsSelfLoops(true).build();
        undirectedGraph.putEdge((Object)N1, (Object)N1);
        undirectedGraph.putEdge((Object)N1, (Object)N2);
        Set edges = undirectedGraph.edges();
        Truth.assertThat((Iterable)edges).hasSize(2);
        Truth.assertThat((Iterable)edges).contains((Object)EndpointPair.unordered((Object)N1, (Object)N1));
        Truth.assertThat((Iterable)edges).contains((Object)EndpointPair.unordered((Object)N1, (Object)N2));
        Truth.assertThat((Iterable)edges).contains((Object)EndpointPair.unordered((Object)N2, (Object)N1));
        Truth.assertThat((Iterable)edges).doesNotContain((Object)EndpointPair.unordered((Object)N2, (Object)N2));
        Truth.assertThat((Iterable)edges).doesNotContain((Object)EndpointPair.ordered((Object)N1, (Object)N2));
        Truth.assertThat((Iterable)edges).doesNotContain((Object)EndpointPair.unordered((Object)N3, (Object)N4));
    }

    private static void containsExactlySanityCheck(Collection<?> collection, Object ... varargs) {
        Truth.assertThat(collection).hasSize(varargs.length);
        for (Object obj : varargs) {
            Truth.assertThat(collection).contains(obj);
        }
        Truth.assertThat(collection).containsExactly(varargs);
    }
}

