/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.collect.ImmutableList;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.Graphs;
import com.google.common.graph.MutableGraph;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import com.google.common.truth.Truth;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GraphPropertiesTest {
    ImmutableList<MutableGraph<Integer>> graphsToTest;
    Graph<Integer> directedGraph;
    Graph<Integer> undirectedGraph;
    ImmutableList<MutableNetwork<Integer, String>> networksToTest;
    Network<Integer, String> directedNetwork;
    Network<Integer, String> undirectedNetwork;

    @Before
    public void init() {
        MutableGraph mutableDirectedGraph = GraphBuilder.directed().allowsSelfLoops(true).build();
        MutableGraph mutableUndirectedGraph = GraphBuilder.undirected().allowsSelfLoops(true).build();
        this.graphsToTest = ImmutableList.of((Object)mutableDirectedGraph, (Object)mutableUndirectedGraph);
        this.directedGraph = mutableDirectedGraph;
        this.undirectedGraph = mutableUndirectedGraph;
        MutableNetwork mutableDirectedNetwork = NetworkBuilder.directed().allowsParallelEdges(true).allowsSelfLoops(true).build();
        MutableNetwork mutableUndirectedNetwork = NetworkBuilder.undirected().allowsParallelEdges(true).allowsSelfLoops(true).build();
        this.networksToTest = ImmutableList.of((Object)mutableDirectedNetwork, (Object)mutableUndirectedNetwork);
        this.directedNetwork = mutableDirectedNetwork;
        this.undirectedNetwork = mutableUndirectedNetwork;
    }

    @Test
    public void hasCycle_emptyGraph() {
        Truth.assertThat((Boolean)Graphs.hasCycle(this.directedGraph)).isFalse();
        Truth.assertThat((Boolean)Graphs.hasCycle(this.undirectedGraph)).isFalse();
    }

    @Test
    public void hasCycle_isolatedNodes() {
        for (MutableGraph graph : this.graphsToTest) {
            graph.addNode((Object)1);
            graph.addNode((Object)2);
        }
        Truth.assertThat((Boolean)Graphs.hasCycle(this.directedGraph)).isFalse();
        Truth.assertThat((Boolean)Graphs.hasCycle(this.undirectedGraph)).isFalse();
    }

    @Test
    public void hasCycle_oneEdge() {
        for (MutableGraph graph : this.graphsToTest) {
            graph.putEdge((Object)1, (Object)2);
        }
        Truth.assertThat((Boolean)Graphs.hasCycle(this.directedGraph)).isFalse();
        Truth.assertThat((Boolean)Graphs.hasCycle(this.undirectedGraph)).isFalse();
    }

    @Test
    public void hasCycle_selfLoopEdge() {
        for (MutableGraph graph : this.graphsToTest) {
            graph.putEdge((Object)1, (Object)1);
        }
        Truth.assertThat((Boolean)Graphs.hasCycle(this.directedGraph)).isTrue();
        Truth.assertThat((Boolean)Graphs.hasCycle(this.undirectedGraph)).isTrue();
    }

    @Test
    public void hasCycle_twoAcyclicEdges() {
        for (MutableGraph graph : this.graphsToTest) {
            graph.putEdge((Object)1, (Object)2);
            graph.putEdge((Object)1, (Object)3);
        }
        Truth.assertThat((Boolean)Graphs.hasCycle(this.directedGraph)).isFalse();
        Truth.assertThat((Boolean)Graphs.hasCycle(this.undirectedGraph)).isFalse();
    }

    @Test
    public void hasCycle_twoCyclicEdges() {
        for (MutableGraph graph : this.graphsToTest) {
            graph.putEdge((Object)1, (Object)2);
            graph.putEdge((Object)2, (Object)1);
        }
        Truth.assertThat((Boolean)Graphs.hasCycle(this.directedGraph)).isTrue();
        Truth.assertThat((Boolean)Graphs.hasCycle(this.undirectedGraph)).isFalse();
    }

    @Test
    public void hasCycle_threeAcyclicEdges() {
        for (MutableGraph graph : this.graphsToTest) {
            graph.putEdge((Object)1, (Object)2);
            graph.putEdge((Object)2, (Object)3);
            graph.putEdge((Object)1, (Object)3);
        }
        Truth.assertThat((Boolean)Graphs.hasCycle(this.directedGraph)).isFalse();
        Truth.assertThat((Boolean)Graphs.hasCycle(this.undirectedGraph)).isTrue();
    }

    @Test
    public void hasCycle_threeCyclicEdges() {
        for (MutableGraph graph : this.graphsToTest) {
            graph.putEdge((Object)1, (Object)2);
            graph.putEdge((Object)2, (Object)3);
            graph.putEdge((Object)3, (Object)1);
        }
        Truth.assertThat((Boolean)Graphs.hasCycle(this.directedGraph)).isTrue();
        Truth.assertThat((Boolean)Graphs.hasCycle(this.undirectedGraph)).isTrue();
    }

    @Test
    public void hasCycle_disconnectedCyclicGraph() {
        for (MutableGraph graph : this.graphsToTest) {
            graph.putEdge((Object)1, (Object)2);
            graph.putEdge((Object)2, (Object)1);
            graph.addNode((Object)3);
        }
        Truth.assertThat((Boolean)Graphs.hasCycle(this.directedGraph)).isTrue();
        Truth.assertThat((Boolean)Graphs.hasCycle(this.undirectedGraph)).isFalse();
    }

    @Test
    public void hasCycle_multipleCycles() {
        for (MutableGraph graph : this.graphsToTest) {
            graph.putEdge((Object)1, (Object)2);
            graph.putEdge((Object)2, (Object)1);
            graph.putEdge((Object)2, (Object)3);
            graph.putEdge((Object)3, (Object)1);
        }
        Truth.assertThat((Boolean)Graphs.hasCycle(this.directedGraph)).isTrue();
        Truth.assertThat((Boolean)Graphs.hasCycle(this.undirectedGraph)).isTrue();
    }

    @Test
    public void hasCycle_twoParallelEdges() {
        for (MutableNetwork network : this.networksToTest) {
            network.addEdge((Object)1, (Object)2, (Object)"1-2a");
            network.addEdge((Object)1, (Object)2, (Object)"1-2b");
        }
        Truth.assertThat((Boolean)Graphs.hasCycle(this.directedNetwork)).isFalse();
        Truth.assertThat((Boolean)Graphs.hasCycle(this.undirectedNetwork)).isTrue();
    }

    @Test
    public void hasCycle_cyclicMultigraph() {
        for (MutableNetwork network : this.networksToTest) {
            network.addEdge((Object)1, (Object)2, (Object)"1-2a");
            network.addEdge((Object)1, (Object)2, (Object)"1-2b");
            network.addEdge((Object)2, (Object)3, (Object)"2-3");
            network.addEdge((Object)3, (Object)1, (Object)"3-1");
        }
        Truth.assertThat((Boolean)Graphs.hasCycle(this.directedNetwork)).isTrue();
        Truth.assertThat((Boolean)Graphs.hasCycle(this.undirectedNetwork)).isTrue();
    }
}

