/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.Graphs;
import com.google.common.graph.ImmutableGraph;
import com.google.common.graph.ImmutableValueGraph;
import com.google.common.graph.MutableGraph;
import com.google.common.graph.MutableValueGraph;
import com.google.common.graph.ValueGraph;
import com.google.common.graph.ValueGraphBuilder;
import com.google.common.truth.Truth;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ImmutableGraphTest {
    @Test
    public void immutableGraph() {
        MutableGraph mutableGraph = GraphBuilder.directed().build();
        mutableGraph.addNode((Object)"A");
        ImmutableGraph immutableGraph = ImmutableGraph.copyOf((Graph)mutableGraph);
        Truth.assertThat((Object)immutableGraph).isNotInstanceOf(MutableGraph.class);
        Truth.assertThat((Boolean)Graphs.equivalent((Graph)immutableGraph, (Graph)mutableGraph)).isTrue();
        mutableGraph.addNode((Object)"B");
        Truth.assertThat((Boolean)Graphs.equivalent((Graph)immutableGraph, (Graph)mutableGraph)).isFalse();
    }

    @Test
    public void immutableValueGraph() {
        MutableValueGraph mutableGraph = ValueGraphBuilder.directed().build();
        mutableGraph.addNode((Object)"A");
        ImmutableValueGraph immutableGraph = ImmutableValueGraph.copyOf((ValueGraph)mutableGraph);
        Truth.assertThat((Object)immutableGraph).isInstanceOf(ImmutableGraph.class);
        Truth.assertThat((Object)immutableGraph).isNotInstanceOf(MutableValueGraph.class);
        Truth.assertThat((Boolean)Graphs.equivalent((ValueGraph)immutableGraph, (ValueGraph)mutableGraph)).isTrue();
        mutableGraph.addNode((Object)"B");
        Truth.assertThat((Boolean)Graphs.equivalent((ValueGraph)immutableGraph, (ValueGraph)mutableGraph)).isFalse();
    }

    @Test
    public void copyOfImmutableGraph_optimized() {
        ImmutableGraph graph1 = ImmutableGraph.copyOf((Graph)GraphBuilder.directed().build());
        ImmutableGraph graph2 = ImmutableGraph.copyOf((Graph)graph1);
        Truth.assertThat((Object)graph2).isSameAs((Object)graph1);
    }

    @Test
    public void copyOfImmutableValueGraph_optimized() {
        ImmutableValueGraph graph1 = ImmutableValueGraph.copyOf((ValueGraph)ValueGraphBuilder.directed().build());
        ImmutableValueGraph graph2 = ImmutableValueGraph.copyOf((ValueGraph)graph1);
        Truth.assertThat((Object)graph2).isSameAs((Object)graph1);
    }
}

