/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.graph.Graph;
import com.google.common.graph.Graphs;
import com.google.common.graph.Network;
import com.google.common.graph.ValueGraph;
import com.google.common.truth.Truth;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Set;

final class TestUtil {
    private TestUtil() {
    }

    static void assertStronglyEquivalent(Graph<?> graphA, Graph<?> graphB) {
        Truth.assertThat((Boolean)graphA.allowsSelfLoops()).isEqualTo((Object)graphB.allowsSelfLoops());
        Truth.assertThat((Object)graphA.nodeOrder()).isEqualTo((Object)graphB.nodeOrder());
        Truth.assertThat((Boolean)Graphs.equivalent(graphA, graphB)).isTrue();
    }

    static void assertStronglyEquivalent(ValueGraph<?, ?> graphA, ValueGraph<?, ?> graphB) {
        Truth.assertThat((Boolean)graphA.allowsSelfLoops()).isEqualTo((Object)graphB.allowsSelfLoops());
        Truth.assertThat((Object)graphA.nodeOrder()).isEqualTo((Object)graphB.nodeOrder());
        Truth.assertThat((Boolean)Graphs.equivalent(graphA, graphB)).isTrue();
    }

    static void assertStronglyEquivalent(Network<?, ?> networkA, Network<?, ?> networkB) {
        Truth.assertThat((Boolean)networkA.allowsParallelEdges()).isEqualTo((Object)networkB.allowsParallelEdges());
        Truth.assertThat((Boolean)networkA.allowsSelfLoops()).isEqualTo((Object)networkB.allowsSelfLoops());
        Truth.assertThat((Object)networkA.nodeOrder()).isEqualTo((Object)networkB.nodeOrder());
        Truth.assertThat((Object)networkA.edgeOrder()).isEqualTo((Object)networkB.edgeOrder());
        Truth.assertThat((Boolean)Graphs.equivalent(networkA, networkB)).isTrue();
    }

    @CanIgnoreReturnValue
    static <T> Set<T> sanityCheckSet(Set<T> set) {
        Truth.assertThat(set).hasSize(Iterators.size(set.iterator()));
        for (T element : set) {
            Truth.assertThat(set).contains(element);
        }
        Truth.assertThat(set).doesNotContain(new Object());
        Truth.assertThat(set).isEqualTo((Object)ImmutableSet.copyOf(set));
        return set;
    }
}

