/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.graph.AbstractGraphTest;
import com.google.common.graph.Graph;
import com.google.common.graph.Graphs;
import com.google.common.graph.ImmutableValueGraph;
import com.google.common.graph.MutableValueGraph;
import com.google.common.graph.TestUtil;
import com.google.common.graph.ValueGraph;
import com.google.common.graph.ValueGraphBuilder;
import com.google.common.truth.Truth;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public final class ValueGraphTest {
    MutableValueGraph<Integer, String> graph;

    @After
    public void validateGraphState() {
        TestUtil.assertStronglyEquivalent(this.graph, Graphs.copyOf(this.graph));
        TestUtil.assertStronglyEquivalent(this.graph, ImmutableValueGraph.copyOf(this.graph));
        for (Integer node : this.graph.nodes()) {
            for (Integer otherNode : this.graph.nodes()) {
                boolean connected = this.graph.successors((Object)node).contains(otherNode);
                Truth.assertThat((Boolean)(this.graph.edgeValueOrDefault((Object)node, (Object)otherNode, null) != null ? 1 : 0)).isEqualTo((Object)connected);
            }
        }
        AbstractGraphTest.validateGraph(this.graph);
    }

    @Test
    public void directedGraph() {
        this.graph = ValueGraphBuilder.directed().allowsSelfLoops(true).build();
        this.graph.putEdgeValue((Object)1, (Object)2, (Object)"valueA");
        this.graph.putEdgeValue((Object)2, (Object)1, (Object)"valueB");
        this.graph.putEdgeValue((Object)2, (Object)3, (Object)"valueC");
        this.graph.putEdgeValue((Object)4, (Object)4, (Object)"valueD");
        Truth.assertThat((String)((String)this.graph.edgeValue((Object)1, (Object)2))).isEqualTo((Object)"valueA");
        Truth.assertThat((String)((String)this.graph.edgeValue((Object)2, (Object)1))).isEqualTo((Object)"valueB");
        Truth.assertThat((String)((String)this.graph.edgeValue((Object)2, (Object)3))).isEqualTo((Object)"valueC");
        Truth.assertThat((String)((String)this.graph.edgeValue((Object)4, (Object)4))).isEqualTo((Object)"valueD");
        String toString = this.graph.toString();
        Truth.assertThat((String)toString).contains((CharSequence)"valueA");
        Truth.assertThat((String)toString).contains((CharSequence)"valueB");
        Truth.assertThat((String)toString).contains((CharSequence)"valueC");
        Truth.assertThat((String)toString).contains((CharSequence)"valueD");
    }

    @Test
    public void undirectedGraph() {
        this.graph = ValueGraphBuilder.undirected().allowsSelfLoops(true).build();
        this.graph.putEdgeValue((Object)1, (Object)2, (Object)"valueA");
        this.graph.putEdgeValue((Object)2, (Object)1, (Object)"valueB");
        this.graph.putEdgeValue((Object)2, (Object)3, (Object)"valueC");
        this.graph.putEdgeValue((Object)4, (Object)4, (Object)"valueD");
        Truth.assertThat((String)((String)this.graph.edgeValue((Object)1, (Object)2))).isEqualTo((Object)"valueB");
        Truth.assertThat((String)((String)this.graph.edgeValue((Object)2, (Object)1))).isEqualTo((Object)"valueB");
        Truth.assertThat((String)((String)this.graph.edgeValue((Object)2, (Object)3))).isEqualTo((Object)"valueC");
        Truth.assertThat((String)((String)this.graph.edgeValue((Object)4, (Object)4))).isEqualTo((Object)"valueD");
        String toString = this.graph.toString();
        Truth.assertThat((String)toString).doesNotContain((CharSequence)"valueA");
        Truth.assertThat((String)toString).contains((CharSequence)"valueB");
        Truth.assertThat((String)toString).contains((CharSequence)"valueC");
        Truth.assertThat((String)toString).contains((CharSequence)"valueD");
    }

    @Test
    public void putEdgeValue_directed() {
        this.graph = ValueGraphBuilder.directed().build();
        Truth.assertThat((String)((String)this.graph.putEdgeValue((Object)1, (Object)2, (Object)"valueA"))).isNull();
        Truth.assertThat((String)((String)this.graph.putEdgeValue((Object)2, (Object)1, (Object)"valueB"))).isNull();
        Truth.assertThat((String)((String)this.graph.putEdgeValue((Object)1, (Object)2, (Object)"valueC"))).isEqualTo((Object)"valueA");
        Truth.assertThat((String)((String)this.graph.putEdgeValue((Object)2, (Object)1, (Object)"valueD"))).isEqualTo((Object)"valueB");
    }

    @Test
    public void putEdgeValue_undirected() {
        this.graph = ValueGraphBuilder.undirected().build();
        Truth.assertThat((String)((String)this.graph.putEdgeValue((Object)1, (Object)2, (Object)"valueA"))).isNull();
        Truth.assertThat((String)((String)this.graph.putEdgeValue((Object)2, (Object)1, (Object)"valueB"))).isEqualTo((Object)"valueA");
        Truth.assertThat((String)((String)this.graph.putEdgeValue((Object)1, (Object)2, (Object)"valueC"))).isEqualTo((Object)"valueB");
        Truth.assertThat((String)((String)this.graph.putEdgeValue((Object)2, (Object)1, (Object)"valueD"))).isEqualTo((Object)"valueC");
    }

    @Test
    public void removeEdge_directed() {
        this.graph = ValueGraphBuilder.directed().build();
        this.graph.putEdgeValue((Object)1, (Object)2, (Object)"valueA");
        this.graph.putEdgeValue((Object)2, (Object)1, (Object)"valueB");
        this.graph.putEdgeValue((Object)2, (Object)3, (Object)"valueC");
        Truth.assertThat((String)((String)this.graph.removeEdge((Object)1, (Object)2))).isEqualTo((Object)"valueA");
        Truth.assertThat((String)((String)this.graph.removeEdge((Object)1, (Object)2))).isNull();
        Truth.assertThat((String)((String)this.graph.removeEdge((Object)2, (Object)1))).isEqualTo((Object)"valueB");
        Truth.assertThat((String)((String)this.graph.removeEdge((Object)2, (Object)1))).isNull();
        Truth.assertThat((String)((String)this.graph.removeEdge((Object)2, (Object)3))).isEqualTo((Object)"valueC");
        Truth.assertThat((String)((String)this.graph.removeEdge((Object)2, (Object)3))).isNull();
    }

    @Test
    public void removeEdge_undirected() {
        this.graph = ValueGraphBuilder.undirected().build();
        this.graph.putEdgeValue((Object)1, (Object)2, (Object)"valueA");
        this.graph.putEdgeValue((Object)2, (Object)1, (Object)"valueB");
        this.graph.putEdgeValue((Object)2, (Object)3, (Object)"valueC");
        Truth.assertThat((String)((String)this.graph.removeEdge((Object)1, (Object)2))).isEqualTo((Object)"valueB");
        Truth.assertThat((String)((String)this.graph.removeEdge((Object)1, (Object)2))).isNull();
        Truth.assertThat((String)((String)this.graph.removeEdge((Object)2, (Object)1))).isNull();
        Truth.assertThat((String)((String)this.graph.removeEdge((Object)2, (Object)3))).isEqualTo((Object)"valueC");
        Truth.assertThat((String)((String)this.graph.removeEdge((Object)2, (Object)3))).isNull();
    }

    @Test
    public void edgeValue_edgeNotPresent() {
        this.graph = ValueGraphBuilder.directed().build();
        this.graph.addNode((Object)1);
        this.graph.addNode((Object)2);
        try {
            this.graph.edgeValue((Object)2, (Object)1);
            Assert.fail((String)"Should have rejected edgeValue() if edge not present in graph.");
        }
        catch (IllegalArgumentException e) {
            Truth.assertThat((Throwable)e).hasMessage("Edge connecting 2 to 1 is not present in this graph.");
        }
    }

    @Test
    public void edgeValue_nodeNotPresent() {
        this.graph = ValueGraphBuilder.undirected().build();
        this.graph.putEdgeValue((Object)1, (Object)2, (Object)"value");
        try {
            this.graph.edgeValue((Object)2, (Object)3);
            Assert.fail((String)"Should have rejected edgeValue() if node not present in graph.");
        }
        catch (IllegalArgumentException e) {
            Truth.assertThat((Throwable)e).hasMessage("Node 3 is not an element of this graph.");
        }
    }

    @Test
    public void edgeValueOrDefault() {
        this.graph = ValueGraphBuilder.directed().build();
        Truth.assertThat((String)((String)this.graph.edgeValueOrDefault((Object)1, (Object)2, (Object)"default"))).isEqualTo((Object)"default");
        Truth.assertThat((String)((String)this.graph.edgeValueOrDefault((Object)2, (Object)1, (Object)"default"))).isEqualTo((Object)"default");
        this.graph.putEdgeValue((Object)1, (Object)2, (Object)"valueA");
        this.graph.putEdgeValue((Object)2, (Object)1, (Object)"valueB");
        Truth.assertThat((String)((String)this.graph.edgeValueOrDefault((Object)1, (Object)2, (Object)"default"))).isEqualTo((Object)"valueA");
        Truth.assertThat((String)((String)this.graph.edgeValueOrDefault((Object)2, (Object)1, (Object)"default"))).isEqualTo((Object)"valueB");
        this.graph.removeEdge((Object)1, (Object)2);
        this.graph.putEdgeValue((Object)2, (Object)1, (Object)"valueC");
        Truth.assertThat((String)((String)this.graph.edgeValueOrDefault((Object)1, (Object)2, (Object)"default"))).isEqualTo((Object)"default");
        Truth.assertThat((String)((String)this.graph.edgeValueOrDefault((Object)2, (Object)1, (Object)"default"))).isEqualTo((Object)"valueC");
    }

    @Test
    public void equivalence_considersEdgeValue() {
        this.graph = ValueGraphBuilder.undirected().build();
        this.graph.putEdgeValue((Object)1, (Object)2, (Object)"valueA");
        MutableValueGraph otherGraph = ValueGraphBuilder.undirected().build();
        otherGraph.putEdgeValue((Object)1, (Object)2, (Object)"valueA");
        Truth.assertThat((Boolean)Graphs.equivalent(this.graph, (ValueGraph)otherGraph)).isTrue();
        Truth.assertThat((Boolean)Graphs.equivalent(this.graph, (Graph)otherGraph)).isTrue();
        otherGraph.putEdgeValue((Object)1, (Object)2, (Object)"valueB");
        Truth.assertThat((Boolean)Graphs.equivalent(this.graph, (ValueGraph)otherGraph)).isFalse();
        Truth.assertThat((Boolean)Graphs.equivalent(this.graph, (Graph)otherGraph)).isTrue();
    }
}

