/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.util.Random;
import java.util.zip.Adler32;
import java.util.zip.CRC32;

public class ChecksumBenchmark {
    private static final int RANDOM_SEED = new Random().nextInt();
    @Param(value={"10", "1000", "100000", "1000000"})
    private int size;
    private byte[] testBytes;

    @BeforeExperiment
    void setUp() {
        this.testBytes = new byte[this.size];
        new Random(RANDOM_SEED).nextBytes(this.testBytes);
    }

    @Benchmark
    byte crc32HashFunction(int reps) {
        return this.runHashFunction(reps, Hashing.crc32());
    }

    @Benchmark
    byte crc32Checksum(int reps) throws Exception {
        byte result = 1;
        for (int i = 0; i < reps; ++i) {
            CRC32 checksum = new CRC32();
            checksum.update(this.testBytes);
            result = (byte)((long)result ^ checksum.getValue());
        }
        return result;
    }

    @Benchmark
    byte adler32HashFunction(int reps) {
        return this.runHashFunction(reps, Hashing.adler32());
    }

    @Benchmark
    byte adler32Checksum(int reps) throws Exception {
        byte result = 1;
        for (int i = 0; i < reps; ++i) {
            Adler32 checksum = new Adler32();
            checksum.update(this.testBytes);
            result = (byte)((long)result ^ checksum.getValue());
        }
        return result;
    }

    private byte runHashFunction(int reps, HashFunction hashFunction) {
        byte result = 1;
        result = (byte)(result ^ Hashing.crc32().hashInt(reps).asBytes()[0]);
        result = (byte)(result ^ Hashing.adler32().hashInt(reps).asBytes()[0]);
        for (int i = 0; i < reps; ++i) {
            result = (byte)(result ^ hashFunction.hashBytes(this.testBytes).asBytes()[0]);
        }
        return result;
    }
}

