/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.io.Flushables;
import java.io.Flushable;
import java.io.IOException;
import junit.framework.TestCase;
import org.mockito.Mockito;

public class FlushablesTest
extends TestCase {
    private Flushable mockFlushable;

    public void testFlush_clean() throws IOException {
        this.setupFlushable(false);
        this.doFlush(this.mockFlushable, false, false);
        this.setupFlushable(false);
        this.doFlush(this.mockFlushable, true, false);
    }

    public void testFlush_flushableWithEatenException() throws IOException {
        this.setupFlushable(true);
        this.doFlush(this.mockFlushable, true, false);
    }

    public void testFlush_flushableWithThrownException() throws IOException {
        this.setupFlushable(true);
        this.doFlush(this.mockFlushable, false, true);
    }

    public void testFlushQuietly_flushableWithEatenException() throws IOException {
        this.setupFlushable(true);
        Flushables.flushQuietly((Flushable)this.mockFlushable);
    }

    private void setupFlushable(boolean shouldThrowOnFlush) throws IOException {
        this.mockFlushable = (Flushable)Mockito.mock(Flushable.class);
        if (shouldThrowOnFlush) {
            ((Flushable)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("This should only appear in the logs. It should not be rethrown.")}).when((Object)this.mockFlushable)).flush();
        }
    }

    private void doFlush(Flushable flushable, boolean swallowException, boolean expectThrown) throws IOException {
        block3: {
            try {
                Flushables.flush((Flushable)flushable, (boolean)swallowException);
                if (expectThrown) {
                    FlushablesTest.fail((String)"Didn't throw exception.");
                }
            }
            catch (IOException e) {
                if (expectThrown) break block3;
                FlushablesTest.fail((String)"Threw exception");
            }
        }
        ((Flushable)Mockito.verify((Object)flushable)).flush();
    }
}

