/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.collect.Lists;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import com.google.common.io.IoTestCase;
import com.google.common.io.MultiInputStream;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;

public class MultiInputStreamTest
extends IoTestCase {
    public void testJoin() throws Exception {
        this.joinHelper(0);
        this.joinHelper(1);
        this.joinHelper(0, 0, 0);
        this.joinHelper(10, 20);
        this.joinHelper(10, 0, 20);
        this.joinHelper(0, 10, 20);
        this.joinHelper(10, 20, 0);
        this.joinHelper(10, 20, 1);
        this.joinHelper(1, 1, 1, 1, 1, 1, 1, 1);
        this.joinHelper(1, 0, 1, 0, 1, 0, 1, 0);
    }

    public void testOnlyOneOpen() throws Exception {
        final ByteSource source = MultiInputStreamTest.newByteSource(0, 50);
        final int[] counter = new int[1];
        ByteSource checker = new ByteSource(){

            public InputStream openStream() throws IOException {
                int n = counter[0];
                counter[0] = n + 1;
                if (n != 0) {
                    throw new IllegalStateException("More than one source open");
                }
                return new FilterInputStream(source.openStream()){

                    @Override
                    public void close() throws IOException {
                        super.close();
                        counter[0] = counter[0] - 1;
                    }
                };
            }
        };
        byte[] result = ByteSource.concat((ByteSource[])new ByteSource[]{checker, checker, checker}).read();
        MultiInputStreamTest.assertEquals((int)150, (int)result.length);
    }

    private void joinHelper(Integer ... spans) throws Exception {
        ArrayList sources = Lists.newArrayList();
        int start = 0;
        for (Integer span : spans) {
            sources.add(MultiInputStreamTest.newByteSource(start, span));
            start += span.intValue();
        }
        ByteSource joined = ByteSource.concat((Iterable)sources);
        MultiInputStreamTest.assertTrue((boolean)MultiInputStreamTest.newByteSource(0, start).contentEquals(joined));
    }

    public void testReadSingleByte() throws Exception {
        ByteSource source = MultiInputStreamTest.newByteSource(0, 10);
        ByteSource joined = ByteSource.concat((ByteSource[])new ByteSource[]{source, source});
        MultiInputStreamTest.assertEquals((long)20L, (long)joined.size());
        InputStream in = joined.openStream();
        MultiInputStreamTest.assertFalse((boolean)in.markSupported());
        MultiInputStreamTest.assertEquals((int)10, (int)in.available());
        int total = 0;
        while (in.read() != -1) {
            ++total;
        }
        MultiInputStreamTest.assertEquals((int)0, (int)in.available());
        MultiInputStreamTest.assertEquals((int)20, (int)total);
    }

    public void testSkip() throws Exception {
        MultiInputStream multi = new MultiInputStream(Collections.singleton(new ByteSource(){

            public InputStream openStream() {
                return new ByteArrayInputStream(IoTestCase.newPreFilledByteArray(0, 50)){

                    @Override
                    public long skip(long n) {
                        return 0L;
                    }
                };
            }
        }).iterator());
        MultiInputStreamTest.assertEquals((long)0L, (long)multi.skip(-1L));
        MultiInputStreamTest.assertEquals((long)0L, (long)multi.skip(-1L));
        MultiInputStreamTest.assertEquals((long)0L, (long)multi.skip(0L));
        ByteStreams.skipFully((InputStream)multi, (long)20L);
        MultiInputStreamTest.assertEquals((int)20, (int)multi.read());
    }

    private static ByteSource newByteSource(final int start, final int size) {
        return new ByteSource(){

            public InputStream openStream() {
                return new ByteArrayInputStream(IoTestCase.newPreFilledByteArray(start, size));
            }
        };
    }
}

