/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.math.AndroidIncompatible;
import com.google.common.math.DoubleUtils;
import com.google.common.math.MathTesting;
import java.math.BigInteger;
import junit.framework.TestCase;
import sun.misc.FpUtils;

public class DoubleUtilsTest
extends TestCase {
    @AndroidIncompatible
    public void testNextDown() {
        for (double d : MathTesting.FINITE_DOUBLE_CANDIDATES) {
            DoubleUtilsTest.assertEquals((Object)FpUtils.nextDown((double)d), (Object)DoubleUtils.nextDown((double)d));
        }
    }

    @AndroidIncompatible
    public void testBigToDouble() {
        for (BigInteger b : MathTesting.ALL_BIGINTEGER_CANDIDATES) {
            if (b.doubleValue() == DoubleUtils.bigToDouble((BigInteger)b)) continue;
            DoubleUtilsTest.failFormat("Converting %s to double: expected doubleValue %s but got bigToDouble %s", b, b.doubleValue(), DoubleUtils.bigToDouble((BigInteger)b));
        }
    }

    public void testEnsureNonNegative() {
        DoubleUtilsTest.assertEquals((Object)0.0, (Object)DoubleUtils.ensureNonNegative((double)0.0));
        for (double positiveValue : MathTesting.POSITIVE_FINITE_DOUBLE_CANDIDATES) {
            DoubleUtilsTest.assertEquals((Object)positiveValue, (Object)DoubleUtils.ensureNonNegative((double)positiveValue));
            DoubleUtilsTest.assertEquals((Object)0.0, (Object)DoubleUtils.ensureNonNegative((double)(-positiveValue)));
        }
        DoubleUtilsTest.assertEquals((Object)Double.POSITIVE_INFINITY, (Object)DoubleUtils.ensureNonNegative((double)Double.POSITIVE_INFINITY));
        DoubleUtilsTest.assertEquals((Object)0.0, (Object)DoubleUtils.ensureNonNegative((double)Double.NEGATIVE_INFINITY));
        try {
            DoubleUtils.ensureNonNegative((double)Double.NaN);
            DoubleUtilsTest.fail((String)"Expected IllegalArgumentException from ensureNonNegative(Double.NaN)");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static void failFormat(String template, Object ... args) {
        DoubleUtilsTest.fail((String)String.format(template, args));
    }
}

