/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.math.LinearTransformation;
import com.google.common.math.StatsTesting;
import com.google.common.truth.Truth;
import junit.framework.TestCase;

public class LinearTransformationTest
extends TestCase {
    private static final double ALLOWED_ERROR = 1.0E-10;

    public void testMappingAnd_regular() {
        double x1 = 1.2;
        double y1 = 3.4;
        double xDelta = 5.6;
        double yDelta = 7.8;
        LinearTransformation transformation = LinearTransformation.mapping((double)x1, (double)y1).and(x1 + xDelta, y1 + yDelta);
        StatsTesting.assertDiagonalLinearTransformation(transformation, x1, y1, xDelta, yDelta);
    }

    public void testMappingAnd_horizontal() {
        double x1 = 1.2;
        double xDelta = 3.4;
        double y = 5.6;
        LinearTransformation transformation = LinearTransformation.mapping((double)x1, (double)y).and(x1 + xDelta, y);
        StatsTesting.assertHorizontalLinearTransformation(transformation, y);
    }

    public void testMappingAnd_vertical() {
        double x = 1.2;
        double y1 = 3.4;
        double yDelta = 5.6;
        LinearTransformation transformation = LinearTransformation.mapping((double)x, (double)y1).and(x, y1 + yDelta);
        StatsTesting.assertVerticalLinearTransformation(transformation, x);
    }

    public void testMapping_infiniteX1() {
        try {
            LinearTransformation.mapping((double)Double.POSITIVE_INFINITY, (double)3.4);
            LinearTransformationTest.fail((String)"Expected IllegalArgumentException from mapping(x, y) with infinite x");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMapping_infiniteY1() {
        try {
            LinearTransformation.mapping((double)1.2, (double)Double.NEGATIVE_INFINITY);
            LinearTransformationTest.fail((String)"Expected IllegalArgumentException from mapping(x, y) with infinite y");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMappingAnd_infiniteX2() {
        try {
            LinearTransformation.mapping((double)1.2, (double)3.4).and(Double.NEGATIVE_INFINITY, 7.8);
            LinearTransformationTest.fail((String)"Expected IllegalArgumentException from and(x, y) with infinite x");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMappingAnd_infiniteY2() {
        try {
            LinearTransformation.mapping((double)1.2, (double)3.4).and(5.6, Double.POSITIVE_INFINITY);
            LinearTransformationTest.fail((String)"Expected IllegalArgumentException from and(x, y) with infinite y");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMapping_nanX1() {
        try {
            LinearTransformation.mapping((double)Double.NaN, (double)3.4);
            LinearTransformationTest.fail((String)"Expected IllegalArgumentException from mapping(x, y) with NaN x");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMapping_nanY1() {
        try {
            LinearTransformation.mapping((double)1.2, (double)Double.NaN);
            LinearTransformationTest.fail((String)"Expected IllegalArgumentException from mapping(x, y) with NaN y");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMappingAnd_nanX2() {
        try {
            LinearTransformation.mapping((double)1.2, (double)3.4).and(Double.NaN, 7.8);
            LinearTransformationTest.fail((String)"Expected IllegalArgumentException from and(x, y) with NaN x");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMappingAnd_nanY2() {
        try {
            LinearTransformation.mapping((double)1.2, (double)3.4).and(5.6, Double.NaN);
            LinearTransformationTest.fail((String)"Expected IllegalArgumentException from and(x, y) with NaN y");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMappingAnd_samePointTwice() {
        try {
            double x = 1.2;
            double y = 3.4;
            LinearTransformation.mapping((double)x, (double)y).and(x, y);
            LinearTransformationTest.fail((String)"Expected IllegalArgumentException from mapping(x1, y1).and(x2, y2) with (x1 == x2) && (y1 == y2)");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMappingWithSlope_regular() {
        double x1 = 1.2;
        double y1 = 3.4;
        double xDelta = -5.6;
        double slope = -7.8;
        LinearTransformation transformation = LinearTransformation.mapping((double)x1, (double)y1).withSlope(slope);
        StatsTesting.assertDiagonalLinearTransformation(transformation, x1, y1, xDelta, xDelta * slope);
    }

    public void testMappingWithSlope_horizontal() {
        double x1 = 1.2;
        double y = 5.6;
        LinearTransformation transformation = LinearTransformation.mapping((double)x1, (double)y).withSlope(0.0);
        StatsTesting.assertHorizontalLinearTransformation(transformation, y);
    }

    public void testMappingWithSlope_vertical() {
        double x = 1.2;
        double y1 = 3.4;
        LinearTransformation transformation = LinearTransformation.mapping((double)x, (double)y1).withSlope(Double.POSITIVE_INFINITY);
        StatsTesting.assertVerticalLinearTransformation(transformation, x);
    }

    public void testMappingWithSlope_minimalSlope() {
        double x1 = 1.2;
        double y1 = 3.4;
        double slope = Double.MIN_VALUE;
        LinearTransformation transformation = LinearTransformation.mapping((double)x1, (double)y1).withSlope(slope);
        Truth.assertThat((Boolean)transformation.isVertical()).isFalse();
        Truth.assertThat((Boolean)transformation.isHorizontal()).isFalse();
        Truth.assertThat((Double)transformation.slope()).isWithin(1.0E-10).of(slope);
    }

    public void testMappingWithSlope_maximalSlope() {
        double x1 = 1.2;
        double y1 = 3.4;
        double slope = Double.MAX_VALUE;
        LinearTransformation transformation = LinearTransformation.mapping((double)x1, (double)y1).withSlope(slope);
        Truth.assertThat((Boolean)transformation.isVertical()).isFalse();
        Truth.assertThat((Boolean)transformation.isHorizontal()).isFalse();
        Truth.assertThat((Double)transformation.slope()).isWithin(1.0E-10).of(slope);
    }

    public void testMappingWithSlope_nanSlope() {
        try {
            LinearTransformation.mapping((double)1.2, (double)3.4).withSlope(Double.NaN);
            LinearTransformationTest.fail((String)"Expected IllegalArgumentException from withSlope(slope) with NaN slope");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testVertical_regular() {
        double x = 1.2;
        LinearTransformation transformation = LinearTransformation.vertical((double)x);
        StatsTesting.assertVerticalLinearTransformation(transformation, x);
    }

    public void testVertical_infiniteX() {
        try {
            LinearTransformation.vertical((double)Double.NEGATIVE_INFINITY);
            LinearTransformationTest.fail((String)"Expected IllegalArgumentException from vertical(x) with infinite x");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testVertical_nanX() {
        try {
            LinearTransformation.vertical((double)Double.NaN);
            LinearTransformationTest.fail((String)"Expected IllegalArgumentException from vertical(x) with NaN x");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testHorizontal_regular() {
        double y = 1.2;
        LinearTransformation transformation = LinearTransformation.horizontal((double)y);
        StatsTesting.assertHorizontalLinearTransformation(transformation, y);
    }

    public void testHorizontal_infiniteY() {
        try {
            LinearTransformation.horizontal((double)Double.POSITIVE_INFINITY);
            LinearTransformationTest.fail((String)"Expected IllegalArgumentException from horizontal(y) with infinite y");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testHorizontal_nanY() {
        try {
            LinearTransformation.horizontal((double)Double.NaN);
            LinearTransformationTest.fail((String)"Expected IllegalArgumentException from horizontal(y) with NaN y");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testForNaN() {
        LinearTransformation transformation = LinearTransformation.forNaN();
        StatsTesting.assertLinearTransformationNaN(transformation);
    }
}

