/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.math.LinearTransformation;
import com.google.common.math.PairedStatsAccumulator;
import com.google.common.math.StatsTesting;
import com.google.common.truth.DoubleSubject;
import com.google.common.truth.Truth;
import java.util.Collections;
import junit.framework.TestCase;

public class PairedStatsAccumulatorTest
extends TestCase {
    private PairedStatsAccumulator emptyAccumulator;
    private PairedStatsAccumulator emptyAccumulatorByAddAllEmptyPairedStats;
    private PairedStatsAccumulator oneValueAccumulator;
    private PairedStatsAccumulator oneValueAccumulatorByAddAllEmptyPairedStats;
    private PairedStatsAccumulator twoValuesAccumulator;
    private PairedStatsAccumulator twoValuesAccumulatorByAddAllPartitionedPairedStats;
    private PairedStatsAccumulator manyValuesAccumulator;
    private PairedStatsAccumulator manyValuesAccumulatorByAddAllPartitionedPairedStats;
    private PairedStatsAccumulator horizontalValuesAccumulator;
    private PairedStatsAccumulator horizontalValuesAccumulatorByAddAllPartitionedPairedStats;
    private PairedStatsAccumulator verticalValuesAccumulator;
    private PairedStatsAccumulator verticalValuesAccumulatorByAddAllPartitionedPairedStats;
    private PairedStatsAccumulator constantValuesAccumulator;
    private PairedStatsAccumulator constantValuesAccumulatorByAddAllPartitionedPairedStats;

    protected void setUp() throws Exception {
        super.setUp();
        this.emptyAccumulator = new PairedStatsAccumulator();
        this.emptyAccumulatorByAddAllEmptyPairedStats = new PairedStatsAccumulator();
        this.emptyAccumulatorByAddAllEmptyPairedStats.addAll(this.emptyAccumulator.snapshot());
        this.oneValueAccumulator = new PairedStatsAccumulator();
        this.oneValueAccumulator.add(12.34, -56.78);
        this.oneValueAccumulatorByAddAllEmptyPairedStats = new PairedStatsAccumulator();
        this.oneValueAccumulatorByAddAllEmptyPairedStats.add(12.34, -56.78);
        this.oneValueAccumulatorByAddAllEmptyPairedStats.addAll(this.emptyAccumulator.snapshot());
        this.twoValuesAccumulator = StatsTesting.createFilledPairedStatsAccumulator(StatsTesting.TWO_VALUES, StatsTesting.OTHER_TWO_VALUES);
        this.twoValuesAccumulatorByAddAllPartitionedPairedStats = StatsTesting.createPartitionedFilledPairedStatsAccumulator(StatsTesting.TWO_VALUES, StatsTesting.OTHER_TWO_VALUES, 1);
        this.manyValuesAccumulator = StatsTesting.createFilledPairedStatsAccumulator(StatsTesting.MANY_VALUES, StatsTesting.OTHER_MANY_VALUES);
        this.manyValuesAccumulatorByAddAllPartitionedPairedStats = StatsTesting.createPartitionedFilledPairedStatsAccumulator(StatsTesting.MANY_VALUES, StatsTesting.OTHER_MANY_VALUES, 2);
        this.horizontalValuesAccumulator = StatsTesting.createFilledPairedStatsAccumulator(StatsTesting.MANY_VALUES, Collections.nCopies(5, -56.78));
        this.horizontalValuesAccumulatorByAddAllPartitionedPairedStats = StatsTesting.createPartitionedFilledPairedStatsAccumulator(StatsTesting.MANY_VALUES, Collections.nCopies(5, -56.78), 2);
        this.verticalValuesAccumulator = StatsTesting.createFilledPairedStatsAccumulator(Collections.nCopies(5, 12.34), StatsTesting.OTHER_MANY_VALUES);
        this.verticalValuesAccumulatorByAddAllPartitionedPairedStats = StatsTesting.createPartitionedFilledPairedStatsAccumulator(Collections.nCopies(5, 12.34), StatsTesting.OTHER_MANY_VALUES, 2);
        this.constantValuesAccumulator = StatsTesting.createFilledPairedStatsAccumulator(Collections.nCopies(5, 12.34), Collections.nCopies(5, -56.78));
        this.constantValuesAccumulatorByAddAllPartitionedPairedStats = StatsTesting.createPartitionedFilledPairedStatsAccumulator(Collections.nCopies(5, 12.34), Collections.nCopies(5, -56.78), 2);
    }

    public void testCount() {
        Truth.assertThat((Long)this.emptyAccumulator.count()).isEqualTo((Object)0);
        Truth.assertThat((Long)this.emptyAccumulatorByAddAllEmptyPairedStats.count()).isEqualTo((Object)0);
        Truth.assertThat((Long)this.oneValueAccumulator.count()).isEqualTo((Object)1);
        Truth.assertThat((Long)this.oneValueAccumulatorByAddAllEmptyPairedStats.count()).isEqualTo((Object)1);
        Truth.assertThat((Long)this.twoValuesAccumulator.count()).isEqualTo((Object)2);
        Truth.assertThat((Long)this.twoValuesAccumulatorByAddAllPartitionedPairedStats.count()).isEqualTo((Object)2);
        Truth.assertThat((Long)this.manyValuesAccumulator.count()).isEqualTo((Object)5);
        Truth.assertThat((Long)this.manyValuesAccumulatorByAddAllPartitionedPairedStats.count()).isEqualTo((Object)5);
    }

    public void testCountOverflow_doesNotThrow() {
        PairedStatsAccumulator accumulator = new PairedStatsAccumulator();
        accumulator.add(12.34, -56.78);
        for (int power = 1; power < 63; ++power) {
            accumulator.addAll(accumulator.snapshot());
        }
        accumulator.addAll(accumulator.snapshot());
        Truth.assertThat((Long)accumulator.count()).isLessThan((Comparable)Long.valueOf(0L));
    }

    public void testXStats() {
        StatsTesting.assertStatsApproxEqual(StatsTesting.EMPTY_STATS_ITERABLE, this.emptyAccumulator.xStats());
        StatsTesting.assertStatsApproxEqual(StatsTesting.EMPTY_STATS_ITERABLE, this.emptyAccumulatorByAddAllEmptyPairedStats.xStats());
        StatsTesting.assertStatsApproxEqual(StatsTesting.ONE_VALUE_STATS, this.oneValueAccumulator.xStats());
        StatsTesting.assertStatsApproxEqual(StatsTesting.ONE_VALUE_STATS, this.oneValueAccumulatorByAddAllEmptyPairedStats.xStats());
        StatsTesting.assertStatsApproxEqual(StatsTesting.TWO_VALUES_STATS, this.twoValuesAccumulator.xStats());
        StatsTesting.assertStatsApproxEqual(StatsTesting.TWO_VALUES_STATS, this.twoValuesAccumulatorByAddAllPartitionedPairedStats.xStats());
        StatsTesting.assertStatsApproxEqual(StatsTesting.MANY_VALUES_STATS_ITERABLE, this.manyValuesAccumulator.xStats());
        StatsTesting.assertStatsApproxEqual(StatsTesting.MANY_VALUES_STATS_ITERABLE, this.manyValuesAccumulatorByAddAllPartitionedPairedStats.xStats());
    }

    public void testYStats() {
        StatsTesting.assertStatsApproxEqual(StatsTesting.EMPTY_STATS_ITERABLE, this.emptyAccumulator.yStats());
        StatsTesting.assertStatsApproxEqual(StatsTesting.EMPTY_STATS_ITERABLE, this.emptyAccumulatorByAddAllEmptyPairedStats.yStats());
        StatsTesting.assertStatsApproxEqual(StatsTesting.OTHER_ONE_VALUE_STATS, this.oneValueAccumulator.yStats());
        StatsTesting.assertStatsApproxEqual(StatsTesting.OTHER_ONE_VALUE_STATS, this.oneValueAccumulatorByAddAllEmptyPairedStats.yStats());
        StatsTesting.assertStatsApproxEqual(StatsTesting.OTHER_TWO_VALUES_STATS, this.twoValuesAccumulator.yStats());
        StatsTesting.assertStatsApproxEqual(StatsTesting.OTHER_TWO_VALUES_STATS, this.twoValuesAccumulatorByAddAllPartitionedPairedStats.yStats());
        StatsTesting.assertStatsApproxEqual(StatsTesting.OTHER_MANY_VALUES_STATS, this.manyValuesAccumulator.yStats());
        StatsTesting.assertStatsApproxEqual(StatsTesting.OTHER_MANY_VALUES_STATS, this.manyValuesAccumulatorByAddAllPartitionedPairedStats.yStats());
    }

    public void testPopulationCovariance() {
        try {
            this.emptyAccumulator.populationCovariance();
            PairedStatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        try {
            this.emptyAccumulatorByAddAllEmptyPairedStats.populationCovariance();
            PairedStatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        Truth.assertThat((Double)this.oneValueAccumulator.populationCovariance()).isWithin(0.0).of(0.0);
        Truth.assertThat((Double)this.oneValueAccumulatorByAddAllEmptyPairedStats.populationCovariance()).isWithin(0.0).of(0.0);
        Truth.assertThat((Double)this.twoValuesAccumulator.populationCovariance()).isWithin(1.0E-10).of(15767.447040000001);
        Truth.assertThat((Double)this.twoValuesAccumulatorByAddAllPartitionedPairedStats.populationCovariance()).isWithin(1.0E-10).of(15767.447040000001);
        Truth.assertThat((Double)this.manyValuesAccumulator.populationCovariance()).isWithin(1.0E-10).of(-16749.253212878997);
        Truth.assertThat((Double)this.manyValuesAccumulatorByAddAllPartitionedPairedStats.populationCovariance()).isWithin(1.0E-10).of(-16749.253212878997);
        for (StatsTesting.ManyValues values : StatsTesting.ALL_MANY_VALUES) {
            PairedStatsAccumulator accumulator = StatsTesting.createFilledPairedStatsAccumulator(values.asIterable(), StatsTesting.OTHER_MANY_VALUES);
            PairedStatsAccumulator accumulatorByAddAllPartitionedPairedStats = StatsTesting.createPartitionedFilledPairedStatsAccumulator(values.asIterable(), StatsTesting.OTHER_MANY_VALUES, 2);
            double populationCovariance = accumulator.populationCovariance();
            double populationCovarianceByAddAllPartitionedPairedStats = accumulatorByAddAllPartitionedPairedStats.populationCovariance();
            if (values.hasAnyNonFinite()) {
                ((DoubleSubject)Truth.assertThat((Double)populationCovariance).named("population covariance of " + values)).isNaN();
                ((DoubleSubject)Truth.assertThat((Double)populationCovarianceByAddAllPartitionedPairedStats).named("population covariance by addAll(PairedStats) of " + values)).isNaN();
                continue;
            }
            ((DoubleSubject)Truth.assertThat((Double)populationCovariance).named("population covariance of " + values)).isWithin(1.0E-10).of(-16749.253212878997);
            ((DoubleSubject)Truth.assertThat((Double)populationCovarianceByAddAllPartitionedPairedStats).named("population covariance by addAll(PairedStats) of " + values)).isWithin(1.0E-10).of(-16749.253212878997);
        }
        Truth.assertThat((Double)this.horizontalValuesAccumulator.populationCovariance()).isWithin(1.0E-10).of(0.0);
        Truth.assertThat((Double)this.horizontalValuesAccumulatorByAddAllPartitionedPairedStats.populationCovariance()).isWithin(1.0E-10).of(0.0);
        Truth.assertThat((Double)this.verticalValuesAccumulator.populationCovariance()).isWithin(1.0E-10).of(0.0);
        Truth.assertThat((Double)this.verticalValuesAccumulatorByAddAllPartitionedPairedStats.populationCovariance()).isWithin(1.0E-10).of(0.0);
        Truth.assertThat((Double)this.constantValuesAccumulator.populationCovariance()).isWithin(1.0E-10).of(0.0);
        Truth.assertThat((Double)this.constantValuesAccumulatorByAddAllPartitionedPairedStats.populationCovariance()).isWithin(1.0E-10).of(0.0);
    }

    public void testSampleCovariance() {
        try {
            this.emptyAccumulator.sampleCovariance();
            PairedStatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        try {
            this.emptyAccumulatorByAddAllEmptyPairedStats.sampleCovariance();
            PairedStatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        try {
            this.oneValueAccumulator.sampleCovariance();
            PairedStatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        try {
            this.oneValueAccumulatorByAddAllEmptyPairedStats.sampleCovariance();
            PairedStatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Truth.assertThat((Double)this.twoValuesAccumulator.sampleCovariance()).isWithin(1.0E-10).of(31534.894080000002);
        Truth.assertThat((Double)this.twoValuesAccumulatorByAddAllPartitionedPairedStats.sampleCovariance()).isWithin(1.0E-10).of(31534.894080000002);
        Truth.assertThat((Double)this.manyValuesAccumulator.sampleCovariance()).isWithin(1.0E-10).of(-20936.56651609875);
        Truth.assertThat((Double)this.manyValuesAccumulatorByAddAllPartitionedPairedStats.sampleCovariance()).isWithin(1.0E-10).of(-20936.56651609875);
        Truth.assertThat((Double)this.horizontalValuesAccumulator.sampleCovariance()).isWithin(1.0E-10).of(0.0);
        Truth.assertThat((Double)this.horizontalValuesAccumulatorByAddAllPartitionedPairedStats.sampleCovariance()).isWithin(1.0E-10).of(0.0);
        Truth.assertThat((Double)this.verticalValuesAccumulator.sampleCovariance()).isWithin(1.0E-10).of(0.0);
        Truth.assertThat((Double)this.verticalValuesAccumulatorByAddAllPartitionedPairedStats.sampleCovariance()).isWithin(1.0E-10).of(0.0);
        Truth.assertThat((Double)this.constantValuesAccumulator.sampleCovariance()).isWithin(1.0E-10).of(0.0);
        Truth.assertThat((Double)this.constantValuesAccumulatorByAddAllPartitionedPairedStats.sampleCovariance()).isWithin(1.0E-10).of(0.0);
    }

    public void testPearsonsCorrelationCoefficient() {
        try {
            this.emptyAccumulator.pearsonsCorrelationCoefficient();
            PairedStatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        try {
            this.emptyAccumulatorByAddAllEmptyPairedStats.pearsonsCorrelationCoefficient();
            PairedStatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        try {
            this.oneValueAccumulator.pearsonsCorrelationCoefficient();
            PairedStatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        try {
            this.oneValueAccumulatorByAddAllEmptyPairedStats.pearsonsCorrelationCoefficient();
            PairedStatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        Truth.assertThat((Double)this.twoValuesAccumulator.pearsonsCorrelationCoefficient()).isWithin(1.0E-10).of(this.twoValuesAccumulator.populationCovariance() / (this.twoValuesAccumulator.xStats().populationStandardDeviation() * this.twoValuesAccumulator.yStats().populationStandardDeviation()));
        Truth.assertThat((Double)this.manyValuesAccumulator.pearsonsCorrelationCoefficient()).isWithin(1.0E-10).of(this.manyValuesAccumulator.populationCovariance() / (this.manyValuesAccumulator.xStats().populationStandardDeviation() * this.manyValuesAccumulator.yStats().populationStandardDeviation()));
        Truth.assertThat((Double)this.manyValuesAccumulatorByAddAllPartitionedPairedStats.pearsonsCorrelationCoefficient()).isWithin(1.0E-10).of(this.manyValuesAccumulatorByAddAllPartitionedPairedStats.populationCovariance() / (this.manyValuesAccumulatorByAddAllPartitionedPairedStats.xStats().populationStandardDeviation() * this.manyValuesAccumulatorByAddAllPartitionedPairedStats.yStats().populationStandardDeviation()));
        for (StatsTesting.ManyValues values : StatsTesting.ALL_MANY_VALUES) {
            PairedStatsAccumulator accumulator = StatsTesting.createFilledPairedStatsAccumulator(StatsTesting.MANY_VALUES, values.asIterable());
            PairedStatsAccumulator accumulatorByAddAllPartitionedPairedStats = StatsTesting.createPartitionedFilledPairedStatsAccumulator(StatsTesting.MANY_VALUES, values.asIterable(), 2);
            double pearsonsCorrelationCoefficient = accumulator.pearsonsCorrelationCoefficient();
            double pearsonsCorrelationCoefficientByAddAllPartitionedPairedStats = accumulatorByAddAllPartitionedPairedStats.pearsonsCorrelationCoefficient();
            if (values.hasAnyNonFinite()) {
                ((DoubleSubject)Truth.assertThat((Double)pearsonsCorrelationCoefficient).named("Pearson's correlation coefficient of " + values)).isNaN();
                ((DoubleSubject)Truth.assertThat((Double)pearsonsCorrelationCoefficient).named("Pearson's correlation coefficient by addAll(PairedStats) of " + values)).isNaN();
                continue;
            }
            ((DoubleSubject)Truth.assertThat((Double)pearsonsCorrelationCoefficient).named("Pearson's correlation coefficient of " + values)).isWithin(1.0E-10).of(accumulator.populationCovariance() / (accumulator.xStats().populationStandardDeviation() * accumulator.yStats().populationStandardDeviation()));
            ((DoubleSubject)Truth.assertThat((Double)pearsonsCorrelationCoefficientByAddAllPartitionedPairedStats).named("Pearson's correlation coefficient by addAll(PairedStats) of " + values)).isWithin(1.0E-10).of(accumulatorByAddAllPartitionedPairedStats.populationCovariance() / (accumulatorByAddAllPartitionedPairedStats.xStats().populationStandardDeviation() * accumulatorByAddAllPartitionedPairedStats.yStats().populationStandardDeviation()));
        }
        try {
            this.horizontalValuesAccumulator.pearsonsCorrelationCoefficient();
            PairedStatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        try {
            this.horizontalValuesAccumulatorByAddAllPartitionedPairedStats.pearsonsCorrelationCoefficient();
            PairedStatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        try {
            this.verticalValuesAccumulator.pearsonsCorrelationCoefficient();
            PairedStatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        try {
            this.verticalValuesAccumulatorByAddAllPartitionedPairedStats.pearsonsCorrelationCoefficient();
            PairedStatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        try {
            this.constantValuesAccumulator.pearsonsCorrelationCoefficient();
            PairedStatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        try {
            this.constantValuesAccumulatorByAddAllPartitionedPairedStats.pearsonsCorrelationCoefficient();
            PairedStatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testLeastSquaresFit() {
        try {
            this.emptyAccumulator.leastSquaresFit();
            PairedStatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        try {
            this.emptyAccumulatorByAddAllEmptyPairedStats.leastSquaresFit();
            PairedStatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        try {
            this.oneValueAccumulator.leastSquaresFit();
            PairedStatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        try {
            this.oneValueAccumulatorByAddAllEmptyPairedStats.leastSquaresFit();
            PairedStatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        StatsTesting.assertDiagonalLinearTransformation(this.twoValuesAccumulator.leastSquaresFit(), this.twoValuesAccumulator.xStats().mean(), this.twoValuesAccumulator.yStats().mean(), this.twoValuesAccumulator.xStats().populationVariance(), this.twoValuesAccumulator.populationCovariance());
        StatsTesting.assertDiagonalLinearTransformation(this.twoValuesAccumulatorByAddAllPartitionedPairedStats.leastSquaresFit(), this.twoValuesAccumulatorByAddAllPartitionedPairedStats.xStats().mean(), this.twoValuesAccumulatorByAddAllPartitionedPairedStats.yStats().mean(), this.twoValuesAccumulatorByAddAllPartitionedPairedStats.xStats().populationVariance(), this.twoValuesAccumulatorByAddAllPartitionedPairedStats.populationCovariance());
        StatsTesting.assertDiagonalLinearTransformation(this.manyValuesAccumulator.leastSquaresFit(), this.manyValuesAccumulator.xStats().mean(), this.manyValuesAccumulator.yStats().mean(), this.manyValuesAccumulator.xStats().populationVariance(), this.manyValuesAccumulator.populationCovariance());
        StatsTesting.assertDiagonalLinearTransformation(this.manyValuesAccumulatorByAddAllPartitionedPairedStats.leastSquaresFit(), this.manyValuesAccumulatorByAddAllPartitionedPairedStats.xStats().mean(), this.manyValuesAccumulatorByAddAllPartitionedPairedStats.yStats().mean(), this.manyValuesAccumulatorByAddAllPartitionedPairedStats.xStats().populationVariance(), this.manyValuesAccumulatorByAddAllPartitionedPairedStats.populationCovariance());
        for (StatsTesting.ManyValues values : StatsTesting.ALL_MANY_VALUES) {
            PairedStatsAccumulator accumulator = StatsTesting.createFilledPairedStatsAccumulator(values.asIterable(), StatsTesting.OTHER_MANY_VALUES);
            PairedStatsAccumulator accumulatorByAddAllPartitionedPairedStats = StatsTesting.createPartitionedFilledPairedStatsAccumulator(values.asIterable(), StatsTesting.OTHER_MANY_VALUES, 2);
            LinearTransformation fit = accumulator.leastSquaresFit();
            LinearTransformation fitByAddAllPartitionedPairedStats = accumulatorByAddAllPartitionedPairedStats.leastSquaresFit();
            if (values.hasAnyNonFinite()) {
                StatsTesting.assertLinearTransformationNaN(fit);
                StatsTesting.assertLinearTransformationNaN(fitByAddAllPartitionedPairedStats);
                continue;
            }
            StatsTesting.assertDiagonalLinearTransformation(fit, accumulator.xStats().mean(), accumulator.yStats().mean(), accumulator.xStats().populationVariance(), accumulator.populationCovariance());
            StatsTesting.assertDiagonalLinearTransformation(fitByAddAllPartitionedPairedStats, accumulatorByAddAllPartitionedPairedStats.xStats().mean(), accumulatorByAddAllPartitionedPairedStats.yStats().mean(), accumulatorByAddAllPartitionedPairedStats.xStats().populationVariance(), accumulatorByAddAllPartitionedPairedStats.populationCovariance());
        }
        StatsTesting.assertHorizontalLinearTransformation(this.horizontalValuesAccumulator.leastSquaresFit(), this.horizontalValuesAccumulator.yStats().mean());
        StatsTesting.assertHorizontalLinearTransformation(this.horizontalValuesAccumulatorByAddAllPartitionedPairedStats.leastSquaresFit(), this.horizontalValuesAccumulatorByAddAllPartitionedPairedStats.yStats().mean());
        StatsTesting.assertVerticalLinearTransformation(this.verticalValuesAccumulator.leastSquaresFit(), this.verticalValuesAccumulator.xStats().mean());
        StatsTesting.assertVerticalLinearTransformation(this.verticalValuesAccumulatorByAddAllPartitionedPairedStats.leastSquaresFit(), this.verticalValuesAccumulatorByAddAllPartitionedPairedStats.xStats().mean());
        try {
            this.constantValuesAccumulator.leastSquaresFit();
            PairedStatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException expected) {
            // empty catch block
        }
        try {
            this.constantValuesAccumulatorByAddAllPartitionedPairedStats.leastSquaresFit();
            PairedStatsAccumulatorTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

