/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.net;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.net.MediaType;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.NullPointerTester;
import com.google.common.truth.Truth;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class MediaTypeTest
extends TestCase {
    private static final ImmutableListMultimap<String, String> PARAMETERS = ImmutableListMultimap.of((Object)"a", (Object)"1", (Object)"a", (Object)"2", (Object)"b", (Object)"3");

    @GwtIncompatible
    public void testParse_useConstants() throws Exception {
        for (MediaType constant : MediaTypeTest.getConstants()) {
            MediaTypeTest.assertSame((Object)constant, (Object)MediaType.parse((String)constant.toString()));
        }
    }

    @GwtIncompatible
    public void testCreate_useConstants() throws Exception {
        for (MediaType constant : MediaTypeTest.getConstants()) {
            MediaTypeTest.assertSame((Object)constant, (Object)MediaType.create((String)constant.type(), (String)constant.subtype()).withParameters((Multimap)constant.parameters()));
        }
    }

    @GwtIncompatible
    public void testConstants_charset() throws Exception {
        for (Field field : MediaTypeTest.getConstantFields()) {
            Optional charset = ((MediaType)field.get(null)).charset();
            if (field.getName().endsWith("_UTF_8")) {
                Truth.assertThat((Optional)charset).hasValue((Object)Charsets.UTF_8);
                continue;
            }
            Truth.assertThat((Optional)charset).isAbsent();
        }
    }

    @GwtIncompatible
    private static FluentIterable<Field> getConstantFields() {
        return FluentIterable.from(Arrays.asList(MediaType.class.getDeclaredFields())).filter((Predicate)new Predicate<Field>(){

            public boolean apply(Field input) {
                int modifiers = input.getModifiers();
                return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers) && MediaType.class.equals(input.getType());
            }
        });
    }

    @GwtIncompatible
    private static FluentIterable<MediaType> getConstants() {
        return MediaTypeTest.getConstantFields().transform((Function)new Function<Field, MediaType>(){

            public MediaType apply(Field input) {
                try {
                    return (MediaType)input.get(null);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public void testCreate_invalidType() {
        try {
            MediaType.create((String)"te><t", (String)"plaintext");
            MediaTypeTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCreate_invalidSubtype() {
        try {
            MediaType.create((String)"text", (String)"pl@intext");
            MediaTypeTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCreate_wildcardTypeDeclaredSubtype() {
        try {
            MediaType.create((String)"*", (String)"text");
            MediaTypeTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCreateApplicationType() {
        MediaType newType = MediaType.createApplicationType((String)"yams");
        MediaTypeTest.assertEquals((String)"application", (String)newType.type());
        MediaTypeTest.assertEquals((String)"yams", (String)newType.subtype());
    }

    public void testCreateAudioType() {
        MediaType newType = MediaType.createAudioType((String)"yams");
        MediaTypeTest.assertEquals((String)"audio", (String)newType.type());
        MediaTypeTest.assertEquals((String)"yams", (String)newType.subtype());
    }

    public void testCreateImageType() {
        MediaType newType = MediaType.createImageType((String)"yams");
        MediaTypeTest.assertEquals((String)"image", (String)newType.type());
        MediaTypeTest.assertEquals((String)"yams", (String)newType.subtype());
    }

    public void testCreateTextType() {
        MediaType newType = MediaType.createTextType((String)"yams");
        MediaTypeTest.assertEquals((String)"text", (String)newType.type());
        MediaTypeTest.assertEquals((String)"yams", (String)newType.subtype());
    }

    public void testCreateVideoType() {
        MediaType newType = MediaType.createVideoType((String)"yams");
        MediaTypeTest.assertEquals((String)"video", (String)newType.type());
        MediaTypeTest.assertEquals((String)"yams", (String)newType.subtype());
    }

    public void testGetType() {
        MediaTypeTest.assertEquals((String)"text", (String)MediaType.parse((String)"text/plain").type());
        MediaTypeTest.assertEquals((String)"application", (String)MediaType.parse((String)"application/atom+xml; charset=utf-8").type());
    }

    public void testGetSubtype() {
        MediaTypeTest.assertEquals((String)"plain", (String)MediaType.parse((String)"text/plain").subtype());
        MediaTypeTest.assertEquals((String)"atom+xml", (String)MediaType.parse((String)"application/atom+xml; charset=utf-8").subtype());
    }

    public void testGetParameters() {
        MediaTypeTest.assertEquals((Object)ImmutableListMultimap.of(), (Object)MediaType.parse((String)"text/plain").parameters());
        MediaTypeTest.assertEquals((Object)ImmutableListMultimap.of((Object)"charset", (Object)"utf-8"), (Object)MediaType.parse((String)"application/atom+xml; charset=utf-8").parameters());
        MediaTypeTest.assertEquals(PARAMETERS, (Object)MediaType.parse((String)"application/atom+xml; a=1; a=2; b=3").parameters());
    }

    public void testWithoutParameters() {
        MediaTypeTest.assertSame((Object)MediaType.parse((String)"image/gif"), (Object)MediaType.parse((String)"image/gif").withoutParameters());
        MediaTypeTest.assertEquals((Object)MediaType.parse((String)"image/gif"), (Object)MediaType.parse((String)"image/gif; foo=bar").withoutParameters());
    }

    public void testWithParameters() {
        MediaTypeTest.assertEquals((Object)MediaType.parse((String)"text/plain; a=1; a=2; b=3"), (Object)MediaType.parse((String)"text/plain").withParameters(PARAMETERS));
        MediaTypeTest.assertEquals((Object)MediaType.parse((String)"text/plain; a=1; a=2; b=3"), (Object)MediaType.parse((String)"text/plain; a=1; a=2; b=3").withParameters(PARAMETERS));
    }

    public void testWithParameters_invalidAttribute() {
        MediaType mediaType = MediaType.parse((String)"text/plain");
        ImmutableListMultimap parameters = ImmutableListMultimap.of((Object)"a", (Object)"1", (Object)"@", (Object)"2", (Object)"b", (Object)"3");
        try {
            mediaType.withParameters((Multimap)parameters);
            MediaTypeTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testWithParameter() {
        MediaTypeTest.assertEquals((Object)MediaType.parse((String)"text/plain; a=1"), (Object)MediaType.parse((String)"text/plain").withParameter("a", "1"));
        MediaTypeTest.assertEquals((Object)MediaType.parse((String)"text/plain; a=1"), (Object)MediaType.parse((String)"text/plain; a=1; a=2").withParameter("a", "1"));
        MediaTypeTest.assertEquals((Object)MediaType.parse((String)"text/plain; a=3"), (Object)MediaType.parse((String)"text/plain; a=1; a=2").withParameter("a", "3"));
        MediaTypeTest.assertEquals((Object)MediaType.parse((String)"text/plain; a=1; a=2; b=3"), (Object)MediaType.parse((String)"text/plain; a=1; a=2").withParameter("b", "3"));
    }

    public void testWithParameter_invalidAttribute() {
        MediaType mediaType = MediaType.parse((String)"text/plain");
        try {
            mediaType.withParameter("@", "2");
            MediaTypeTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testWithCharset() {
        MediaTypeTest.assertEquals((Object)MediaType.parse((String)"text/plain; charset=utf-8"), (Object)MediaType.parse((String)"text/plain").withCharset(Charsets.UTF_8));
        MediaTypeTest.assertEquals((Object)MediaType.parse((String)"text/plain; charset=utf-8"), (Object)MediaType.parse((String)"text/plain; charset=utf-16").withCharset(Charsets.UTF_8));
    }

    public void testHasWildcard() {
        MediaTypeTest.assertFalse((boolean)MediaType.PLAIN_TEXT_UTF_8.hasWildcard());
        MediaTypeTest.assertFalse((boolean)MediaType.JPEG.hasWildcard());
        MediaTypeTest.assertTrue((boolean)MediaType.ANY_TYPE.hasWildcard());
        MediaTypeTest.assertTrue((boolean)MediaType.ANY_APPLICATION_TYPE.hasWildcard());
        MediaTypeTest.assertTrue((boolean)MediaType.ANY_AUDIO_TYPE.hasWildcard());
        MediaTypeTest.assertTrue((boolean)MediaType.ANY_IMAGE_TYPE.hasWildcard());
        MediaTypeTest.assertTrue((boolean)MediaType.ANY_TEXT_TYPE.hasWildcard());
        MediaTypeTest.assertTrue((boolean)MediaType.ANY_VIDEO_TYPE.hasWildcard());
    }

    public void testIs() {
        MediaTypeTest.assertTrue((boolean)MediaType.PLAIN_TEXT_UTF_8.is(MediaType.ANY_TYPE));
        MediaTypeTest.assertTrue((boolean)MediaType.JPEG.is(MediaType.ANY_TYPE));
        MediaTypeTest.assertTrue((boolean)MediaType.ANY_TEXT_TYPE.is(MediaType.ANY_TYPE));
        MediaTypeTest.assertTrue((boolean)MediaType.PLAIN_TEXT_UTF_8.is(MediaType.ANY_TEXT_TYPE));
        MediaTypeTest.assertTrue((boolean)MediaType.PLAIN_TEXT_UTF_8.withoutParameters().is(MediaType.ANY_TEXT_TYPE));
        MediaTypeTest.assertFalse((boolean)MediaType.JPEG.is(MediaType.ANY_TEXT_TYPE));
        MediaTypeTest.assertTrue((boolean)MediaType.PLAIN_TEXT_UTF_8.is(MediaType.PLAIN_TEXT_UTF_8));
        MediaTypeTest.assertTrue((boolean)MediaType.PLAIN_TEXT_UTF_8.is(MediaType.PLAIN_TEXT_UTF_8.withoutParameters()));
        MediaTypeTest.assertFalse((boolean)MediaType.PLAIN_TEXT_UTF_8.withoutParameters().is(MediaType.PLAIN_TEXT_UTF_8));
        MediaTypeTest.assertFalse((boolean)MediaType.PLAIN_TEXT_UTF_8.is(MediaType.HTML_UTF_8));
        MediaTypeTest.assertFalse((boolean)MediaType.PLAIN_TEXT_UTF_8.withParameter("charset", "UTF-16").is(MediaType.PLAIN_TEXT_UTF_8));
        MediaTypeTest.assertFalse((boolean)MediaType.PLAIN_TEXT_UTF_8.is(MediaType.PLAIN_TEXT_UTF_8.withParameter("charset", "UTF-16")));
    }

    public void testParse_empty() {
        try {
            MediaType.parse((String)"");
            MediaTypeTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParse_badInput() {
        try {
            MediaType.parse((String)"/");
            MediaTypeTest.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            MediaType.parse((String)"text");
            MediaTypeTest.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            MediaType.parse((String)"text/");
            MediaTypeTest.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            MediaType.parse((String)"te<t/plain");
            MediaTypeTest.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            MediaType.parse((String)"text/pl@in");
            MediaTypeTest.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            MediaType.parse((String)"text/plain;");
            MediaTypeTest.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            MediaType.parse((String)"text/plain; ");
            MediaTypeTest.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            MediaType.parse((String)"text/plain; a");
            MediaTypeTest.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            MediaType.parse((String)"text/plain; a=");
            MediaTypeTest.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            MediaType.parse((String)"text/plain; a=@");
            MediaTypeTest.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            MediaType.parse((String)"text/plain; a=\"@");
            MediaTypeTest.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            MediaType.parse((String)"text/plain; a=1;");
            MediaTypeTest.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            MediaType.parse((String)"text/plain; a=1; ");
            MediaTypeTest.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            MediaType.parse((String)"text/plain; a=1; b");
            MediaTypeTest.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            MediaType.parse((String)"text/plain; a=1; b=");
            MediaTypeTest.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            MediaType.parse((String)"text/plain; a=\u2025");
            MediaTypeTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetCharset() {
        Truth.assertThat((Optional)MediaType.parse((String)"text/plain").charset()).isAbsent();
        Truth.assertThat((Optional)MediaType.parse((String)"text/plain; charset=utf-8").charset()).hasValue((Object)Charsets.UTF_8);
    }

    @GwtIncompatible
    public void testGetCharset_utf16() {
        Truth.assertThat((Optional)MediaType.parse((String)"text/plain; charset=utf-16").charset()).hasValue((Object)Charsets.UTF_16);
    }

    public void testGetCharset_tooMany() {
        MediaType mediaType = MediaType.parse((String)"text/plain; charset=utf-8; charset=utf-16");
        try {
            mediaType.charset();
            MediaTypeTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetCharset_illegalCharset() {
        MediaType mediaType = MediaType.parse((String)"text/plain; charset=\"!@#$%^&*()\"");
        try {
            mediaType.charset();
            MediaTypeTest.fail();
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            // empty catch block
        }
    }

    public void testGetCharset_unsupportedCharset() {
        MediaType mediaType = MediaType.parse((String)"text/plain; charset=utf-wtf");
        try {
            mediaType.charset();
            MediaTypeTest.fail();
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            // empty catch block
        }
    }

    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{MediaType.create((String)"text", (String)"plain"), MediaType.create((String)"TEXT", (String)"PLAIN"), MediaType.parse((String)"text/plain"), MediaType.parse((String)"TEXT/PLAIN"), MediaType.create((String)"text", (String)"plain").withParameter("a", "1").withoutParameters()}).addEqualityGroup(new Object[]{MediaType.create((String)"text", (String)"plain").withCharset(Charsets.UTF_8), MediaType.create((String)"text", (String)"plain").withParameter("CHARSET", "UTF-8"), MediaType.create((String)"text", (String)"plain").withParameters((Multimap)ImmutableMultimap.of((Object)"charset", (Object)"utf-8")), MediaType.parse((String)"text/plain;charset=utf-8"), MediaType.parse((String)"text/plain; charset=utf-8"), MediaType.parse((String)"text/plain;  charset=utf-8"), MediaType.parse((String)"text/plain; \tcharset=utf-8"), MediaType.parse((String)"text/plain; \r\n\tcharset=utf-8"), MediaType.parse((String)"text/plain; CHARSET=utf-8"), MediaType.parse((String)"text/plain; charset=\"utf-8\""), MediaType.parse((String)"text/plain; charset=\"\\u\\tf-\\8\""), MediaType.parse((String)"text/plain; charset=UTF-8"), MediaType.parse((String)"text/plain ; charset=utf-8")}).addEqualityGroup(new Object[]{MediaType.parse((String)"text/plain; charset=utf-8; charset=utf-8")}).addEqualityGroup(new Object[]{MediaType.create((String)"text", (String)"plain").withParameter("a", "value"), MediaType.create((String)"text", (String)"plain").withParameter("A", "value")}).addEqualityGroup(new Object[]{MediaType.create((String)"text", (String)"plain").withParameter("a", "VALUE"), MediaType.create((String)"text", (String)"plain").withParameter("A", "VALUE")}).addEqualityGroup(new Object[]{MediaType.create((String)"text", (String)"plain").withParameters((Multimap)ImmutableListMultimap.of((Object)"a", (Object)"1", (Object)"a", (Object)"2")), MediaType.create((String)"text", (String)"plain").withParameters((Multimap)ImmutableListMultimap.of((Object)"a", (Object)"2", (Object)"a", (Object)"1"))}).addEqualityGroup(new Object[]{MediaType.create((String)"text", (String)"csv")}).addEqualityGroup(new Object[]{MediaType.create((String)"application", (String)"atom+xml")}).testEquals();
    }

    @GwtIncompatible
    public void testEquals_nonUtf8Charsets() {
        new EqualsTester().addEqualityGroup(new Object[]{MediaType.create((String)"text", (String)"plain")}).addEqualityGroup(new Object[]{MediaType.create((String)"text", (String)"plain").withCharset(Charsets.UTF_8)}).addEqualityGroup(new Object[]{MediaType.create((String)"text", (String)"plain").withCharset(Charsets.UTF_16)}).testEquals();
    }

    @GwtIncompatible
    public void testNullPointer() {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicConstructors(MediaType.class);
        tester.testAllPublicStaticMethods(MediaType.class);
        tester.testAllPublicInstanceMethods((Object)MediaType.parse((String)"text/plain"));
    }

    public void testToString() {
        MediaTypeTest.assertEquals((String)"text/plain", (String)MediaType.create((String)"text", (String)"plain").toString());
        MediaTypeTest.assertEquals((String)"text/plain; something=\"cr@zy\"; something-else=\"crazy with spaces\"", (String)MediaType.create((String)"text", (String)"plain").withParameter("something", "cr@zy").withParameter("something-else", "crazy with spaces").toString());
    }
}

