/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.testing.ListTestSuiteBuilder;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.TestListGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.ListFeature;
import com.google.common.primitives.Ints;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

@GwtCompatible(emulated=true)
public class IntArrayAsListTest
extends TestCase {
    private static List<Integer> asList(Integer[] values) {
        int[] temp = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            temp[i] = (Integer)Preconditions.checkNotNull((Object)values[i]);
        }
        return Ints.asList((int[])temp);
    }

    @GwtIncompatible
    public static Test suite() {
        ImmutableList builders = ImmutableList.of((Object)ListTestSuiteBuilder.using((TestListGenerator)new IntsAsListGenerator()).named("Ints.asList"), (Object)ListTestSuiteBuilder.using((TestListGenerator)new IntsAsListHeadSubListGenerator()).named("Ints.asList, head subList"), (Object)ListTestSuiteBuilder.using((TestListGenerator)new IntsAsListTailSubListGenerator()).named("Ints.asList, tail subList"), (Object)ListTestSuiteBuilder.using((TestListGenerator)new IntsAsListMiddleSubListGenerator()).named("Ints.asList, middle subList"));
        TestSuite suite = new TestSuite();
        for (ListTestSuiteBuilder builder : builders) {
            suite.addTest((Test)((ListTestSuiteBuilder)builder.withFeatures(new Feature[]{CollectionSize.ONE, CollectionSize.SEVERAL, CollectionFeature.RESTRICTS_ELEMENTS, ListFeature.SUPPORTS_SET})).createTestSuite());
        }
        return suite;
    }

    private static Integer[] concat(Integer[] left, Integer[] right) {
        Integer[] result = new Integer[left.length + right.length];
        System.arraycopy(left, 0, result, 0, left.length);
        System.arraycopy(right, 0, result, left.length, right.length);
        return result;
    }

    public static class SampleIntegers
    extends SampleElements<Integer> {
        public SampleIntegers() {
            super((Object)0, (Object)1, (Object)2, (Object)3, (Object)4);
        }
    }

    public static abstract class TestIntegerListGenerator
    implements TestListGenerator<Integer> {
        public SampleElements<Integer> samples() {
            return new SampleIntegers();
        }

        public List<Integer> create(Object ... elements) {
            Integer[] array = new Integer[elements.length];
            int i = 0;
            for (Object e : elements) {
                array[i++] = (Integer)e;
            }
            return this.create(array);
        }

        protected abstract List<Integer> create(Integer[] var1);

        public Integer[] createArray(int length) {
            return new Integer[length];
        }

        public List<Integer> order(List<Integer> insertionOrder) {
            return insertionOrder;
        }
    }

    public static final class IntsAsListMiddleSubListGenerator
    extends TestIntegerListGenerator {
        @Override
        protected List<Integer> create(Integer[] elements) {
            Integer[] prefix = new Integer[]{Integer.MIN_VALUE, Integer.MAX_VALUE};
            Integer[] suffix = new Integer[]{86, 99};
            Integer[] all = IntArrayAsListTest.concat(IntArrayAsListTest.concat(prefix, elements), suffix);
            return IntArrayAsListTest.asList(all).subList(2, elements.length + 2);
        }
    }

    public static final class IntsAsListTailSubListGenerator
    extends TestIntegerListGenerator {
        @Override
        protected List<Integer> create(Integer[] elements) {
            Integer[] prefix = new Integer[]{86, 99};
            Integer[] all = IntArrayAsListTest.concat(prefix, elements);
            return IntArrayAsListTest.asList(all).subList(2, elements.length + 2);
        }
    }

    public static final class IntsAsListHeadSubListGenerator
    extends TestIntegerListGenerator {
        @Override
        protected List<Integer> create(Integer[] elements) {
            Integer[] suffix = new Integer[]{Integer.MIN_VALUE, Integer.MAX_VALUE};
            Integer[] all = IntArrayAsListTest.concat(elements, suffix);
            return IntArrayAsListTest.asList(all).subList(0, elements.length);
        }
    }

    public static final class IntsAsListGenerator
    extends TestIntegerListGenerator {
        @Override
        protected List<Integer> create(Integer[] elements) {
            return IntArrayAsListTest.asList(elements);
        }
    }
}

