/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.reflect;

import com.google.common.reflect.TypeParameter;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.NullPointerTester;
import java.lang.reflect.Method;
import java.lang.reflect.TypeVariable;
import junit.framework.TestCase;

public class TypeParameterTest
extends TestCase {
    public <T> void testCaptureTypeParameter() throws Exception {
        TypeVariable variable = new TypeParameter<T>(){}.typeVariable;
        TypeVariable<Method> expected = TypeParameterTest.class.getDeclaredMethod("testCaptureTypeParameter", new Class[0]).getTypeParameters()[0];
        TypeParameterTest.assertEquals(expected, (Object)variable);
    }

    public void testConcreteTypeRejected() {
        try {
            new TypeParameter<String>(){};
            TypeParameterTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public <A, B> void testEquals() throws Exception {
        Method method = TypeParameterTest.class.getDeclaredMethod("testEquals", new Class[0]);
        new EqualsTester().addEqualityGroup(new Object[]{new TypeParameter<A>(){}, new TypeParameter<A>(){}}).addEqualityGroup(new Object[]{new TypeParameter<B>(){}}).testEquals();
    }

    public void testNullPointers() {
        new NullPointerTester().testAllPublicStaticMethods(TypeParameter.class);
    }
}

