/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.reflect;

import com.google.common.reflect.AndroidIncompatible;
import com.google.common.reflect.SubtypeTester;
import com.google.common.reflect.TypeToken;
import java.util.Comparator;
import java.util.List;
import junit.framework.TestCase;

@AndroidIncompatible
public class TypeTokenSubtypeTest
extends TestCase {
    public void testOwnerTypeSubtypes() throws Exception {
        new OwnerTypeSubtypingTests().testAllDeclarations();
    }

    public void testWildcardSubtypes() throws Exception {
        new WildcardSubtypingTests().testAllDeclarations();
    }

    public void testSubtypeOfInnerClass_nonStaticAnonymousClass() {
        TypeToken<Mall.Shop<Electronics>> supertype = new TypeToken<Mall.Shop<Electronics>>(){};
        Class<?> subclass = new Mall.Shop<Electronics>(new Mall()){}.getClass();
        TypeTokenSubtypeTest.assertTrue((boolean)TypeToken.of(subclass).isSubtypeOf((TypeToken)supertype));
    }

    public void testSubtypeOfInnerClass_nonStaticAnonymousClass_typeParameterOfOwnerTypeNotMatch() {
        TypeToken<Mall.Shop<Electronics>> supertype = new TypeToken<Mall.Shop<Electronics>>(){};
        Class<?> subclass = new Mall.Shop<Electronics>(new Mall()){}.getClass();
        TypeTokenSubtypeTest.assertFalse((boolean)TypeToken.of(subclass).isSubtypeOf((TypeToken)supertype));
    }

    public void testSubtypeOfInnerClass_nonStaticAnonymousClass_typeParameterOfInnerTypeNotMatch() {
        TypeToken<Mall.Shop<Electronics>> supertype = new TypeToken<Mall.Shop<Electronics>>(){};
        Class<?> subclass = new Mall.Shop<Grocery>(new Mall()){}.getClass();
        TypeTokenSubtypeTest.assertFalse((boolean)TypeToken.of(subclass).isSubtypeOf((TypeToken)supertype));
    }

    public static void testSubtypeOfInnerClass_staticAnonymousClass() {
        TypeToken<Mall.Shop<Electronics>> supertype = new TypeToken<Mall.Shop<Electronics>>(){};
        Class<?> subclass = new Mall.Shop<Electronics>(new Mall()){}.getClass();
        TypeTokenSubtypeTest.assertTrue((boolean)TypeToken.of(subclass).isSubtypeOf((TypeToken)supertype));
    }

    public static void testSubtypeOfStaticAnonymousClass() {
        Class<?> superclass = new Mall.Shop<Electronics>(new Mall()){}.getClass();
        TypeTokenSubtypeTest.assertTrue((boolean)TypeToken.of(superclass).isSubtypeOf(superclass));
        TypeTokenSubtypeTest.assertFalse((boolean)TypeToken.of(new Mall.Shop<Electronics>(new Mall()){}.getClass()).isSubtypeOf(superclass));
    }

    public void testSubtypeOfNonStaticAnonymousClass() {
        Class<?> superclass = new Mall.Shop<Electronics>(new Mall()){}.getClass();
        TypeTokenSubtypeTest.assertTrue((boolean)TypeToken.of(superclass).isSubtypeOf(superclass));
        TypeTokenSubtypeTest.assertFalse((boolean)TypeToken.of(new Mall.Shop<Electronics>(new Mall()){}.getClass()).isSubtypeOf(superclass));
    }

    private static class Outlet<T>
    extends Mall<T> {
        private Outlet() {
        }
    }

    private static class Mall<T> {
        private Mall() {
        }

        abstract class Retailer<ProductT>
        extends Shop<ProductT>
        implements Comparator<ProductT>,
        ConsumerFacing<ProductT> {
            Retailer() {
            }
        }

        class Shop<ProductT> {
            Shop() {
            }
        }
    }

    private static interface ConsumerFacing<T> {
    }

    private static interface Electronics {
    }

    private static interface Grocery {
    }

    private static interface Indoor {
    }

    private static interface Outdoor {
    }

    private static class WildcardSubtypingTests
    extends SubtypeTester {
        private WildcardSubtypingTests() {
        }

        @SubtypeTester.TestSubtype(suppressGetSupertype=true, suppressGetSubtype=true)
        public <T> Iterable<? extends T> supertypeWithWildcardUpperBound(List<T> list) {
            return this.isSubtype(list);
        }

        @SubtypeTester.TestSubtype(suppressGetSupertype=true, suppressGetSubtype=true)
        public <T> Iterable<? extends T> supertypeWithWildcardUpperBound_notMatch(List<String> list) {
            return (Iterable)this.notSubtype(list);
        }

        @SubtypeTester.TestSubtype(suppressGetSupertype=true, suppressGetSubtype=true)
        public <T> Iterable<? super T> supertypeWithWildcardULowerBound(List<T> list) {
            return this.isSubtype(list);
        }

        @SubtypeTester.TestSubtype(suppressGetSupertype=true, suppressGetSubtype=true)
        public <T> Iterable<? extends T> supertypeWithWildcardULowerBound_notMatch(List<String> list) {
            return (Iterable)this.notSubtype(list);
        }

        @SubtypeTester.TestSubtype(suppressGetSupertype=true, suppressGetSubtype=true)
        public <T> Iterable<?> wildcardsMatchByUpperBound(List<? extends T> list) {
            return this.isSubtype(list);
        }

        @SubtypeTester.TestSubtype(suppressGetSupertype=true, suppressGetSubtype=true)
        public <T> Iterable<? extends T> wildCardsDoNotMatchByUpperBound(List<?> list) {
            return (Iterable)this.notSubtype(list);
        }

        @SubtypeTester.TestSubtype(suppressGetSupertype=true, suppressGetSubtype=true)
        public <T> Iterable<? super String> wildcardsMatchByLowerBound(List<? super CharSequence> list) {
            return this.isSubtype(list);
        }

        @SubtypeTester.TestSubtype(suppressGetSupertype=true, suppressGetSubtype=true)
        public <T> Iterable<? super CharSequence> wildCardsDoNotMatchByLowerBound(List<? super String> list) {
            return (Iterable)this.notSubtype(list);
        }
    }

    private static class OwnerTypeSubtypingTests
    extends SubtypeTester {
        private OwnerTypeSubtypingTests() {
        }

        @SubtypeTester.TestSubtype
        public Mall.Shop<Electronics> innerTypeIsSubtype(Mall.Retailer<Electronics> retailer) {
            return this.isSubtype(retailer);
        }

        @SubtypeTester.TestSubtype(suppressGetSupertype=true, suppressGetSubtype=true)
        public Mall.Shop<? extends Electronics> innerTypeIsSubtype_supertypeWithWildcard(Mall.Retailer<Electronics> retailer) {
            return this.isSubtype(retailer);
        }

        @SubtypeTester.TestSubtype(suppressGetSupertype=true, suppressGetSubtype=true)
        public Mall.Shop<?> innerTypeIsSubtype_withWildcards(Mall.Retailer<? extends Electronics> retailer) {
            return this.isSubtype(retailer);
        }

        @SubtypeTester.TestSubtype
        public Mall.Shop<Electronics> ownerTypeIsSubtype(Mall.Shop<Electronics> shop) {
            return this.isSubtype(shop);
        }

        @SubtypeTester.TestSubtype(suppressGetSupertype=true, suppressGetSubtype=true)
        public Mall.Shop<Electronics> ownerTypeIsSubtype_supertypeWithWildcard(Mall.Shop<Electronics> shop) {
            return this.isSubtype(shop);
        }

        @SubtypeTester.TestSubtype(suppressGetSupertype=true, suppressGetSubtype=true)
        public Mall.Shop<Electronics> ownerTypeIsSubtype_withWildcards(Mall.Shop<Electronics> shop) {
            return this.isSubtype(shop);
        }

        @SubtypeTester.TestSubtype
        public Mall.Shop<Electronics> bothOwnerTypeAndInnerTypeAreSubtypes(Mall.Retailer<Electronics> retailer) {
            return this.isSubtype(retailer);
        }

        @SubtypeTester.TestSubtype(suppressGetSupertype=true, suppressGetSubtype=true)
        public Mall.Shop<? extends Electronics> bothOwnerTypeAndInnerTypeAreSubtypes_supertypeWithWildcard(Mall.Retailer<Electronics> retailer) {
            return this.isSubtype(retailer);
        }

        @SubtypeTester.TestSubtype(suppressGetSupertype=true, suppressGetSubtype=true)
        public Mall.Shop<? extends Electronics> bothOwnerTypeAndInnerTypeAreSubtypes_withWildcards(Mall.Retailer<Electronics> retailer) {
            return this.isSubtype(retailer);
        }

        @SubtypeTester.TestSubtype
        public Mall.Shop<Electronics> ownerTypeDoesNotMatch(Mall.Shop<Electronics> shop) {
            return (Mall.Shop)this.notSubtype(shop);
        }

        @SubtypeTester.TestSubtype
        public Mall.Shop<Electronics> ownerTypeDoesNotMatch_subtypeWithWildcard(Mall.Shop<Electronics> shop) {
            return (Mall.Shop)this.notSubtype(shop);
        }

        @SubtypeTester.TestSubtype
        public Mall.Shop<Electronics> ownerTypeDoesNotMatch_supertypeWithWildcard(Mall.Shop<Electronics> shop) {
            return (Mall.Shop)this.notSubtype(shop);
        }

        @SubtypeTester.TestSubtype
        public Mall.Retailer<Electronics> innerTypeDoesNotMatch(Mall.Shop<Grocery> shop) {
            return (Mall.Retailer)this.notSubtype(shop);
        }

        @SubtypeTester.TestSubtype
        public Mall.Shop<Electronics> innerTypeDoesNotMatch_subtypeWithWildcard(Mall.Shop<? extends Electronics> shop) {
            return (Mall.Shop)this.notSubtype(shop);
        }

        @SubtypeTester.TestSubtype
        public Mall.Shop<? extends Electronics> innerTypeDoesNotMatch_supertypeWithWildcard(Mall.Shop<Grocery> shop) {
            return (Mall.Shop)this.notSubtype(shop);
        }

        @SubtypeTester.TestSubtype(suppressGetSubtype=true)
        public ConsumerFacing<Electronics> supertypeIsNestedClass(Mall.Retailer<Electronics> shop) {
            return this.isSubtype(shop);
        }

        @SubtypeTester.TestSubtype
        public ConsumerFacing<Grocery> nestedClassIsNotSupertypeDueToTypeParameter(Mall.Shop<Electronics> shop) {
            return (ConsumerFacing)this.notSubtype(shop);
        }

        @SubtypeTester.TestSubtype
        public ConsumerFacing<Grocery> nestedClassIsNotSupertype(Mall.Shop<Grocery> shop) {
            return (ConsumerFacing)this.notSubtype(shop);
        }

        @SubtypeTester.TestSubtype(suppressGetSubtype=true)
        public Comparator<Electronics> supertypeIsTopLevelClass(Mall.Retailer<Electronics> shop) {
            return this.isSubtype(shop);
        }

        @SubtypeTester.TestSubtype
        public Comparator<Electronics> topLevelClassIsNotSupertypeDueToTypeParameter(Mall.Retailer<Grocery> shop) {
            return (Comparator)this.notSubtype(shop);
        }

        @SubtypeTester.TestSubtype
        public Comparator<Electronics> topLevelClassIsNotSupertype(Mall.Shop<Electronics> shop) {
            return (Comparator)this.notSubtype(shop);
        }
    }
}

